/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.tree.directory;

import com.metamatrix.common.tree.directory.GenericFileSystemView;
import com.metamatrix.common.tree.directory.UnixFileSystemView;
import com.metamatrix.common.tree.directory.WindowsFileSystemView;
import java.io.File;
import java.io.IOException;
import java.util.Vector;

public abstract class FileSystemViewHelper {
    static final String NEWFOLDER_OTHER = "NewFolder";
    static final String NEWFOLDER_SUBSEQUENT_OTHER = "NewFolder.{0}";
    static final String NEWFOLDER_WIN32 = "NewFolder";
    static final String NEWFOLDER_SUBSEQUENT_WIN32 = "NewFolder ({0})";
    static FileSystemViewHelper windowsFileSystemView = null;
    static FileSystemViewHelper unixFileSystemView = null;
    static FileSystemViewHelper genericFileSystemView = null;

    public static FileSystemViewHelper getFileSystemView() {
        if (File.separatorChar == '\\') {
            if (windowsFileSystemView == null) {
                windowsFileSystemView = new WindowsFileSystemView();
            }
            return windowsFileSystemView;
        }
        if (File.separatorChar == '/') {
            if (unixFileSystemView == null) {
                unixFileSystemView = new UnixFileSystemView();
            }
            return unixFileSystemView;
        }
        if (genericFileSystemView == null) {
            genericFileSystemView = new GenericFileSystemView();
        }
        return genericFileSystemView;
    }

    public abstract boolean isRoot(File var1);

    public abstract File createNewFolder(File var1) throws IOException;

    public abstract boolean isHiddenFile(File var1);

    public abstract File[] getRoots();

    public File getHomeDirectory() {
        return this.createFileObject(System.getProperty("user.home"));
    }

    public File createFileObject(File dir, String filename) {
        if (dir == null) {
            return new File(filename);
        }
        return new File(dir, filename);
    }

    public File createFileObject(String path) {
        return new File(path);
    }

    public File[] getFiles(File dir, boolean useFileHiding) {
        Vector<File> files = new Vector<File>();
        File[] names = dir.listFiles();
        int nameCount = names == null ? 0 : names.length;
        for (int i = 0; i < nameCount; ++i) {
            File f = names[i];
            if (!f.isFile() && !f.isDirectory() || useFileHiding && this.isHiddenFile(f)) continue;
            files.addElement(f);
        }
        return files.toArray(new File[files.size()]);
    }

    public File getParentDirectory(File dir) {
        File f;
        String parentFilename;
        if (dir != null && (parentFilename = (f = this.createFileObject(dir.getAbsolutePath())).getParent()) != null) {
            return new File(parentFilename);
        }
        return null;
    }
}

