/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.tree.directory;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.tree.directory.FileSystemRoot;
import com.metamatrix.common.tree.directory.FileSystemViewHelper;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Vector;

class WindowsFileSystemView
extends FileSystemViewHelper {
    private static final Object[] noArgs = new Object[0];
    private static final Class[] noArgTypes = new Class[0];
    private static final String newFolderString = "NewFolder";
    private static final String newFolderNextString = "NewFolder ({0})";
    private static Method listRootsMethod = null;
    private static boolean listRootsMethodChecked = false;
    static /* synthetic */ Class class$java$io$File;

    WindowsFileSystemView() {
    }

    public boolean isRoot(File f) {
        if (!f.isAbsolute()) {
            return false;
        }
        String parentPath = f.getParent();
        if (parentPath == null) {
            return true;
        }
        File parent = new File(parentPath);
        return parent.equals(f);
    }

    public File createNewFolder(File containingDir) throws IOException {
        if (containingDir == null) {
            throw new IOException(CommonPlugin.Util.getString("ERR.003.028.0054"));
        }
        File newFolder = null;
        newFolder = this.createFileObject(containingDir, newFolderString);
        for (int i = 2; newFolder.exists() && i < 100; ++i) {
            newFolder = this.createFileObject(containingDir, MessageFormat.format(newFolderNextString, new Integer(i)));
        }
        if (newFolder.exists()) {
            throw new IOException(CommonPlugin.Util.getString("ERR.003.028.0055", (Object)newFolder.getAbsolutePath()));
        }
        newFolder.mkdirs();
        return newFolder;
    }

    public boolean isHiddenFile(File f) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File[] getRoots() {
        if (!listRootsMethodChecked) {
            try {
                listRootsMethod = (class$java$io$File == null ? (class$java$io$File = WindowsFileSystemView.class$("java.io.File")) : class$java$io$File).getMethod("listRoots", noArgTypes);
            }
            catch (NoSuchMethodException e) {
            }
            finally {
                listRootsMethodChecked = true;
            }
        }
        if (listRootsMethod != null) {
            try {
                File[] roots = (File[])listRootsMethod.invoke(null, noArgs);
                for (int i = 0; i < roots.length; ++i) {
                    roots[i] = new FileSystemRoot(roots[i]);
                }
                return roots;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            Vector<FileSystemRoot> rootsVector = new Vector<FileSystemRoot>();
            FileSystemRoot floppy = new FileSystemRoot("A:\\");
            rootsVector.addElement(floppy);
            for (char c = 'C'; c <= 'Z'; c = (char)((char)(c + 1))) {
                char[] device = new char[]{c, ':', '\\'};
                String deviceName = new String(device);
                FileSystemRoot deviceFile = new FileSystemRoot(deviceName);
                if (deviceFile == null || !deviceFile.exists()) continue;
                rootsVector.addElement(deviceFile);
            }
            Object[] roots = new File[rootsVector.size()];
            rootsVector.copyInto(roots);
            return roots;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

