/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;

public class WSDLServletUtil {
    public static final String SERVER_URL_KEY = "ServerURL";
    public static final String SECURE_PROTOCOL = "Secure";
    public static final String VDB_NAME_KEY = "VDBName";
    public static final String VDB_VERSION_KEY = "VDBVersion";
    public static final String ADD_PROPS = "AdditionalProperties";
    public static final String TXN_AUTO_WRAP = "txnAutoWrap";
    public static final String ADD_EXEC_PROPS = "AddExecProperties";
    public static final String MM_WEBSERVICE_QUERY_TIMEOUT = "com.metamatrix.webservice.querytimeout";
    public static final String HTTP_TYPE_PARAMETER_KEY = "httptype";
    public static final String HTTP_PARAMETER_VALUE = "http";
    public static final String HTTP = "http";
    public static final String HTTPS = "https";
    public static final String DEFAULT_CONTENT_TYPE = "text/html";
    public static final String XML_CONTENT_TYPE = "text/xml";
    public static final String MMSERVER_HOST_KEY = "MMServerHost";
    public static final String MMSERVER_PORT_KEY = "MMServerPort";
    public static final String TARGET_HOST_KEY = "TargetHost";
    public static final String TARGET_PORT_KEY = "TargetPort";
    public static final String SERVLET_PATH = "metamatrix-soap/servlet/ArtifactDocumentService";
    public static final String SQLQUERYWEBSERVICE_WSDL_PATH = "metamatrix-soap/SqlQueryWebService/WSDL";
    public static final String GENERATED_WSDL_NAME = "MetaMatrixDataServices";
    public static final String GENERATED_WSDL_FILENAME = "MetaMatrixDataServices.wsdl";
    private static final String URL_FORMAT = "{0}://{1}:{2}/{3}/{4}?{5}={6}&{7}={8}&{9}={10}&{11}={12}";
    private static final String URL_NOPORT_FORMAT = "{0}://{1}/{2}/{3}?{4}={5}&{6}={7}&{8}={9}&{10}={11}";
    private static final String SQLQUERYWEBSERVICE_URL_FORMAT = "{0}://{1}:{2}/{3}";
    private static final String DEFAULT_HTTPS_PORT = "8443";
    private static final String DEFAULT_HTTP_PORT = "8080";
    private static final String HTTPS_PORT_PROPERTY_KEY = "com.metamatrix.webservice.dataservice.httpsport";
    private static final String HTTP_PORT_PROPERTY_KEY = "com.metamatrix.webservice.dataservice.httpport";

    public static String formatURL(String scheme, String host, String port, String serverURL, String vdbName, String vdbVersion, boolean isHttp, String txnAutoWrap) {
        String result = null;
        try {
            result = port == null || port.length() == 0 ? MessageFormat.format(URL_NOPORT_FORMAT, scheme, host, SERVLET_PATH, GENERATED_WSDL_FILENAME, SERVER_URL_KEY, serverURL, VDB_NAME_KEY, vdbName, VDB_VERSION_KEY, vdbVersion, ADD_EXEC_PROPS, URLEncoder.encode("txnAutoWrap=" + txnAutoWrap, "UTF-8")) : MessageFormat.format(URL_FORMAT, scheme, host, port, SERVLET_PATH, GENERATED_WSDL_FILENAME, SERVER_URL_KEY, serverURL, VDB_NAME_KEY, vdbName, VDB_VERSION_KEY, vdbVersion, ADD_EXEC_PROPS, URLEncoder.encode("txnAutoWrap=" + txnAutoWrap, "UTF-8"));
        }
        catch (UnsupportedEncodingException err) {
            // empty catch block
        }
        if (isHttp) {
            result = result + "&httptype=http";
        }
        return result;
    }

    public static String getSqlQueryWebServiceUrl(String server, boolean secure) {
        return MessageFormat.format(SQLQUERYWEBSERVICE_URL_FORMAT, secure ? HTTPS : "http", server, secure ? WSDLServletUtil.getHttpsPort() : WSDLServletUtil.getHttpPort(), SQLQUERYWEBSERVICE_WSDL_PATH);
    }

    public static final String getHttpsPort() {
        return System.getProperty(HTTPS_PORT_PROPERTY_KEY, DEFAULT_HTTPS_PORT);
    }

    public static final String getHttpPort() {
        return System.getProperty(HTTP_PORT_PROPERTY_KEY, DEFAULT_HTTP_PORT);
    }
}

