/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.util.crypto.keymanage;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.util.ByteArrayHelper;
import com.metamatrix.common.util.crypto.CryptoException;
import com.metamatrix.common.util.crypto.CryptoUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.X509V3CertificateGenerator;

public class KeystoreCreator {
    private static final String DECRYPTION_ALGORITHM = "RSA";
    private static final int KEY_STRENGTH = 1024;
    public static final int MIN_EXPIRATION = 1;
    public static final int MAX_EXPIRATION = 99;
    public static final int DEFAULT_EXPIRATION = 3;
    private static DateFormat formatter = new SimpleDateFormat("dd/MM/yyyy hh:mm aa");

    private KeystoreCreator() {
    }

    public static KeyStore createKeyStore(String fileName, char[] password, String alias, int certExpiration) throws CryptoException {
        KeyStore keyStore = KeystoreCreator.getEmptyKeyStore(password);
        KeyPair pair = KeystoreCreator.getKeyPair();
        RSAPrivateKey privKey = (RSAPrivateKey)pair.getPrivate();
        RSAPublicKey pubKey = (RSAPublicKey)pair.getPublic();
        X509Certificate cert = KeystoreCreator.genNewMetaMatrixCertificate(pubKey, privKey, certExpiration);
        KeystoreCreator.verifyCertificate(cert, false);
        ByteArrayInputStream bIn = null;
        try {
            bIn = new ByteArrayInputStream(cert.getEncoded());
        }
        catch (CertificateEncodingException e) {
            throw new CryptoException(e, "ERR.003.030.0092", CommonPlugin.Util.getString("ERR.003.030.0092"));
        }
        CertificateFactory fact = null;
        try {
            fact = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            System.out.println(CommonPlugin.Util.getString("MSG.003.030.0036", (Object)e.toString()));
            e.printStackTrace();
        }
        try {
            cert = (X509Certificate)fact.generateCertificate(bIn);
        }
        catch (CertificateException e) {
            throw new CryptoException(e, "ERR.003.030.0093", CommonPlugin.Util.getString("ERR.003.030.0093"));
        }
        Certificate[] chain = new Certificate[]{cert};
        try {
            keyStore.setKeyEntry(alias, privKey, password, chain);
        }
        catch (KeyStoreException e) {
            throw new CryptoException(e, "ERR.003.030.0094", CommonPlugin.Util.getString("ERR.003.030.0094"));
        }
        OutputStream outFile = null;
        try {
            outFile = KeystoreCreator.getOutputStreamForFileName(fileName);
        }
        catch (IOException e) {
            throw new CryptoException(e, "ERR.003.030.0095", CommonPlugin.Util.getString("ERR.003.030.0095"));
        }
        try {
            keyStore.store(outFile, password);
        }
        catch (KeyStoreException e) {
            throw new CryptoException(e, "ERR.003.030.0096", CommonPlugin.Util.getString("ERR.003.030.0096"));
        }
        catch (IOException e) {
            throw new CryptoException(e, "ERR.003.030.0096", CommonPlugin.Util.getString("ERR.003.030.0096"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e, "ERR.003.030.0096", CommonPlugin.Util.getString("ERR.003.030.0096"));
        }
        catch (CertificateException e) {
            throw new CryptoException(e, "ERR.003.030.0096", CommonPlugin.Util.getString("ERR.003.030.0096"));
        }
        finally {
            try {
                outFile.close();
            }
            catch (IOException e) {}
        }
        return keyStore;
    }

    public static KeyStore updateKeyStore(String fileName, char[] password, String alias, int certExpiration) throws CryptoException {
        KeyStore keyStore = null;
        PrivateKey privKey = null;
        PublicKey pubKey = null;
        try {
            keyStore = KeystoreCreator.readInKeyStore(fileName, password);
            privKey = (PrivateKey)keyStore.getKey(alias, password);
            pubKey = keyStore.getCertificate(alias).getPublicKey();
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e, "ERR.003.030.0098", CommonPlugin.Util.getString("ERR.003.030.0098"));
        }
        catch (KeyStoreException e) {
            throw new CryptoException(e, "ERR.003.030.0098", CommonPlugin.Util.getString("ERR.003.030.0098"));
        }
        catch (UnrecoverableKeyException e) {
            throw new CryptoException(e, "ERR.003.030.0098", CommonPlugin.Util.getString("ERR.003.030.0098"));
        }
        X509Certificate cert = KeystoreCreator.genNewMetaMatrixCertificate(pubKey, privKey, certExpiration);
        KeystoreCreator.verifyCertificate(cert, false);
        ByteArrayInputStream bIn = null;
        try {
            bIn = new ByteArrayInputStream(cert.getEncoded());
        }
        catch (CertificateEncodingException e) {
            throw new CryptoException(e, "ERR.003.030.0092", CommonPlugin.Util.getString("ERR.003.030.0092"));
        }
        CertificateFactory fact = null;
        try {
            fact = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            System.out.println(CommonPlugin.Util.getString("MSG.003.030.0036", (Object)e.toString()));
            e.printStackTrace();
        }
        try {
            cert = (X509Certificate)fact.generateCertificate(bIn);
        }
        catch (CertificateException e) {
            throw new CryptoException(e, "ERR.003.030.0093", CommonPlugin.Util.getString("ERR.003.030.0093"));
        }
        Certificate[] chain = new Certificate[]{cert};
        try {
            keyStore.setKeyEntry(alias, privKey, password, chain);
        }
        catch (KeyStoreException e) {
            throw new CryptoException(e, "ERR.003.030.0094", CommonPlugin.Util.getString("ERR.003.030.0094"));
        }
        OutputStream outFile = null;
        try {
            outFile = KeystoreCreator.getOutputStreamForFileName(fileName);
        }
        catch (IOException e) {
            throw new CryptoException(e, "ERR.003.030.0095", CommonPlugin.Util.getString("ERR.003.030.0095"));
        }
        try {
            keyStore.store(outFile, password);
        }
        catch (KeyStoreException e) {
            throw new CryptoException(e, "ERR.003.030.0096", CommonPlugin.Util.getString("ERR.003.030.0096"));
        }
        catch (IOException e) {
            throw new CryptoException(e, "ERR.003.030.0096", CommonPlugin.Util.getString("ERR.003.030.0096"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e, "ERR.003.030.0096", CommonPlugin.Util.getString("ERR.003.030.0096"));
        }
        catch (CertificateException e) {
            throw new CryptoException(e, "ERR.003.030.0096", CommonPlugin.Util.getString("ERR.003.030.0096"));
        }
        finally {
            try {
                outFile.close();
            }
            catch (IOException e) {}
        }
        return keyStore;
    }

    private static OutputStream getOutputStreamForFileName(String pathName) throws IOException {
        File file = new File(pathName);
        if (!file.exists()) {
            file.createNewFile();
        }
        FileOutputStream out = new FileOutputStream(file);
        return out;
    }

    private static InputStream getInputStreamForFileName(String pathName) throws IOException {
        File file = new File(pathName);
        FileInputStream in = new FileInputStream(file);
        return in;
    }

    private static KeyStore getEmptyKeyStore(char[] password) throws CryptoException {
        KeyStore store = null;
        try {
            store = KeyStore.getInstance("JKS");
        }
        catch (KeyStoreException e) {
            throw new CryptoException(e, "ERR.003.030.0097", CommonPlugin.Util.getString("ERR.003.030.0097"));
        }
        try {
            store.load(null, password);
        }
        catch (IOException e) {
            throw new CryptoException(e, "ERR.003.030.0098", CommonPlugin.Util.getString("ERR.003.030.0098"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e, "ERR.003.030.0098", CommonPlugin.Util.getString("ERR.003.030.0098"));
        }
        catch (CertificateException e) {
            throw new CryptoException(e, "ERR.003.030.0098", CommonPlugin.Util.getString("ERR.003.030.0098"));
        }
        return store;
    }

    private static KeyPair getKeyPair() throws CryptoException {
        KeyPairGenerator gen = null;
        try {
            gen = KeyPairGenerator.getInstance(DECRYPTION_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e, "ERR.003.030.0099", CommonPlugin.Util.getString("ERR.003.030.0099"));
        }
        gen.initialize(1024, new SecureRandom());
        KeyPair pair = gen.generateKeyPair();
        return pair;
    }

    public static KeyStore readInKeyStore(String filename, char[] password) throws CryptoException {
        KeyStore keyStore = null;
        try {
            keyStore = KeyStore.getInstance("JKS");
        }
        catch (KeyStoreException e) {
            throw new CryptoException(e, "ERR.003.030.0100", CommonPlugin.Util.getString("ERR.003.030.0100"));
        }
        InputStream inFile = null;
        try {
            inFile = KeystoreCreator.getInputStreamForFileName(filename);
        }
        catch (IOException e) {
            throw new CryptoException(e, "ERR.003.030.0101", CommonPlugin.Util.getString("ERR.003.030.0101"));
        }
        try {
            keyStore.load(inFile, password);
        }
        catch (IOException e) {
            throw new CryptoException(e, "ERR.003.030.0098", CommonPlugin.Util.getString("ERR.003.030.0098"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e, "ERR.003.030.0098", CommonPlugin.Util.getString("ERR.003.030.0098"));
        }
        catch (CertificateException e) {
            throw new CryptoException(e, "ERR.003.030.0098", CommonPlugin.Util.getString("ERR.003.030.0098"));
        }
        finally {
            try {
                inFile.close();
            }
            catch (IOException e) {}
        }
        return keyStore;
    }

    private static X509Certificate genNewMetaMatrixCertificate(PublicKey pubKey, PrivateKey privKey, int certExpiration) throws CryptoException {
        CryptoUtil.initJCEProvider();
        Hashtable<DERObjectIdentifier, String> attrs = new Hashtable<DERObjectIdentifier, String>();
        attrs.put(X509Principal.C, "US");
        attrs.put(X509Principal.O, "MetaMatrix Inc.");
        attrs.put(X509Principal.OU, "Development");
        attrs.put(X509Principal.L, "St. Louis");
        attrs.put(X509Principal.ST, "MO");
        attrs.put(X509Principal.CN, "MetaMatrix");
        X509V3CertificateGenerator certGen = new X509V3CertificateGenerator();
        certGen.setSerialNumber(BigInteger.valueOf(1011905221L));
        certGen.setIssuerDN((X509Name)new X509Principal(attrs));
        certGen.setNotBefore(new Date(System.currentTimeMillis() - 50000L));
        Calendar cal = Calendar.getInstance();
        cal.add(1, certExpiration);
        certGen.setNotAfter(cal.getTime());
        certGen.setSubjectDN((X509Name)new X509Principal(attrs));
        certGen.setPublicKey(pubKey);
        certGen.setSignatureAlgorithm("MD5WithRSA");
        X509Certificate cert = null;
        try {
            cert = certGen.generateX509Certificate(privKey);
        }
        catch (SecurityException e) {
            throw new CryptoException(e, "ERR.003.030.0102", CommonPlugin.Util.getString("ERR.003.030.0102"));
        }
        catch (SignatureException e) {
            throw new CryptoException(e, "ERR.003.030.0102", CommonPlugin.Util.getString("ERR.003.030.0102"));
        }
        catch (InvalidKeyException e) {
            throw new CryptoException(e, "ERR.003.030.0102", CommonPlugin.Util.getString("ERR.003.030.0102"));
        }
        CryptoUtil.initJCEProvider();
        return cert;
    }

    private static void validateKeyStore(KeyStore keyStore, char[] password, String alias) {
        System.out.println(CommonPlugin.Util.getString("MSG.003.030.0037", (Object)alias));
        Key key = null;
        try {
            key = (PrivateKey)keyStore.getKey(alias, password);
        }
        catch (KeyStoreException e) {
            System.out.println(CommonPlugin.Util.getString("ERR.003.030.0103", (Object)e.toString()));
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println(CommonPlugin.Util.getString("ERR.003.030.0103", (Object)e.toString()));
            e.printStackTrace();
        }
        catch (UnrecoverableKeyException e) {
            System.out.println(CommonPlugin.Util.getString("ERR.003.030.0103", (Object)e.toString()));
            e.printStackTrace();
        }
        System.out.println(CommonPlugin.Util.getString("MSG.003.030.0038", (Object)key.getAlgorithm()));
        System.out.println(CommonPlugin.Util.getString("MSG.003.030.0039", (Object)key.getFormat()));
        System.out.println(CommonPlugin.Util.getString("MSG.003.030.0027", (Object)ByteArrayHelper.toString(key.getEncoded())));
        System.out.println(CommonPlugin.Util.getString("MSG.003.030.0040", (Object)alias));
        Certificate cert = null;
        try {
            cert = keyStore.getCertificate(alias);
        }
        catch (KeyStoreException e) {
            System.out.println(CommonPlugin.Util.getString("ERR.003.030.0104", (Object)e.toString()));
        }
        if (cert == null) {
            System.out.println(CommonPlugin.Util.getString("ERR.003.030.0105", (Object)alias));
            return;
        }
        key = cert.getPublicKey();
        System.out.println(CommonPlugin.Util.getString("MSG.003.030.0038", (Object)key.getAlgorithm()));
        System.out.println(CommonPlugin.Util.getString("MSG.003.030.0039", (Object)key.getFormat()));
        System.out.println(CommonPlugin.Util.getString("MSG.003.030.0027", (Object)ByteArrayHelper.toString(key.getEncoded())));
        System.out.println(CommonPlugin.Util.getString("MSG.003.030.0041"));
    }

    private static boolean compareCertificates(KeyStore keyStore1, String alias1, KeyStore keyStore2, String alias2) {
        Certificate[] certArray1 = null;
        try {
            certArray1 = keyStore1.getCertificateChain(alias1);
        }
        catch (KeyStoreException e) {
            System.out.println(CommonPlugin.Util.getString("ERR.003.030.0106", (Object)e.toString()));
            e.printStackTrace();
        }
        Certificate[] certArray2 = null;
        try {
            certArray2 = keyStore2.getCertificateChain(alias2);
        }
        catch (KeyStoreException e) {
            System.out.println(CommonPlugin.Util.getString("ERR.003.030.0107", (Object)e.toString()));
            e.printStackTrace();
        }
        Certificate cert1 = null;
        Certificate cert2 = null;
        int minCertLen = certArray1.length <= certArray2.length ? certArray1.length : certArray2.length;
        for (int i = 0; i < minCertLen; ++i) {
            System.out.println(CommonPlugin.Util.getString("MSG.003.030.0042", i));
            cert1 = certArray1[i];
            cert2 = certArray2[i];
            KeystoreCreator.compareCertificates(cert1, cert2);
            System.out.println(CommonPlugin.Util.getString("MSG.003.030.0043"));
        }
        return true;
    }

    private static boolean validateKeyStoreCertificate(KeyStore keyStore, String alias) {
        Certificate[] certArray = null;
        try {
            certArray = keyStore.getCertificateChain(alias);
        }
        catch (KeyStoreException e) {
            System.out.println(CommonPlugin.Util.getString("ERR.003.030.0108", (Object)e.toString()));
            e.printStackTrace();
        }
        Certificate cert = null;
        for (int i = 0; i < certArray.length; ++i) {
            System.out.println(CommonPlugin.Util.getString("MSG.003.030.0044", i));
            cert = certArray[i];
            KeystoreCreator.verifyCertificate(cert, true);
            System.out.println(CommonPlugin.Util.getString("MSG.003.030.0045"));
        }
        return true;
    }

    private static boolean compareCertificates(Certificate cert1, Certificate cert2) {
        try {
            byte[] cert1Bytes = cert1.getEncoded();
            byte[] cert2Bytes = cert2.getEncoded();
            if (cert1Bytes.length != cert2Bytes.length) {
                System.out.println(CommonPlugin.Util.getString("ERR.003.030.0109"));
                return false;
            }
            for (int i = 0; i < cert1Bytes.length; ++i) {
                if (cert1Bytes[i] == cert2Bytes[i]) continue;
                System.out.println(CommonPlugin.Util.getString("ERR.003.030.0110", i));
                return false;
            }
            System.out.println(CommonPlugin.Util.getString("MSG.003.030.0046"));
            return true;
        }
        catch (CertificateException e) {
            System.out.println(CommonPlugin.Util.getString("ERR.003.030.0111", (Object)e.toString()));
            e.printStackTrace();
            return false;
        }
    }

    private static boolean verifyCertificate(Certificate cert, boolean verbose) {
        boolean certValid = false;
        String certType = cert.getType();
        if (verbose) {
            System.out.println(CommonPlugin.Util.getString("MSG.003.030.0047", (Object)certType));
        }
        PublicKey pubKey = cert.getPublicKey();
        try {
            cert.verify(pubKey);
            certValid = true;
        }
        catch (CertificateException e) {
            System.out.println(CommonPlugin.Util.getString("ERR.003.030.0112", (Object)e.toString()));
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println(CommonPlugin.Util.getString("ERR.003.030.0112", (Object)e.toString()));
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            System.out.println(CommonPlugin.Util.getString("ERR.003.030.0112", (Object)e.toString()));
            e.printStackTrace();
        }
        catch (NoSuchProviderException e) {
            System.out.println(CommonPlugin.Util.getString("ERR.003.030.0112", (Object)e.toString()));
            e.printStackTrace();
        }
        catch (SignatureException e) {
            System.out.println(CommonPlugin.Util.getString("ERR.003.030.0112", (Object)e.toString()));
            e.printStackTrace();
        }
        if (certType.equalsIgnoreCase("X.509")) {
            X509Certificate x509Cert = (X509Certificate)cert;
            if (verbose) {
                System.out.println(CommonPlugin.Util.getString("MSG.003.030.0048", (Object)x509Cert.getIssuerDN()));
                System.out.println(CommonPlugin.Util.getString("MSG.003.030.0049", (Object)x509Cert.getSubjectDN()));
                System.out.println(CommonPlugin.Util.getString("MSG.003.030.0050", x509Cert.getVersion()));
                System.out.println(CommonPlugin.Util.getString("MSG.003.030.0051", (Object)x509Cert.getSerialNumber()));
                System.out.println(CommonPlugin.Util.getString("MSG.003.030.0052", (Object)formatter.format(x509Cert.getNotBefore())));
                System.out.println(CommonPlugin.Util.getString("MSG.003.030.0053", (Object)formatter.format(x509Cert.getNotAfter())));
                System.out.println(CommonPlugin.Util.getString("MSG.003.030.0054", (Object)x509Cert.getSigAlgName()));
            }
            String currentlyValid = "Valid";
            try {
                x509Cert.checkValidity();
                certValid = true;
            }
            catch (CertificateExpiredException e) {
                currentlyValid = "Invalid, expired on " + x509Cert.getNotAfter();
            }
            catch (CertificateNotYetValidException e) {
                currentlyValid = "Invalid, " + e.toString();
            }
            if (verbose) {
                System.out.println(CommonPlugin.Util.getString("MSG.003.030.0055", (Object)currentlyValid));
            }
        }
        return certValid;
    }

    public static void main(String[] args) {
        String usage = "\nUsage: KeyStoreCreator <-create|-update> <keystorefile> <pwd> <alias> <years_valid> (1 - 99)\n                       <-validate> <keystorefile> <pwd> <alias>\n                       <-compare> <keystorefile> <pwd> <alias> <keystorefile> <pwd> <alias>";
        String CREATE = "-create";
        String VALIDATE = "-validate";
        String COMPARE = "-compare";
        String UPDATE = "-update";
        boolean create = false;
        boolean validate = false;
        boolean compare = false;
        boolean update = false;
        char[] pwd1 = new char[]{'b', 'o', 'g', 'u', 's'};
        char[] pwd2 = new char[]{'b', 'o', 'g', 'u', 's'};
        String alias1 = "";
        String alias2 = "";
        int yearsValid = 0;
        if (args.length == 0) {
            System.err.println(usage);
            System.exit(1);
        }
        String keyStoreFile1 = null;
        String keyStoreFile2 = null;
        create = args[0].equalsIgnoreCase(CREATE);
        update = args[0].equalsIgnoreCase(UPDATE);
        validate = args[0].equalsIgnoreCase(VALIDATE);
        compare = args[0].equalsIgnoreCase(COMPARE);
        if (create || update) {
            if (args.length != 5) {
                System.err.println("Expected: " + args[0] + " <keystorefile> <pwd> <alias> <years_valid>" + usage);
                System.exit(1);
            }
            keyStoreFile1 = args[1];
            pwd1 = args[2].toCharArray();
            alias1 = args[3];
            try {
                yearsValid = Integer.parseInt(args[4]);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (yearsValid < 1 || yearsValid > 99) {
                System.err.println("<years_valid> must be a number between 1 and 99" + usage);
                System.exit(1);
            }
        } else if (validate) {
            if (args.length != 4) {
                System.err.println("Expected: -validate <keystorefile> <pwd> <alias>" + usage);
                System.exit(1);
            }
            keyStoreFile1 = args[1];
            pwd1 = args[2].toCharArray();
            alias1 = args[3];
        } else if (compare) {
            if (args.length != 7) {
                System.err.println("Expected: -compare <keystorefile> <pwd> <alias> <keystorefile> <pwd> <alias>" + usage);
                System.exit(1);
            }
            keyStoreFile1 = args[1];
            pwd1 = args[2].toCharArray();
            alias1 = args[3];
            keyStoreFile2 = args[4];
            pwd2 = args[5].toCharArray();
            alias2 = args[6];
        }
        try {
            if (create) {
                System.out.println("\nCreating and validating keystore: <" + keyStoreFile1 + ">");
                KeyStore store = KeystoreCreator.createKeyStore(keyStoreFile1, pwd1, alias1, yearsValid);
                KeystoreCreator.validateKeyStore(store, pwd1, alias1);
                KeystoreCreator.validateKeyStoreCertificate(store, alias1);
                System.out.println("\nDone\nkeystore: " + store);
            } else if (update) {
                System.out.println("\nUpdating keystore date: <" + keyStoreFile1 + ">");
                KeyStore store = KeystoreCreator.updateKeyStore(keyStoreFile1, pwd1, alias1, yearsValid);
                KeystoreCreator.validateKeyStore(store, pwd1, alias1);
                KeystoreCreator.validateKeyStoreCertificate(store, alias1);
                System.out.println("\nDone\nkeystore: " + store);
            } else if (compare) {
                System.out.println("\nReading in, validating and comparing <" + keyStoreFile1 + "> and <" + keyStoreFile2 + ">");
                System.out.println("\nReading keystore: " + keyStoreFile1);
                KeyStore store1 = KeystoreCreator.readInKeyStore(keyStoreFile1, pwd1);
                System.out.println("\nReading keystore: " + keyStoreFile2);
                KeyStore store2 = KeystoreCreator.readInKeyStore(keyStoreFile2, pwd2);
                System.out.println("\nValidating keystore: " + keyStoreFile1);
                KeystoreCreator.validateKeyStore(store1, pwd1, alias1);
                System.out.println("\nValidating keystore: " + keyStoreFile2);
                KeystoreCreator.validateKeyStore(store2, pwd2, alias2);
                System.out.println("\nValidating keystore certificate: " + keyStoreFile1);
                KeystoreCreator.validateKeyStoreCertificate(store1, alias2);
                System.out.println("\nValidating keystore certificate: " + keyStoreFile2);
                KeystoreCreator.validateKeyStoreCertificate(store2, alias2);
                System.out.println("\nComparing keystore certificates...");
                KeystoreCreator.compareCertificates(store1, alias1, store2, alias2);
                System.out.println("\nDone\nkeystore1: " + store1 + "\n" + "keystore2: " + store2);
            } else if (validate) {
                System.out.println("\nReading in and validating <" + keyStoreFile1 + ">");
                KeyStore store = KeystoreCreator.readInKeyStore(keyStoreFile1, pwd1);
                KeystoreCreator.validateKeyStore(store, pwd1, alias1);
                KeystoreCreator.validateKeyStoreCertificate(store, alias1);
                System.out.println("\nDone\nkeystore: " + store);
            } else {
                System.err.println("Don't know what to do..." + usage);
                System.exit(1);
            }
        }
        catch (CryptoException e) {
            System.err.println("Error: " + e.getFullMessage());
            e.printStackTrace();
            System.exit(1);
        }
    }
}

