/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational.rules;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.optimizer.capabilities.SourceCapabilities;
import com.metamatrix.query.optimizer.relational.rules.CapabilitiesUtil;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.BetweenCriteria;
import com.metamatrix.query.sql.lang.CompareCriteria;
import com.metamatrix.query.sql.lang.CompoundCriteria;
import com.metamatrix.query.sql.lang.DependentSetCriteria;
import com.metamatrix.query.sql.lang.ExistsCriteria;
import com.metamatrix.query.sql.lang.IsNullCriteria;
import com.metamatrix.query.sql.lang.MatchCriteria;
import com.metamatrix.query.sql.lang.NotCriteria;
import com.metamatrix.query.sql.lang.PredicateCriteria;
import com.metamatrix.query.sql.lang.SetCriteria;
import com.metamatrix.query.sql.lang.SubqueryCompareCriteria;
import com.metamatrix.query.sql.lang.SubquerySetCriteria;
import com.metamatrix.query.sql.navigator.PreOrderNavigator;
import com.metamatrix.query.sql.symbol.AggregateSymbol;
import com.metamatrix.query.sql.symbol.CaseExpression;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Function;
import com.metamatrix.query.sql.symbol.SearchedCaseExpression;
import com.metamatrix.query.sql.visitor.ElementCollectorVisitor;
import com.metamatrix.query.sql.visitor.EvaluateExpressionVisitor;
import java.util.Collection;
import java.util.Iterator;

public class CriteriaCapabilityValidatorVisitor
extends LanguageVisitor {
    private Object modelID;
    private QueryMetadataInterface metadata;
    private CapabilitiesFinder capFinder;
    private SourceCapabilities caps;
    private MetaMatrixComponentException exception;
    private boolean valid = true;

    public CriteriaCapabilityValidatorVisitor(Object modelID, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) {
        this.modelID = modelID;
        this.metadata = metadata;
        this.capFinder = capFinder;
        this.loadCapabilities();
    }

    private void loadCapabilities() {
        if (this.capFinder != null) {
            try {
                String modelName = this.metadata.getFullName(this.modelID);
                this.caps = this.capFinder.findCapabilities(modelName);
            }
            catch (QueryMetadataException e) {
                this.handleException(new MetaMatrixComponentException((Throwable)e));
            }
            catch (MetaMatrixComponentException e) {
                this.handleException(e);
            }
        }
    }

    public void visit(AggregateSymbol obj) {
        if (this.caps == null) {
            return;
        }
        try {
            if (!CapabilitiesUtil.supportsAggregateFunction(this.modelID, obj, this.metadata, this.capFinder)) {
                this.markInvalid();
            }
        }
        catch (QueryMetadataException e) {
            this.handleException(new MetaMatrixComponentException((Throwable)e));
        }
        catch (MetaMatrixComponentException e) {
            this.handleException(e);
        }
    }

    public void visit(BetweenCriteria obj) {
        if (this.caps == null) {
            return;
        }
        if (!this.caps.supportsCapability("QUERY.WHERE")) {
            this.markInvalid();
            return;
        }
        if (!this.caps.supportsCapability("QUERY.WHERE.BETWEEN")) {
            this.markInvalid();
            return;
        }
        try {
            this.checkElementsAreSearchable((PredicateCriteria)obj, 2);
        }
        catch (QueryMetadataException e) {
            this.handleException(new MetaMatrixComponentException((Throwable)e));
        }
        catch (MetaMatrixComponentException e) {
            this.handleException(e);
        }
    }

    public void visit(CaseExpression obj) {
        if (this.caps == null) {
            return;
        }
        if (!this.caps.supportsCapability("QUERY.CASE")) {
            this.markInvalid();
        }
    }

    public void visit(CompareCriteria obj) {
        if (this.caps != null) {
            if (!this.caps.supportsCapability("QUERY.WHERE")) {
                this.markInvalid();
                return;
            }
            if (!this.caps.supportsCapability("QUERY.WHERE.COMPARE")) {
                this.markInvalid();
                return;
            }
            String operatorCap = null;
            switch (obj.getOperator()) {
                case 1: {
                    operatorCap = "QUERY.WHERE.COMPARE.EQ";
                    break;
                }
                case 2: {
                    operatorCap = "QUERY.WHERE.COMPARE.NE";
                    break;
                }
                case 3: {
                    operatorCap = "QUERY.WHERE.COMPARE.LT";
                    break;
                }
                case 4: {
                    operatorCap = "QUERY.WHERE.COMPARE.GT";
                    break;
                }
                case 5: {
                    operatorCap = "QUERY.WHERE.COMPARE.LE";
                    break;
                }
                case 6: {
                    operatorCap = "QUERY.WHERE.COMPARE.GE";
                }
            }
            if (!this.caps.supportsCapability(operatorCap)) {
                this.markInvalid();
            }
        }
        try {
            this.checkElementsAreSearchable((PredicateCriteria)obj, 2);
        }
        catch (QueryMetadataException e) {
            this.handleException(new MetaMatrixComponentException((Throwable)e));
        }
        catch (MetaMatrixComponentException e) {
            this.handleException(e);
        }
    }

    public void visit(CompoundCriteria crit) {
        int operator = crit.getOperator();
        if (this.caps != null) {
            if (operator == 0) {
                if (!this.caps.supportsCapability("QUERY.WHERE.AND")) {
                    this.markInvalid();
                    return;
                }
            } else if (!this.caps.supportsCapability("QUERY.WHERE.OR")) {
                this.markInvalid();
                return;
            }
        }
    }

    public void visit(Function obj) {
        try {
            if (EvaluateExpressionVisitor.willBecomeConstant((LanguageObject)obj)) {
                return;
            }
            if (obj.getFunctionDescriptor().getPushdown() == 1 || !CapabilitiesUtil.supportsScalarFunction(this.modelID, obj, this.metadata, this.capFinder)) {
                this.markInvalid();
            }
        }
        catch (QueryMetadataException e) {
            this.handleException(new MetaMatrixComponentException((Throwable)e));
        }
        catch (MetaMatrixComponentException e) {
            this.handleException(e);
        }
    }

    public void visit(IsNullCriteria obj) {
        if (this.caps != null) {
            if (!this.caps.supportsCapability("QUERY.WHERE")) {
                this.markInvalid();
                return;
            }
            if (!this.caps.supportsCapability("QUERY.WHERE.ISNULL")) {
                this.markInvalid();
                return;
            }
            try {
                this.checkElementsAreSearchable((PredicateCriteria)obj, 2);
            }
            catch (QueryMetadataException e) {
                this.handleException(new MetaMatrixComponentException((Throwable)e));
            }
            catch (MetaMatrixComponentException e) {
                this.handleException(e);
            }
        }
    }

    public void visit(MatchCriteria obj) {
        if (this.caps != null) {
            if (!this.caps.supportsCapability("QUERY.WHERE")) {
                this.markInvalid();
                return;
            }
            if (!this.caps.supportsCapability("QUERY.WHERE.LIKE")) {
                this.markInvalid();
                return;
            }
            if (obj.getEscapeChar() != '\u0000' && !this.caps.supportsCapability("QUERY.WHERE.LIKE.ESCAPE")) {
                this.markInvalid();
                return;
            }
            try {
                this.checkElementsAreSearchable((PredicateCriteria)obj, 1);
            }
            catch (QueryMetadataException e) {
                this.handleException(new MetaMatrixComponentException((Throwable)e));
            }
            catch (MetaMatrixComponentException e) {
                this.handleException(e);
            }
        }
    }

    public void visit(NotCriteria obj) {
        if (this.caps != null && !this.caps.supportsCapability("QUERY.WHERE.NOT")) {
            this.markInvalid();
            return;
        }
    }

    public void visit(SearchedCaseExpression obj) {
        if (this.caps == null) {
            return;
        }
        if (!this.caps.supportsCapability("QUERY.SEARCHED.CASE")) {
            this.markInvalid();
        }
    }

    public void visit(SetCriteria crit) {
        try {
            if (this.caps != null) {
                if (!this.caps.supportsCapability("QUERY.WHERE")) {
                    this.markInvalid();
                    return;
                }
                if (!this.caps.supportsCapability("QUERY.WHERE.IN")) {
                    this.markInvalid();
                    return;
                }
            }
            this.checkElementsAreSearchable((PredicateCriteria)crit, 2);
        }
        catch (QueryMetadataException e) {
            this.handleException(new MetaMatrixComponentException((Throwable)e));
        }
        catch (MetaMatrixComponentException e) {
            this.handleException(e);
        }
    }

    public void visit(ExistsCriteria crit) {
        if (this.caps != null) {
            if (!this.caps.supportsCapability("QUERY.WHERE")) {
                this.markInvalid();
                return;
            }
            if (!this.caps.supportsCapability("QUERY.WHERE.QUANT.EXISTS")) {
                this.markInvalid();
                return;
            }
        }
    }

    public void visit(SubqueryCompareCriteria crit) {
        if (this.caps != null) {
            if (!this.caps.supportsCapability("QUERY.WHERE")) {
                this.markInvalid();
                return;
            }
            if (!this.caps.supportsCapability("QUERY.WHERE.COMPARE")) {
                this.markInvalid();
                return;
            }
            if (!this.caps.supportsCapability("QUERY.WHERE.QUANT.COMPARE")) {
                this.markInvalid();
                return;
            }
            String capability = null;
            switch (crit.getPredicateQuantifier()) {
                case 4: {
                    capability = "QUERY.WHERE.QUANT.ALL";
                    break;
                }
                case 3: {
                    capability = "QUERY.WHERE.QUANT.SOME";
                    break;
                }
                case 2: {
                    capability = "QUERY.WHERE.QUANT.SOME";
                }
            }
            if (!this.caps.supportsCapability(capability)) {
                this.markInvalid();
                return;
            }
            String operatorCap = null;
            switch (crit.getOperator()) {
                case 1: {
                    operatorCap = "QUERY.WHERE.COMPARE.EQ";
                    break;
                }
                case 2: {
                    operatorCap = "QUERY.WHERE.COMPARE.NE";
                    break;
                }
                case 3: {
                    operatorCap = "QUERY.WHERE.COMPARE.LT";
                    break;
                }
                case 4: {
                    operatorCap = "QUERY.WHERE.COMPARE.GT";
                    break;
                }
                case 5: {
                    operatorCap = "QUERY.WHERE.COMPARE.LE";
                    break;
                }
                case 6: {
                    operatorCap = "QUERY.WHERE.COMPARE.GE";
                }
            }
            if (!this.caps.supportsCapability(operatorCap)) {
                this.markInvalid();
            }
        }
        try {
            this.checkElementsAreSearchable((PredicateCriteria)crit, 2);
        }
        catch (QueryMetadataException e) {
            this.handleException(new MetaMatrixComponentException((Throwable)e));
        }
        catch (MetaMatrixComponentException e) {
            this.handleException(e);
        }
    }

    public void visit(SubquerySetCriteria crit) {
        try {
            if (this.caps != null) {
                if (!this.caps.supportsCapability("QUERY.WHERE")) {
                    this.markInvalid();
                    return;
                }
                if (!this.caps.supportsCapability("QUERY.WHERE.IN")) {
                    this.markInvalid();
                    return;
                }
                if (!this.caps.supportsCapability("QUERY.WHERE.IN.SUBQUERY")) {
                    this.markInvalid();
                    return;
                }
            }
            this.checkElementsAreSearchable((PredicateCriteria)crit, 2);
        }
        catch (QueryMetadataException e) {
            this.handleException(new MetaMatrixComponentException((Throwable)e));
        }
        catch (MetaMatrixComponentException e) {
            this.handleException(e);
        }
    }

    public void visit(DependentSetCriteria crit) {
        try {
            if (this.caps != null) {
                if (!this.caps.supportsCapability("QUERY.WHERE")) {
                    this.markInvalid();
                    return;
                }
                if (!this.caps.supportsCapability("QUERY.WHERE.IN")) {
                    this.markInvalid();
                    return;
                }
            }
            this.checkElementsAreSearchable((PredicateCriteria)crit, 2);
        }
        catch (QueryMetadataException e) {
            this.handleException(new MetaMatrixComponentException((Throwable)e));
        }
        catch (MetaMatrixComponentException e) {
            this.handleException(e);
        }
    }

    private void checkElementsAreSearchable(PredicateCriteria crit, int searchableType) throws QueryMetadataException, MetaMatrixComponentException {
        Collection elements = ElementCollectorVisitor.getElements((LanguageObject)crit, (boolean)false);
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            ElementSymbol element = (ElementSymbol)iter.next();
            if (this.metadata.elementSupports(element.getMetadataID(), searchableType)) continue;
            this.markInvalid();
            return;
        }
    }

    private void handleException(MetaMatrixComponentException e) {
        this.valid = false;
        this.exception = e;
        this.setAbort(true);
    }

    public MetaMatrixComponentException getException() {
        return this.exception;
    }

    private void markInvalid() {
        this.valid = false;
        this.setAbort(true);
    }

    public boolean isValid() {
        return this.valid;
    }

    public static boolean canPushLanguageObject(LanguageObject obj, Object modelID, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, MetaMatrixComponentException {
        if (obj == null) {
            return true;
        }
        if (modelID == null || metadata.isVirtualModel(modelID)) {
            return false;
        }
        CriteriaCapabilityValidatorVisitor visitor = new CriteriaCapabilityValidatorVisitor(modelID, metadata, capFinder);
        PreOrderNavigator.doVisit((LanguageObject)obj, (LanguageVisitor)visitor);
        if (visitor.getException() != null) {
            throw visitor.getException();
        }
        return visitor.isValid();
    }
}

