/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.rewriter;

import com.metamatrix.api.exception.query.QueryValidatorException;
import com.metamatrix.query.execution.QueryExecPlugin;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.rewriter.QueryRewriter;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.BetweenCriteria;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.CompareCriteria;
import com.metamatrix.query.sql.lang.DependentSetCriteria;
import com.metamatrix.query.sql.lang.DynamicCommand;
import com.metamatrix.query.sql.lang.Insert;
import com.metamatrix.query.sql.lang.IsNullCriteria;
import com.metamatrix.query.sql.lang.MatchCriteria;
import com.metamatrix.query.sql.lang.SPParameter;
import com.metamatrix.query.sql.lang.Select;
import com.metamatrix.query.sql.lang.SetCriteria;
import com.metamatrix.query.sql.lang.StoredProcedure;
import com.metamatrix.query.sql.lang.Update;
import com.metamatrix.query.sql.navigator.DeepPreOrderNavigator;
import com.metamatrix.query.sql.proc.AssignmentStatement;
import com.metamatrix.query.sql.proc.CreateUpdateProcedureCommand;
import com.metamatrix.query.sql.symbol.AliasSymbol;
import com.metamatrix.query.sql.symbol.CaseExpression;
import com.metamatrix.query.sql.symbol.Constant;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.ExpressionSymbol;
import com.metamatrix.query.sql.symbol.Function;
import com.metamatrix.query.sql.symbol.Reference;
import com.metamatrix.query.sql.symbol.SearchedCaseExpression;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import com.metamatrix.query.sql.visitor.VariableCollectorVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class VariableSubstitutionVisitor
extends LanguageVisitor {
    private static Constant NOT_CHANGING = new Constant((Object)"NOT_CHANGING");
    private static Constant NULL_CONSTANT = new Constant(null);
    private int refCounter = 0;
    private Command userCommand;
    private Collection invalidInput;
    private QueryValidatorException validExp;
    private QueryMetadataInterface metadata = null;
    private CreateUpdateProcedureCommand procCmd = null;

    public VariableSubstitutionVisitor(Command userCommand, QueryMetadataInterface metadata) {
        this.userCommand = userCommand;
        this.metadata = metadata;
    }

    public void setProcedure(CreateUpdateProcedureCommand procCmd) {
        this.procCmd = procCmd;
    }

    public void visit(Select obj) {
        List selectSymbols = obj.getProjectedSymbols();
        ArrayList<SingleElementSymbol> newSelectSymbols = new ArrayList<SingleElementSymbol>(selectSymbols.size());
        Iterator sybIter = selectSymbols.iterator();
        while (sybIter.hasNext()) {
            SingleElementSymbol exp = (SingleElementSymbol)sybIter.next();
            AliasSymbol alias = null;
            if (exp instanceof AliasSymbol) {
                alias = (AliasSymbol)exp;
                exp = ((AliasSymbol)exp).getSymbol();
            }
            if (exp instanceof ElementSymbol) {
                exp = this.getSelectValue((ElementSymbol)exp);
            }
            if (alias != null) {
                alias.setSymbol(exp);
                exp = alias;
            }
            newSelectSymbols.add(exp);
        }
        if (newSelectSymbols.size() > 0) {
            obj.setSymbols(newSelectSymbols);
        }
    }

    public void visit(Insert obj) {
        List insertValues = obj.getValues();
        ArrayList<Object> valuesList = new ArrayList<Object>(insertValues.size());
        Iterator valuesIter = insertValues.iterator();
        while (valuesIter.hasNext()) {
            Object exp = valuesIter.next();
            if (exp instanceof AliasSymbol) {
                exp = ((AliasSymbol)exp).getSymbol();
            }
            if (exp instanceof ElementSymbol) {
                ElementSymbol elmntSyb = (ElementSymbol)exp;
                Expression value = this.getVariableValue(elmntSyb);
                if (value.equals(NOT_CHANGING)) {
                    int cmdType = this.userCommand.getType();
                    if (cmdType == 2) {
                        Object grpMetaataID = ((Insert)this.userCommand).getGroup().getMetadataID();
                        Object defaultValue = null;
                        String virtualElement = null;
                        try {
                            String grpName = this.metadata.getFullName(grpMetaataID);
                            virtualElement = grpName + "." + elmntSyb.getShortName();
                            Object virtualID = this.metadata.getElementID(virtualElement);
                            defaultValue = this.metadata.getDefaultValue(virtualID);
                        }
                        catch (Exception e) {
                            this.validExp = new QueryValidatorException((Throwable)e, QueryExecPlugin.Util.getString("VariableSubstitutionVisitor.Error_lookup_default_value") + virtualElement);
                            return;
                        }
                        valuesList.add(new Constant(defaultValue, elmntSyb.getType()));
                        continue;
                    }
                    valuesList.add(NULL_CONSTANT);
                    continue;
                }
                valuesList.add(value);
                continue;
            }
            valuesList.add(exp);
        }
        obj.setValues(valuesList);
    }

    private boolean checkInputVariables(Expression expr) {
        Iterator varIter = VariableCollectorVisitor.getVariables((LanguageObject)expr, (boolean)false).iterator();
        ArrayList<Boolean> matches = null;
        while (varIter.hasNext()) {
            Expression evalValue;
            ElementSymbol var = (ElementSymbol)varIter.next();
            String grpName = var.getGroupSymbol().getName();
            if (!grpName.equals("INPUT")) continue;
            if (matches == null) {
                matches = new ArrayList<Boolean>();
            }
            if ((evalValue = this.evaluateInputChangingVariables(var, grpName)).equals(NOT_CHANGING)) {
                matches.add(Boolean.FALSE);
                continue;
            }
            matches.add(Boolean.TRUE);
        }
        if (matches != null) {
            Iterator matchIter = matches.iterator();
            boolean remove = (Boolean)matchIter.next();
            while (matchIter.hasNext()) {
                if ((Boolean)matchIter.next() == remove) continue;
                if (this.invalidInput == null) {
                    this.invalidInput = new ArrayList();
                }
                this.invalidInput.add(expr);
            }
            return remove;
        }
        return true;
    }

    public void visit(Update obj) {
        List changeList = obj.getChangeList();
        ArrayList<CompareCriteria> newChangeList = new ArrayList<CompareCriteria>(changeList.size());
        Iterator changeIter = changeList.iterator();
        while (changeIter.hasNext()) {
            CompareCriteria compCrit = (CompareCriteria)changeIter.next();
            Expression rightExpr = compCrit.getRightExpression();
            boolean retainCrit = this.checkInputVariables(rightExpr);
            if (!retainCrit) continue;
            this.visit(compCrit);
            newChangeList.add(compCrit);
        }
        if (newChangeList.size() == 0) {
            if (this.procCmd != null) {
                this.procCmd.removeSubCommand((Command)obj);
            }
        } else {
            obj.setChangeList(newChangeList);
        }
    }

    public void visit(AssignmentStatement obj) {
        if (obj.hasExpression()) {
            obj.setExpression(this.replaceExpression(obj.getExpression()));
        }
    }

    public void visit(BetweenCriteria obj) {
        obj.setExpression(this.replaceExpression(obj.getExpression()));
        obj.setLowerExpression(this.replaceExpression(obj.getLowerExpression()));
        obj.setUpperExpression(this.replaceExpression(obj.getUpperExpression()));
    }

    public void visit(CaseExpression obj) {
        obj.setExpression(this.replaceExpression(obj.getExpression()));
        int whenCount = obj.getWhenCount();
        ArrayList<Expression> whens = new ArrayList<Expression>(whenCount);
        ArrayList<Expression> thens = new ArrayList<Expression>(whenCount);
        for (int i = 0; i < whenCount; ++i) {
            whens.add(this.replaceExpression(obj.getWhenExpression(i)));
            thens.add(this.replaceExpression(obj.getThenExpression(i)));
        }
        obj.setWhen(whens, thens);
        obj.setElseExpression(this.replaceExpression(obj.getElseExpression()));
    }

    public void visit(CompareCriteria obj) {
        obj.setLeftExpression(this.replaceExpression(obj.getLeftExpression()));
        obj.setRightExpression(this.replaceExpression(obj.getRightExpression()));
    }

    public void visit(IsNullCriteria obj) {
        obj.setExpression(this.replaceExpression(obj.getExpression()));
    }

    public void visit(MatchCriteria obj) {
        obj.setLeftExpression(this.replaceExpression(obj.getLeftExpression()));
        obj.setRightExpression(this.replaceExpression(obj.getRightExpression()));
    }

    public void visit(SearchedCaseExpression obj) {
        int whenCount = obj.getWhenCount();
        ArrayList<Expression> thens = new ArrayList<Expression>(whenCount);
        for (int i = 0; i < whenCount; ++i) {
            thens.add(this.replaceExpression(obj.getThenExpression(i)));
        }
        obj.setWhen(obj.getWhen(), thens);
        obj.setElseExpression(this.replaceExpression(obj.getElseExpression()));
    }

    public void visit(SetCriteria obj) {
        Expression expr = obj.getExpression();
        if (expr instanceof AliasSymbol) {
            expr = ((AliasSymbol)expr).getSymbol();
        }
        if (expr instanceof ElementSymbol) {
            obj.setExpression(this.getVariableValue((ElementSymbol)expr));
        } else {
            obj.setExpression(expr);
        }
        ArrayList<Object> valuesList = new ArrayList<Object>(obj.getNumberOfValues());
        Iterator valuesIter = obj.getValues().iterator();
        while (valuesIter.hasNext()) {
            Object exp = valuesIter.next();
            if (exp instanceof AliasSymbol) {
                SingleElementSymbol aliasExp = ((AliasSymbol)exp).getSymbol();
                if (aliasExp instanceof ElementSymbol) {
                    valuesList.add(this.getVariableValue((ElementSymbol)aliasExp));
                    continue;
                }
                valuesList.add(exp);
                continue;
            }
            if (exp instanceof ElementSymbol && (exp = this.getVariableValue((ElementSymbol)exp)).equals(NOT_CHANGING)) {
                exp = NULL_CONSTANT;
            }
            valuesList.add(exp);
        }
        obj.setValues(valuesList);
    }

    public void visit(DependentSetCriteria obj) {
        Expression expr = obj.getExpression();
        if (expr instanceof ElementSymbol) {
            obj.setExpression(this.getVariableValue((ElementSymbol)expr));
        } else {
            obj.setExpression(expr);
        }
    }

    public void visit(StoredProcedure obj) {
        Iterator paramIter = obj.getParameters().iterator();
        while (paramIter.hasNext()) {
            SPParameter param = (SPParameter)paramIter.next();
            Expression expr = param.getExpression();
            if (expr == null || !(expr instanceof ElementSymbol)) continue;
            param.setExpression(this.replaceExpression(expr));
        }
    }

    public void visit(Function obj) {
        int argLength = obj.getArgs().length;
        Expression[] args = new Expression[argLength];
        for (int i = 0; i < argLength; ++i) {
            Expression exp = obj.getArg(i);
            if (exp instanceof ElementSymbol && (exp = this.getVariableValue((ElementSymbol)exp)).equals(NOT_CHANGING)) {
                exp = NULL_CONSTANT;
            }
            args[i] = exp;
        }
        obj.setArgs(args);
    }

    public void visit(DynamicCommand obj) {
        if (obj.getUsing() != null && !obj.getUsing().isEmpty()) {
            Iterator i = obj.getUsing().entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                entry.setValue(this.replaceExpression((Expression)entry.getValue()));
            }
        }
        obj.setSql(this.replaceExpression(obj.getSql()));
    }

    private String getVariableElementName(ElementSymbol variable) {
        String elementName = variable.getName();
        int index = elementName.lastIndexOf(".");
        return elementName.substring(index + 1);
    }

    private Expression evaluateInputChangingVariables(ElementSymbol variable, String type) {
        int cmdType = this.userCommand.getType();
        if (cmdType == 3) {
            Update update = (Update)this.userCommand;
            Iterator changeIter = update.getChangeList().iterator();
            while (changeIter.hasNext()) {
                CompareCriteria compCrit = (CompareCriteria)changeIter.next();
                ElementSymbol leftSymbol = (ElementSymbol)compCrit.getLeftExpression();
                String userElmntRef = this.getVariableElementName(variable);
                if (!userElmntRef.equalsIgnoreCase(leftSymbol.getShortName())) continue;
                if (type.equals("CHANGING")) {
                    return new Constant((Object)Boolean.TRUE);
                }
                Expression rightExpr = compCrit.getRightExpression();
                Expression evaluatedValue = null;
                try {
                    evaluatedValue = QueryRewriter.rewriteExpression(rightExpr, null);
                }
                catch (Exception e) {
                    // empty catch block
                }
                return evaluatedValue;
            }
        } else if (cmdType == 2) {
            Insert insert = (Insert)this.userCommand;
            Iterator varIter = insert.getVariables().iterator();
            Iterator valIter = insert.getValues().iterator();
            while (varIter.hasNext()) {
                ElementSymbol varSymbol = (ElementSymbol)varIter.next();
                String userElmntRef = variable.getShortName();
                if (userElmntRef.equalsIgnoreCase(varSymbol.getShortName())) {
                    if (type.equals("CHANGING")) {
                        return new Constant((Object)Boolean.TRUE);
                    }
                    Expression valueExpr = (Expression)valIter.next();
                    Expression evaluatedValue = null;
                    try {
                        evaluatedValue = QueryRewriter.rewriteExpression(valueExpr, null);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    return evaluatedValue;
                }
                valIter.next();
            }
        }
        if (type.equals("CHANGING")) {
            return new Constant((Object)Boolean.FALSE);
        }
        return NOT_CHANGING;
    }

    private SingleElementSymbol getSelectValue(ElementSymbol variable) {
        if (variable.isExternalReference()) {
            String grpName = variable.getGroupSymbol().getCanonicalName();
            if (grpName.equals("VARIABLES")) {
                Reference selectRef = new Reference(this.refCounter++, (Expression)variable);
                return new ExpressionSymbol(variable.getName(), (Expression)selectRef);
            }
            if (grpName.equals("INPUT") || grpName.equals("CHANGING")) {
                Expression selectConst = this.evaluateInputChangingVariables(variable, grpName);
                if (selectConst.equals(NOT_CHANGING)) {
                    selectConst = NULL_CONSTANT;
                }
                return new ExpressionSymbol(variable.getName(), selectConst);
            }
        }
        return variable;
    }

    private Expression getVariableValue(ElementSymbol variable) {
        if (variable.isExternalReference()) {
            String grpName = variable.getGroupSymbol().getCanonicalName();
            if (grpName.equals("VARIABLES")) {
                return new Reference(this.refCounter++, (Expression)variable);
            }
            if (grpName.equals("INPUT") || grpName.equals("CHANGING")) {
                return this.evaluateInputChangingVariables(variable, grpName);
            }
            if (!grpName.startsWith("#")) {
                return new Reference(this.refCounter++, (Expression)variable);
            }
        }
        return variable;
    }

    private Expression replaceExpression(Expression expr) {
        if (expr instanceof AliasSymbol) {
            expr = ((AliasSymbol)expr).getSymbol();
        }
        if (expr instanceof ElementSymbol && (expr = this.getVariableValue((ElementSymbol)expr)).equals(NOT_CHANGING)) {
            expr = NULL_CONSTANT;
        }
        return expr;
    }

    public static final void substituteVariables(LanguageObject obj, Command userCommand, QueryMetadataInterface metadata) throws QueryValidatorException {
        VariableSubstitutionVisitor visitor = new VariableSubstitutionVisitor(userCommand, metadata);
        if (obj instanceof CreateUpdateProcedureCommand) {
            visitor.setProcedure((CreateUpdateProcedureCommand)obj);
        }
        DeepPreOrderNavigator.doVisit((LanguageObject)obj, (LanguageVisitor)visitor);
        if (visitor.validExp != null) {
            throw visitor.validExp;
        }
        if (visitor.invalidInput != null) {
            throw new QueryValidatorException(QueryExecPlugin.Util.getString("VariableSubstitutionVisitor.Input_vars_should_have_same_changing_state", (Object)visitor.invalidInput));
        }
    }
}

