/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.ExpressionEvaluationException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.api.exception.query.QueryResolverException;
import com.metamatrix.core.id.IDGenerator;
import com.metamatrix.core.id.IntegerID;
import com.metamatrix.core.id.IntegerIDFactory;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.execution.QueryExecPlugin;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.metadata.TempMetadataID;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.optimizer.capabilities.SourceCapabilities;
import com.metamatrix.query.optimizer.relational.plantree.JoinStrategyType;
import com.metamatrix.query.optimizer.relational.plantree.NodeConstants;
import com.metamatrix.query.optimizer.relational.plantree.PlanNode;
import com.metamatrix.query.optimizer.relational.rules.CapabilitiesUtil;
import com.metamatrix.query.optimizer.relational.rules.RuleImplementJoinStrategy;
import com.metamatrix.query.processor.ProcessorPlan;
import com.metamatrix.query.processor.relational.AccessNode;
import com.metamatrix.query.processor.relational.DependentAccessNode;
import com.metamatrix.query.processor.relational.DependentFeederNode;
import com.metamatrix.query.processor.relational.DependentProcedureAccessNode;
import com.metamatrix.query.processor.relational.DependentProcedureExecutionNode;
import com.metamatrix.query.processor.relational.DependentProjectNode;
import com.metamatrix.query.processor.relational.DependentSelectNode;
import com.metamatrix.query.processor.relational.DependentSortNode;
import com.metamatrix.query.processor.relational.DependentValueSource;
import com.metamatrix.query.processor.relational.DependentWaitNode;
import com.metamatrix.query.processor.relational.DupRemoveNode;
import com.metamatrix.query.processor.relational.GroupingNode;
import com.metamatrix.query.processor.relational.JoinNode;
import com.metamatrix.query.processor.relational.LimitNode;
import com.metamatrix.query.processor.relational.MergeJoinStrategy;
import com.metamatrix.query.processor.relational.NestedLoopJoinStrategy;
import com.metamatrix.query.processor.relational.NullNode;
import com.metamatrix.query.processor.relational.PlanExecutionNode;
import com.metamatrix.query.processor.relational.ProjectIntoNode;
import com.metamatrix.query.processor.relational.ProjectNode;
import com.metamatrix.query.processor.relational.RelationalNode;
import com.metamatrix.query.processor.relational.RelationalPlan;
import com.metamatrix.query.processor.relational.SelectNode;
import com.metamatrix.query.processor.relational.SortNode;
import com.metamatrix.query.processor.relational.UnionAllNode;
import com.metamatrix.query.resolver.util.ResolverUtil;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.JoinType;
import com.metamatrix.query.sql.lang.StoredProcedure;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.visitor.DependentSetCriteriaCollectorVisitor;
import com.metamatrix.query.sql.visitor.EvaluateExpressionVisitor;
import com.metamatrix.query.sql.visitor.GroupCollectorVisitor;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class PlanToProcessConverter {
    public static ProcessorPlan convert(PlanNode planNode, QueryMetadataInterface metadata, IDGenerator idGenerator, AnalysisRecord analysisRecord, CapabilitiesFinder capFinder) throws QueryPlannerException, MetaMatrixComponentException {
        boolean debug = analysisRecord.recordDebug();
        if (debug) {
            analysisRecord.println("\n============================================================================");
            analysisRecord.println("CONVERTING PLAN TREE TO PROCESS TREE");
        }
        RelationalNode processNode = PlanToProcessConverter.convertPlan(planNode, null, idGenerator, metadata, capFinder);
        if (debug) {
            analysisRecord.println("\nPROCESS PLAN = \n" + processNode);
            analysisRecord.println("============================================================================");
        }
        RelationalPlan processPlan = new RelationalPlan(processNode);
        return processPlan;
    }

    private static RelationalNode convertPlan(PlanNode planNode, RelationalNode parent, IDGenerator idGenerator, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryPlannerException, MetaMatrixComponentException {
        RelationalNode convertedNode = PlanToProcessConverter.convertNode(planNode, idGenerator, metadata, capFinder);
        RelationalNode nextParent = null;
        if (convertedNode != null) {
            if (parent != null) {
                parent.addChild(convertedNode);
            }
            nextParent = convertedNode;
            while (nextParent.getChildren()[0] != null) {
                nextParent = nextParent.getChildren()[0];
            }
        } else {
            convertedNode = parent;
            nextParent = parent;
        }
        Iterator childIter = planNode.getChildren().iterator();
        while (childIter.hasNext()) {
            PlanNode childNode = (PlanNode)childIter.next();
            PlanToProcessConverter.convertPlan(childNode, nextParent, idGenerator, metadata, capFinder);
        }
        return convertedNode;
    }

    private static int getID(IDGenerator idGenerator) {
        IntegerIDFactory intFactory = (IntegerIDFactory)idGenerator.getDefaultFactory();
        return ((IntegerID)intFactory.create()).getValue();
    }

    private static RelationalNode convertNode(PlanNode node, IDGenerator idGenerator, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryPlannerException, MetaMatrixComponentException {
        DependentValueSource depValueSource;
        Object processNode = null;
        Command possiblyDependentObject = null;
        switch (node.getType()) {
            case 11: {
                GroupSymbol intoGroup = (GroupSymbol)node.getProperty((Object)NodeConstants.Info.INTO_GROUP);
                if (intoGroup != null) {
                    ProjectIntoNode pinode = new ProjectIntoNode(PlanToProcessConverter.getID(idGenerator));
                    pinode.setIntoGroup(intoGroup);
                    try {
                        List allIntoElements = ResolverUtil.resolveElementsInGroup((GroupSymbol)intoGroup, (QueryMetadataInterface)metadata);
                        pinode.setIntoElements(allIntoElements);
                        Object groupID = intoGroup.getMetadataID();
                        Object modelID = metadata.getModelID(groupID);
                        String modelName = metadata.getFullName(modelID);
                        pinode.setModelName(modelName);
                        if (!metadata.isVirtualGroup(groupID) && !metadata.isTemporaryTable(groupID)) {
                            SourceCapabilities caps = capFinder.findCapabilities(modelName);
                            pinode.setDoBatching(caps.supportsCapability("UPDATE.BATCHED"));
                            pinode.setDoBulkInsert(caps.supportsCapability("BULK.INSERT"));
                        } else if (metadata.isTemporaryTable(groupID)) {
                            pinode.setDoBulkInsert(true);
                        }
                    }
                    catch (QueryResolverException e) {
                        throw new MetaMatrixComponentException((Throwable)e);
                    }
                    catch (QueryMetadataException e) {
                        throw new MetaMatrixComponentException((Throwable)e);
                    }
                    processNode = pinode;
                    break;
                }
                List subqueryPlans = (List)node.getProperty((Object)NodeConstants.Info.SUBQUERY_PLANS);
                if (subqueryPlans == null) {
                    ProjectNode pnode = new ProjectNode(PlanToProcessConverter.getID(idGenerator));
                    List symbols = (List)node.getProperty((Object)NodeConstants.Info.PROJECT_COLS);
                    pnode.setSelectSymbols(symbols);
                    processNode = pnode;
                    break;
                }
                List subqueries = (List)node.getProperty((Object)NodeConstants.Info.SUBQUERY_VALUE_PROVIDERS);
                DependentProjectNode pnode = new DependentProjectNode(PlanToProcessConverter.getID(idGenerator));
                List symbols = (List)node.getProperty((Object)NodeConstants.Info.PROJECT_COLS);
                pnode.setSelectSymbols(symbols);
                pnode.setPlansAndValueProviders(subqueryPlans, subqueries);
                List correlatedReferences = (List)node.getProperty((Object)NodeConstants.Info.CORRELATED_REFERENCES);
                if (correlatedReferences != null) {
                    pnode.setCorrelatedReferences(correlatedReferences);
                }
                processNode = pnode;
                break;
            }
            case 7: {
                JoinType jtype = (JoinType)node.getProperty((Object)NodeConstants.Info.JOIN_TYPE);
                JoinStrategyType stype = (JoinStrategyType)node.getProperty((Object)NodeConstants.Info.JOIN_STRATEGY);
                JoinNode jnode = new JoinNode(PlanToProcessConverter.getID(idGenerator));
                List joinCrits = (List)node.getProperty((Object)NodeConstants.Info.JOIN_CRITERIA);
                Criteria joinCrit = Criteria.combineCriteria((List)joinCrits);
                jnode.setJoinCriteria(joinCrit);
                List oneSideJoinCrits = (List)node.getProperty((Object)NodeConstants.Info.NON_EQUI_JOIN_CRITERIA);
                Criteria oneSideJoinCrit = Criteria.combineCriteria((List)oneSideJoinCrits);
                jnode.setNonEquiJoinCriteria(oneSideJoinCrit);
                if (stype.equals((Object)JoinStrategyType.MERGE)) {
                    MergeJoinStrategy mjStrategy = new MergeJoinStrategy();
                    jnode.setJoinStrategy(mjStrategy);
                    jnode.setJoinType(jtype);
                    List leftExpressions = (List)node.getProperty((Object)NodeConstants.Info.LEFT_EXPRESSIONS);
                    List rightExpressions = (List)node.getProperty((Object)NodeConstants.Info.RIGHT_EXPRESSIONS);
                    jnode.setJoinExpressions(leftExpressions, rightExpressions);
                } else {
                    possiblyDependentObject = joinCrit;
                    NestedLoopJoinStrategy nljStrategy = new NestedLoopJoinStrategy();
                    jnode.setJoinStrategy(nljStrategy);
                    jnode.setJoinType(jtype);
                }
                processNode = jnode;
                depValueSource = (DependentValueSource)node.getProperty((Object)NodeConstants.Info.DEPENDENT_VALUE_SOURCE);
                if (depValueSource == null) break;
                jnode.setDependent(true);
                node.removeProperty((Object)NodeConstants.Info.DEPENDENT_VALUE_SOURCE);
                node.getFirstChild().setProperty((Object)NodeConstants.Info.DEPENDENT_VALUE_SOURCE, (Object)depValueSource);
                break;
            }
            case 3: {
                Command command;
                ProcessorPlan plan = (ProcessorPlan)node.getProperty((Object)NodeConstants.Info.PROCESSOR_PLAN);
                if (plan != null) {
                    PlanExecutionNode peNode = null;
                    Criteria crit = (Criteria)node.getProperty((Object)NodeConstants.Info.PROCEDURE_CRITERIA);
                    possiblyDependentObject = crit;
                    if (crit != null) {
                        List references = (List)node.getProperty((Object)NodeConstants.Info.PROCEDURE_INPUTS);
                        List defaults = (List)node.getProperty((Object)NodeConstants.Info.PROCEDURE_DEFAULTS);
                        peNode = new DependentProcedureExecutionNode(PlanToProcessConverter.getID(idGenerator), crit, references, defaults);
                    } else {
                        peNode = new PlanExecutionNode(PlanToProcessConverter.getID(idGenerator));
                    }
                    peNode.setProcessorPlan(plan);
                    processNode = peNode;
                    break;
                }
                possiblyDependentObject = command = (Command)node.getProperty((Object)NodeConstants.Info.ATOMIC_REQUEST);
                if (node.hasBooleanProperty((Object)NodeConstants.Info.IS_DEPENDENT_SET)) {
                    if (command instanceof StoredProcedure) {
                        List references = (List)node.getProperty((Object)NodeConstants.Info.PROCEDURE_INPUTS);
                        List defaults = (List)node.getProperty((Object)NodeConstants.Info.PROCEDURE_DEFAULTS);
                        Criteria crit = (Criteria)node.getProperty((Object)NodeConstants.Info.PROCEDURE_CRITERIA);
                        DependentProcedureAccessNode depAccessNode = new DependentProcedureAccessNode(PlanToProcessConverter.getID(idGenerator), crit, references, defaults);
                        depAccessNode.setShouldEvaluateExpressions(true);
                        processNode = depAccessNode;
                    } else {
                        DependentAccessNode depAccessNode = new DependentAccessNode(PlanToProcessConverter.getID(idGenerator));
                        Object modelID = node.getProperty((Object)NodeConstants.Info.MODEL_ID);
                        int maxSetSize = -1;
                        if (modelID != null) {
                            try {
                                maxSetSize = CapabilitiesUtil.getMaxInCriteriaSize((Object)modelID, (QueryMetadataInterface)metadata, (CapabilitiesFinder)capFinder);
                            }
                            catch (QueryMetadataException e) {
                                throw new QueryPlannerException((Throwable)e, QueryExecPlugin.Util.getString("ERR.015.004.0006", modelID));
                            }
                        }
                        depAccessNode.setMaxSetSize(maxSetSize);
                        depAccessNode.setSortController((RuleImplementJoinStrategy.DependentSortController)node.getProperty((Object)NodeConstants.Info.SORT_CONTROLLER));
                        processNode = depAccessNode;
                        depAccessNode.setShouldEvaluateExpressions(true);
                    }
                } else {
                    AccessNode anode = new AccessNode(PlanToProcessConverter.getID(idGenerator));
                    processNode = anode;
                    try {
                        anode.setShouldEvaluateExpressions(EvaluateExpressionVisitor.wouldChangeExpressions((LanguageObject)command, (boolean)true, (boolean)true));
                    }
                    catch (ExpressionEvaluationException e) {
                        anode.setShouldEvaluateExpressions(true);
                    }
                }
                AccessNode aNode = (AccessNode)processNode;
                aNode.setCommand(command);
                aNode.setModelName(PlanToProcessConverter.getRoutingName(node, metadata));
                break;
            }
            case 13: {
                List subPlans = (List)node.getProperty((Object)NodeConstants.Info.SUBQUERY_PLANS);
                Criteria crit = (Criteria)node.getProperty((Object)NodeConstants.Info.SELECT_CRITERIA);
                if (subPlans == null) {
                    SelectNode selnode = new SelectNode(PlanToProcessConverter.getID(idGenerator));
                    selnode.setCriteria(crit);
                    processNode = selnode;
                } else {
                    List subCrits = (List)node.getProperty((Object)NodeConstants.Info.SUBQUERY_VALUE_PROVIDERS);
                    DependentSelectNode selnode = null;
                    selnode = new DependentSelectNode(PlanToProcessConverter.getID(idGenerator));
                    selnode.setCriteria(crit);
                    selnode.setPlansAndCriteriaMapping(subPlans, subCrits);
                    List correlatedReferences = (List)node.getProperty((Object)NodeConstants.Info.CORRELATED_REFERENCES);
                    if (correlatedReferences != null) {
                        selnode.setCorrelatedReferences(correlatedReferences);
                    }
                    processNode = selnode;
                }
                possiblyDependentObject = crit;
                break;
            }
            case 17: {
                RuleImplementJoinStrategy.DependentSortController controller = (RuleImplementJoinStrategy.DependentSortController)node.getProperty((Object)NodeConstants.Info.SORT_CONTROLLER);
                DependentSortNode sortNode = null;
                if (controller != null) {
                    sortNode = new DependentSortNode(PlanToProcessConverter.getID(idGenerator));
                    sortNode.setSortController(controller);
                } else {
                    sortNode = new SortNode(PlanToProcessConverter.getID(idGenerator));
                }
                List elements = (List)node.getProperty((Object)NodeConstants.Info.SORT_ORDER);
                List sortTypes = (List)node.getProperty((Object)NodeConstants.Info.ORDER_TYPES);
                sortNode.setSortElements(elements, sortTypes);
                processNode = sortNode;
                break;
            }
            case 5: {
                processNode = new DupRemoveNode(PlanToProcessConverter.getID(idGenerator));
                break;
            }
            case 23: {
                GroupingNode gnode = new GroupingNode(PlanToProcessConverter.getID(idGenerator));
                gnode.setGroupingElements((List)node.getProperty((Object)NodeConstants.Info.GROUP_COLS));
                processNode = gnode;
                break;
            }
            case 19: {
                DependentValueSource depValueSource2;
                Map symbolMap = (Map)node.getProperty((Object)NodeConstants.Info.SYMBOL_MAP);
                if (symbolMap != null) {
                    PlanNode child = node.getLastChild();
                    child.setProperty((Object)NodeConstants.Info.SYMBOL_MAP, (Object)symbolMap);
                    if (node.getParent().getType() != 11 || node.getParent().getProperty((Object)NodeConstants.Info.INTO_GROUP) == null) {
                        child.setProperty((Object)NodeConstants.Info.OUTPUT_COLS, node.getProperty((Object)NodeConstants.Info.OUTPUT_COLS));
                    }
                }
                if ((depValueSource2 = (DependentValueSource)node.getProperty((Object)NodeConstants.Info.DEPENDENT_VALUE_SOURCE)) != null) {
                    node.removeProperty((Object)NodeConstants.Info.DEPENDENT_VALUE_SOURCE);
                    node.getFirstChild().setProperty((Object)NodeConstants.Info.DEPENDENT_VALUE_SOURCE, (Object)depValueSource2);
                }
                return null;
            }
            case 29: {
                int setOp = (Integer)node.getProperty((Object)NodeConstants.Info.SET_OPERATION);
                boolean useAll = (Boolean)node.getProperty((Object)NodeConstants.Info.USE_ALL);
                if (setOp != 0) break;
                UnionAllNode unionAllNode = new UnionAllNode(PlanToProcessConverter.getID(idGenerator));
                if (useAll) {
                    processNode = unionAllNode;
                    break;
                }
                processNode = new DupRemoveNode(PlanToProcessConverter.getID(idGenerator));
                unionAllNode.setElements((List)node.getProperty((Object)NodeConstants.Info.OUTPUT_COLS));
                processNode.addChild((RelationalNode)unionAllNode);
                break;
            }
            case 41: {
                Expression rowLimit = (Expression)node.getProperty((Object)NodeConstants.Info.MAX_TUPLE_LIMIT);
                Expression offset = (Expression)node.getProperty((Object)NodeConstants.Info.OFFSET_TUPLE_COUNT);
                processNode = new LimitNode(PlanToProcessConverter.getID(idGenerator), rowLimit, offset);
                break;
            }
            case 31: {
                processNode = new NullNode(PlanToProcessConverter.getID(idGenerator));
                break;
            }
            default: {
                throw new QueryPlannerException(QueryExecPlugin.Util.getString("ERR.015.004.0007", (Object)NodeConstants.getNodeTypeString((int)node.getType())));
            }
        }
        if (processNode != null) {
            Number estimateJoinCost;
            Number estimateDepJoinCost;
            Number estimateDepAccessCardinality;
            Number estimateNodeSetSize;
            Map symbolMap = (Map)node.getProperty((Object)NodeConstants.Info.SYMBOL_MAP);
            if (symbolMap != null) {
                processNode.setSymbolMap(symbolMap);
            }
            List cols = (List)node.getProperty((Object)NodeConstants.Info.OUTPUT_COLS);
            processNode.setElements(cols);
            List topCols = (List)node.getProperty((Object)NodeConstants.Info.TOP_COLS);
            processNode.setTopElements(topCols);
            Number estimateNodeCardinality = (Number)node.getProperty((Object)NodeConstants.Info.EST_CARDINALITY);
            if (estimateNodeCardinality != null) {
                processNode.setEstimateNodeCardinality(estimateNodeCardinality);
            }
            if ((estimateNodeSetSize = (Number)node.getProperty((Object)NodeConstants.Info.EST_SET_SIZE)) != null) {
                processNode.setEstimateNodeSetSize(estimateNodeSetSize);
            }
            if ((estimateDepAccessCardinality = (Number)node.getProperty((Object)NodeConstants.Info.EST_DEP_CARDINALITY)) != null) {
                processNode.setEstimateDepAccessCardinality(estimateDepAccessCardinality);
            }
            if ((estimateDepJoinCost = (Number)node.getProperty((Object)NodeConstants.Info.EST_DEP_JOIN_COST)) != null) {
                processNode.setEstimateDepJoinCost(estimateDepJoinCost);
            }
            if ((estimateJoinCost = (Number)node.getProperty((Object)NodeConstants.Info.EST_JOIN_COST)) != null) {
                processNode.setEstimateJoinCost(estimateJoinCost);
            }
            if (node.hasBooleanProperty((Object)NodeConstants.Info.IS_DEPENDENT_SET)) {
                DependentWaitNode waitNode = new DependentWaitNode(PlanToProcessConverter.getID(idGenerator));
                waitNode.setDependentCriteria(DependentSetCriteriaCollectorVisitor.getDependentSetCriteria((LanguageObject)possiblyDependentObject));
                processNode = PlanToProcessConverter.insertNode((RelationalNode)processNode, (RelationalNode)waitNode, cols, topCols, estimateNodeCardinality, estimateNodeSetSize, estimateDepAccessCardinality, estimateDepJoinCost, estimateJoinCost);
            }
            if ((depValueSource = (DependentValueSource)node.getProperty((Object)NodeConstants.Info.DEPENDENT_VALUE_SOURCE)) != null) {
                DependentFeederNode feederNode = new DependentFeederNode(PlanToProcessConverter.getID(idGenerator));
                feederNode.setDependentValueSource(depValueSource);
                processNode = PlanToProcessConverter.insertNode((RelationalNode)processNode, (RelationalNode)feederNode, cols, topCols, estimateNodeCardinality, estimateNodeSetSize, estimateDepAccessCardinality, estimateDepJoinCost, estimateJoinCost);
            }
        }
        return processNode;
    }

    private static RelationalNode insertNode(RelationalNode currentNode, RelationalNode insertedNode, List cols, List topCols, Number estimateNodeCardinality, Number estimateNodeSetSize, Number estimateDepAccessCardinality, Number estimateDepJoinCost, Number estimateJoinCost) {
        insertedNode.setElements(cols);
        insertedNode.setTopElements(topCols);
        insertedNode.setEstimateNodeCardinality(estimateNodeCardinality);
        insertedNode.setEstimateNodeSetSize(estimateNodeSetSize);
        insertedNode.setEstimateDepAccessCardinality(estimateDepAccessCardinality);
        insertedNode.setEstimateDepJoinCost(estimateDepJoinCost);
        insertedNode.setEstimateJoinCost(estimateJoinCost);
        insertedNode.addChild(currentNode);
        return insertedNode;
    }

    private static String getRoutingName(PlanNode node, QueryMetadataInterface metadata) throws QueryPlannerException, MetaMatrixComponentException {
        try {
            Object modelID = node.getProperty((Object)NodeConstants.Info.MODEL_ID);
            if (modelID == null || modelID instanceof TempMetadataID) {
                Command command = (Command)node.getProperty((Object)NodeConstants.Info.ATOMIC_REQUEST);
                if (command instanceof StoredProcedure) {
                    modelID = ((StoredProcedure)command).getModelID();
                } else {
                    Collection groups = GroupCollectorVisitor.getGroups((LanguageObject)command, (boolean)true);
                    Iterator groupIter = groups.iterator();
                    GroupSymbol group = (GroupSymbol)groupIter.next();
                    modelID = metadata.getModelID(group.getMetadataID());
                }
            }
            String cbName = metadata.getFullName(modelID);
            return cbName;
        }
        catch (QueryMetadataException e) {
            throw new QueryPlannerException((Throwable)e, QueryExecPlugin.Util.getString("ERR.015.004.0009"));
        }
    }
}

