/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.modelgenerator.xml.model;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MapResultSet
implements ResultSet {
    List values;
    Map names;
    String[] reverseNames;
    int row;
    boolean wasNull;
    MetaData metaData;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$sql$Clob;
    static /* synthetic */ Class class$java$sql$Blob;
    static /* synthetic */ Class class$java$sql$Array;
    static /* synthetic */ Class class$java$sql$Struct;
    static /* synthetic */ Class class$java$sql$Ref;

    public MapResultSet(List values, Map names) {
        this.values = Collections.unmodifiableList(values);
        this.names = names;
        this.reverseNames = new String[names.size() + 1];
        Iterator iter = names.keySet().iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            String name = (String)o;
            Number n = (Number)names.get(name);
            int column = n.intValue();
            this.reverseNames[column] = name;
        }
        this.row = -1;
        this.wasNull = false;
        this.metaData = new MetaData();
    }

    public int getConcurrency() throws SQLException {
        return 1007;
    }

    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    public int getFetchSize() throws SQLException {
        return 1;
    }

    public int getRow() throws SQLException {
        return this.row + 1;
    }

    public int getType() throws SQLException {
        return 1003;
    }

    public void afterLast() throws SQLException {
        this.row = this.values.size();
    }

    public void beforeFirst() throws SQLException {
        this.row = -1;
    }

    public void cancelRowUpdates() throws SQLException {
    }

    public void clearWarnings() throws SQLException {
    }

    public void close() throws SQLException {
    }

    public void deleteRow() throws SQLException {
        this.throwReadOnly();
    }

    public void insertRow() throws SQLException {
        this.throwReadOnly();
    }

    private void throwReadOnly() throws SQLException {
        throw new SQLException("Read only");
    }

    private void throwNotImplemented() throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void moveToCurrentRow() throws SQLException {
    }

    public void moveToInsertRow() throws SQLException {
        this.throwReadOnly();
    }

    public void refreshRow() throws SQLException {
        this.throwReadOnly();
    }

    public void updateRow() throws SQLException {
        this.throwReadOnly();
    }

    public boolean first() throws SQLException {
        this.row = 0;
        return this.values.size() > 0;
    }

    public boolean isAfterLast() throws SQLException {
        return this.row >= this.values.size();
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.row < 0;
    }

    public boolean isFirst() throws SQLException {
        return this.row == 0;
    }

    public boolean isLast() throws SQLException {
        return this.row == this.values.size() - 1;
    }

    public boolean last() throws SQLException {
        this.row = this.values.size() - 1;
        return this.values.size() > 0;
    }

    public boolean next() throws SQLException {
        ++this.row;
        return !this.isAfterLast();
    }

    public boolean previous() throws SQLException {
        ++this.row;
        return !this.isBeforeFirst();
    }

    public boolean rowDeleted() throws SQLException {
        return false;
    }

    public boolean rowInserted() throws SQLException {
        return false;
    }

    public boolean rowUpdated() throws SQLException {
        return false;
    }

    public boolean wasNull() throws SQLException {
        return this.wasNull;
    }

    public byte getByte(int columnIndex) throws SQLException {
        String str = this.getString(columnIndex);
        boolean bl = this.wasNull = str == null;
        if (this.wasNull) {
            return 0;
        }
        return new Byte(str);
    }

    public double getDouble(int columnIndex) throws SQLException {
        String str = this.getString(columnIndex);
        boolean bl = this.wasNull = str == null;
        if (this.wasNull) {
            return 0.0;
        }
        return new Double(str);
    }

    public float getFloat(int columnIndex) throws SQLException {
        String str = this.getString(columnIndex);
        boolean bl = this.wasNull = str == null;
        if (this.wasNull) {
            return 0.0f;
        }
        return new Float(str).floatValue();
    }

    public int getInt(int columnIndex) throws SQLException {
        String str = this.getString(columnIndex);
        boolean bl = this.wasNull = str == null;
        if (this.wasNull) {
            return 0;
        }
        return new Integer(str);
    }

    public long getLong(int columnIndex) throws SQLException {
        String str = this.getString(columnIndex);
        boolean bl = this.wasNull = str == null;
        if (this.wasNull) {
            return 0L;
        }
        return new Long(str);
    }

    public short getShort(int columnIndex) throws SQLException {
        String str = this.getString(columnIndex);
        boolean bl = this.wasNull = str == null;
        if (this.wasNull) {
            return 0;
        }
        return new Short(str);
    }

    public void setFetchDirection(int direction) throws SQLException {
    }

    public void setFetchSize(int rows) throws SQLException {
    }

    public void updateNull(int columnIndex) throws SQLException {
        this.throwReadOnly();
    }

    public boolean absolute(int row) throws SQLException {
        this.row = row > 0 ? row - 1 : this.values.size() + row;
        return !this.isBeforeFirst() && !this.isAfterLast();
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        String str = this.getString(columnIndex);
        boolean bl = this.wasNull = str == null;
        if (this.wasNull) {
            return false;
        }
        return new Boolean(str);
    }

    public boolean relative(int rows) throws SQLException {
        this.row += rows;
        return !this.isBeforeFirst() && !this.isAfterLast();
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        Object o = this.getObject(columnIndex);
        boolean bl = this.wasNull = o == null;
        if (o instanceof byte[]) {
            return (byte[])o;
        }
        if (this.wasNull) {
            return new byte[0];
        }
        return o.toString().getBytes();
    }

    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.throwReadOnly();
    }

    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.throwReadOnly();
    }

    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.throwReadOnly();
    }

    public void updateInt(int columnIndex, int x) throws SQLException {
        this.throwReadOnly();
    }

    public void updateLong(int columnIndex, long x) throws SQLException {
        this.throwReadOnly();
    }

    public void updateShort(int columnIndex, short x) throws SQLException {
        this.throwReadOnly();
    }

    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.throwReadOnly();
    }

    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.throwReadOnly();
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        Reader reader = this.getCharacterStream(columnIndex);
        boolean bl = this.wasNull = reader == null;
        if (this.wasNull) {
            return null;
        }
        return new ReaderInputStream(reader, "US-ASCII");
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        Object o = this.getObject(columnIndex);
        boolean bl = this.wasNull = o == null;
        if (this.wasNull) {
            return null;
        }
        if (o instanceof InputStream) {
            return (InputStream)o;
        }
        if (o instanceof Reader) {
            return new ReaderInputStream((Reader)o, "UTF16");
        }
        byte[] bytes = this.getBytes(columnIndex);
        return new ByteArrayInputStream(bytes);
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        Reader reader = this.getCharacterStream(columnIndex);
        boolean bl = this.wasNull = reader == null;
        if (this.wasNull) {
            return null;
        }
        return new ReaderInputStream(reader, "UTF16");
    }

    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.throwReadOnly();
    }

    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.throwReadOnly();
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        Object o = this.getObject(columnIndex);
        boolean bl = this.wasNull = o == null;
        if (this.wasNull) {
            return null;
        }
        if (o instanceof Reader) {
            return (Reader)o;
        }
        if (o instanceof InputStream) {
            try {
                return new InputStreamReader((InputStream)o, "UTF16");
            }
            catch (UnsupportedEncodingException e) {
                throw this.wrapException(e);
            }
        }
        String str = this.getString(columnIndex);
        return new StringReader(str);
    }

    private SQLException wrapException(Exception e) {
        return new SQLException(e.toString());
    }

    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.throwReadOnly();
    }

    public Object getObject(int columnIndex) throws SQLException {
        return this.getObjectFromRow(columnIndex, this.row);
    }

    private Object getObjectFromRow(int columnIndex, int rowIndex) {
        List rowvalues = (List)this.values.get(rowIndex);
        return rowvalues.get(columnIndex - 1);
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.throwReadOnly();
    }

    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        this.throwReadOnly();
    }

    public String getCursorName() throws SQLException {
        return "";
    }

    public String getString(int columnIndex) throws SQLException {
        Object o = this.getObject(columnIndex);
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    public void updateString(int columnIndex, String x) throws SQLException {
        this.throwReadOnly();
    }

    public byte getByte(String columnName) throws SQLException {
        int index = this.findColumn(columnName);
        return this.getByte(index);
    }

    public double getDouble(String columnName) throws SQLException {
        int index = this.findColumn(columnName);
        return this.getDouble(index);
    }

    public float getFloat(String columnName) throws SQLException {
        int index = this.findColumn(columnName);
        return this.getFloat(index);
    }

    public int findColumn(String columnName) throws SQLException {
        Object o = this.names.get(columnName);
        Number n = (Number)o;
        int index = n.intValue();
        return index;
    }

    public String reverseFindColumn(int column) throws SQLException {
        return this.reverseNames[column];
    }

    public int getInt(String columnName) throws SQLException {
        int index = this.findColumn(columnName);
        return this.getInt(index);
    }

    public long getLong(String columnName) throws SQLException {
        int index = this.findColumn(columnName);
        return this.getLong(index);
    }

    public short getShort(String columnName) throws SQLException {
        int index = this.findColumn(columnName);
        return this.getShort(index);
    }

    public void updateNull(String columnName) throws SQLException {
        this.throwReadOnly();
    }

    public boolean getBoolean(String columnName) throws SQLException {
        int index = this.findColumn(columnName);
        return this.getBoolean(index);
    }

    public byte[] getBytes(String columnName) throws SQLException {
        int index = this.findColumn(columnName);
        return this.getBytes(index);
    }

    public void updateByte(String columnName, byte x) throws SQLException {
        this.throwReadOnly();
    }

    public void updateDouble(String columnName, double x) throws SQLException {
        this.throwReadOnly();
    }

    public void updateFloat(String columnName, float x) throws SQLException {
        this.throwReadOnly();
    }

    public void updateInt(String columnName, int x) throws SQLException {
        this.throwReadOnly();
    }

    public void updateLong(String columnName, long x) throws SQLException {
        this.throwReadOnly();
    }

    public void updateShort(String columnName, short x) throws SQLException {
        this.throwReadOnly();
    }

    public void updateBoolean(String columnName, boolean x) throws SQLException {
        this.throwReadOnly();
    }

    public void updateBytes(String columnName, byte[] x) throws SQLException {
        this.throwReadOnly();
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        String str = this.getString(columnIndex);
        boolean bl = this.wasNull = str == null;
        if (this.wasNull) {
            return null;
        }
        return new BigDecimal(str);
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return this.getBigDecimal(columnIndex);
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.throwReadOnly();
    }

    public URL getURL(int columnIndex) throws SQLException {
        String str = this.getString(columnIndex);
        boolean bl = this.wasNull = str == null;
        if (this.wasNull) {
            return null;
        }
        try {
            return new URL(str);
        }
        catch (MalformedURLException e) {
            throw this.wrapException(e);
        }
    }

    public Array getArray(int i) throws SQLException {
        this.throwNotImplemented();
        return null;
    }

    public void updateArray(int columnIndex, Array x) throws SQLException {
        this.throwReadOnly();
    }

    public Blob getBlob(int i) throws SQLException {
        this.throwNotImplemented();
        return null;
    }

    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.throwReadOnly();
    }

    public Clob getClob(int i) throws SQLException {
        this.throwNotImplemented();
        return null;
    }

    public void updateClob(int columnIndex, Clob x) throws SQLException {
        this.throwReadOnly();
    }

    public Date getDate(int columnIndex) throws SQLException {
        String str = this.getString(columnIndex);
        boolean bl = this.wasNull = str == null;
        if (this.wasNull) {
            return null;
        }
        return new Date(Date.parse(str));
    }

    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.throwReadOnly();
    }

    public Ref getRef(int i) throws SQLException {
        this.throwNotImplemented();
        return null;
    }

    public void updateRef(int columnIndex, Ref x) throws SQLException {
        this.throwReadOnly();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.metaData;
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public Statement getStatement() throws SQLException {
        return null;
    }

    public Time getTime(int columnIndex) throws SQLException {
        String str = this.getString(columnIndex);
        boolean bl = this.wasNull = str == null;
        if (this.wasNull) {
            return null;
        }
        return new Time(Time.parse(str));
    }

    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.throwReadOnly();
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        String str = this.getString(columnIndex);
        boolean bl = this.wasNull = str == null;
        if (this.wasNull) {
            return null;
        }
        return new Timestamp(Timestamp.parse(str));
    }

    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.throwReadOnly();
    }

    public InputStream getAsciiStream(String columnName) throws SQLException {
        int index = this.findColumn(columnName);
        return this.getAsciiStream(index);
    }

    public InputStream getBinaryStream(String columnName) throws SQLException {
        int index = this.findColumn(columnName);
        return this.getBinaryStream(index);
    }

    public InputStream getUnicodeStream(String columnName) throws SQLException {
        int index = this.findColumn(columnName);
        return this.getUnicodeStream(index);
    }

    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.throwReadOnly();
    }

    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.throwReadOnly();
    }

    public Reader getCharacterStream(String columnName) throws SQLException {
        int index = this.findColumn(columnName);
        return this.getCharacterStream(index);
    }

    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.throwReadOnly();
    }

    public Object getObject(String columnName) throws SQLException {
        int index = this.findColumn(columnName);
        return this.getObject(index);
    }

    public void updateObject(String columnName, Object x) throws SQLException {
        this.throwReadOnly();
    }

    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.throwReadOnly();
    }

    public Object getObject(int i, Map map) throws SQLException {
        return this.getObject(i);
    }

    public String getString(String columnName) throws SQLException {
        int index = this.findColumn(columnName);
        return this.getString(index);
    }

    public void updateString(String columnName, String x) throws SQLException {
        this.throwReadOnly();
    }

    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        int index = this.findColumn(columnName);
        return this.getBigDecimal(index);
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(columnName);
    }

    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.throwReadOnly();
    }

    public URL getURL(String columnName) throws SQLException {
        int index = this.findColumn(columnName);
        return this.getURL(index);
    }

    public Array getArray(String colName) throws SQLException {
        int index = this.findColumn(colName);
        return this.getArray(index);
    }

    public void updateArray(String columnName, Array x) throws SQLException {
        this.throwReadOnly();
    }

    public Blob getBlob(String colName) throws SQLException {
        int index = this.findColumn(colName);
        return this.getBlob(index);
    }

    public void updateBlob(String columnName, Blob x) throws SQLException {
        this.throwReadOnly();
    }

    public Clob getClob(String colName) throws SQLException {
        int index = this.findColumn(colName);
        return this.getClob(index);
    }

    public void updateClob(String columnName, Clob x) throws SQLException {
        this.throwReadOnly();
    }

    public Date getDate(String columnName) throws SQLException {
        int index = this.findColumn(columnName);
        return this.getDate(index);
    }

    public void updateDate(String columnName, Date x) throws SQLException {
        this.throwReadOnly();
    }

    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return this.getDate(columnIndex);
    }

    public Ref getRef(String colName) throws SQLException {
        int index = this.findColumn(colName);
        return this.getRef(index);
    }

    public void updateRef(String columnName, Ref x) throws SQLException {
        this.throwReadOnly();
    }

    public Time getTime(String columnName) throws SQLException {
        int index = this.findColumn(columnName);
        return this.getTime(index);
    }

    public void updateTime(String columnName, Time x) throws SQLException {
        this.throwReadOnly();
    }

    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return this.getTime(columnIndex);
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        int index = this.findColumn(columnName);
        return this.getTimestamp(index);
    }

    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.throwReadOnly();
    }

    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this.getTimestamp(columnIndex);
    }

    public Object getObject(String colName, Map map) throws SQLException {
        int index = this.findColumn(colName);
        return this.getObject(index);
    }

    public Date getDate(String columnName, Calendar cal) throws SQLException {
        int index = this.findColumn(columnName);
        return this.getDate(index);
    }

    public Time getTime(String columnName, Calendar cal) throws SQLException {
        int index = this.findColumn(columnName);
        return this.getTime(index);
    }

    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        int index = this.findColumn(columnName);
        return this.getTimestamp(index);
    }

    class MetaData
    implements ResultSetMetaData {
        MetaData() {
        }

        public String getCatalogName(int column) throws SQLException {
            return "";
        }

        public String getColumnClassName(int column) throws SQLException {
            Class cls = this.getColumnClass(column);
            return cls.getName();
        }

        private Class getColumnClass(int column) {
            Class retval = null;
            for (int i = 0; i < MapResultSet.this.values.size(); ++i) {
                Object value = MapResultSet.this.getObjectFromRow(column, i);
                if (value == null) continue;
                retval = value.getClass();
                break;
            }
            if (retval == null) {
                retval = class$java$lang$Object == null ? (class$java$lang$Object = MapResultSet.class$("java.lang.Object")) : class$java$lang$Object;
            }
            return retval;
        }

        public int getColumnCount() throws SQLException {
            return MapResultSet.this.names.size();
        }

        public int getColumnDisplaySize(int column) throws SQLException {
            return 32;
        }

        public String getColumnLabel(int column) throws SQLException {
            return MapResultSet.this.reverseFindColumn(column);
        }

        public String getColumnName(int column) throws SQLException {
            return MapResultSet.this.reverseFindColumn(column);
        }

        public int getColumnType(int column) throws SQLException {
            Class cls = this.getColumnClass(column);
            if (cls == (class$java$lang$String == null ? (class$java$lang$String = MapResultSet.class$("java.lang.String")) : class$java$lang$String)) {
                return 12;
            }
            if (cls == (class$java$lang$String == null ? (class$java$lang$String = MapResultSet.class$("java.lang.String")) : class$java$lang$String)) {
                return 12;
            }
            if (cls == (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = MapResultSet.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
                return 2;
            }
            if (cls == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = MapResultSet.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                return -7;
            }
            if (cls == (class$java$lang$Integer == null ? (class$java$lang$Integer = MapResultSet.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                return 4;
            }
            if (cls == (class$java$lang$Long == null ? (class$java$lang$Long = MapResultSet.class$("java.lang.Long")) : class$java$lang$Long)) {
                return -5;
            }
            if (cls == (class$java$lang$Float == null ? (class$java$lang$Float = MapResultSet.class$("java.lang.Float")) : class$java$lang$Float)) {
                return 7;
            }
            if (cls == (class$java$lang$Double == null ? (class$java$lang$Double = MapResultSet.class$("java.lang.Double")) : class$java$lang$Double)) {
                return 8;
            }
            if (cls == (array$B == null ? (array$B = MapResultSet.class$("[B")) : array$B)) {
                return -3;
            }
            if (cls == (class$java$sql$Date == null ? (class$java$sql$Date = MapResultSet.class$("java.sql.Date")) : class$java$sql$Date)) {
                return 91;
            }
            if (cls == (class$java$sql$Time == null ? (class$java$sql$Time = MapResultSet.class$("java.sql.Time")) : class$java$sql$Time)) {
                return 92;
            }
            if (cls == (class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = MapResultSet.class$("java.sql.Timestamp")) : class$java$sql$Timestamp)) {
                return 93;
            }
            if (cls == (class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = MapResultSet.class$("java.sql.Timestamp")) : class$java$sql$Timestamp)) {
                return 93;
            }
            if (cls == (class$java$sql$Clob == null ? (class$java$sql$Clob = MapResultSet.class$("java.sql.Clob")) : class$java$sql$Clob)) {
                return 2005;
            }
            if (cls == (class$java$sql$Blob == null ? (class$java$sql$Blob = MapResultSet.class$("java.sql.Blob")) : class$java$sql$Blob)) {
                return 2004;
            }
            if (cls == (class$java$sql$Array == null ? (class$java$sql$Array = MapResultSet.class$("java.sql.Array")) : class$java$sql$Array)) {
                return 2003;
            }
            if (cls == (class$java$sql$Struct == null ? (class$java$sql$Struct = MapResultSet.class$("java.sql.Struct")) : class$java$sql$Struct)) {
                return 2002;
            }
            if (cls == (class$java$sql$Ref == null ? (class$java$sql$Ref = MapResultSet.class$("java.sql.Ref")) : class$java$sql$Ref)) {
                return 2006;
            }
            return 2000;
        }

        public String getColumnTypeName(int column) throws SQLException {
            Class cls = this.getColumnClass(column);
            return cls.getName();
        }

        public int getPrecision(int column) throws SQLException {
            return 10;
        }

        public int getScale(int column) throws SQLException {
            return 10;
        }

        public String getSchemaName(int column) throws SQLException {
            return "";
        }

        public String getTableName(int column) throws SQLException {
            return "";
        }

        public boolean isAutoIncrement(int column) throws SQLException {
            return false;
        }

        public boolean isCaseSensitive(int column) throws SQLException {
            return true;
        }

        public boolean isCurrency(int column) throws SQLException {
            return false;
        }

        public boolean isDefinitelyWritable(int column) throws SQLException {
            return false;
        }

        public int isNullable(int column) throws SQLException {
            return 0;
        }

        public boolean isReadOnly(int column) throws SQLException {
            return true;
        }

        public boolean isSearchable(int column) throws SQLException {
            return false;
        }

        public boolean isSigned(int column) throws SQLException {
            return false;
        }

        public boolean isWritable(int column) throws SQLException {
            return false;
        }
    }

    static class ReaderInputStream
    extends InputStream {
        private Reader reader;
        private static final String ASCII = "US-ASCII";
        private static final String UNICODE = "UTF16";
        private String charset;
        private byte[] buffer;

        public ReaderInputStream(Reader reader, String charset) {
            this.reader = reader;
            this.charset = charset;
            this.buffer = new byte[0];
        }

        public int read() throws IOException {
            if (this.buffer.length > 0) {
                byte retval = this.buffer[0];
                byte[] newBytes = new byte[this.buffer.length - 1];
                System.arraycopy(this.buffer, 1, newBytes, 0, newBytes.length);
                this.buffer = newBytes;
                return retval;
            }
            int t = this.reader.read();
            if (t <= 0) {
                return t;
            }
            this.buffer = new Character((char)t).toString().getBytes(this.charset);
            if (this.buffer.length == 0) {
                return -1;
            }
            int retval = this.read();
            return retval;
        }
    }
}

