/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.internal.datamgr.impl;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.data.api.Connection;
import com.metamatrix.data.api.Connector;
import com.metamatrix.data.api.Execution;
import com.metamatrix.data.api.ExecutionContext;
import com.metamatrix.data.api.SecurityContext;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.language.IBatchedUpdates;
import com.metamatrix.data.language.IBulkInsert;
import com.metamatrix.data.language.ICommand;
import com.metamatrix.data.language.IProcedure;
import com.metamatrix.data.language.IQuery;
import com.metamatrix.data.metadata.runtime.RuntimeMetadata;
import com.metamatrix.data.xa.api.TransactionContext;
import com.metamatrix.data.xa.api.XAConnector;
import com.metamatrix.dqp.internal.datamgr.impl.AtomicRequestID;
import com.metamatrix.dqp.internal.datamgr.impl.ExecutionContextImpl;
import com.metamatrix.dqp.internal.datamgr.impl.TransactionState;
import com.metamatrix.dqp.internal.datamgr.language.LanguageBridgeFactory;
import com.metamatrix.dqp.internal.datamgr.metadata.MetadataFactory;
import com.metamatrix.dqp.internal.datamgr.metadata.RuntimeMetadataImpl;
import com.metamatrix.dqp.message.AtomicRequestMessage;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.sql.lang.Command;

class ConnectorRequestState {
    Connection connection;
    private Object connectionLock = new Object();
    SecurityContext securityContext;
    int executionMode;
    Execution execution;
    private Object executionLock = new Object();
    AtomicRequestID requestID;
    AtomicRequestMessage requestMsg;
    ICommand translatedCommand;
    Object stateLock = new Object();
    int processingState;
    boolean isCancelled = false;
    boolean closeRequested = false;
    TransactionState transactionState = TransactionState.TRANSACTION_NONE;
    int rowCount = 0;

    ConnectorRequestState(AtomicRequestMessage requestMessage, int state) {
        this.requestMsg = requestMessage;
        this.requestID = new AtomicRequestID(this.requestMsg);
        this.processingState = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Connection getConnection() {
        Object object = this.connectionLock;
        synchronized (object) {
            return this.connection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Connection getConnection(Connector connector) throws ConnectorException {
        Object object = this.connectionLock;
        synchronized (object) {
            if (this.connection == null) {
                try {
                    this.securityContext = new ExecutionContextImpl(this.requestMsg.getVdbName(), this.requestMsg.getVdbVersion(), this.requestMsg.getUserName(), this.requestMsg.getTrustedPayload(), this.requestMsg.getExecutionPayload(), this.requestMsg.getConnectionID(), this.requestMsg.getConnectorID().getID(), this.requestMsg.getRequestID().toString(), Integer.toString(this.requestMsg.getNodeID()), Integer.toString(this.requestMsg.getExecCount()), this.requestMsg.useResultSetCache() && this.requestMsg.getCommand().areResultsCachable());
                    if (this.requestMsg.isTransactional() && connector instanceof XAConnector) {
                        String txnID = this.requestMsg.getTransactionContext().getTopLevelTxnID().asString();
                        this.connection = ((XAConnector)connector).getXAConnection(this.securityContext, (TransactionContext)new /* Unavailable Anonymous Inner Class!! */);
                    } else {
                        this.connection = connector.getConnection(this.securityContext);
                    }
                }
                catch (ConnectorException e) {
                    LogManager.logError((String)"CONNECTOR", (Throwable)((Object)e), (String)e.getMessage());
                    throw e;
                }
            }
            return this.connection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Execution getExecution() {
        Object object = this.executionLock;
        synchronized (object) {
            return this.execution;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Execution createExecution(Connector connector, AtomicRequestMessage aqrMsg, QueryMetadataInterface queryMetadata) throws ConnectorException {
        Object object = this.executionLock;
        synchronized (object) {
            if (this.execution == null) {
                this.getConnection(connector);
                try {
                    Command command = this.requestMsg.getCommand();
                    LanguageBridgeFactory factory = new LanguageBridgeFactory(queryMetadata);
                    this.translatedCommand = factory.translate(command);
                    RuntimeMetadataImpl rmd = new RuntimeMetadataImpl(new MetadataFactory(queryMetadata));
                    if (this.translatedCommand instanceof IQuery) {
                        if (this.connection.getCapabilities().supportsExecutionMode(0)) {
                            this.executionMode = 0;
                        } else if (this.connection.getCapabilities().supportsExecutionMode(5)) {
                            this.executionMode = 5;
                        }
                    } else {
                        this.executionMode = this.translatedCommand instanceof IProcedure ? 2 : (this.translatedCommand instanceof IBatchedUpdates ? 3 : (this.translatedCommand instanceof IBulkInsert ? 4 : 1));
                    }
                    this.execution = this.connection.createExecution(this.executionMode, (ExecutionContext)this.securityContext, (RuntimeMetadata)rmd);
                }
                catch (MetaMatrixComponentException e) {
                    throw new ConnectorException(e);
                }
            }
            return this.execution;
        }
    }

    AtomicRequestMessage getRequestMsg() {
        return this.requestMsg;
    }

    public ICommand getTranslatedCommand() {
        return this.translatedCommand;
    }

    public int getExecutionMode() {
        return this.executionMode;
    }

    public SecurityContext getExecutionContext() {
        return this.securityContext;
    }

    public TransactionState getTransactionState() {
        return this.transactionState;
    }

    public void setTransactionState(TransactionState state) {
        this.transactionState = state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConnectorRequestState)) {
            return false;
        }
        ConnectorRequestState connectorRequestState = (ConnectorRequestState)o;
        return this.requestID.equals((Object)connectorRequestState.requestID);
    }

    public int hashCode() {
        return this.requestID.hashCode();
    }
}

