/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl;

import java.util.ArrayList;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.WSITag;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionFailException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionNotApplicableException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;

public class AP2911
extends AssertionProcess
implements WSITag {
    private final WSDLValidatorImpl validator;

    public AP2911(WSDLValidatorImpl impl) {
        super(impl);
        this.validator = impl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            boolean multipartsFound = false;
            Binding binding = (Binding)entryContext.getEntry().getEntryDetail();
            List ops = binding.getBindingOperations();
            int i = 0;
            while (i < ops.size()) {
                BindingOperation bindingOperation = (BindingOperation)ops.get(i);
                BindingInput bindingInput = bindingOperation.getBindingInput();
                BindingOutput bindingOutput = bindingOperation.getBindingOutput();
                List inputMultiparts = this.getMimeMultipartElements(bindingInput == null ? null : bindingInput.getExtensibilityElements());
                List outputMultiparts = this.getMimeMultipartElements(bindingOutput == null ? null : bindingOutput.getExtensibilityElements());
                if (!inputMultiparts.isEmpty()) {
                    multipartsFound = true;
                    if (!this.containsOneSoapBody(inputMultiparts)) {
                        throw new AssertionFailException("The invalid mime:multipartRelated element is in the wsdl:input of the \"" + bindingOperation.getName() + "\" binding operation.");
                    }
                }
                if (!outputMultiparts.isEmpty()) {
                    multipartsFound = true;
                    if (!this.containsOneSoapBody(outputMultiparts)) {
                        throw new AssertionFailException("The invalid mime:multipartRelated element is in the wsdl:output of the \"" + bindingOperation.getName() + "\" binding operation.");
                    }
                }
                ++i;
            }
            if (!multipartsFound) {
                throw new AssertionNotApplicableException();
            }
        }
        catch (AssertionNotApplicableException assertionNotApplicableException) {
            this.result = "notApplicable";
        }
        catch (AssertionFailException afe) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(afe.getMessage(), entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private boolean containsOneSoapBody(List multiparts) {
        boolean soapBodyFound = false;
        int i = 0;
        while (i < multiparts.size()) {
            List mimeParts = ((MIMEMultipartRelated)multiparts.get(i)).getMIMEParts();
            int j = 0;
            while (j < mimeParts.size()) {
                List extElems = ((MIMEPart)mimeParts.get(j)).getExtensibilityElements();
                int k = 0;
                while (k < extElems.size()) {
                    if (((ExtensibilityElement)extElems.get(k)).getElementType().equals(WSDL_SOAP_BODY)) {
                        if (soapBodyFound) {
                            return false;
                        }
                        soapBodyFound = true;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return soapBodyFound;
    }

    private List getMimeMultipartElements(List extElems) {
        ArrayList<ExtensibilityElement> mimeMultipartElements = new ArrayList<ExtensibilityElement>();
        if (extElems != null) {
            int i = 0;
            while (i < extElems.size()) {
                ExtensibilityElement extElem = (ExtensibilityElement)extElems.get(i);
                if (extElem.getElementType().equals(WSDL_MIME_MULTIPART)) {
                    mimeMultipartElements.add(extElem);
                    List mimeParts = ((MIMEMultipartRelated)extElem).getMIMEParts();
                    int j = 0;
                    while (j < mimeParts.size()) {
                        List elems = this.getMimeMultipartElements(((MIMEPart)mimeParts.get(j)).getExtensibilityElements());
                        mimeMultipartElements.addAll(elems);
                        ++j;
                    }
                }
                ++i;
            }
        }
        return mimeMultipartElements;
    }
}

