/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.diagram.ui.printing;

import com.metamatrix.modeler.diagram.ui.printing.PrintMargins;
import com.metamatrix.modeler.diagram.ui.printing.PrintSettings;
import com.metamatrix.modeler.diagram.ui.util.PrintDiagramHelper;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PrinterGraphics;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.print.PrintGraphicalViewerOperation;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.widgets.Display;

public class DiagramPrintingOperation
extends PrintGraphicalViewerOperation {
    private PrintSettings psSettings;
    private int iPrintMode = -1;
    private Rectangle printRegion;
    private String orientation = "portrait";
    private String printerOrientation = "portrait";
    private Dimension diagramSize;
    private double printScaleFactor = 1.0;
    private boolean debugMode = false;
    public static final int SCALE = 9;

    public DiagramPrintingOperation(Printer p, GraphicalViewer g) {
        super(p, g);
        this.loadPrintSettings();
    }

    public String getOrientation() {
        return this.orientation;
    }

    public String getPrinterOrientation() {
        return this.printerOrientation;
    }

    public boolean isPrinterPortrait() {
        org.eclipse.swt.graphics.Rectangle oClientArea = this.getPrinter().getClientArea();
        return oClientArea.height > oClientArea.width;
    }

    public boolean isPortrait() {
        return this.getPrintSettings().isPortrait();
    }

    public void reset() {
        this.printRegion = null;
        this.psSettings = null;
        this.loadPrintSettings();
    }

    public void loadPrintSettings() {
        PrintSettings settings = this.getPrintSettings();
        this.orientation = settings.isPortrait() ? "portrait" : "landscape";
        this.printerOrientation = this.isPrinterPortrait() ? "portrait" : "landscape";
    }

    public Rectangle getPrintRegionORIGINAL() {
        org.eclipse.swt.graphics.Rectangle trim = this.getPrinter().computeTrim(0, 0, 0, 0);
        org.eclipse.swt.graphics.Rectangle clientArea = this.getPrinter().getClientArea();
        Point printerDPI = this.getPrinter().getDPI();
        PrintMargins printMargin = this.getPrintSettings().getMargins();
        this.printRegion = new Rectangle();
        this.printRegion.x = (int)Math.max(printMargin.left * (double)printerDPI.x - (double)trim.width, (double)clientArea.x);
        this.printRegion.y = (int)Math.max(printMargin.top * (double)printerDPI.y - (double)trim.height, (double)clientArea.y);
        this.printRegion.width = (int)((double)(clientArea.x + clientArea.width - this.printRegion.x) - Math.max(0.0, printMargin.right * (double)printerDPI.x - (double)trim.width));
        this.printRegion.height = (int)((double)(clientArea.y + clientArea.height - this.printRegion.y) - Math.max(0.0, printMargin.bottom * (double)printerDPI.y - (double)trim.height));
        return this.printRegion;
    }

    public Rectangle getPrintRegion() {
        if (this.printRegion == null) {
            org.eclipse.swt.graphics.Rectangle clientArea = this.getPrinter().getClientArea();
            org.eclipse.swt.graphics.Rectangle trim = this.getPrinter().computeTrim(0, 0, 0, 0);
            Point printerDPI = this.getPrinter().getDPI();
            PrintMargins printMargin = this.getPrintSettings().getMargins();
            PrintMargins orientedPrintMargins = new PrintMargins();
            if (this.isPortrait()) {
                if (this.isPrinterPortrait()) {
                    orientedPrintMargins.setTop(new Double(printMargin.top));
                    orientedPrintMargins.setRight(new Double(printMargin.right));
                    orientedPrintMargins.setBottom(new Double(printMargin.bottom));
                    orientedPrintMargins.setLeft(new Double(printMargin.left));
                } else {
                    orientedPrintMargins.setTop(new Double(printMargin.right));
                    orientedPrintMargins.setRight(new Double(printMargin.bottom));
                    orientedPrintMargins.setBottom(new Double(printMargin.left));
                    orientedPrintMargins.setLeft(new Double(printMargin.top));
                }
            } else if (this.isPrinterPortrait()) {
                orientedPrintMargins.setTop(new Double(printMargin.right));
                orientedPrintMargins.setRight(new Double(printMargin.bottom));
                orientedPrintMargins.setBottom(new Double(printMargin.left));
                orientedPrintMargins.setLeft(new Double(printMargin.top));
            } else {
                orientedPrintMargins.setTop(new Double(printMargin.top));
                orientedPrintMargins.setRight(new Double(printMargin.right));
                orientedPrintMargins.setBottom(new Double(printMargin.bottom));
                orientedPrintMargins.setLeft(new Double(printMargin.left));
            }
            this.printRegion = new Rectangle();
            this.printRegion.x = (int)Math.max(orientedPrintMargins.left * (double)printerDPI.x, (double)clientArea.x);
            this.printRegion.y = (int)Math.max(orientedPrintMargins.top * (double)printerDPI.y, (double)clientArea.y);
            this.printRegion.width = (int)((double)(clientArea.x + clientArea.width - this.printRegion.x) - orientedPrintMargins.right * (double)printerDPI.x);
            this.printRegion.height = (int)((double)(clientArea.y + clientArea.height - this.printRegion.y) - orientedPrintMargins.bottom * (double)printerDPI.y);
            if (this.debugMode) {
                System.out.println("\n[DiagramPrintingOperation.getPrintRegion()]  - Client Area = " + clientArea);
                System.out.println("\n[DiagramPrintingOperation.getPrintRegion()]  - Trim Area   = " + trim);
                System.out.println("\n[DiagramPrintingOperation.getPrintRegion()]  - Margins = " + orientedPrintMargins);
                System.out.println("[DiagramPrintingOperation.getPrintRegion()]  - resulting printRegion: " + this.printRegion.toString());
                double wdth = (double)this.printRegion.width / (double)printerDPI.x;
                double hght = (double)this.printRegion.height / (double)printerDPI.x;
                System.out.println("[DiagramPrintingOperation.getPrintRegion()]  - Page Size (" + wdth + ", " + hght + ") inches ");
            }
        }
        return this.printRegion;
    }

    protected int getPrintMode() {
        this.iPrintMode = (Boolean)this.getPrintSettings().getSetting("fitToOnePage") != false ? 2 : ((Boolean)this.getPrintSettings().getSetting("fitToOnePageWide") != false ? 4 : ((Boolean)this.getPrintSettings().getSetting("fitToOnePageHigh") != false ? 3 : ((Boolean)this.getPrintSettings().getSetting("adjustToPercent") != false ? 9 : 1)));
        return this.iPrintMode;
    }

    protected boolean okToPrint(int iPageNo) {
        boolean bResult = false;
        int iScope = (Integer)this.getPrintSettings().getSetting("scope");
        switch (iScope) {
            case 0: {
                bResult = true;
                break;
            }
            case 1: {
                int iStartPage = (Integer)this.getPrintSettings().getSetting("startPage");
                int iEndPage = (Integer)this.getPrintSettings().getSetting("endPage");
                if (iStartPage > iPageNo || iPageNo > iEndPage) break;
                bResult = true;
                break;
            }
        }
        return bResult;
    }

    protected void setupPrinterGraphicsFor(Graphics pgPrinterGraphics, IFigure figure, Rectangle bndsSourceImage) {
        double dpiScale = this.getPrinter().getDPI().x / Display.getCurrent().getDPI().x;
        if (this.debugMode) {
            System.out.println(" DPO.setupPrinterGraphics()  DIP Printer = " + this.getPrinter().getDPI().x);
            System.out.println(" DPO.setupPrinterGraphics()  DIP Display = " + Display.getCurrent().getDPI().x);
        }
        Rectangle printRegion = this.getPrintRegion();
        printRegion.width = (int)((double)printRegion.width / dpiScale);
        printRegion.height = (int)((double)printRegion.height / dpiScale);
        if (this.debugMode) {
            System.out.println(" DPO.setupPrinterGraphics()  dpiScale        = " + dpiScale);
            System.out.println(" DPO.setupPrinterGraphics()  bndsSourceImage = " + bndsSourceImage);
            System.out.println(" DPO.setupPrinterGraphics()  printRegion     = " + printRegion);
        }
        this.diagramSize = new Dimension(bndsSourceImage.getSize());
        double yScale = 0.0;
        double xScale = 0.0;
        if (this.isPortrait()) {
            xScale = (double)printRegion.width / (double)bndsSourceImage.width;
            yScale = (double)printRegion.height / (double)bndsSourceImage.height;
        } else {
            xScale = (double)printRegion.width / (double)bndsSourceImage.width;
            yScale = (double)printRegion.height / (double)bndsSourceImage.height;
        }
        if (this.debugMode) {
            System.out.println(" DPO.setupPrinterGraphics()  Scales:  X = " + xScale + "  Y = " + yScale);
        }
        double finalScale = 1.0;
        switch (this.getPrintMode()) {
            case 2: {
                if (this.isPortrait()) {
                    xScale = (double)printRegion.width / (double)bndsSourceImage.width;
                    yScale = (double)printRegion.height / (double)bndsSourceImage.height;
                    finalScale = 1.0 * dpiScale;
                    if (xScale > 1.0 && yScale > 1.0) {
                        finalScale = 1.0 * dpiScale;
                        break;
                    }
                    if (xScale < 1.0 && yScale < 1.0) {
                        finalScale = Math.min(xScale, yScale) * dpiScale;
                        break;
                    }
                    if (xScale > 1.0) {
                        if (yScale * xScale < 1.0) {
                            finalScale = 1.0 * dpiScale;
                            break;
                        }
                        finalScale = yScale * dpiScale;
                        break;
                    }
                    finalScale = xScale * dpiScale;
                    break;
                }
                finalScale = 1.0 * dpiScale;
                if (xScale > 1.0 && yScale > 1.0) {
                    finalScale = 1.0 * dpiScale;
                    break;
                }
                if (xScale < 1.0 && yScale < 1.0) {
                    finalScale = Math.min(xScale, yScale) * dpiScale;
                    break;
                }
                if (xScale > 1.0) {
                    finalScale = yScale * dpiScale;
                    break;
                }
                if (yScale * xScale > 1.0) {
                    finalScale = 1.0 * dpiScale;
                    break;
                }
                finalScale = xScale * dpiScale;
                break;
            }
            case 3: {
                if (this.isPortrait()) {
                    if (xScale > 1.0) {
                        finalScale = 1.0 * dpiScale;
                        break;
                    }
                    finalScale = xScale * dpiScale;
                    break;
                }
                if (yScale > 1.0) {
                    finalScale = 1.0 * dpiScale;
                    break;
                }
                finalScale = yScale * dpiScale;
                break;
            }
            case 4: {
                if (this.isPortrait()) {
                    if (yScale > 1.0) {
                        finalScale = 1.0 * dpiScale;
                        break;
                    }
                    finalScale = yScale * dpiScale;
                    break;
                }
                if (xScale > 1.0) {
                    finalScale = 1.0 * dpiScale;
                    break;
                }
                finalScale = xScale * dpiScale;
                break;
            }
            case 9: {
                int iScalePct = (Integer)this.getPrintSettings().getSetting("scalingPercentage");
                double dScalePct = iScalePct;
                double dCentage = 0.01;
                double dScaleFactor = 1.0;
                finalScale = dScaleFactor * dpiScale * (dScalePct *= dCentage);
                break;
            }
            default: {
                this.setGraphicsScale(pgPrinterGraphics, dpiScale);
            }
        }
        this.printScaleFactor = finalScale;
        this.setGraphicsScale(pgPrinterGraphics, finalScale);
        pgPrinterGraphics.setForegroundColor(figure.getForegroundColor());
        pgPrinterGraphics.setBackgroundColor(figure.getBackgroundColor());
        pgPrinterGraphics.setFont(figure.getFont());
    }

    private void setGraphicsScale(Graphics g, double scale) {
        if (this.debugMode) {
            System.out.println(" DPO.setGraphicsScale()  scale = " + scale);
        }
        g.scale(scale);
    }

    public boolean okToPrint() {
        Image sourceImage;
        IFigure figure = this.getPrintSource();
        if (this.debugMode) {
            System.out.println("[DPO.okToPrint] figure.getBounds(): " + figure.getBounds());
        }
        return (sourceImage = this.getSourceImage(figure)) != null;
    }

    protected void printPages() {
        if (this.isPortrait()) {
            if (this.isPrinterPortrait()) {
                this.printPortrait_PrinterIsPortrait();
            } else {
                this.printPortrait_PrinterIsLandscape();
            }
        } else if (this.isPrinterPortrait()) {
            this.printLandscape_PrinterIsPortrait();
        } else {
            this.printLandscape_PrinterIsLandscape();
        }
    }

    protected void printPortrait_PrinterIsPortrait() {
        int x;
        int y;
        int iPageNo = 0;
        PrinterGraphics graphics = this.getFreshPrinterGraphics();
        if (this.debugMode) {
            System.out.println("[DPO.printPortraitPortrait] graphics Scale = " + graphics.getAbsoluteScale());
        }
        IFigure figure = this.getPrintSource();
        if (this.debugMode) {
            System.out.println("[DPO.printPortraitPortrait] figure.getBounds(): " + figure.getBounds());
        }
        Image sourceImage = this.getSourceImage(figure);
        org.eclipse.swt.graphics.Rectangle swtRectSource = sourceImage.getBounds();
        if (this.debugMode) {
            System.out.println("[DPO.printPortraitPortrait()] sourceImage dimensions: " + sourceImage);
        }
        Rectangle bounds = new Rectangle(swtRectSource.x, swtRectSource.y, swtRectSource.width, swtRectSource.height);
        if (this.debugMode) {
            System.out.println("[DPO.printPortraitPortrait] sourceImage dimensions: " + swtRectSource);
        }
        this.setupPrinterGraphicsFor((Graphics)graphics, figure, bounds);
        Rectangle clipRect = new Rectangle();
        int iPagesPrinted = 0;
        if (((Boolean)this.getPrintSettings().getSetting("overThenDown")).booleanValue()) {
            for (y = bounds.y; y < bounds.y + bounds.height; y += clipRect.height) {
                while (x < bounds.x + bounds.width) {
                    ++iPageNo;
                    graphics.pushState();
                    if (this.debugMode) {
                        System.out.println(" DPO.printPortraitPortrait():  Graphics Scale = " + graphics.getAbsoluteScale());
                    }
                    graphics.translate(-x, -y);
                    graphics.getClip(clipRect);
                    clipRect.setLocation(x, y);
                    graphics.clipRect(clipRect);
                    if (this.okToPrint(iPageNo)) {
                        ++iPagesPrinted;
                        this.printImage(graphics, sourceImage, x, y, clipRect);
                    }
                    graphics.popState();
                    x += clipRect.width;
                }
                x = bounds.x;
            }
        } else {
            for (x = bounds.x; x < bounds.x + bounds.width; x += clipRect.width) {
                while (y < bounds.y + bounds.height) {
                    ++iPageNo;
                    graphics.pushState();
                    graphics.translate(-x, -y);
                    graphics.getClip(clipRect);
                    clipRect.setLocation(x, y);
                    graphics.clipRect(clipRect);
                    if (this.okToPrint(iPageNo)) {
                        ++iPagesPrinted;
                        this.printImage(graphics, sourceImage, x, y, clipRect);
                    }
                    graphics.popState();
                    y += clipRect.height;
                }
                y = bounds.y;
            }
        }
        if (sourceImage != null) {
            sourceImage.dispose();
        }
    }

    protected void printPortrait_PrinterIsLandscape() {
        int iPageNo = 0;
        PrinterGraphics graphics = this.getFreshPrinterGraphics();
        if (this.debugMode) {
            System.out.println("[DPO.printPortraitLandscape] graphics Scale = " + graphics.getAbsoluteScale());
        }
        IFigure figure = this.getPrintSource();
        Image originalImage = this.getSourceImage(figure);
        Image sourceImage = this.rotateImageLeft(originalImage);
        org.eclipse.swt.graphics.Rectangle swtRectSource = sourceImage.getBounds();
        Rectangle bounds = new Rectangle(swtRectSource.x, swtRectSource.y, swtRectSource.width, swtRectSource.height);
        if (this.debugMode) {
            System.out.println("[DPO.printPortraitLandscape] sourceImage dimensions: " + swtRectSource);
        }
        this.setupPrinterGraphicsFor((Graphics)graphics, figure, bounds);
        int x = bounds.x;
        int y = bounds.y;
        Rectangle clipRect = new Rectangle();
        graphics.pushState();
        graphics.translate(-x, -y);
        graphics.getClip(clipRect);
        clipRect.setLocation(x, y);
        graphics.clipRect(clipRect);
        int clipWidth = clipRect.width;
        int iPagesPrinted = 0;
        if (((Boolean)this.getPrintSettings().getSetting("overThenDown")).booleanValue()) {
            x = bounds.x + bounds.width - clipWidth;
            y = 0;
            while (x + clipWidth > 0) {
                while (y < bounds.y + bounds.height) {
                    ++iPageNo;
                    graphics.pushState();
                    graphics.translate(-x, -y);
                    graphics.getClip(clipRect);
                    clipRect.setLocation(x, y);
                    graphics.clipRect(clipRect);
                    if (this.okToPrint(iPageNo)) {
                        ++iPagesPrinted;
                        this.printImage(graphics, sourceImage, x, y, clipRect);
                    }
                    graphics.popState();
                    y += clipRect.height;
                }
                y = 0;
                x -= clipWidth;
            }
        } else {
            x = bounds.x + bounds.width - clipWidth;
            for (y = 0; y < bounds.y + bounds.height; y += clipRect.height) {
                while (x + clipWidth > 0) {
                    ++iPageNo;
                    graphics.pushState();
                    graphics.translate(-x, -y);
                    graphics.getClip(clipRect);
                    clipRect.setLocation(x, y);
                    graphics.clipRect(clipRect);
                    if (this.okToPrint(iPageNo)) {
                        ++iPagesPrinted;
                        this.printImage(graphics, sourceImage, x, y, clipRect);
                    }
                    graphics.popState();
                    x -= clipWidth;
                }
                x = bounds.x + bounds.width - clipWidth;
            }
        }
        if (sourceImage != null) {
            sourceImage.dispose();
        }
        if (originalImage != null && !originalImage.isDisposed()) {
            originalImage.dispose();
        }
    }

    protected void printLandscape_PrinterIsPortrait() {
        int iMaxY;
        int x;
        int iPageNo = 0;
        PrinterGraphics graphics = this.getFreshPrinterGraphics();
        if (this.debugMode) {
            System.out.println(" [DPO.printPagesInLandscape] graphics Scale = " + graphics.getAbsoluteScale());
        }
        IFigure figure = this.getPrintSource();
        Image startingImage = this.getSourceImage(figure);
        if (this.debugMode) {
            org.eclipse.swt.graphics.Rectangle swtRectSourceBeforeRotation = startingImage.getBounds();
            System.out.println("\n[DPO.printPagesInLandscape] sourceImage dimensions BEFORE rotation: " + swtRectSourceBeforeRotation);
        }
        Image sourceImage = this.rotateImageRight(startingImage);
        org.eclipse.swt.graphics.Rectangle swtRectSource = sourceImage.getBounds();
        if (this.debugMode) {
            System.out.println("[DPO.printPagesInLandscape] sourceImage dimensions AFTER rotation: " + swtRectSource);
        }
        Rectangle bounds = new Rectangle(swtRectSource.x, swtRectSource.y, swtRectSource.width, swtRectSource.height);
        this.setupPrinterGraphicsFor((Graphics)graphics, figure, bounds);
        Rectangle clipRect = new Rectangle();
        int y = bounds.y;
        graphics.pushState();
        graphics.translate(-x, -y);
        graphics.getClip(clipRect);
        clipRect.setLocation(x, y);
        graphics.clipRect(clipRect);
        graphics.popState();
        y = iMaxY = bounds.y + bounds.height - clipRect.height;
        int iPagesPrinted = 0;
        if (((Boolean)this.getPrintSettings().getSetting("downThenOver")).booleanValue()) {
            while (y + clipRect.height >= 0) {
                while (x < bounds.x + bounds.width) {
                    ++iPageNo;
                    graphics.pushState();
                    graphics.translate(-x, -y);
                    graphics.getClip(clipRect);
                    clipRect.setLocation(x, y);
                    graphics.clipRect(clipRect);
                    if (this.okToPrint(iPageNo)) {
                        ++iPagesPrinted;
                        this.printImage(graphics, sourceImage, x, y, clipRect);
                    }
                    graphics.popState();
                    x += clipRect.width;
                }
                x = bounds.x;
                y -= clipRect.height;
            }
        } else {
            for (x = bounds.x; x < bounds.x + bounds.width; x += clipRect.width) {
                while (y + clipRect.height >= 0) {
                    ++iPageNo;
                    graphics.pushState();
                    graphics.translate(-x, -y);
                    graphics.getClip(clipRect);
                    clipRect.setLocation(x, y);
                    graphics.clipRect(clipRect);
                    if (this.okToPrint(iPageNo)) {
                        ++iPagesPrinted;
                        this.printImage(graphics, sourceImage, x, y, clipRect);
                    }
                    graphics.popState();
                    y -= clipRect.height;
                }
                y = iMaxY;
            }
        }
        if (startingImage != null) {
            startingImage.dispose();
        }
        if (sourceImage != null) {
            sourceImage.dispose();
        }
    }

    protected void printLandscape_PrinterIsLandscape() {
        this.printPortrait_PrinterIsPortrait();
    }

    protected Image getSourceImage(IFigure figure) {
        Rectangle diagramSize = figure.getBounds();
        Image image = PrintDiagramHelper.getImage(diagramSize);
        if (image == null) {
            return image;
        }
        GC graphicContext = new GC((Drawable)image);
        SWTGraphics sourceGraphics = new SWTGraphics(graphicContext);
        figure.paint((Graphics)sourceGraphics);
        return image;
    }

    protected void printImage(PrinterGraphics graphics, Image sourceImage, int xOffset, int yOffset, Rectangle clipRect) {
        int iDestY;
        this.getPrinter().startPage();
        int iSourceWidth = clipRect.width;
        int iSourceHeight = clipRect.height;
        int iDestX = clipRect.x;
        if (iDestX < 0) {
            iDestX = 0;
        }
        if ((iDestY = clipRect.y) < 0) {
            iDestY = 0;
        }
        int iDestWidth = clipRect.width;
        int iDestHeight = clipRect.height;
        int iOverage = 0;
        int iNewWidth = 0;
        int iNewHeight = 0;
        if (xOffset + clipRect.width > sourceImage.getBounds().width) {
            iOverage = xOffset + clipRect.width - sourceImage.getBounds().width;
            iNewWidth = clipRect.width - iOverage;
            if (iNewWidth == 0) {
                // empty if block
            }
            iSourceWidth = iNewWidth;
            iDestWidth = iNewWidth;
        }
        if (xOffset < 0) {
            iNewWidth = xOffset + clipRect.width;
            xOffset = 0;
            iSourceWidth = iNewWidth;
            iDestWidth = iNewWidth;
        }
        if (yOffset < 0) {
            iNewHeight = yOffset + clipRect.height;
            yOffset = 0;
            iSourceHeight = iNewHeight;
            iDestHeight = iNewHeight;
        }
        if (yOffset + clipRect.height > sourceImage.getBounds().height) {
            iOverage = yOffset + clipRect.height - sourceImage.getBounds().height;
            iSourceHeight = iNewHeight = clipRect.height - iOverage;
            iDestHeight = iNewHeight;
        }
        if (this.debugMode) {
            System.out.println("\n[DPO.printImage - About to call drawImage] ::       xOffset: " + xOffset);
            System.out.println("[DPO.printImage - About to call drawImage] ::       yOffset: " + yOffset);
            System.out.println("[DPO.printImage - About to call drawImage] ::     Clip Rect: " + clipRect);
            System.out.println("[DPO.printImage - About to call drawImage] ::  iSourceWidth: " + iSourceWidth);
            System.out.println("[DPO.printImage - About to call drawImage] :: iSourceHeight: " + iSourceHeight);
            System.out.println("[DPO.printImage - About to call drawImage] ::        iDestX: " + iDestX);
            System.out.println("[DPO.printImage - About to call drawImage] ::        iDestY: " + iDestY);
            System.out.println("[DPO.printImage - About to call drawImage] ::    iDestWidth: " + iDestWidth);
            System.out.println("[DPO.printImage - About to call drawImage] ::   iDestHeight: " + iDestHeight);
        }
        graphics.drawImage(sourceImage, xOffset, yOffset, iSourceWidth, iSourceHeight, iDestX, iDestY, iDestWidth, iDestHeight);
        this.getPrinter().endPage();
    }

    protected Image rotateImageRight(Image img) {
        ImageData srcImageData = img.getImageData();
        PaletteData srcPal = srcImageData.palette;
        PaletteData destPal = srcPal.isDirect ? new PaletteData(srcPal.redMask, srcPal.greenMask, srcPal.blueMask) : new PaletteData(srcPal.getRGBs());
        ImageData destImageData = new ImageData(srcImageData.height, srcImageData.width, srcImageData.depth, destPal);
        for (int i = 0; i < srcImageData.width; ++i) {
            for (int j = 0; j < srcImageData.height; ++j) {
                int pixel = srcImageData.getPixel(i, j);
                destImageData.setPixel(j, srcImageData.width - 1 - i, pixel);
            }
        }
        Image destImage = new Image((Device)Display.getDefault(), destImageData);
        return destImage;
    }

    protected Image rotateImageLeft(Image img) {
        ImageData srcImageData = img.getImageData();
        PaletteData srcPal = srcImageData.palette;
        PaletteData destPal = srcPal.isDirect ? new PaletteData(srcPal.redMask, srcPal.greenMask, srcPal.blueMask) : new PaletteData(srcPal.getRGBs());
        ImageData destImageData = new ImageData(srcImageData.height, srcImageData.width, srcImageData.depth, destPal);
        for (int i = 0; i < srcImageData.width; ++i) {
            for (int j = 0; j < srcImageData.height; ++j) {
                int pixel = srcImageData.getPixel(i, j);
                destImageData.setPixel(srcImageData.height - 1 - j, i, pixel);
            }
        }
        Image destImage = new Image((Device)Display.getDefault(), destImageData);
        return destImage;
    }

    public PrintSettings getPrintSettings() {
        if (this.psSettings == null) {
            this.psSettings = new PrintSettings(this.getPrinter().getPrinterData());
        }
        return this.psSettings;
    }

    public Dimension getDiagramSize() {
        return this.diagramSize;
    }

    public double getPrintScaleFactor() {
        return this.printScaleFactor;
    }
}

