/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xml.cache;

import com.metamatrix.connector.xml.base.XMLDocument;
import com.metamatrix.connector.xml.cache.IDocumentCache;
import com.metamatrix.data.api.ConnectorLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class DocumentCache
implements IDocumentCache {
    private int m_maxTimeToLive;
    private int m_maxMemoryCacheSize;
    private int m_maxFileCacheSize;
    private int m_currentMemoryCacheSize;
    private int m_currentFileCacheSize;
    private Hashtable m_cacheImpl;
    private List deleteList;
    private CachedObject m_mostRecentUsed;
    private CachedObject m_leastRecentUsed;
    private CacheCleaner m_cleaner;
    private String m_fileCacheLocation;
    private ConnectorLogger m_log;
    private String m_cacheIdentifier;
    private int m_memoryCacheCount = 0;
    private int m_fileCacheCount = 0;
    private boolean m_performanceCache = false;
    CachedObjectRemover cachedObjectRemover;
    private static final int UNLIMITED_CACHE_THRESHOLD = -1;

    public DocumentCache(int maxMemoryCacheSize, int maxFileCacheSize, String fileCacheLocation, int maxTimeToLive, ConnectorLogger log, String identifier, boolean useCleanerThread) {
        this.m_log = log;
        if (maxTimeToLive != 0) {
            this.m_performanceCache = true;
            this.m_cleaner = new CacheCleaner(useCleanerThread);
            this.m_log.logTrace("Performance File cache is enabled");
        } else {
            this.m_log.logTrace("Performance File cache is disabled");
        }
        this.m_maxMemoryCacheSize = maxMemoryCacheSize;
        this.m_log.logTrace("File cache Max Memory Cache Size " + maxMemoryCacheSize);
        this.m_maxTimeToLive = maxTimeToLive;
        this.m_log.logTrace("File cache Max Time to Live " + this.m_maxTimeToLive);
        this.m_maxFileCacheSize = maxFileCacheSize;
        this.m_log.logTrace("File cache location is " + this.m_fileCacheLocation);
        this.m_fileCacheLocation = fileCacheLocation;
        this.m_currentMemoryCacheSize = 0;
        this.m_currentFileCacheSize = 0;
        this.m_cacheImpl = new Hashtable();
        this.m_leastRecentUsed = this.m_mostRecentUsed = null;
        this.m_cacheIdentifier = identifier;
        this.deleteList = new ArrayList();
        this.cachedObjectRemover = new CachedObjectRemover();
        this.cachedObjectRemover.start();
    }

    public DocumentCache(int maxMemoryCacheSize, int maxFileCacheSize, String fileCacheLocation, int maxTimeToLive, ConnectorLogger log, String identifier) {
        this(maxMemoryCacheSize, maxFileCacheSize, fileCacheLocation, maxTimeToLive, log, identifier, true);
    }

    public static XMLDocument cacheLookup(IDocumentCache cache, String cacheKey, String requestID, String partID) {
        XMLDocument doc = null;
        Object tmpObject = cache.fetchObject(cacheKey, requestID, partID);
        if (tmpObject != null) {
            doc = (XMLDocument)tmpObject;
        }
        return doc;
    }

    public synchronized void addToCache(String id, Object obj, int size, String requestID, String partID) {
        this.m_log.logTrace("Attempting to cache item identified by " + id + "; estimated memory size is " + size + " bytes.");
        if (this.m_maxMemoryCacheSize > -1 && size > this.m_maxMemoryCacheSize && this.m_maxFileCacheSize > -1 && size > this.m_maxFileCacheSize) {
            this.m_log.logTrace(this.m_cacheIdentifier + ": unable to cache item identified by " + id);
            return;
        }
        CachedObject newItem = new CachedObject();
        if (this.m_performanceCache) {
            newItem.setExpires(System.currentTimeMillis() + (long)this.m_maxTimeToLive);
        }
        newItem.setItemID(id);
        newItem.setPayload(obj);
        newItem.setSize(size);
        newItem.addReference(requestID, partID);
        if (obj instanceof EventSinkFactory) {
            EventSink eventSink = ((EventSinkFactory)obj).getEventSink();
            newItem.setEventSink(eventSink);
        }
        if (this.m_currentMemoryCacheSize == 0 && this.m_currentFileCacheSize == 0) {
            this.m_leastRecentUsed = newItem;
        } else if (this.m_cacheImpl.get(id) != null) {
            this.remove((CachedObject)this.m_cacheImpl.get(id));
        }
        if (size <= this.m_maxMemoryCacheSize || this.m_maxMemoryCacheSize <= -1) {
            this.addItemToMemoryCache(newItem);
        } else {
            this.addItemToFileCache(newItem);
        }
        if (this.m_mostRecentUsed != null) {
            this.m_mostRecentUsed.setPrevious(newItem);
        }
        this.m_mostRecentUsed = newItem;
        this.m_cacheImpl.put(newItem.getItemId(), newItem);
        this.m_log.logTrace(this.m_cacheIdentifier + ": adding item to cache as " + newItem.getItemId());
        this.logCacheReport();
        if (this.m_performanceCache) {
            this.m_cleaner.scheduleRemoval(newItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void release(String cacheKey, String requestID, String partID) {
        CachedObject cacheObject = (CachedObject)this.m_cacheImpl.get(cacheKey);
        if (null != cacheObject) {
            cacheObject.removeReference(requestID, partID);
            this.m_log.logTrace("Removing reference to Request Identification " + requestID + " and Part Identification " + partID + " from cache item " + cacheKey);
            if (!this.m_performanceCache && !cacheObject.isLocked()) {
                this.m_log.logTrace("Moving cache item " + cacheKey + " to the delete list");
                this.removeLink(cacheObject);
                this.m_cacheImpl.remove(cacheKey);
                cacheObject.setListed(false);
                List list = this.deleteList;
                synchronized (list) {
                    this.deleteList.add(cacheObject);
                }
            }
        }
    }

    private void remove(CachedObject ref) {
        this.removeLink(ref);
        this.m_cacheImpl.remove(ref.getItemId());
        this.m_log.logTrace(this.m_cacheIdentifier + ": removing item from cache identified by : " + ref.getItemId());
        if (ref.getPayload() instanceof FileCacheItem) {
            FileCacheItem item = (FileCacheItem)ref.getPayload();
            File itemFile = new File(item.getCacheFile());
            boolean success = itemFile.delete();
            if (success) {
                this.m_log.logTrace(this.m_cacheIdentifier + ": removed file " + itemFile.getAbsolutePath() + " from file cache");
            } else {
                this.m_log.logError(this.m_cacheIdentifier + ": failed to remove file " + itemFile.getAbsolutePath() + " from the cache");
            }
            this.decrementFileCacheCount();
            this.updateFileCacheSize(-ref.getSize());
        } else {
            this.decrementMemoryCacheCount();
            this.updateMemoryCacheSize(-ref.getSize());
        }
        if (ref.getEventSink() != null) {
            ref.getEventSink().onDelete();
        }
        this.m_log.logTrace(this.m_cacheIdentifier + ": removed item " + ref.getItemId() + " from cache");
        this.logCacheReport();
    }

    private void removeLink(CachedObject remove) {
        if (this.m_mostRecentUsed == remove) {
            this.m_mostRecentUsed = remove.getNext();
        }
        if (this.m_leastRecentUsed == remove) {
            this.m_leastRecentUsed = remove.getPrevious();
        }
        if (remove.getNext() != null) {
            remove.getNext().setPrevious(remove.getPrevious());
        }
        if (remove.getPrevious() != null) {
            remove.getPrevious().setNext(remove.getNext());
        }
    }

    public synchronized Object fetchObject(String id, String requestID, String partID) {
        this.m_log.logTrace("Looking up " + id + " | " + requestID + " | " + partID);
        CachedObject foundLink = (CachedObject)this.m_cacheImpl.get(id);
        if (foundLink == null) {
            this.m_log.logTrace(this.m_cacheIdentifier + ": could not find item in cache with id " + id);
            return null;
        }
        String message = this.m_cacheIdentifier + ": found item in cache with id " + id;
        if (foundLink.isExpired()) {
            if (foundLink.hasReference(requestID)) {
                foundLink.addReference(requestID, partID);
            } else {
                message = message + ", Item is expired, returning null";
                this.m_log.logTrace(message);
                return null;
            }
        }
        this.m_log.logTrace(message);
        Object o = null;
        if (foundLink.getPayload() instanceof FileCacheItem) {
            o = this.deserializeFileCacheItem((FileCacheItem)foundLink.getPayload());
            if (foundLink.getEventSink() != null) {
                foundLink.getEventSink().onRestoreFromFile(o);
            }
            this.updateFileCacheSize(-foundLink.getSize());
            if (o == null) {
                this.m_cacheImpl.remove(foundLink.getItemId());
            }
        } else {
            o = foundLink.getPayload();
        }
        foundLink.addReference(requestID, partID);
        return o;
    }

    public synchronized void clearCache() {
        this.m_cleaner.interrupt();
        this.m_cleaner.clearCache();
        this.cachedObjectRemover.interrupt();
    }

    private void addItemToFileCache(CachedObject item) {
        if (this.m_maxFileCacheSize > -1 && item.getSize() > this.m_maxFileCacheSize) {
            this.m_log.logTrace(item.getItemId() + " cannot be cached to file.  Cache size would be exceeded");
            return;
        }
        String extension = ".ser";
        if (item.getPayload() instanceof Serializable) {
            File serialized = new File(this.m_fileCacheLocation + File.separator + item.hashCode() + ".ser");
            try {
                ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(serialized));
                oos.writeObject(item.getPayload());
                oos.flush();
                oos.close();
            }
            catch (IOException e) {
                this.m_log.logTrace("IOException serializing " + item.getItemId() + " Exception Message = " + e.getMessage());
                this.remove(item);
                return;
            }
            while (this.m_maxFileCacheSize > -1 && this.m_currentFileCacheSize + item.getSize() >= this.m_maxFileCacheSize) {
                CachedObject obj = this.m_cleaner.m_head.getCurrent();
                this.m_cleaner.m_head = this.m_cleaner.m_head.getNext();
                this.m_log.logTrace("Removing file cache item " + obj.getItemId() + " to make room for " + item.getItemId());
                this.m_log.logTrace("Consider increasing the memory cache size");
                this.remove(obj);
            }
            FileCacheItem cacheItem = new FileCacheItem();
            cacheItem.setCacheFile(this.m_fileCacheLocation + File.separator + item.hashCode() + ".ser");
            item.setPayload(cacheItem);
            this.incrementFileCacheCount();
            this.updateFileCacheSize(item.getSize());
            this.m_log.logTrace(this.m_cacheIdentifier + ": added item " + item.getItemId() + " to file cache with name " + cacheItem.getCacheFile());
        } else {
            this.m_log.logTrace(item.getItemId() + " cannot be cached to file.  It does not implement Serializable");
            this.remove(item);
        }
    }

    private void incrementFileCacheCount() {
        ++this.m_fileCacheCount;
    }

    private void decrementFileCacheCount() {
        --this.m_fileCacheCount;
    }

    private void incrementMemoryCacheCount() {
        ++this.m_memoryCacheCount;
    }

    private void decrementMemoryCacheCount() {
        --this.m_memoryCacheCount;
    }

    private void addItemToMemoryCache(CachedObject newItem) {
        int writeTimeBuffer = 5000;
        while (this.m_maxMemoryCacheSize > -1 && this.m_currentMemoryCacheSize + newItem.getSize() > this.m_maxMemoryCacheSize) {
            if (this.m_leastRecentUsed != null && this.m_performanceCache && this.m_leastRecentUsed.getExpires() <= 5000L + System.currentTimeMillis()) {
                this.m_cacheImpl.remove(this.m_leastRecentUsed.getItemId());
                this.updateMemoryCacheSize(-this.m_leastRecentUsed.getSize());
                this.m_leastRecentUsed = this.m_leastRecentUsed.getNext();
                continue;
            }
            CachedObject removeCandidate = this.m_leastRecentUsed;
            while (removeCandidate != null && removeCandidate.m_payload instanceof FileCacheItem) {
                removeCandidate = removeCandidate.getPrevious();
            }
            if (removeCandidate == null) continue;
            this.m_log.logTrace("Moving item " + removeCandidate.getItemId() + " from memory to file cache");
            this.addItemToFileCache(removeCandidate);
            this.updateMemoryCacheSize(-removeCandidate.getSize());
            this.decrementMemoryCacheCount();
        }
        newItem.setNext(this.m_mostRecentUsed);
        newItem.setPrevious(null);
        this.incrementMemoryCacheCount();
        this.updateMemoryCacheSize(newItem.getSize());
    }

    private void updateMemoryCacheSize(int amount) {
        this.m_currentMemoryCacheSize += amount;
        if (this.m_currentMemoryCacheSize < 0) {
            this.m_currentMemoryCacheSize = 0;
        }
    }

    private void updateFileCacheSize(int amount) {
        this.m_currentFileCacheSize += amount;
        if (this.m_currentFileCacheSize < 0) {
            this.m_currentFileCacheSize = 0;
        }
    }

    private void logCacheReport() {
        if (this.m_maxMemoryCacheSize <= -1) {
            this.m_log.logTrace(this.m_cacheIdentifier + " in-memory cache is unlimited. current usage: " + this.getCurrentMemoryCacheSize());
        } else {
            this.m_log.logTrace(this.m_cacheIdentifier + ": remaining in-memory cache: " + (this.m_maxMemoryCacheSize - this.getCurrentMemoryCacheSize()));
        }
        if (this.m_maxFileCacheSize <= -1) {
            this.m_log.logTrace(this.m_cacheIdentifier + " file cache is unlimited. current usage: " + this.getCurrentFileCacheSize());
        } else {
            this.m_log.logTrace(this.m_cacheIdentifier + ": remianing file memory cache: " + (this.m_maxFileCacheSize - this.getCurrentFileCacheSize()));
        }
        this.m_log.logTrace("Count of items in memory cache: " + this.m_memoryCacheCount);
        this.m_log.logTrace("Count of items in file cache: " + this.m_fileCacheCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object deserializeFileCacheItem(FileCacheItem item) {
        Object obj;
        File cacheFile = new File(item.getCacheFile());
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new FileInputStream(cacheFile));
            obj = ois.readObject();
            ois.close();
            ois = null;
        }
        catch (Exception e) {
            obj = null;
        }
        finally {
            if (null != ois) {
                try {
                    ois.close();
                }
                catch (IOException e) {}
            }
        }
        return obj;
    }

    public void shutdownCleaner() {
        this.m_log.logTrace(this.m_cacheIdentifier + ": shutting down");
        if (this.m_performanceCache) {
            this.m_cleaner.interrupt();
        }
    }

    protected int getCurrentMemoryCacheSize() {
        return this.m_currentMemoryCacheSize;
    }

    protected int getCurrentFileCacheSize() {
        return this.m_currentFileCacheSize;
    }

    protected int getCacheCount() {
        return this.m_cacheImpl.size();
    }

    protected Enumeration getCacheContents() {
        return this.m_cacheImpl.elements();
    }

    protected void dumpCache() {
        CachedObject obj;
        int i;
        Enumeration enumer = this.getCacheContents();
        Vector<CachedObject> memory = new Vector<CachedObject>();
        Vector<CachedObject> files = new Vector<CachedObject>();
        while (enumer.hasMoreElements()) {
            CachedObject next = (CachedObject)enumer.nextElement();
            if (next.m_payload instanceof FileCacheItem) {
                files.add(next);
                continue;
            }
            memory.add(next);
        }
        this.m_log.logTrace(this.m_cacheIdentifier + ": memory cache items:");
        for (i = 0; i < memory.size(); ++i) {
            obj = (CachedObject)memory.get(i);
            this.m_log.logTrace(obj.toString());
        }
        this.m_log.logTrace(this.m_cacheIdentifier + ": file cache items:");
        for (i = 0; i < files.size(); ++i) {
            obj = (CachedObject)files.get(i);
            this.m_log.logTrace(obj.toString());
        }
        this.m_log.logTrace("most recent used item: " + (this.m_mostRecentUsed == null ? "null" : this.m_mostRecentUsed.m_itemID));
        this.m_log.logTrace("least recent used item: " + (this.m_leastRecentUsed == null ? "null" : this.m_leastRecentUsed.m_itemID));
    }

    private class FileCacheItem {
        private String m_cacheFile;

        private FileCacheItem() {
        }

        private synchronized void setCacheFile(String file) {
            this.m_cacheFile = file;
        }

        private synchronized String getCacheFile() {
            return this.m_cacheFile;
        }
    }

    public class CachedObject
    implements Serializable {
        public static final long serialVersionUID = 1L;
        private Object m_payload;
        private String m_itemID;
        private int m_size;
        private long m_expires;
        private CachedObject m_previous;
        private CachedObject m_next;
        private EventSink m_eventSink;
        private boolean locked = false;
        private Map references = new HashMap();
        private boolean listed = true;

        private CachedObject() {
        }

        public boolean hasReference(String requestID) {
            return this.references.containsKey(requestID);
        }

        public void removeReference(String requestID, String partID) {
            Set requestPartIDs = (Set)this.references.get(requestID);
            if (null == requestPartIDs) {
                throw new RuntimeException("ERROR: Removing a reference that does not exist");
            }
            requestPartIDs.remove(partID);
            if (requestPartIDs.isEmpty()) {
                this.references.remove(requestID);
            }
            if (this.references.isEmpty()) {
                this.setLocked(false);
                DocumentCache.this.m_log.logTrace("unlocking cache item " + this.m_itemID);
            }
        }

        public void addReference(String requestID, String partID) {
            if (null != requestID && null != partID) {
                if (this.references.containsKey(requestID)) {
                    Set requestPartIDs = (Set)this.references.get(requestID);
                    requestPartIDs.add(partID);
                } else {
                    HashSet requestpartIDs = new HashSet();
                    this.references.put(requestID, requestpartIDs);
                }
                this.setLocked(true);
            }
        }

        public boolean isLocked() {
            return this.locked;
        }

        public void setLocked(boolean lock) {
            this.locked = lock;
        }

        private CachedObject(String id, Object payload) {
            this.m_itemID = id;
            this.m_payload = payload;
        }

        private synchronized void setPayload(Object payload) {
            this.m_payload = payload;
        }

        private synchronized Object getPayload() {
            return this.m_payload;
        }

        private void setItemID(String id) {
            this.m_itemID = id;
        }

        private String getItemId() {
            return this.m_itemID;
        }

        private synchronized void setSize(int size) {
            this.m_size = size;
        }

        private synchronized int getSize() {
            return this.m_size;
        }

        private synchronized void setExpires(long expires) {
            this.m_expires = expires;
        }

        private synchronized long getExpires() {
            return this.m_expires;
        }

        public boolean isExpired() {
            boolean result = true;
            if (System.currentTimeMillis() < this.getExpires()) {
                result = false;
            }
            return result;
        }

        private synchronized void setPrevious(CachedObject previous) {
            this.m_previous = previous;
        }

        private synchronized CachedObject getPrevious() {
            return this.m_previous;
        }

        private synchronized void setNext(CachedObject next) {
            this.m_next = next;
        }

        private synchronized CachedObject getNext() {
            return this.m_next;
        }

        private void setEventSink(EventSink eventSink) {
            this.m_eventSink = eventSink;
        }

        private EventSink getEventSink() {
            return this.m_eventSink;
        }

        public String toString() {
            return new String("id: " + this.getItemId() + " size: " + this.getSize() + " expires: " + this.getExpires());
        }

        public boolean isListed() {
            return this.listed;
        }

        public void setListed(boolean listed) {
            this.listed = listed;
        }
    }

    public static interface EventSinkFactory {
        public EventSink getEventSink();
    }

    public static interface EventSink {
        public void onDelete();

        public void onRestoreFromFile(Object var1);
    }

    private class CachedObjectRemover
    extends Thread {
        private CachedObjectRemover() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                while (!this.isInterrupted()) {
                    CachedObjectRemover.sleep(10000L);
                    List list = DocumentCache.this.deleteList;
                    synchronized (list) {
                        ArrayList<CachedObject> lockedObjects = new ArrayList<CachedObject>();
                        Iterator iter = DocumentCache.this.deleteList.iterator();
                        while (iter.hasNext()) {
                            CachedObject cachedObject = (CachedObject)iter.next();
                            DocumentCache.this.m_log.logTrace("CachedObjectRemover removing " + cachedObject.m_itemID);
                            if (cachedObject.isLocked()) {
                                DocumentCache.this.m_log.logTrace("CachedObjectRemover moving " + cachedObject.m_itemID + "to the locked objects list");
                                lockedObjects.add(cachedObject);
                                continue;
                            }
                            DocumentCache.this.remove(cachedObject);
                            DocumentCache.this.m_log.logTrace("CachedObjectRemover removed " + cachedObject.m_itemID);
                        }
                        DocumentCache.this.deleteList = lockedObjects;
                    }
                }
                return;
            }
            catch (InterruptedException i) {
                DocumentCache.this.m_log.logTrace("CachedObjectRemover shutting down");
                List list = DocumentCache.this.deleteList;
                synchronized (list) {
                    Iterator iter = DocumentCache.this.deleteList.iterator();
                    while (iter.hasNext()) {
                        CachedObject cachedObject = (CachedObject)iter.next();
                        DocumentCache.this.remove(cachedObject);
                        DocumentCache.this.m_log.logTrace("CachedObjectRemover removed " + cachedObject.m_itemID);
                    }
                    return;
                }
            }
        }
    }

    private class CacheCleaner
    extends Thread {
        private CachedObjectQueueItem m_head = null;
        private CachedObjectQueueItem m_tail = null;

        public CacheCleaner() {
            this(true);
        }

        public CacheCleaner(boolean start) {
            if (start) {
                this.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scheduleRemoval(CachedObject node) {
            CachedObjectQueueItem newItem = new CachedObjectQueueItem();
            newItem.setCurrent(node);
            newItem.setNext(null);
            CacheCleaner cacheCleaner = this;
            synchronized (cacheCleaner) {
                if (this.m_head == null) {
                    this.m_head = newItem;
                }
                if (this.m_tail != null) {
                    this.m_tail.setNext(newItem);
                }
                this.m_tail = newItem;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                while (!this.isInterrupted()) {
                    while (this.m_head != null) {
                        CacheCleaner cacheCleaner;
                        long nextExpiration;
                        long now = System.currentTimeMillis();
                        if (now < (nextExpiration = this.m_head.getCurrent().getExpires())) {
                            cacheCleaner = this;
                            synchronized (cacheCleaner) {
                                DocumentCache.this.m_log.logTrace("CacheCleaner waiting " + (nextExpiration - now) + " for expiration of item identified by: " + this.m_head.getCurrent().getItemId());
                                this.wait(nextExpiration - now);
                            }
                        }
                        cacheCleaner = this;
                        synchronized (cacheCleaner) {
                            CachedObject removal = this.m_head.getCurrent();
                            this.m_head = this.m_head.getNext();
                            if (this.m_head == null) {
                                this.m_tail = null;
                            }
                            if (removal.isLocked()) {
                                DocumentCache.this.removeLink(removal);
                                removal.setListed(false);
                                DocumentCache.this.deleteList.add(removal);
                            } else if (DocumentCache.this.m_cacheImpl.get(removal.getItemId()) != null) {
                                DocumentCache.this.m_log.logTrace("CacheCleaner removing " + removal.getItemId());
                                DocumentCache.this.remove(removal);
                            } else {
                                DocumentCache.this.m_log.logTrace("CacheCleaner cannot remove item, ItemId is: " + removal.getItemId());
                                DocumentCache.this.m_log.logTrace("Payload class is: " + removal.getPayload().getClass());
                                if (removal.getPayload() != null && removal.getPayload() instanceof FileCacheItem) {
                                    FileCacheItem item = (FileCacheItem)removal.getPayload();
                                    DocumentCache.this.m_log.logTrace("FileCacheItem file is " + item.getCacheFile());
                                }
                            }
                        }
                    }
                    DocumentCache.this.m_log.logTrace("CacheCleaner sleeping for " + DocumentCache.this.m_maxTimeToLive);
                    CacheCleaner nextExpiration = this;
                    synchronized (nextExpiration) {
                        this.wait(DocumentCache.this.m_maxTimeToLive);
                    }
                }
                return;
            }
            catch (InterruptedException ie) {
                DocumentCache.this.m_log.logTrace("CacheCleaner shutting down");
                this.clearCache();
                return;
            }
        }

        private synchronized void clearCache() {
            DocumentCache.this.m_log.logTrace("CacheCleaner clearing the cache");
            while (this.m_head != null) {
                CachedObject done = this.m_head.getCurrent();
                this.m_head = this.m_head.getNext();
                DocumentCache.this.remove(done);
            }
            DocumentCache.this.m_log.logTrace("CacheCleaner cache cleared");
        }
    }

    private class CachedObjectQueueItem {
        private CachedObject m_current;
        private CachedObjectQueueItem m_next;

        private CachedObjectQueueItem() {
        }

        private synchronized void setCurrent(CachedObject obj) {
            this.m_current = obj;
        }

        private synchronized CachedObject getCurrent() {
            return this.m_current;
        }

        private synchronized void setNext(CachedObjectQueueItem item) {
            this.m_next = item;
        }

        private synchronized CachedObjectQueueItem getNext() {
            return this.m_next;
        }
    }
}

