/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational.rules;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.optimizer.relational.OptimizerRule;
import com.metamatrix.query.optimizer.relational.RuleStack;
import com.metamatrix.query.optimizer.relational.plantree.JoinStrategyType;
import com.metamatrix.query.optimizer.relational.plantree.NodeConstants;
import com.metamatrix.query.optimizer.relational.plantree.NodeEditor;
import com.metamatrix.query.optimizer.relational.plantree.NodeFactory;
import com.metamatrix.query.optimizer.relational.plantree.PlanNode;
import com.metamatrix.query.optimizer.relational.rules.FrameUtil;
import com.metamatrix.query.optimizer.relational.rules.JoinUtil;
import com.metamatrix.query.optimizer.relational.rules.NewCalculateCostUtil;
import com.metamatrix.query.optimizer.relational.rules.RuleChooseDependent;
import com.metamatrix.query.optimizer.relational.rules.RuleConstants;
import com.metamatrix.query.processor.relational.DependentValueSource;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.CompareCriteria;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.DependentSetCriteria;
import com.metamatrix.query.sql.lang.JoinType;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.ExpressionSymbol;
import com.metamatrix.query.sql.util.ValueIteratorSource;
import com.metamatrix.query.sql.visitor.GroupsUsedByElementsVisitor;
import com.metamatrix.query.util.CommandContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class RuleChooseDependent
implements OptimizerRule {
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        List matches = this.findCandidate(plan, metadata, capFinder, context);
        boolean pushCriteria = false;
        Iterator matchIter = matches.iterator();
        while (matchIter.hasNext()) {
            float siblingDepJoinCost;
            CandidateJoin entry = (CandidateJoin)matchIter.next();
            PlanNode joinNode = entry.joinNode;
            PlanNode sourceNode = entry.leftCandidate ? joinNode.getFirstChild() : joinNode.getLastChild();
            PlanNode siblingNode = entry.rightCandidate ? joinNode.getLastChild() : joinNode.getFirstChild();
            boolean bothCandidates = entry.leftCandidate && entry.rightCandidate;
            JoinStrategyType joinStrategy = (JoinStrategyType)joinNode.getProperty((Object)NodeConstants.Info.JOIN_STRATEGY);
            PlanNode chosenNode = this.chooseDepWithoutCosting(sourceNode, (PlanNode)(bothCandidates ? siblingNode : null), metadata, capFinder);
            if (chosenNode != null) {
                pushCriteria |= this.markDependent(chosenNode, joinNode, metadata, capFinder);
                continue;
            }
            float depJoinCost = NewCalculateCostUtil.computeCostForDepJoin(joinNode, !entry.leftCandidate, joinStrategy, metadata, capFinder, context);
            PlanNode dependentNode = sourceNode;
            PlanNode independentNode = siblingNode;
            if (bothCandidates && (siblingDepJoinCost = NewCalculateCostUtil.computeCostForDepJoin(joinNode, true, joinStrategy, metadata, capFinder, context)) != -1.0f && (siblingDepJoinCost < depJoinCost || depJoinCost == -1.0f)) {
                dependentNode = siblingNode;
                depJoinCost = siblingDepJoinCost;
                independentNode = sourceNode;
            }
            if (depJoinCost != -1.0f) {
                pushCriteria |= this.decideForAgainstDependentJoin(depJoinCost, independentNode, dependentNode, joinNode, metadata, context, capFinder);
                continue;
            }
            boolean siblingStrong = NewCalculateCostUtil.isNodeStrong(siblingNode, metadata, context);
            boolean sourceStrong = NewCalculateCostUtil.isNodeStrong(sourceNode, metadata, context);
            if (!bothCandidates) {
                if (!siblingStrong) continue;
                pushCriteria |= this.markDependent(sourceNode, joinNode, metadata, capFinder);
                continue;
            }
            if (siblingStrong && !sourceStrong) {
                pushCriteria |= this.markDependent(sourceNode, joinNode, metadata, capFinder);
                continue;
            }
            if (!siblingStrong && sourceStrong) {
                pushCriteria |= this.markDependent(siblingNode, joinNode, metadata, capFinder);
                continue;
            }
            if (!siblingStrong || !sourceStrong) continue;
            if (NewCalculateCostUtil.computeCostForTree(sourceNode, metadata) <= NewCalculateCostUtil.computeCostForTree(siblingNode, metadata)) {
                pushCriteria |= this.markDependent(siblingNode, joinNode, metadata, capFinder);
                continue;
            }
            pushCriteria |= this.markDependent(sourceNode, joinNode, metadata, capFinder);
        }
        List selectNodes = NodeEditor.findAllNodes((PlanNode)plan, (int)13, (int)3);
        Iterator selectIter = selectNodes.iterator();
        while (selectIter.hasNext()) {
            PlanNode critNode = (PlanNode)selectIter.next();
            if (!critNode.hasBooleanProperty((Object)NodeConstants.Info.IS_DEPENDENT_SET)) continue;
            pushCriteria = true;
            critNode.setProperty((Object)NodeConstants.Info.IS_COPIED, (Object)Boolean.FALSE);
        }
        if (pushCriteria) {
            rules.push(RuleConstants.CLEAN_CRITERIA);
            rules.push(RuleConstants.PUSH_SELECT_CRITERIA);
        }
        return plan;
    }

    boolean decideForAgainstDependentJoin(float depJoinCost, PlanNode independentNode, PlanNode dependentNode, PlanNode joinNode, QueryMetadataInterface metadata, CommandContext context, CapabilitiesFinder capFinder) throws QueryMetadataException, QueryPlannerException, MetaMatrixComponentException {
        JoinStrategyType joinStrategy = (JoinStrategyType)joinNode.getProperty((Object)NodeConstants.Info.JOIN_STRATEGY);
        joinNode.setProperty((Object)NodeConstants.Info.EST_DEP_JOIN_COST, (Object)new Float(depJoinCost));
        float joinCost = NewCalculateCostUtil.computeCostForJoin(independentNode, dependentNode, joinStrategy, metadata, context);
        joinNode.setProperty((Object)NodeConstants.Info.EST_JOIN_COST, (Object)new Float(joinCost));
        if (depJoinCost < joinCost) {
            return this.markDependent(dependentNode, joinNode, metadata, capFinder);
        }
        return false;
    }

    List findCandidate(PlanNode root, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, CommandContext context) throws QueryMetadataException, QueryPlannerException, MetaMatrixComponentException {
        List joinNodes = NodeEditor.findAllNodes((PlanNode)root, (int)7, (int)3);
        ArrayList<CandidateJoin> candidates = new ArrayList<CandidateJoin>();
        Iterator i = joinNodes.iterator();
        while (i.hasNext()) {
            PlanNode joinNode = (PlanNode)i.next();
            CandidateJoin candidate = null;
            Iterator j = joinNode.getChildren().iterator();
            while (j.hasNext()) {
                PlanNode child = (PlanNode)j.next();
                if (!this.isCandidate(child = FrameUtil.findJoinSourceNode((PlanNode)child), joinNode, metadata, capFinder, context)) continue;
                if (candidate == null) {
                    candidate = new CandidateJoin(null);
                    candidate.joinNode = joinNode;
                    candidates.add(candidate);
                }
                if (j.hasNext()) {
                    candidate.leftCandidate = true;
                    continue;
                }
                candidate.rightCandidate = true;
            }
        }
        return candidates;
    }

    boolean isCandidate(PlanNode node, PlanNode parentJoin, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, CommandContext context) throws QueryMetadataException, MetaMatrixComponentException {
        if (node.hasBooleanProperty((Object)NodeConstants.Info.MAKE_NOT_DEP)) {
            return false;
        }
        return this.isValidJoin(parentJoin, node);
    }

    boolean isValidJoin(PlanNode joinNode, PlanNode sourceNode) {
        JoinType jtype = (JoinType)joinNode.getProperty((Object)NodeConstants.Info.JOIN_TYPE);
        if (jtype.equals((Object)JoinType.JOIN_CROSS) || jtype.equals((Object)JoinType.JOIN_FULL_OUTER)) {
            LogManager.logTrace((String)"QUERY_PLANNER", (Object[])new Object[]{"Rejecting dependent access node as parent join is CROSS or FULL OUTER: ", sourceNode.nodeToString()});
            return false;
        }
        List jcrit = (List)joinNode.getProperty((Object)NodeConstants.Info.JOIN_CRITERIA);
        if (jcrit == null || jcrit.size() == 0) {
            LogManager.logTrace((String)"QUERY_PLANNER", (Object[])new Object[]{"Rejecting dependent access node as parent join has no join criteria: ", sourceNode.nodeToString()});
            return false;
        }
        if (joinNode.getProperty((Object)NodeConstants.Info.LEFT_EXPRESSIONS) == null) {
            LogManager.logTrace((String)"QUERY_PLANNER", (Object[])new Object[]{"Rejecting dependent access node as parent join has no equality expressions: ", sourceNode.nodeToString()});
            return false;
        }
        if (jtype.isOuter() && JoinUtil.getInnerSideJoinNodes((PlanNode)joinNode)[0] != sourceNode) {
            LogManager.logTrace((String)"QUERY_PLANNER", (Object[])new Object[]{"Rejecting dependent access node as it is on outer side of a join: ", sourceNode.nodeToString()});
            return false;
        }
        return true;
    }

    static Collection[] isEqualityCriteria(Criteria theCrit) {
        if (!(theCrit instanceof CompareCriteria)) {
            return null;
        }
        CompareCriteria compCrit = (CompareCriteria)theCrit;
        if (compCrit.getOperator() != 1) {
            return null;
        }
        Collection[] groups = new Collection[]{GroupsUsedByElementsVisitor.getGroups((LanguageObject)compCrit.getLeftExpression()), GroupsUsedByElementsVisitor.getGroups((LanguageObject)compCrit.getRightExpression())};
        Collection allGroups = GroupsUsedByElementsVisitor.getGroups((LanguageObject)compCrit);
        if (groups[0].size() > 0 && groups[0].size() + groups[1].size() == allGroups.size()) {
            return groups;
        }
        return null;
    }

    PlanNode chooseDepWithoutCosting(PlanNode sourceNode1, PlanNode sourceNode2, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) {
        if (sourceNode1.hasCollectionProperty((Object)NodeConstants.Info.ACCESS_PATTERNS)) {
            if (sourceNode2 != null && sourceNode2.hasCollectionProperty((Object)NodeConstants.Info.ACCESS_PATTERNS)) {
                LogManager.logTrace((String)"QUERY_PLANNER", (Object[])new Object[]{"Neither access node can be made dependent because both have unsatisfied access patterns: ", sourceNode1.nodeToString(), "\n", sourceNode2.toString()});
                return null;
            }
            return sourceNode1;
        }
        if (sourceNode2 != null && sourceNode2.hasCollectionProperty((Object)NodeConstants.Info.ACCESS_PATTERNS)) {
            LogManager.logTrace((String)"QUERY_PLANNER", (Object[])new Object[]{"Making access node dependent to satisfy access pattern: ", sourceNode2.nodeToString()});
            return sourceNode2;
        }
        if (sourceNode1.hasBooleanProperty((Object)NodeConstants.Info.MAKE_DEP)) {
            LogManager.logTrace((String)"QUERY_PLANNER", (Object[])new Object[]{"Making access node dependent due to hint: ", sourceNode1.nodeToString()});
            return sourceNode1;
        }
        if (sourceNode2 != null && sourceNode2.hasBooleanProperty((Object)NodeConstants.Info.MAKE_DEP)) {
            LogManager.logTrace((String)"QUERY_PLANNER", (Object[])new Object[]{"Making access node dependent due to hint: ", sourceNode2.nodeToString()});
            return sourceNode2;
        }
        return null;
    }

    boolean markDependent(PlanNode sourceNode, PlanNode joinNode, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, QueryPlannerException, MetaMatrixComponentException {
        boolean isLeft = joinNode.getFirstChild() == sourceNode;
        List independentExpressions = (List)(isLeft ? joinNode.getProperty((Object)NodeConstants.Info.RIGHT_EXPRESSIONS) : joinNode.getProperty((Object)NodeConstants.Info.LEFT_EXPRESSIONS));
        List dependentExpressions = (List)(isLeft ? joinNode.getProperty((Object)NodeConstants.Info.LEFT_EXPRESSIONS) : joinNode.getProperty((Object)NodeConstants.Info.RIGHT_EXPRESSIONS));
        if (independentExpressions == null || independentExpressions.isEmpty()) {
            return false;
        }
        DependentValueSource valueIterSrc = new DependentValueSource();
        joinNode.setProperty((Object)NodeConstants.Info.DEPENDENT_VALUE_SOURCE, (Object)valueIterSrc);
        List crits = this.getDependentCriteriaNodes((ValueIteratorSource)valueIterSrc, independentExpressions, dependentExpressions);
        PlanNode newRoot = sourceNode;
        Iterator i = crits.iterator();
        while (i.hasNext()) {
            PlanNode crit = (PlanNode)i.next();
            NodeEditor.insertNode((PlanNode)joinNode, (PlanNode)newRoot, (PlanNode)crit);
            newRoot = crit;
        }
        if (isLeft) {
            JoinUtil.swapJoinChildren((PlanNode)joinNode);
        }
        return true;
    }

    private List getDependentCriteriaNodes(ValueIteratorSource iterSrc, List independentExpressions, List dependentExpressions) {
        LinkedList<PlanNode> result = new LinkedList<PlanNode>();
        Iterator depIter = dependentExpressions.iterator();
        Iterator indepIter = independentExpressions.iterator();
        while (depIter.hasNext()) {
            PlanNode selectNode = NodeFactory.getNewNode((int)13);
            Expression depExpr = (Expression)depIter.next();
            Expression indepExpr = (Expression)indepIter.next();
            DependentSetCriteria crit = new DependentSetCriteria(depExpr);
            if (!(indepExpr instanceof ElementSymbol) && !(indepExpr instanceof ExpressionSymbol)) {
                indepExpr = new ExpressionSymbol(indepExpr.toString(), indepExpr);
            }
            crit.setValueExpression(indepExpr);
            crit.setValueIteratorSource(iterSrc);
            selectNode.setProperty((Object)NodeConstants.Info.SELECT_CRITERIA, (Object)crit);
            selectNode.setProperty((Object)NodeConstants.Info.IS_DEPENDENT_SET, (Object)Boolean.TRUE);
            selectNode.addGroups(GroupsUsedByElementsVisitor.getGroups((LanguageObject)crit));
            result.add(selectNode);
        }
        return result;
    }

    public String toString() {
        return "ChooseDependent";
    }
}

