/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.bridges.io;

import MITI.sdk.MIRModel;
import com.metamatrix.api.exception.MetaMatrixRuntimeException;
import com.metamatrix.bridges.BridgeConstants;
import com.metamatrix.bridges.BridgesPlugin;
import com.metamatrix.bridges.api.Bridge;
import com.metamatrix.bridges.internal.log.BridgeMessageMappingStrategyImpl;
import com.metamatrix.bridges.io.BridgeModelProcessor;
import com.metamatrix.bridges.io.IBridgeImporterListener;
import com.metamatrix.bridges.log.BridgeLoggingAdapter;
import com.metamatrix.bridges.log.BridgeMessageMappingStrategy;
import com.metamatrix.core.MetaMatrixCoreException;
import com.metamatrix.core.UserCancelledException;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.FileUtils;
import com.metamatrix.internal.bridges.BridgeImpl;
import com.metamatrix.internal.bridges.BridgeOption;
import com.metamatrix.license.LicensePlugin;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.validation.rules.StringNameValidator;
import com.metamatrix.modeler.internal.ui.viewsupport.ModelUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public final class BridgeImporter
implements BridgeConstants {
    public static final int LOGICAL_MODEL = 0;
    public static final int PHYSICAL_MODEL = 1;
    public static final int RELATIONSHIPS_MODEL = 2;
    public static final int DATATYPE_MODEL = 3;
    static final int PRIMER = 2000;
    static final int AMOUNT_OF_WORK_FOR_PREPROCESSING = 5000;
    static final int AMOUNT_OF_WORK_FOR_CONVERTING = 15000;
    static final int AMOUNT_OF_WORK_FOR_POST_PROCESSING1 = 2000;
    static final int AMOUNT_OF_WORK_FOR_POST_PROCESSING2 = 4000;
    static final int AMOUNT_OF_WORK_FOR_POST_PROCESSING3 = 2000;
    static final int AMOUNT_OF_WORK_FOR_POST_PROCESSING4 = 1000;
    static final int AMOUNT_OF_WORK_FOR_POST_PROCESSING5 = 1000;
    static final int AMOUNT_OF_WORK_FOR_POST_PROCESSING6 = 1000;
    static final int AMOUNT_OF_WORK_FOR_CREATING_RESULTS = 100;
    private final BridgeLoggingAdapter loggingAdapter;
    private final Bridge bridge;
    private IProgressMonitor monitor;
    private boolean dirty;
    private String description;
    private String[] fileExtensions;
    private String msg;
    private String sourceModelName;
    private String targetFullPath;
    private String targetLocation;
    private String targetDatatypeModelName;
    private String targetLogicalModelName;
    private String targetPhysicalModelName;
    private String targetRelationshipsModelName;
    private boolean updateExisting;
    private boolean updatesRequired;
    private boolean modelIsFolder;
    private boolean valid;
    private boolean warnings;
    private ResourceSet resourceSet;
    private ResourceSet updateResourceSet;
    private MultiStatus status;
    private final Map licenseMap;
    private String conversionString;
    private BridgeModelProcessor processor;
    private final List updateModelMappings = new ArrayList(4);
    private IBridgeImporterListener listener;
    private boolean createLogicalAsRelational = true;
    private long createEntityProgressDelta = 100L;
    private final StringNameValidator nameValidator;
    static boolean HEADLESS;
    ResourceSet testResourceSet;

    public BridgeImporter() {
        this.loggingAdapter = new BridgeLoggingAdapter(this, (BridgeMessageMappingStrategy)new BridgeMessageMappingStrategyImpl());
        this.bridge = new BridgeImpl(this.loggingAdapter);
        this.licenseMap = this.initializeLicenseMap();
        this.nameValidator = new StringNameValidator();
        this.validate();
    }

    BridgeImporter(BridgeImpl bridge) {
        this.loggingAdapter = bridge.getLoggingAdapter();
        this.bridge = bridge;
        this.licenseMap = this.initializeLicenseMap();
        this.nameValidator = new StringNameValidator();
        this.validate();
    }

    public String getTargetDatatypeModelName() {
        return this.getLongFileName(this.getTargetDatatypeModelShortName(), 3);
    }

    public String getTargetLogicalModelName() {
        return this.getLongFileName(this.getTargetLogicalModelShortName(), 0);
    }

    public String getTargetPhysicalModelName() {
        return this.getLongFileName(this.getTargetPhysicalModelShortName(), 1);
    }

    public String getTargetRelationshipsModelName() {
        return this.getLongFileName(this.getTargetRelationshipsModelShortName(), 2);
    }

    public boolean isValid() {
        return !this.isDirty() && this.valid;
    }

    public boolean createLogicalAsRelational() {
        return this.createLogicalAsRelational;
    }

    public void setCreateLogicalAsRelational(boolean clar) {
        this.createLogicalAsRelational = clar;
    }

    public boolean isWarning() {
        return this.isValid() && this.warnings;
    }

    public Collection getUdps() {
        return this.bridge.getUdps();
    }

    public void addUdp(BridgeOption info) {
        this.bridge.addUdp(info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MultiStatus executeImport(IProgressMonitor progressMonitor) {
        if (!this.validate()) {
            throw new MetaMatrixRuntimeException(BridgesPlugin.Util.getString("BridgeImporter.BridgeImporter_is_not_valid_2", (Object)this.getMessage()));
        }
        boolean isLicensed = this.checkLicense();
        if (!isLicensed) {
            String feature = this.bridge.getImportLibraryName();
            String msg = BridgesPlugin.Util.getString("BridgeImporter.licenseException", (Object)feature);
            this.log(msg, 4, null);
            return this.status;
        }
        boolean startedTxn = ModelerCore.startTxn((boolean)true, (boolean)false, (String)this.description, (Object)this);
        this.monitor = progressMonitor != null ? progressMonitor : new NullProgressMonitor();
        String taskName = this.doGetTaskName();
        int totalWork = this.doComputeTotalWork();
        this.monitor.beginTask(taskName, totalWork);
        this.monitor.worked(2000);
        MIRModel model = null;
        try {
            block25: {
                try {
                    String preProcessingSubTask = BridgesPlugin.Util.getString("BridgeImporter.Performing_model_preprocessing_1");
                    this.monitor.subTask(preProcessingSubTask);
                    model = this.getBridge().executeConversion(this.getSourceModelName());
                    if (this.listener != null) {
                        this.listener.importComplete();
                    }
                    this.monitor.worked(5000);
                    if (model == null || model.getChildPackageCount() == 0) {
                        String msg = BridgesPlugin.Util.getString("BridgeImporter.Preprocessing_produced_a_zero_length_file_1");
                        this.log(msg, 4, null);
                        break block25;
                    }
                    if (model != null) {
                        if (!this.monitor.isCanceled()) {
                            File tempFile = this.getBridge().getTempFile();
                            String conversionSubTask = this.getConversionSting(tempFile.length());
                            this.monitor.subTask(conversionSubTask);
                            this.processor = new BridgeModelProcessor(this);
                            this.processor.process(model);
                        }
                        break block25;
                    }
                    String msg = BridgesPlugin.Util.getString("BridgeImporter.Pre-read_conversion_did_not_return_a_readable_file_2");
                    this.log(msg, 4, null);
                }
                catch (UserCancelledException e) {
                    Object var11_18 = null;
                    if (this.monitor.isCanceled()) {
                        String canceled = BridgesPlugin.Util.getString("BridgeImporter.Bridge_Import_canceled_1");
                        this.status = new MultiStatus("com.metamatrix.bridges", -1, canceled, null);
                    } else if (this.status == null) {
                        String success = BridgesPlugin.Util.getString("BridgeImporter.completed_successfully_1", (Object)this.getDescription());
                        this.status = new MultiStatus("com.metamatrix.bridges", -1, success, null);
                    }
                    BridgesPlugin.Util.log((IStatus)this.status);
                    if (!startedTxn) return this.status;
                    ModelerCore.commitTxn();
                    return this.status;
                }
                catch (Throwable e2) {
                    String msg = BridgesPlugin.Util.getString("BridgeImporter.Exception_performing_post-conversion_MetaMatrix_read_3");
                    if (e2 instanceof Exception) {
                        this.log(msg, 4, (Exception)e2);
                    } else {
                        this.log(msg, 4, (Exception)new MetaMatrixCoreException(e2));
                    }
                    Object var11_19 = null;
                    if (this.monitor.isCanceled()) {
                        String canceled = BridgesPlugin.Util.getString("BridgeImporter.Bridge_Import_canceled_1");
                        this.status = new MultiStatus("com.metamatrix.bridges", -1, canceled, null);
                    } else if (this.status == null) {
                        String success = BridgesPlugin.Util.getString("BridgeImporter.completed_successfully_1", (Object)this.getDescription());
                        this.status = new MultiStatus("com.metamatrix.bridges", -1, success, null);
                    }
                    BridgesPlugin.Util.log((IStatus)this.status);
                    if (!startedTxn) return this.status;
                    ModelerCore.commitTxn();
                    return this.status;
                }
            }
            Object var11_17 = null;
            if (this.monitor.isCanceled()) {
                String canceled = BridgesPlugin.Util.getString("BridgeImporter.Bridge_Import_canceled_1");
                this.status = new MultiStatus("com.metamatrix.bridges", -1, canceled, null);
            } else if (this.status == null) {
                String success = BridgesPlugin.Util.getString("BridgeImporter.completed_successfully_1", (Object)this.getDescription());
                this.status = new MultiStatus("com.metamatrix.bridges", -1, success, null);
            }
            BridgesPlugin.Util.log((IStatus)this.status);
            if (!startedTxn) return this.status;
            ModelerCore.commitTxn();
            return this.status;
        }
        catch (Throwable throwable) {
            Object var11_20 = null;
            if (this.monitor.isCanceled()) {
                String canceled = BridgesPlugin.Util.getString("BridgeImporter.Bridge_Import_canceled_1");
                this.status = new MultiStatus("com.metamatrix.bridges", -1, canceled, null);
            } else if (this.status == null) {
                String success = BridgesPlugin.Util.getString("BridgeImporter.completed_successfully_1", (Object)this.getDescription());
                this.status = new MultiStatus("com.metamatrix.bridges", -1, success, null);
            }
            BridgesPlugin.Util.log((IStatus)this.status);
            if (!startedTxn) throw throwable;
            ModelerCore.commitTxn();
            throw throwable;
        }
    }

    public void finish(boolean doSave) {
        if (this.processor != null) {
            this.processor.finish(doSave);
            this.processor = null;
        }
        if (this.updateResourceSet != null) {
            this.updateResourceSet = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean validate() {
        IResource rsrc;
        if (this.getBridge() == null) {
            this.setErrorState(BridgesPlugin.Util.getString("BridgeImporter.validation.nullBridge"));
            return this.isValid();
        }
        if (!(this.isModelFolder() || this.getFileExtensions() != null && this.getFileExtensions().length != 0)) {
            this.setErrorState(BridgesPlugin.Util.getString("BridgeImporter.validation.noFileExtensions"));
            return this.isValid();
        }
        if (!this.isComplete(this.getSourceModelName())) {
            this.setErrorState(BridgesPlugin.Util.getString("BridgeImporter.validation.sourceModelNotCompleteMessage"));
            return this.isValid();
        }
        if (!this.isComplete(this.getTargetFullPath())) {
            this.setErrorState(BridgesPlugin.Util.getString("BridgeImporter.validation.targetFullPathNotCompleteMessage"));
            return this.isValid();
        }
        if (!this.isComplete(this.getTargetLocation())) {
            this.setErrorState(BridgesPlugin.Util.getString("BridgeImporter.validation.targetLocationNotCompleteMessage"));
            return this.isValid();
        }
        if (!HEADLESS && (rsrc = ModelerCore.getWorkspace().getRoot().findMember(this.targetLocation)) != null && !rsrc.getProject().isOpen()) {
            this.setErrorState(BridgesPlugin.Util.getString("BridgeImporter.validation.Target_Project_must_be_open_1"));
            return this.isValid();
        }
        if (!this.isComplete(this.getTargetDatatypeModelShortName())) {
            this.setErrorState(BridgesPlugin.Util.getString("BridgeImporter.validation.targetDatatypeModelNotCompleteMessage"));
            return this.isValid();
        }
        if (!this.isComplete(this.getTargetPhysicalModelShortName())) {
            this.setErrorState(BridgesPlugin.Util.getString("BridgeImporter.validation.targetPhysicalModelNotCompleteMessage"));
            return this.isValid();
        }
        if (!this.isComplete(this.getTargetLogicalModelShortName())) {
            this.setErrorState(BridgesPlugin.Util.getString("BridgeImporter.validation.targetLogicalModelNotCompleteMessage"));
            return this.isValid();
        }
        if (!this.isComplete(this.getTargetRelationshipsModelShortName())) {
            this.setErrorState(BridgesPlugin.Util.getString("BridgeImporter.validation.targetRelationshipsModelNotCompleteMessage"));
            return this.isValid();
        }
        String invalidNameMsg = ModelUtilities.validateModelName((String)this.getTargetDatatypeModelShortName(), (String)".xsd");
        if (invalidNameMsg != null) {
            this.setErrorState(BridgesPlugin.Util.getString("BridgeImporter.validation.targetDatatypeModelNameInvalid", (Object)invalidNameMsg));
            return this.isValid();
        }
        invalidNameMsg = ModelUtilities.validateModelName((String)this.getTargetPhysicalModelShortName(), (String)".xmi");
        if (invalidNameMsg != null) {
            this.setErrorState(BridgesPlugin.Util.getString("BridgeImporter.validation.targetPhysicalModelNameInvalid", (Object)invalidNameMsg));
            return this.isValid();
        }
        invalidNameMsg = ModelUtilities.validateModelName((String)this.getTargetLogicalModelShortName(), (String)".xmi");
        if (invalidNameMsg != null) {
            this.setErrorState(BridgesPlugin.Util.getString("BridgeImporter.validation.targetLogicalModelNameInvalid", (Object)invalidNameMsg));
            return this.isValid();
        }
        invalidNameMsg = ModelUtilities.validateModelName((String)this.getTargetRelationshipsModelShortName(), (String)".xmi");
        if (invalidNameMsg != null) {
            this.setErrorState(BridgesPlugin.Util.getString("BridgeImporter.validation.targetRelationshipsModelNameInvalid", (Object)invalidNameMsg));
            return this.isValid();
        }
        if (!this.isComplete(this.getDescription())) {
            this.setErrorState(BridgesPlugin.Util.getString("BridgeImporter.validation.descriptionNotCompleteMessage"));
            return this.isValid();
        }
        if (this.getTargetPhysicalModelShortName().equals(this.getTargetLogicalModelShortName()) || this.getTargetPhysicalModelShortName().equals(this.getTargetRelationshipsModelShortName()) || this.getTargetLogicalModelShortName().equals(this.getTargetRelationshipsModelShortName()) || this.getTargetDatatypeModelShortName().equals(this.getTargetPhysicalModelShortName()) || this.getTargetDatatypeModelShortName().equals(this.getTargetLogicalModelShortName()) || this.getTargetDatatypeModelShortName().equals(this.getTargetRelationshipsModelShortName())) {
            this.setErrorState(BridgesPlugin.Util.getString("BridgeImporter.validation.duplicateTargetModelNamesMessage"));
            return this.isValid();
        }
        File tmpFile = new File(this.getTargetPhysicalModelName());
        this.updatesRequired = false;
        if (tmpFile.exists()) {
            this.updatesRequired = true;
            if (!this.updateExisting) {
                this.setErrorState(BridgesPlugin.Util.getString("BridgeImporter.validation.targetPhysicalModelExistsMessage"));
                return this.isValid();
            }
            if (!tmpFile.canWrite()) {
                this.setErrorState(BridgesPlugin.Util.getString("BridgeImporter.validation.physicalRO"));
                return this.isValid();
            }
        }
        if ((tmpFile = new File(this.getTargetLogicalModelName())).exists()) {
            this.updatesRequired = true;
            if (!this.updateExisting) {
                this.setErrorState(BridgesPlugin.Util.getString("BridgeImporter.validation.targetLogicalModelExistsMessage"));
                return this.isValid();
            }
            if (!tmpFile.canWrite()) {
                this.setErrorState(BridgesPlugin.Util.getString("BridgeImporter.validation.logicalRO"));
                return this.isValid();
            }
        }
        if ((tmpFile = new File(this.getTargetRelationshipsModelName())).exists()) {
            this.updatesRequired = true;
            if (!this.updateExisting) {
                this.setErrorState(BridgesPlugin.Util.getString("BridgeImporter.validation.targetRelationshipsModelExistsMessage"));
                return this.isValid();
            }
            if (!tmpFile.canWrite()) {
                this.setErrorState(BridgesPlugin.Util.getString("BridgeImporter.validation.relationshipRO"));
                return this.isValid();
            }
        }
        if ((tmpFile = new File(this.getTargetDatatypeModelName())).exists()) {
            this.updatesRequired = true;
            if (!this.updateExisting) {
                this.setErrorState(BridgesPlugin.Util.getString("BridgeImporter.validation.targetDatatypeModelExistsMessage"));
                return this.isValid();
            }
            if (!tmpFile.canWrite()) {
                this.setErrorState(BridgesPlugin.Util.getString("BridgeImporter.validation.dataTypeRO"));
                return this.isValid();
            }
        }
        if (!this.getBridge().isCurrentlyExecutable()) {
            this.setErrorState(BridgesPlugin.Util.getString("BridgeImporter.validation.bridgeNotExecutable"));
            return this.isValid();
        }
        this.setValidState(BridgesPlugin.Util.getString("BridgeImporter.validation.successMessage"));
        return this.isValid();
    }

    public Resource createResource(String fullPath) throws MetaMatrixCoreException {
        try {
            URI uri = URI.createFileURI((String)fullPath);
            ResourceSet rs = this.getResourceSet();
            Resource rsrc = rs.getResource(uri, false);
            if (rsrc != null) {
                if (this.updateExisting) {
                    if (!rsrc.isLoaded()) {
                        rsrc.load(new HashMap());
                    }
                    Resource neww = this.getUpdateResourceSet().createResource(uri);
                    this.addUpdateMapping(rsrc, neww);
                    return neww;
                }
                throw new MetaMatrixCoreException(BridgesPlugin.Util.getString("BridgeReaderAdapter.A_resource_with_name_already_exists_1", (Object)fullPath));
            }
            return rs.createResource(uri);
        }
        catch (Exception e) {
            BridgesPlugin.Util.log(4, (Throwable)e, e.getMessage());
            return null;
        }
    }

    public void log(String msg, int severity, Exception e) {
        if (msg == null) {
            if (e == null) {
                return;
            }
            msg = e.getMessage();
            if (msg == null) {
                msg = e.getClass().getName();
            }
        }
        this.getStatus().add((IStatus)new Status(severity, "com.metamatrix.bridges", -1, msg, (Throwable)e));
    }

    public InputStream getSourceInputStream(File f) {
        FileInputStream result;
        block3: {
            if (f == null || !f.exists()) {
                return null;
            }
            result = null;
            try {
                result = new FileInputStream(f);
                f.delete();
            }
            catch (Exception e) {
                BridgesPlugin.Util.log(4, (Throwable)e, e.getMessage());
                if (f == null) break block3;
                f.delete();
            }
        }
        return result;
    }

    public IProgressMonitor getProgressMonitor() {
        return this.monitor;
    }

    public String getDescription() {
        return this.description;
    }

    public Bridge getBridge() {
        return this.bridge;
    }

    public String[] getFileExtensions() {
        return this.fileExtensions;
    }

    public String getMessage() {
        return this.msg;
    }

    public String getSourceModelName() {
        return this.sourceModelName;
    }

    public String getTargetLocation() {
        return this.targetLocation;
    }

    public String getTargetFullPath() {
        return this.targetFullPath;
    }

    public String getTargetDatatypeModelShortName() {
        return this.targetDatatypeModelName;
    }

    public String getTargetLogicalModelShortName() {
        return this.targetLogicalModelName;
    }

    public String getTargetPhysicalModelShortName() {
        return this.targetPhysicalModelName;
    }

    public String getTargetRelationshipsModelShortName() {
        return this.targetRelationshipsModelName;
    }

    public boolean getUpdateExisting() {
        return this.updateExisting;
    }

    public Collection getUpdateMappings() {
        return this.updateModelMappings;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void addUpdateMapping(Resource existing, Resource neww) {
        this.updateModelMappings.add(new UpdateMapping(neww, existing));
    }

    public boolean isModelFolder() {
        return this.modelIsFolder;
    }

    public void setModelIsFolder(boolean modelIsFolder) {
        this.modelIsFolder = modelIsFolder;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setFileExtensions(String[] theExtensions) {
        this.fileExtensions = theExtensions;
        this.setDirty(true);
    }

    public void setListener(IBridgeImporterListener listener) {
        this.listener = listener;
    }

    public void setMiExportLibrary(String string) {
        this.getBridge().setExportLibraryName(string);
        this.setDirty(true);
    }

    public void setMiImportLibrary(String string) {
        this.getBridge().setImportLibraryName(string);
        this.setDirty(true);
    }

    public void setSourceModelName(String theModelName) {
        this.sourceModelName = theModelName;
        this.modifyOutputModelNames();
        this.setDirty(true);
    }

    public void setTargetLocation(String theLocation) {
        if (theLocation == null || theLocation.trim().length() == 0) {
            this.targetLocation = null;
            this.setTargetFullPath(null);
            this.setDirty(true);
            return;
        }
        this.targetLocation = theLocation;
        IResource rsrc = null;
        if (!HEADLESS) {
            ModelerCore.getWorkspace().getRoot().findMember(theLocation);
            if (rsrc == null && theLocation.indexOf("/") > -1) {
                theLocation = theLocation.substring(theLocation.indexOf("/"));
                rsrc = ModelerCore.getWorkspace().getRoot().findMember(theLocation);
            }
        }
        if (rsrc != null) {
            this.setTargetFullPath(rsrc.getLocation().toString());
        }
        this.setDirty(true);
    }

    public void setTargetFullPath(String theLocation) {
        this.targetFullPath = theLocation;
        this.setDirty(true);
    }

    public void setTargetDatatypeModelName(String theModelName) {
        this.targetDatatypeModelName = theModelName;
        this.setDirty(true);
    }

    public Collection getImportOptions() {
        if (this.bridge == null) {
            return Collections.EMPTY_LIST;
        }
        return this.bridge.getBridgeOptions(true);
    }

    public void setTargetLogicalModelName(String theModelName) {
        this.targetLogicalModelName = theModelName;
        this.setDirty(true);
    }

    public void setTargetPhysicalModelName(String theModelName) {
        this.targetPhysicalModelName = theModelName;
        this.setDirty(true);
    }

    public void setTargetRelationshipsModelName(String theModelName) {
        this.targetRelationshipsModelName = theModelName;
        this.setDirty(true);
    }

    public void setUpdateExisting(boolean updateExisting) {
        this.updateExisting = updateExisting;
        this.setDirty(true);
    }

    public ResourceSet getResourceSet() {
        if (this.resourceSet == null) {
            try {
                this.resourceSet = ModelerCore.getModelContainer();
            }
            catch (CoreException e) {
                BridgesPlugin.Util.log(4, (Throwable)e, e.getMessage());
            }
        }
        return this.resourceSet;
    }

    public void setResourceSet(ResourceSet resourceSet) {
        this.resourceSet = resourceSet;
    }

    public ResourceSet getUpdateResourceSet() {
        if (this.updateResourceSet == null) {
            try {
                this.updateResourceSet = ModelerCore.createContainer((String)"Update Container");
            }
            catch (CoreException e) {
                BridgesPlugin.Util.log(4, (Throwable)e, e.getMessage());
            }
        }
        return this.updateResourceSet;
    }

    public String getConversionString() {
        if (this.conversionString == null) {
            this.conversionString = "";
        }
        return this.conversionString;
    }

    public boolean updatesRequired() {
        return this.updatesRequired;
    }

    private String getConversionSting(long mirModelSize) {
        if (mirModelSize < 250000L) {
            this.createEntityProgressDelta = 1000L;
            this.conversionString = BridgesPlugin.Util.getString("BridgeImporter.Converting_to_MetaMatrix_models_1");
        } else if (mirModelSize >= 250000L && mirModelSize < 1000000L) {
            this.createEntityProgressDelta = 5000L;
            this.conversionString = BridgesPlugin.Util.getString("BridgeImporter.Converting_to_MetaMatrix_models_2");
        } else if (mirModelSize >= 1000000L && mirModelSize < 5000000L) {
            this.createEntityProgressDelta = 10000L;
            this.conversionString = BridgesPlugin.Util.getString("BridgeImporter.Converting_to_MetaMatrix_models_3");
        } else {
            this.createEntityProgressDelta = 10000L;
            this.conversionString = BridgesPlugin.Util.getString("BridgeImporter.Converting_to_MetaMatrix_models_4");
        }
        return this.conversionString;
    }

    public long getProgressDelta() {
        return this.createEntityProgressDelta;
    }

    protected boolean checkLicense() {
        if (HEADLESS) {
            return true;
        }
        ArgCheck.isNotNull((Object)this.getBridge());
        boolean isLicensed = false;
        String bridgeName = this.getBridge().getImportLibraryName();
        String feature = (String)this.licenseMap.get(bridgeName);
        if (feature == null) {
            String msg = BridgesPlugin.Util.getString("BridgeImporter.nullFeature", (Object)bridgeName, this.licenseMap.keySet());
            BridgesPlugin.Util.log(4, msg);
        }
        try {
            LicensePlugin.checkLicense((String)"Modeler", (String)"5.5");
        }
        catch (CoreException e) {
            throw new MetaMatrixRuntimeException((Throwable)e, e.getMessage());
        }
        isLicensed = this.isModelerCapabilityLicensed(feature);
        return isLicensed;
    }

    protected boolean isModelerCapabilityLicensed(String theCapability) {
        return LicensePlugin.isCapabilityLicensed((String)"Modeler", (String)theCapability, (String)"5.5");
    }

    protected String doGetTaskName() {
        return BridgesPlugin.Util.getString("BridgeImporter.Importing_models");
    }

    protected int doComputeTotalWork() {
        return 33100;
    }

    private static String createModelName(String theName, int theModelType) {
        String suffix = null;
        switch (theModelType) {
            case 0: {
                suffix = BridgesPlugin.Util.getString("BridgeImporter.suffix.logicalModel");
                break;
            }
            case 1: {
                suffix = BridgesPlugin.Util.getString("BridgeImporter.suffix.physicalModel");
                break;
            }
            case 2: {
                suffix = BridgesPlugin.Util.getString("BridgeImporter.suffix.relationshipsModel");
                break;
            }
            case 3: {
                suffix = BridgesPlugin.Util.getString("BridgeImporter.suffix.datatypeModel");
                break;
            }
            default: {
                suffix = BridgesPlugin.Util.getString("BridgeImporter.suffix.unknown");
            }
        }
        StringBuffer result = new StringBuffer(theName);
        result.append(suffix);
        if (theModelType == 3) {
            result.append(".xsd");
        } else {
            result.append(".xmi");
        }
        return result.toString();
    }

    private String getLongFileName(String theFileName, int rsrcType) {
        String extension = rsrcType == 3 ? ".xsd" : ".xmi";
        String result = null;
        if (this.isComplete(this.getTargetLocation())) {
            String tmp = theFileName.endsWith(".xmi") || theFileName.endsWith(".xsd") ? theFileName : theFileName + extension;
            result = this.getTargetFullPath() + File.separatorChar + tmp;
        }
        return result;
    }

    private boolean isComplete(String theText) {
        return theText != null && theText.length() > 0;
    }

    private void modifyOutputModelNames() {
        if (this.isComplete(this.getSourceModelName())) {
            String newName = FileUtils.getFilenameWithoutExtension((String)new File(this.getSourceModelName()).getName());
            String tmp = this.nameValidator.createValidName(newName);
            String validName = tmp == null ? newName : tmp;
            this.setTargetLogicalModelName(BridgeImporter.createModelName(validName, 0));
            this.setTargetPhysicalModelName(BridgeImporter.createModelName(validName, 1));
            this.setTargetRelationshipsModelName(BridgeImporter.createModelName(validName, 2));
            this.setTargetDatatypeModelName(BridgeImporter.createModelName(validName, 3));
        } else {
            this.setTargetLogicalModelName(null);
            this.setTargetPhysicalModelName(null);
            this.setTargetRelationshipsModelName(null);
            this.setTargetDatatypeModelName(null);
        }
    }

    protected void setDirty(boolean theDirtyFlag) {
        this.dirty = theDirtyFlag;
    }

    protected void setErrorState(String theMessage) {
        this.valid = false;
        this.warnings = false;
        this.setDirty(false);
        this.setMessage(theMessage);
    }

    protected void setMessage(String theMessage) {
        this.msg = theMessage;
    }

    protected void setValidState(String theMessage) {
        this.valid = true;
        this.warnings = false;
        this.setDirty(false);
        this.setMessage(theMessage);
    }

    protected void setWarningState(String theMessage) {
        this.warnings = true;
        this.valid = true;
        this.setDirty(false);
        this.setMessage(theMessage);
    }

    protected MultiStatus getStatus() {
        if (this.status == null) {
            String msg = BridgesPlugin.Util.getString("BridgeImporter.result_1", (Object)this.getDescription());
            this.status = new MultiStatus("com.metamatrix.bridges", -1, new IStatus[0], msg, null);
        }
        return this.status;
    }

    public String toString() {
        String tmp = this.fileExtensions == null ? "null" : Arrays.asList(this.fileExtensions).toString();
        return "bridge=" + this.bridge + '\n' + "dirty=" + this.dirty + '\n' + "fileExtensions=" + tmp + '\n' + "msg=" + this.msg + '\n' + "sourceModelName=" + this.sourceModelName + '\n' + "targetLocation=" + this.targetLocation + '\n' + "targetFullPath=" + this.targetFullPath + '\n' + "targetLogicalModelName=" + this.targetLogicalModelName + '\n' + "targetPhysicalModelName=" + this.targetPhysicalModelName + '\n' + "targetRelationshipsModelName=" + this.targetRelationshipsModelName + '\n' + "targetDatatypeModelName=" + this.targetDatatypeModelName + '\n' + "valid=" + this.valid + '\n' + "warnings=" + this.warnings + '\n';
    }

    private Map initializeLicenseMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("CaErwin3Erx", "Importer/ERwin");
        map.put("CaErwin4Xml", "Importer/ERwin");
        map.put("CaErwin7Xml", "Importer/ERwin");
        map.put("PopkinSa08813", "Importer/Popkin");
        map.put("PopkinSa10014", "Importer/Popkin");
        map.put("EmbarcaderoErStudio", "Importer/ERwin");
        return map;
    }

    public class UpdateMapping {
        final Resource neww;
        final Resource existing;

        public UpdateMapping(Resource neww, Resource existing) {
            this.neww = neww;
            this.existing = existing;
        }

        public Resource getExisting() {
            return this.existing;
        }

        public Resource getNew() {
            return this.neww;
        }
    }
}

