/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.bridges.internal.ui.util;

import com.metamatrix.bridges.BridgeConstants;
import com.metamatrix.bridges.api.Bridge;
import com.metamatrix.bridges.internal.ui.util.BridgeItemProvider;
import com.metamatrix.bridges.internal.ui.util.ExtendedComboBoxPropertyDescriptor;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.internal.bridges.BridgeOption;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.ui.provider.PropertySource;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class BridgeOptionPropertySource
extends PropertySource
implements StringUtil.Constants,
BridgeConstants {
    final Bridge bridge;
    private IPropertyDescriptor[] descriptors;

    public BridgeOptionPropertySource(Bridge bridge) {
        super((Object)bridge, (IItemPropertySource)new BridgeItemProvider());
        this.bridge = bridge;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.descriptors == null) {
            Collection properties = this.bridge.getBridgeOptions(true);
            int size = properties.size() == 0 ? 0 : properties.size() - 1;
            this.descriptors = new IPropertyDescriptor[size];
            if (this.descriptors.length == 0) {
                return this.descriptors;
            }
            Iterator it = properties.iterator();
            int i = 0;
            while (it.hasNext()) {
                BridgeOption id = (BridgeOption)it.next();
                String name = id.getName();
                String type = id.getType();
                ExtendedComboBoxPropertyDescriptor descriptor = null;
                if ("ENUMERATED".equals(type)) {
                    String[] valuesArray = id.getAllowedValues();
                    descriptor = new ExtendedComboBoxPropertyDescriptor((Object)id, name, valuesArray);
                } else if ("BOOLEAN".equals(type)) {
                    descriptor = new ExtendedComboBoxPropertyDescriptor((Object)id, name, new String[]{"false", "true"});
                } else if (!"FILE".equals(type)) {
                    descriptor = new TextPropertyDescriptor((Object)id, name);
                }
                if (descriptor == null) continue;
                this.bridge.addImportOption(name, (String)this.getPropertyValue(id));
                this.descriptors[i++] = descriptor;
            }
        }
        return this.descriptors;
    }

    public Object getPropertyValue(Object id) {
        BridgeOption option = (BridgeOption)id;
        if (option.getSavedValue() == null) {
            if (option.getDefaultValue() == null) {
                return new String();
            }
            return option.getDefaultValue();
        }
        return option.getSavedValue();
    }

    public boolean isPropertySet(Object id) {
        BridgeOption option = (BridgeOption)id;
        return option.getSavedValue() != null;
    }

    public void resetPropertyValue(Object id) {
        BridgeOption option = (BridgeOption)id;
        String defaultVal = option.getDefaultValue();
        option.setSavedValue(defaultVal);
    }

    public void setPropertyValue(Object id, Object value) {
        BridgeOption option = (BridgeOption)id;
        if (value == null) {
            option.setSavedValue(null);
        } else {
            option.setSavedValue(value.toString());
        }
    }
}

