/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbcspy;

import com.metamatrix.jdbcspy.SpyConnection;
import com.metamatrix.jdbcspy.SpyLogger;
import com.metamatrix.jdbcspy.SpyResultSet;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class SpyStatement
implements Statement {
    protected Statement realStatement;
    protected SpyLogger spyLogger;
    protected SpyConnection spyConnection;
    private int id;
    private static int Id = 0;

    SpyStatement(Statement statement, SpyLogger spyLogger, SpyConnection spyConnection) {
        this.realStatement = statement;
        this.spyLogger = spyLogger;
        this.spyConnection = spyConnection;
        this.id = ++Id;
    }

    protected SpyStatement() {
    }

    public final ResultSet executeQuery(String string) throws SQLException {
        ResultSet resultSet;
        this.spyLogger.println("\n" + this + ".executeQuery(String sql)");
        this.spyLogger.println("sql = " + string);
        this.spyLogger.enter();
        try {
            resultSet = this.realStatement.executeQuery(string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        SpyResultSet spyResultSet = new SpyResultSet(this, resultSet, this.spyLogger, this.spyConnection);
        this.spyLogger.println("OK (" + spyResultSet + ")");
        return spyResultSet;
    }

    public final int executeUpdate(String string) throws SQLException {
        int n;
        this.spyLogger.println("\n" + this + ".executeUpdate(String sql)");
        this.spyLogger.println("sql = " + string);
        this.spyLogger.enter();
        try {
            n = this.realStatement.executeUpdate(string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + n + ")");
        return n;
    }

    public final boolean execute(String string) throws SQLException {
        boolean bl;
        this.spyLogger.println("\n" + this + ".execute(String sql)");
        this.spyLogger.println("sql = " + string);
        this.spyLogger.enter();
        try {
            bl = this.realStatement.execute(string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + bl + ")");
        return bl;
    }

    public final void close() throws SQLException {
        this.spyLogger.println("\n" + this + ".close()");
        this.spyLogger.enter();
        try {
            this.realStatement.close();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final int getMaxFieldSize() throws SQLException {
        int n;
        this.spyLogger.println("\n" + this + ".getMaxFieldSize()");
        this.spyLogger.enter();
        try {
            n = this.realStatement.getMaxFieldSize();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + n + ")");
        return n;
    }

    public final void setMaxFieldSize(int n) throws SQLException {
        this.spyLogger.println("\n" + this + ".setMaxFieldSize(int max)");
        this.spyLogger.println("max = " + n);
        this.spyLogger.enter();
        try {
            this.realStatement.setMaxFieldSize(n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final int getMaxRows() throws SQLException {
        int n;
        this.spyLogger.println("\n" + this + ".getMaxRows()");
        this.spyLogger.enter();
        try {
            n = this.realStatement.getMaxRows();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + n + ")");
        return n;
    }

    public final void setMaxRows(int n) throws SQLException {
        this.spyLogger.println("\n" + this + ".setMaxRows(int max)");
        this.spyLogger.println("max = " + n);
        this.spyLogger.enter();
        try {
            this.realStatement.setMaxRows(n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void setEscapeProcessing(boolean bl) throws SQLException {
        this.spyLogger.println("\n" + this + ".setEscapeProcessing(boolean enable)");
        this.spyLogger.println("enable = " + bl);
        this.spyLogger.enter();
        try {
            this.realStatement.setEscapeProcessing(bl);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final int getQueryTimeout() throws SQLException {
        int n;
        this.spyLogger.println("\n" + this + ".getQueryTimeout()");
        this.spyLogger.enter();
        try {
            n = this.realStatement.getQueryTimeout();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + n + ")");
        return n;
    }

    public final void setQueryTimeout(int n) throws SQLException {
        this.spyLogger.println("\n" + this + ".setQueryTimeout(int seconds)");
        this.spyLogger.println("seconds = " + n);
        this.spyLogger.enter();
        try {
            this.realStatement.setQueryTimeout(n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void cancel() throws SQLException {
        this.spyLogger.println("\n" + this + ".cancel()");
        this.spyLogger.enter();
        try {
            this.realStatement.cancel();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final SQLWarning getWarnings() throws SQLException {
        SQLWarning sQLWarning;
        this.spyLogger.println("\n" + this + ".getWarnings()");
        this.spyLogger.enter();
        try {
            sQLWarning = this.realStatement.getWarnings();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.printSqlWarning(sQLWarning);
        this.spyLogger.println("OK");
        return sQLWarning;
    }

    public final void clearWarnings() throws SQLException {
        this.spyLogger.println("\n" + this + ".clearWarnings()");
        this.spyLogger.enter();
        try {
            this.realStatement.clearWarnings();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void setCursorName(String string) throws SQLException {
        this.spyLogger.println("\n" + this + ".setCursorName(String name)");
        this.spyLogger.println("name = " + string);
        this.spyLogger.enter();
        try {
            this.realStatement.setCursorName(string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final ResultSet getResultSet() throws SQLException {
        ResultSet resultSet;
        this.spyLogger.println("\n" + this + ".getResultSet()");
        this.spyLogger.enter();
        try {
            resultSet = this.realStatement.getResultSet();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        SpyResultSet spyResultSet = null;
        if (resultSet != null) {
            spyResultSet = new SpyResultSet(this, resultSet, this.spyLogger, this.spyConnection);
        }
        this.spyLogger.println("OK (" + spyResultSet + ")");
        return spyResultSet;
    }

    public final int getUpdateCount() throws SQLException {
        int n;
        this.spyLogger.println("\n" + this + ".getUpdateCount()");
        this.spyLogger.enter();
        try {
            n = this.realStatement.getUpdateCount();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + n + ")");
        return n;
    }

    public final boolean getMoreResults() throws SQLException {
        boolean bl;
        this.spyLogger.println("\n" + this + ".getMoreResults()");
        this.spyLogger.enter();
        try {
            bl = this.realStatement.getMoreResults();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + bl + ")");
        return bl;
    }

    public final void setFetchDirection(int n) throws SQLException {
        this.spyLogger.println("\n" + this + ".setFetchDirection(int direction)");
        this.spyLogger.println("direction = " + n);
        this.spyLogger.enter();
        try {
            this.realStatement.setFetchDirection(n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final int getFetchDirection() throws SQLException {
        int n;
        this.spyLogger.println("\n" + this + ".getFetchDirection()");
        this.spyLogger.enter();
        try {
            n = this.realStatement.getFetchDirection();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + n + ")");
        return n;
    }

    public final void setFetchSize(int n) throws SQLException {
        this.spyLogger.println("\n" + this + ".setFetchSize(int rows)");
        this.spyLogger.println("rows = " + n);
        this.spyLogger.enter();
        try {
            this.realStatement.setFetchSize(n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final int getFetchSize() throws SQLException {
        int n;
        this.spyLogger.println("\n" + this + ".getFetchSize()");
        this.spyLogger.enter();
        try {
            n = this.realStatement.getFetchSize();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + n + ")");
        return n;
    }

    public final int getResultSetConcurrency() throws SQLException {
        int n;
        this.spyLogger.println("\n" + this + ".getResultSetConcurrency()");
        this.spyLogger.enter();
        try {
            n = this.realStatement.getResultSetConcurrency();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + n + ")");
        return n;
    }

    public final int getResultSetType() throws SQLException {
        int n;
        this.spyLogger.println("\n" + this + ".getResultSetType()");
        this.spyLogger.enter();
        try {
            n = this.realStatement.getResultSetType();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + n + ")");
        return n;
    }

    public final void addBatch(String string) throws SQLException {
        this.spyLogger.println("\n" + this + ".addBatch(String sql)");
        this.spyLogger.println("sql = " + string);
        this.spyLogger.enter();
        try {
            this.realStatement.addBatch(string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final void clearBatch() throws SQLException {
        this.spyLogger.println("\n" + this + ".clearBatch()");
        this.spyLogger.enter();
        try {
            this.realStatement.clearBatch();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final int[] executeBatch() throws SQLException {
        int[] nArray;
        this.spyLogger.println("\n" + this + ".executeBatch()");
        this.spyLogger.enter();
        try {
            nArray = this.realStatement.executeBatch();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + this.spyLogger.intArrayToString(nArray) + ")");
        return nArray;
    }

    public final Connection getConnection() throws SQLException {
        this.spyLogger.println("\n" + this + ".getConnection()");
        this.spyLogger.println("OK (" + this.spyConnection + ")");
        return this.spyConnection;
    }

    public final boolean getMoreResults(int n) throws SQLException {
        boolean bl;
        this.spyLogger.println("\n" + this + ".getMoreResults(int current)");
        this.spyLogger.println("current = " + n);
        this.spyLogger.enter();
        try {
            bl = this.realStatement.getMoreResults(n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + bl + ")");
        return bl;
    }

    public final ResultSet getGeneratedKeys() throws SQLException {
        ResultSet resultSet;
        this.spyLogger.println("\n" + this + ".getGeneratedKeys()");
        this.spyLogger.enter();
        try {
            resultSet = this.realStatement.getGeneratedKeys();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        SpyResultSet spyResultSet = null;
        if (resultSet != null) {
            spyResultSet = new SpyResultSet(this, resultSet, this.spyLogger, this.spyConnection);
        }
        this.spyLogger.println("OK (" + spyResultSet + ")");
        return spyResultSet;
    }

    public final int executeUpdate(String string, int n) throws SQLException {
        int n2;
        this.spyLogger.println("\n" + this + ".executeUpdate(String sql, int autoGeneratedKeys)");
        this.spyLogger.println("sql = " + string);
        this.spyLogger.println("autoGeneratedKeys = " + n);
        this.spyLogger.enter();
        try {
            n2 = this.realStatement.executeUpdate(string, n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + n2 + ")");
        return n2;
    }

    public final int executeUpdate(String string, int[] nArray) throws SQLException {
        int n;
        this.spyLogger.println("\n" + this + ".executeUpdate(String sql, int[] columnIndexes)");
        this.spyLogger.println("sql = " + string);
        this.spyLogger.println("columnIndexes = " + this.spyLogger.intArrayToString(nArray));
        this.spyLogger.enter();
        try {
            n = this.realStatement.executeUpdate(string, nArray);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + n + ")");
        return n;
    }

    public final int executeUpdate(String string, String[] stringArray) throws SQLException {
        int n;
        this.spyLogger.println("\n" + this + ".executeUpdate(String sql, String[] columnNames)");
        this.spyLogger.println("sql = " + string);
        this.spyLogger.println("columnNames = " + this.spyLogger.stringArrayToString(stringArray));
        this.spyLogger.enter();
        try {
            n = this.realStatement.executeUpdate(string, stringArray);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + n + ")");
        return n;
    }

    public final boolean execute(String string, int n) throws SQLException {
        boolean bl;
        this.spyLogger.println("\n" + this + ".execute(String sql, int autoGeneratedKeys)");
        this.spyLogger.println("sql = " + string);
        this.spyLogger.println("autoGeneratedKeys = " + n);
        this.spyLogger.enter();
        try {
            bl = this.realStatement.execute(string, n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + bl + ")");
        return bl;
    }

    public final boolean execute(String string, int[] nArray) throws SQLException {
        boolean bl;
        this.spyLogger.println("\n" + this + ".execute(String sql, int[] columnIndexes)");
        this.spyLogger.println("sql = " + string);
        this.spyLogger.println("columnIndexes = " + this.spyLogger.intArrayToString(nArray));
        this.spyLogger.enter();
        try {
            bl = this.realStatement.execute(string, nArray);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + bl + ")");
        return bl;
    }

    public final boolean execute(String string, String[] stringArray) throws SQLException {
        boolean bl;
        this.spyLogger.println("\n" + this + ".execute(String sql, String[] columnNames)");
        this.spyLogger.println("sql = " + string);
        this.spyLogger.println("columnNames = " + this.spyLogger.stringArrayToString(stringArray));
        this.spyLogger.enter();
        try {
            bl = this.realStatement.execute(string, stringArray);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + bl + ")");
        return bl;
    }

    public final int getResultSetHoldability() throws SQLException {
        int n;
        this.spyLogger.println("\n" + this + ".getResultSetHoldability()");
        this.spyLogger.enter();
        try {
            n = this.realStatement.getResultSetHoldability();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + n + ")");
        return n;
    }

    public String toString() {
        return "Statement[" + this.id + "]";
    }
}

