/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.util;

import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilSSLSocketCreator;
import com.metamatrix.util.UtilSnoopIndirection;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;

public class UtilSocketCreator {
    private static String footprint = "$Revision:   3.13.1.0  $";

    public static final Socket getSocket(String string, int n, Properties properties) throws UtilException {
        Socket socket = null;
        try {
            final String string2 = string;
            final int n2 = n;
            socket = (Socket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws UtilException {
                    return UtilSocketCreator.createSocket(string2, n2);
                }
            });
            String string3 = (String)properties.get("DDTDBG.PROTOCOLTRACEENABLE");
            if (string3 != null && string3.equalsIgnoreCase("true")) {
                socket = UtilSnoopIndirection.createSocket(socket, properties);
            }
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (UtilException)privilegedActionException.getException();
        }
        try {
            socket.setTcpNoDelay(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return socket;
    }

    public static final Socket getSSLSocket(String string, int n, Properties properties) throws UtilException {
        try {
            return UtilSSLSocketCreator.getSocket(string, n, null, false, null, properties);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw new UtilException(1043);
        }
    }

    public static final Socket getSSLSocket(String string, int n, Socket socket, boolean bl, String[] stringArray, Properties properties) throws UtilException {
        try {
            return UtilSSLSocketCreator.getSocket(string, n, socket, bl, stringArray, properties);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw new UtilException(1043);
        }
    }

    public static final Socket createSocket(String string, int n) throws UtilException {
        Socket socket = null;
        try {
            socket = new Socket(string, n);
        }
        catch (UnknownHostException unknownHostException) {
            String[] stringArray = new String[]{string};
            throw new UtilException(1021, stringArray);
        }
        catch (Exception exception) {
            String[] stringArray = new String[]{string, String.valueOf(n), exception.getMessage()};
            throw new UtilException(1020, stringArray);
        }
        return socket;
    }
}

