/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sybase;

import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbc.base.BaseConnectionProperties;
import com.metamatrix.jdbc.base.BaseDriverPropertyInfos;
import com.metamatrix.jdbc.base.BaseEscapeTranslator;
import com.metamatrix.jdbc.base.BaseImplConnection;
import com.metamatrix.jdbc.base.BaseImplDatabaseMetaData;
import com.metamatrix.jdbc.sybase.SybaseEscapeTranslator;
import com.metamatrix.jdbc.sybase.SybaseImplConnection;
import com.metamatrix.jdbc.sybase.SybaseImplDatabaseMetaData;
import java.sql.SQLException;

public class SybaseConnection
extends BaseConnection {
    private static String footprint = "$Revision:   3.28.1.2  $";
    public SybaseImplConnection implConnection = null;
    SybaseImplDatabaseMetaData databaseMetaData = null;
    private float serverVersion = 0.0f;
    private int pageSize = 255;
    public String serverDefaultCharSet = null;
    public boolean supportsUniCharTypes;
    public boolean supportsDateAndTimeTypes;

    public float getServerVersion() {
        return this.serverVersion;
    }

    public void setServerVersion(int n, int n2) {
        this.serverVersion = Float.valueOf(n + "." + n2).floatValue();
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int n) {
        this.pageSize = n;
    }

    protected void getImplPropertyInfo(BaseDriverPropertyInfos baseDriverPropertyInfos) {
        baseDriverPropertyInfos.put("user", "Login ID", "", null, false);
        baseDriverPropertyInfos.put("password", "Login Password", "", null, false);
        baseDriverPropertyInfos.put("databaseName", "Database Name", "", null, false);
        String[] stringArray = new String[]{"cursor", "direct"};
        baseDriverPropertyInfos.put("selectMethod", "Select Method", "direct", stringArray, false);
        String[] stringArray2 = new String[]{"storedProcIfParam", "storedProc", "direct"};
        baseDriverPropertyInfos.put("prepareMethod", "Prepare Method", "storedProcIfParam", stringArray2, false);
        baseDriverPropertyInfos.put("codePageOverride", "Code page override", "", null, false);
        baseDriverPropertyInfos.put("useAlternateProductInfo", "useAlternateProductInfo", "false", null, false);
        String[] stringArray3 = new String[]{"Exception", "Warning", "Raiseerrorwarning"};
        baseDriverPropertyInfos.put("errorBehavior", "errorBehavior", "Exception", stringArray3, false);
        String[] stringArray4 = new String[]{"kerberos", "UserIdPassword"};
        baseDriverPropertyInfos.put("authenticationMethod", "Authentication method used to connect", "UserIdPassword", stringArray4, false);
        baseDriverPropertyInfos.put("servicePrincipalName", "The service principal name used with Kerberos authentication", "", null, false);
        String[] stringArray5 = new String[]{"NoEncryption", "SSL"};
        baseDriverPropertyInfos.put("encryptionMethod", "Specifies the driver encryption method. The encryption method determines whether the driver encrypts and decrypts the data sent between the driver and the database server.", "NoEncryption", stringArray5, false);
        baseDriverPropertyInfos.put("trustStore", "An override of javax.net.ssl.trustStore", "", null, false);
        baseDriverPropertyInfos.put("trustStorePassword", "An override of javax.net.ssl.trustStorePassword", "", null, false);
        baseDriverPropertyInfos.put("validateServerCertificate", "Specifies whether the driver will validate the server certificate returned by the database server.", "true", null, false);
        baseDriverPropertyInfos.put("hostNameInCertificate", "Specifies the name the driver will use to compare with the Common Name in the certificate returned by the database server during the SSL session establishment.", "", null, false);
        String[] stringArray6 = new String[]{"implicit", "explicit"};
        baseDriverPropertyInfos.put("transactionMode", "Transaction mode when autocommit is off", "explicit", stringArray6, false);
        baseDriverPropertyInfos.put("packetSize", "Determines number of bytes used per network packet.", "0", null, false);
        baseDriverPropertyInfos.put("longDataCacheSize", "Specifies the maximum amount of memory, in kilobytes, the driver will use to buffer long data", "2048", null, false);
    }

    protected BaseImplConnection createImplConnection(BaseConnectionProperties baseConnectionProperties) {
        this.implConnection = new SybaseImplConnection(this);
        return this.implConnection;
    }

    public void instantiateImplDatabaseMetaData(SybaseImplConnection sybaseImplConnection) throws SQLException {
        this.databaseMetaData = new SybaseImplDatabaseMetaData(sybaseImplConnection);
    }

    public BaseImplDatabaseMetaData createImplDatabaseMetaData(BaseConnectionProperties baseConnectionProperties) throws SQLException {
        return this.databaseMetaData;
    }

    public BaseEscapeTranslator createEscapeTranslator() throws SQLException {
        return new SybaseEscapeTranslator(this.serverVersion);
    }
}

