/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.core.validation.rules;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.metamodel.aspect.AspectManager;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlProcedureAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlTableAspect;
import com.metamatrix.modeler.core.validation.ResourceValidationRule;
import com.metamatrix.modeler.core.validation.ValidationContext;
import com.metamatrix.modeler.core.validation.ValidationProblem;
import com.metamatrix.modeler.core.validation.ValidationResult;
import com.metamatrix.modeler.internal.core.validation.ValidationProblemImpl;
import com.metamatrix.modeler.internal.core.validation.ValidationResultImpl;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class TargetTransformationRule
implements ResourceValidationRule {
    public void validate(Resource resource, ValidationContext context) {
        ArgCheck.isNotNull((Object)resource);
        ArgCheck.isNotNull((Object)context);
        URI uri = resource.getURI();
        if (uri != null && !uri.lastSegment().endsWith("xmi")) {
            return;
        }
        Map targetTransformMap = context.getTargetTransformMap();
        if (targetTransformMap == null || targetTransformMap.isEmpty()) {
            return;
        }
        Iterator targetIter = targetTransformMap.keySet().iterator();
        while (targetIter.hasNext()) {
            EObject target = (EObject)targetIter.next();
            Resource targetResource = target.eResource();
            if (targetResource != resource || targetTransformMap.get(target) != null) continue;
            SqlAspect targetAspect = AspectManager.getSqlAspect((EObject)target);
            Assertion.isNotNull((Object)targetAspect);
            if (targetAspect instanceof SqlTableAspect) {
                boolean isXmlDoc;
                SqlTableAspect tableAspect = (SqlTableAspect)targetAspect;
                boolean bl = isXmlDoc = tableAspect.getTableType(target) == 2;
                if (!tableAspect.isVirtual(target) || isXmlDoc) continue;
                int status = this.getPreferenceStatus(context);
                if (status == 0) {
                    return;
                }
                ValidationResultImpl result = new ValidationResultImpl((Object)target);
                String msg = ModelerCore.Util.getString("TargetTransformationRule.The_virtual_table_{0}_does_not_have_any_associated_transformation._1", (Object)tableAspect.getName(target));
                ValidationProblemImpl problem = new ValidationProblemImpl(0, status, msg);
                result.addProblem((ValidationProblem)problem);
                context.addResult((ValidationResult)result);
                continue;
            }
            SqlProcedureAspect procAspect = (SqlProcedureAspect)targetAspect;
            if (!procAspect.isVirtual(target)) continue;
            int status = this.getPreferenceStatus(context);
            if (status == 0) {
                return;
            }
            ValidationResultImpl result = new ValidationResultImpl((Object)target);
            String msg = ModelerCore.Util.getString("TargetTransformationRule.The_virtual_procedure_{0}_does_not_have_any_associated_transformation._1", (Object)procAspect.getName(target));
            ValidationProblemImpl problem = new ValidationProblemImpl(0, status, msg);
            result.addProblem((ValidationProblem)problem);
            context.addResult((ValidationResult)result);
        }
    }

    protected int getPreferenceStatus(ValidationContext context) {
        return context.getPreferenceStatus("relationalPreferences.emptyTransformations", 4);
    }
}

