/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.sequelink.ssp;

import com.metamatrix.sequelink.ssp.AsciiAttribute;
import com.metamatrix.sequelink.ssp.BinaryAttribute;
import com.metamatrix.sequelink.ssp.IntAttribute;
import com.metamatrix.sequelink.ssp.Message;
import com.metamatrix.sequelink.ssp.SspInputStream;
import com.metamatrix.sequelink.ssp.SspOutputStream;
import java.io.IOException;
import java.sql.SQLException;

abstract class Attribute {
    int id;
    int length;

    Attribute() {
    }

    abstract void encode(SspOutputStream var1) throws IOException;

    abstract void decode(SspInputStream var1) throws IOException;

    static final Attribute ReadAttribute(SspInputStream sspInputStream) throws IOException, SQLException {
        Attribute attribute;
        int n = sspInputStream.readSSPFullInt32();
        int n2 = sspInputStream.readSSPFullInt32();
        if (n2 == 0) {
            throw Message.Gen.getSqlException(7428);
        }
        switch (n) {
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                if (n2 != 4) {
                    throw Message.Gen.getSqlException(7428);
                }
                attribute = new IntAttribute(n, 0);
                attribute.decode(sspInputStream);
                break;
            }
            case 10: {
                if (n2 < 4) {
                    throw Message.Gen.getSqlException(7428);
                }
                attribute = new AsciiAttribute(n, "");
                attribute.decode(sspInputStream);
                if (n2 == attribute.length) break;
                throw Message.Gen.getSqlException(7428);
            }
            case 12: {
                if (n2 < 4) {
                    throw Message.Gen.getSqlException(7428);
                }
                attribute = new BinaryAttribute(n, new byte[0]);
                attribute.decode(sspInputStream);
                if (n2 == attribute.length) break;
                throw Message.Gen.getSqlException(7428);
            }
            default: {
                if (n2 < 0) {
                    throw Message.Gen.getSqlException(7428);
                }
                sspInputStream.skipBytes(n2);
                attribute = null;
            }
        }
        return attribute;
    }
}

