/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.sequelink.security;

import COM.rsa.jsafe.JSAFE_AsymmetricCipher;
import COM.rsa.jsafe.JSAFE_InputException;
import COM.rsa.jsafe.JSAFE_InvalidKeyException;
import COM.rsa.jsafe.JSAFE_InvalidUseException;
import COM.rsa.jsafe.JSAFE_PaddingException;
import COM.rsa.jsafe.JSAFE_PrivateKey;
import COM.rsa.jsafe.JSAFE_PublicKey;
import com.metamatrix.sequelink.security.JSafeRSAPrivateKey;
import com.metamatrix.sequelink.security.JSafeRSAPublicKey;
import com.metamatrix.sequelink.security.Message;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

public final class JSafeRSACipher
extends CipherSpi {
    private static final String JSAFE_RSA_ENC_TRANS = "RSA/NoPad";
    private static final String JSAFE_DEVICE = "Java";
    private static final String SUPPORTED_PADDING = "PKCS1Padding";
    private static final String SUPPORTED_MODE = "ECB";
    private static final String JSAFE_RSA_KEY_ALG = "RSA";
    private static final String JSAFE_RSA_PRIVATEKEY_FORMAT = "RSAPrivateKey";
    private static final String JSAFE_RSA_PUBLICKEY_FORMAT = "RSAPublicKey";
    private static final int MODE_ENCRYPTION = 1;
    private static final int MODE_DECRYPTION = 2;
    private static final int MODE_SIGNING = 3;
    private static final int MODE_VERIFICATION = 4;
    private JSAFE_AsymmetricCipher realCipher;
    private int mode;
    private byte[] buffer;
    private int modulusSize;
    private SecureRandom random;

    public JSafeRSACipher() {
        try {
            this.realCipher = JSAFE_AsymmetricCipher.getInstance((String)JSAFE_RSA_ENC_TRANS, (String)JSAFE_DEVICE);
        }
        catch (Exception exception) {
            throw new RuntimeException(Message.Gen.getException(7646, exception.toString()));
        }
    }

    protected byte[] engineDoFinal(byte[] byArray, int n2, int n3) throws IllegalBlockSizeException, BadPaddingException {
        this.addInput(byArray, n2, n3);
        byte[] byArray2 = null;
        switch (this.mode) {
            case 1: {
                byArray2 = this.encrypt((byte)2, true);
                break;
            }
            case 2: {
                byArray2 = this.decrypt((byte)2, true);
                break;
            }
            case 3: {
                byArray2 = this.encrypt((byte)1, false);
                break;
            }
            case 4: {
                byArray2 = this.decrypt((byte)1, false);
            }
        }
        return byArray2;
    }

    protected int engineDoFinal(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        byte[] byArray3 = this.engineDoFinal(byArray, n2, n3);
        System.arraycopy(byArray3, 0, byArray2, n4, byArray3.length);
        return byArray3.length;
    }

    protected int engineGetBlockSize() {
        return this.realCipher.getInputBlockSize();
    }

    protected byte[] engineGetIV() {
        return null;
    }

    protected int engineGetOutputSize(int n2) {
        return this.realCipher.getOutputBufferSize(n2);
    }

    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    protected void engineInit(int n2, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.engineInit(n2, key, secureRandom);
    }

    protected void engineInit(int n2, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.engineInit(n2, key, secureRandom);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void engineInit(int n2, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        this.buffer = null;
        switch (n2) {
            case 1: {
                try {
                    if (key instanceof JSafeRSAPublicKey) {
                        JSAFE_PublicKey jSAFE_PublicKey = ((JSafeRSAPublicKey)key).getJSafePublicKey();
                        this.realCipher.encryptInit(jSAFE_PublicKey, null);
                        this.mode = 1;
                        this.modulusSize = JSafeRSACipher.getModulusSize(((JSafeRSAPublicKey)key).getModulus());
                        return;
                    }
                    if (!(key instanceof JSafeRSAPrivateKey)) throw new InvalidKeyException(Message.Gen.getException(7659));
                    JSAFE_PrivateKey jSAFE_PrivateKey = ((JSafeRSAPrivateKey)key).getJSafePrivateKey();
                    this.realCipher.decryptInit(jSAFE_PrivateKey);
                    this.mode = 3;
                    this.modulusSize = JSafeRSACipher.getModulusSize(((JSafeRSAPrivateKey)key).getModulus());
                    return;
                }
                catch (JSAFE_InvalidUseException jSAFE_InvalidUseException) {
                    throw new RuntimeException(Message.Gen.getException(7646, jSAFE_InvalidUseException.toString()));
                }
                catch (JSAFE_InvalidKeyException jSAFE_InvalidKeyException) {
                    throw new InvalidKeyException(Message.Gen.getException(7653, jSAFE_InvalidKeyException.toString()));
                }
            }
            case 2: {
                try {
                    if (key instanceof JSafeRSAPrivateKey) {
                        JSAFE_PrivateKey jSAFE_PrivateKey = ((JSafeRSAPrivateKey)key).getJSafePrivateKey();
                        this.realCipher.decryptInit(jSAFE_PrivateKey);
                        this.mode = 2;
                        this.modulusSize = JSafeRSACipher.getModulusSize(((JSafeRSAPrivateKey)key).getModulus());
                        return;
                    }
                    if (!(key instanceof JSafeRSAPublicKey)) throw new InvalidKeyException(Message.Gen.getException(7659));
                    JSAFE_PublicKey jSAFE_PublicKey = ((JSafeRSAPublicKey)key).getJSafePublicKey();
                    this.realCipher.encryptInit(jSAFE_PublicKey, null);
                    this.mode = 4;
                    this.modulusSize = JSafeRSACipher.getModulusSize(((JSafeRSAPublicKey)key).getModulus());
                    return;
                }
                catch (JSAFE_InvalidUseException jSAFE_InvalidUseException) {
                    throw new RuntimeException(Message.Gen.getException(7646, jSAFE_InvalidUseException.toString()));
                }
                catch (JSAFE_InvalidKeyException jSAFE_InvalidKeyException) {
                    throw new InvalidKeyException(Message.Gen.getException(7652, jSAFE_InvalidKeyException.toString()));
                }
            }
            default: {
                throw new IllegalArgumentException(Message.Gen.getException(7654));
            }
        }
    }

    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        if (!SUPPORTED_MODE.equals(string)) {
            throw new NoSuchAlgorithmException(Message.Gen.getException(7655, string));
        }
    }

    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        if (!SUPPORTED_PADDING.equals(string)) {
            throw new NoSuchPaddingException(Message.Gen.getException(7656, string));
        }
    }

    protected byte[] engineUpdate(byte[] byArray, int n2, int n3) {
        this.addInput(byArray, n2, n3);
        return new byte[0];
    }

    protected int engineUpdate(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws ShortBufferException {
        this.addInput(byArray, n2, n3);
        return 0;
    }

    private byte[] decrypt(byte by, boolean bl) throws BadPaddingException {
        try {
            byte[] byArray = new byte[this.realCipher.getInputBlockSize()];
            System.arraycopy(this.buffer, 0, byArray, byArray.length - this.buffer.length, this.buffer.length);
            byte[] byArray2 = null;
            byte[] byArray3 = null;
            if (bl) {
                byArray2 = this.realCipher.decryptUpdate(byArray, 0, byArray.length);
                byArray3 = this.realCipher.decryptFinal();
                this.realCipher.decryptReInit();
            } else {
                byArray2 = this.realCipher.encryptUpdate(byArray, 0, byArray.length);
                byArray3 = this.realCipher.encryptFinal();
                this.realCipher.encryptReInit();
            }
            this.buffer = new byte[byArray2.length + byArray3.length];
            System.arraycopy(byArray2, 0, this.buffer, 0, byArray2.length);
            System.arraycopy(byArray3, 0, this.buffer, byArray2.length, byArray3.length);
            return JSafeRSACipher.removePKCS1Padding(by, this.buffer);
        }
        catch (JSAFE_InvalidUseException jSAFE_InvalidUseException) {
            throw new RuntimeException(Message.Gen.getException(7649, jSAFE_InvalidUseException.toString()));
        }
        catch (JSAFE_InputException jSAFE_InputException) {
            throw new RuntimeException(Message.Gen.getException(7649, jSAFE_InputException.toString()));
        }
        catch (JSAFE_PaddingException jSAFE_PaddingException) {
            throw new BadPaddingException(Message.Gen.getException(7649, jSAFE_PaddingException.toString()));
        }
    }

    private byte[] encrypt(byte by, boolean bl) throws BadPaddingException {
        try {
            this.buffer = JSafeRSACipher.addPKCS1Padding(by, this.buffer, this.modulusSize, this.random);
            byte[] byArray = new byte[this.realCipher.getInputBlockSize()];
            System.arraycopy(this.buffer, 0, byArray, byArray.length - this.buffer.length, this.buffer.length);
            byte[] byArray2 = null;
            byte[] byArray3 = null;
            if (bl) {
                byArray2 = this.realCipher.encryptUpdate(byArray, 0, byArray.length);
                byArray3 = this.realCipher.encryptFinal();
                this.realCipher.encryptReInit();
            } else {
                byArray2 = this.realCipher.decryptUpdate(byArray, 0, byArray.length);
                byArray3 = this.realCipher.decryptFinal();
                this.realCipher.decryptReInit();
            }
            byte[] byArray4 = new byte[byArray2.length + byArray3.length];
            System.arraycopy(byArray2, 0, byArray4, 0, byArray2.length);
            System.arraycopy(byArray3, 0, byArray4, byArray2.length, byArray3.length);
            return JSafeRSACipher.removeTrailingZeros(byArray4);
        }
        catch (JSAFE_InvalidUseException jSAFE_InvalidUseException) {
            throw new RuntimeException(Message.Gen.getException(7649, jSAFE_InvalidUseException.toString()));
        }
        catch (JSAFE_InputException jSAFE_InputException) {
            throw new RuntimeException(Message.Gen.getException(7649, jSAFE_InputException.toString()));
        }
        catch (JSAFE_PaddingException jSAFE_PaddingException) {
            throw new BadPaddingException(Message.Gen.getException(7649, jSAFE_PaddingException.toString()));
        }
    }

    private void addInput(byte[] byArray, int n2, int n3) {
        if (this.buffer == null) {
            this.buffer = new byte[n3];
            System.arraycopy(byArray, n2, this.buffer, 0, n3);
        } else {
            byte[] byArray2 = new byte[this.buffer.length + n3];
            System.arraycopy(this.buffer, 0, byArray2, 0, this.buffer.length);
            System.arraycopy(byArray, n2, byArray2, this.buffer.length, n3);
            this.buffer = byArray2;
        }
    }

    private static int getModulusSize(BigInteger bigInteger) {
        return (bigInteger.bitLength() + 1) / 8;
    }

    private static byte[] addPKCS1Padding(byte by, byte[] byArray, int n2, SecureRandom secureRandom) {
        byte[] byArray2 = new byte[n2];
        byArray2[0] = 0;
        byArray2[1] = by;
        if (by == 1 || by == 2) {
            for (int i2 = 0; i2 < n2 - 3 - byArray.length; ++i2) {
                byArray2[2 + i2] = -1;
            }
        } else {
            byte[] byArray3 = new byte[n2 - 3 - byArray.length];
            secureRandom.nextBytes(byArray3);
            int n3 = 0;
            while (n3 < byArray3.length) {
                int n4 = n3++;
                byArray3[n4] = (byte)(byArray3[n4] | 1);
            }
            System.arraycopy(byArray3, 0, byArray2, 2, byArray3.length);
        }
        System.arraycopy(byArray, 0, byArray2, n2 - byArray.length, byArray.length);
        return byArray2;
    }

    private static byte[] removePKCS1Padding(byte by, byte[] byArray) throws BadPaddingException {
        int n2;
        for (n2 = 0; n2 < byArray.length && byArray[n2] == 0; ++n2) {
        }
        if (n2 >= byArray.length) {
            Object[] objectArray = new Object[]{new Byte(by)};
            throw new BadPaddingException(Message.Gen.getException(7664, objectArray));
        }
        if (byArray[n2++] != by) {
            Object[] objectArray = new Object[]{new Byte(by)};
            throw new BadPaddingException(Message.Gen.getException(7664, objectArray));
        }
        while (n2 < byArray.length && byArray[n2] != 0) {
            ++n2;
        }
        if (n2 >= byArray.length) {
            Object[] objectArray = new Object[]{new Byte(by)};
            throw new BadPaddingException(Message.Gen.getException(7664, objectArray));
        }
        byte[] byArray2 = new byte[byArray.length - n2 - 1];
        System.arraycopy(byArray, n2 + 1, byArray2, 0, byArray2.length);
        return byArray2;
    }

    private static byte[] removeTrailingZeros(byte[] byArray) {
        int n2;
        for (n2 = 0; n2 < byArray.length && byArray[n2] == 0; ++n2) {
        }
        byte[] byArray2 = new byte[byArray.length - n2];
        System.arraycopy(byArray, n2, byArray2, 0, byArray.length - n2);
        return byArray2;
    }
}

