/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.cipher;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.ConstructedType;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.SEQUENCE;
import iaik.security.cipher.IvParameters;
import iaik.utils.Util;
import java.io.IOException;
import java.math.BigInteger;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;

public class RC2Parameters
extends IvParameters {
    int b;
    static final int[] a;
    static final int[] c;

    static int b(int n2) {
        if (n2 <= 0) {
            return 128;
        }
        if (n2 >= 256) {
            return n2;
        }
        return a[n2];
    }

    protected String engineToString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.b > 0) {
            stringBuffer.append("rc2ParameterVersion: " + this.b + "\n");
        }
        stringBuffer.append("IV: " + Util.toString(((IvParameters)this).a) + "\n");
        return stringBuffer.toString();
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    protected void engineInit(byte[] byArray) throws IOException {
        try {
            ASN1Object aSN1Object = DerCoder.decode(byArray);
            if (aSN1Object.isA(ASN.SEQUENCE)) {
                this.b = ((BigInteger)aSN1Object.getComponentAt(0).getValue()).intValue();
                ((IvParameters)this).a = (byte[])aSN1Object.getComponentAt(1).getValue();
            } else if (aSN1Object.isA(ASN.OCTET_STRING)) {
                this.b = -1;
                ((IvParameters)this).a = (byte[])aSN1Object.getValue();
            } else {
                throw new IOException("Cannot decode RC2 params. Invalid ASN.1 type!");
            }
            if (((IvParameters)this).a == null || ((IvParameters)this).a.length != 8) {
                throw new IOException("Cannot init RC2 params. Invalid IV; must be 8 octets long.");
            }
        }
        catch (CodingException codingException) {
            throw new IOException("DER decoding error. " + codingException.toString());
        }
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (algorithmParameterSpec instanceof RC2ParameterSpec) {
            RC2ParameterSpec rC2ParameterSpec = (RC2ParameterSpec)algorithmParameterSpec;
            this.b = RC2Parameters.a(rC2ParameterSpec.getEffectiveKeyBits());
            ((IvParameters)this).a = rC2ParameterSpec.getIV();
        } else if (algorithmParameterSpec instanceof IvParameterSpec) {
            IvParameterSpec ivParameterSpec = (IvParameterSpec)algorithmParameterSpec;
            ((IvParameters)this).a = ivParameterSpec.getIV();
            this.b = -1;
        } else {
            throw new InvalidParameterSpecException("Parameter must be IvParameterSpec or RC2ParameterSpec.");
        }
        if (((IvParameters)this).a == null) {
            ((IvParameters)this).a = new byte[8];
        }
        if (((IvParameters)this).a.length != 8) {
            throw new InvalidParameterSpecException("IV must be 8 octets long!");
        }
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        int n2 = RC2Parameters.b(this.b);
        RC2ParameterSpec rC2ParameterSpec = new RC2ParameterSpec(n2, ((IvParameters)this).a);
        if (!rC2ParameterSpec.getClass().isAssignableFrom(clazz)) {
            return super.engineGetParameterSpec(clazz);
        }
        return rC2ParameterSpec;
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    protected byte[] engineGetEncoded() throws IOException {
        try {
            ConstructedType constructedType;
            if (this.b > 0) {
                constructedType = new SEQUENCE();
                ((ASN1Object)constructedType).addComponent(new INTEGER(this.b));
                ((ASN1Object)constructedType).addComponent(new OCTET_STRING(((IvParameters)this).a));
            } else {
                constructedType = new OCTET_STRING(((IvParameters)this).a);
            }
            return DerCoder.encode(constructedType);
        }
        catch (CodingException codingException) {
            throw new IOException("Cannot encode RC2 parameters: " + codingException.getMessage());
        }
    }

    static int a(int n2) {
        if (n2 >= 256) {
            return n2;
        }
        return c[n2];
    }

    static {
        int[] nArray = new int[256];
        nArray[0] = 189;
        nArray[1] = 86;
        nArray[2] = 234;
        nArray[3] = 242;
        nArray[4] = 162;
        nArray[5] = 241;
        nArray[6] = 172;
        nArray[7] = 42;
        nArray[8] = 176;
        nArray[9] = 147;
        nArray[10] = 209;
        nArray[11] = 156;
        nArray[12] = 27;
        nArray[13] = 51;
        nArray[14] = 253;
        nArray[15] = 208;
        nArray[16] = 48;
        nArray[17] = 4;
        nArray[18] = 182;
        nArray[19] = 220;
        nArray[20] = 125;
        nArray[21] = 223;
        nArray[22] = 50;
        nArray[23] = 75;
        nArray[24] = 247;
        nArray[25] = 203;
        nArray[26] = 69;
        nArray[27] = 155;
        nArray[28] = 49;
        nArray[29] = 187;
        nArray[30] = 33;
        nArray[31] = 90;
        nArray[32] = 65;
        nArray[33] = 159;
        nArray[34] = 225;
        nArray[35] = 217;
        nArray[36] = 74;
        nArray[37] = 77;
        nArray[38] = 158;
        nArray[39] = 218;
        nArray[40] = 160;
        nArray[41] = 104;
        nArray[42] = 44;
        nArray[43] = 195;
        nArray[44] = 39;
        nArray[45] = 95;
        nArray[46] = 128;
        nArray[47] = 54;
        nArray[48] = 62;
        nArray[49] = 238;
        nArray[50] = 251;
        nArray[51] = 149;
        nArray[52] = 26;
        nArray[53] = 254;
        nArray[54] = 206;
        nArray[55] = 168;
        nArray[56] = 52;
        nArray[57] = 169;
        nArray[58] = 19;
        nArray[59] = 240;
        nArray[60] = 166;
        nArray[61] = 63;
        nArray[62] = 216;
        nArray[63] = 12;
        nArray[64] = 120;
        nArray[65] = 36;
        nArray[66] = 175;
        nArray[67] = 35;
        nArray[68] = 82;
        nArray[69] = 193;
        nArray[70] = 103;
        nArray[71] = 23;
        nArray[72] = 245;
        nArray[73] = 102;
        nArray[74] = 144;
        nArray[75] = 231;
        nArray[76] = 232;
        nArray[77] = 7;
        nArray[78] = 184;
        nArray[79] = 96;
        nArray[80] = 72;
        nArray[81] = 230;
        nArray[82] = 30;
        nArray[83] = 83;
        nArray[84] = 243;
        nArray[85] = 146;
        nArray[86] = 164;
        nArray[87] = 114;
        nArray[88] = 140;
        nArray[89] = 8;
        nArray[90] = 21;
        nArray[91] = 110;
        nArray[92] = 134;
        nArray[94] = 132;
        nArray[95] = 250;
        nArray[96] = 244;
        nArray[97] = 127;
        nArray[98] = 138;
        nArray[99] = 66;
        nArray[100] = 25;
        nArray[101] = 246;
        nArray[102] = 219;
        nArray[103] = 205;
        nArray[104] = 20;
        nArray[105] = 141;
        nArray[106] = 80;
        nArray[107] = 18;
        nArray[108] = 186;
        nArray[109] = 60;
        nArray[110] = 6;
        nArray[111] = 78;
        nArray[112] = 236;
        nArray[113] = 179;
        nArray[114] = 53;
        nArray[115] = 17;
        nArray[116] = 161;
        nArray[117] = 136;
        nArray[118] = 142;
        nArray[119] = 43;
        nArray[120] = 148;
        nArray[121] = 153;
        nArray[122] = 183;
        nArray[123] = 113;
        nArray[124] = 116;
        nArray[125] = 211;
        nArray[126] = 228;
        nArray[127] = 191;
        nArray[128] = 58;
        nArray[129] = 222;
        nArray[130] = 150;
        nArray[131] = 14;
        nArray[132] = 188;
        nArray[133] = 10;
        nArray[134] = 237;
        nArray[135] = 119;
        nArray[136] = 252;
        nArray[137] = 55;
        nArray[138] = 107;
        nArray[139] = 3;
        nArray[140] = 121;
        nArray[141] = 137;
        nArray[142] = 98;
        nArray[143] = 198;
        nArray[144] = 215;
        nArray[145] = 192;
        nArray[146] = 210;
        nArray[147] = 124;
        nArray[148] = 106;
        nArray[149] = 139;
        nArray[150] = 34;
        nArray[151] = 163;
        nArray[152] = 91;
        nArray[153] = 5;
        nArray[154] = 93;
        nArray[155] = 2;
        nArray[156] = 117;
        nArray[157] = 213;
        nArray[158] = 97;
        nArray[159] = 227;
        nArray[160] = 24;
        nArray[161] = 143;
        nArray[162] = 85;
        nArray[163] = 81;
        nArray[164] = 173;
        nArray[165] = 31;
        nArray[166] = 11;
        nArray[167] = 94;
        nArray[168] = 133;
        nArray[169] = 229;
        nArray[170] = 194;
        nArray[171] = 87;
        nArray[172] = 99;
        nArray[173] = 202;
        nArray[174] = 61;
        nArray[175] = 108;
        nArray[176] = 180;
        nArray[177] = 197;
        nArray[178] = 204;
        nArray[179] = 112;
        nArray[180] = 178;
        nArray[181] = 145;
        nArray[182] = 89;
        nArray[183] = 13;
        nArray[184] = 71;
        nArray[185] = 32;
        nArray[186] = 200;
        nArray[187] = 79;
        nArray[188] = 88;
        nArray[189] = 224;
        nArray[190] = 1;
        nArray[191] = 226;
        nArray[192] = 22;
        nArray[193] = 56;
        nArray[194] = 196;
        nArray[195] = 111;
        nArray[196] = 59;
        nArray[197] = 15;
        nArray[198] = 101;
        nArray[199] = 70;
        nArray[200] = 190;
        nArray[201] = 126;
        nArray[202] = 45;
        nArray[203] = 123;
        nArray[204] = 130;
        nArray[205] = 249;
        nArray[206] = 64;
        nArray[207] = 181;
        nArray[208] = 29;
        nArray[209] = 115;
        nArray[210] = 248;
        nArray[211] = 235;
        nArray[212] = 38;
        nArray[213] = 199;
        nArray[214] = 135;
        nArray[215] = 151;
        nArray[216] = 37;
        nArray[217] = 84;
        nArray[218] = 177;
        nArray[219] = 40;
        nArray[220] = 170;
        nArray[221] = 152;
        nArray[222] = 157;
        nArray[223] = 165;
        nArray[224] = 100;
        nArray[225] = 109;
        nArray[226] = 122;
        nArray[227] = 212;
        nArray[228] = 16;
        nArray[229] = 129;
        nArray[230] = 68;
        nArray[231] = 239;
        nArray[232] = 73;
        nArray[233] = 214;
        nArray[234] = 174;
        nArray[235] = 46;
        nArray[236] = 221;
        nArray[237] = 118;
        nArray[238] = 92;
        nArray[239] = 47;
        nArray[240] = 167;
        nArray[241] = 28;
        nArray[242] = 201;
        nArray[243] = 9;
        nArray[244] = 105;
        nArray[245] = 154;
        nArray[246] = 131;
        nArray[247] = 207;
        nArray[248] = 41;
        nArray[249] = 57;
        nArray[250] = 185;
        nArray[251] = 233;
        nArray[252] = 76;
        nArray[253] = 255;
        nArray[254] = 67;
        nArray[255] = 171;
        c = nArray;
        a = new int[256];
        int n2 = 0;
        while (n2 < 256) {
            RC2Parameters.a[RC2Parameters.c[n2]] = n2;
            ++n2;
        }
    }
}

