/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.sequelink.security;

import com.metamatrix.sequelink.security.Message;
import com.metamatrix.sequelink.security.SLProvider_VMActions;
import com.metamatrix.sequelink.security.SLProvider_VMActionsJDK11;
import com.metamatrix.sequelink.security.SLProvider_VMActionsJava2;
import com.metamatrix.sequelink.util.JDKVersionChecker;
import java.security.Provider;
import java.util.Properties;

public final class SLProvider
extends Provider {
    protected final String DESName = Message.Gen.getMessage("des.cipher.name");
    protected final String tripleDESName = Message.Gen.getMessage("tripledes.cipher.name");
    protected final String RSAName = Message.Gen.getMessage("rsa.cipher.name");
    protected final String RC4Name = Message.Gen.getMessage("rc4.cipher.name");
    private static final SLProvider_VMActions vmActions = JDKVersionChecker.isJava2() ? new SLProvider_VMActionsJava2() : new SLProvider_VMActionsJDK11();

    public SLProvider() {
        super(Message.Gen.getMessage("provider.name"), Double.valueOf(Message.Gen.getMessage("provider.version")), Message.Gen.getMessage("provider.info"));
        boolean bl = this.checkJSafe();
        Properties properties = new Properties();
        properties.put("Cipher." + this.DESName, "com.metamatrix.sequelink.security.DESCipher");
        properties.put("Cipher." + this.tripleDESName, "com.metamatrix.sequelink.security.TripleDESCipher");
        if (bl) {
            properties.put("Cipher." + this.RSAName, "com.metamatrix.sequelink.security.JSafeRSACipher");
            properties.put("Cipher." + this.RC4Name, "com.metamatrix.sequelink.security.JSafeRC4Cipher");
        }
        properties.put("KeyGenerator." + this.DESName, "com.metamatrix.sequelink.security.DESKeyGenerator");
        properties.put("KeyGenerator." + this.tripleDESName, "com.metamatrix.sequelink.security.TripleDESGenerator");
        properties.put("SecretKeyFactory." + this.DESName, "com.metamatrix.sequelink.security.DESKeyFactory");
        properties.put("SecretKeyFactory." + this.tripleDESName, "com.metamatrix.sequelink.security.TripleDESKeyFactory");
        if (bl) {
            properties.put("KeyFactory." + this.RSAName, "com.metamatrix.sequelink.security.JSafeRSAKeyFactory");
        }
        vmActions.addProperties(properties, this);
    }

    private boolean checkJSafe() {
        try {
            Class<?> clazz = Class.forName("COM.rsa.jsafe.JSAFE_AsymmetricCipher");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }
}

