/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sqlserver.tds;

import com.metamatrix.jdbc.sqlserver.SQLServerByteOrderedDataReader;
import com.metamatrix.jdbc.sqlserver.SQLServerByteOrderedDataWriter;
import com.metamatrix.jdbc.sqlserver.SQLServerImplStatement;
import com.metamatrix.jdbc.sqlserver.tds.TDSConnection;
import com.metamatrix.jdbc.sqlserver.tds.TDSRequest;
import com.metamatrix.util.UtilException;
import java.sql.SQLException;

public final class TDSPreLoginRequest
extends TDSRequest {
    private static String footprint = "$Revision:   1.4.1.0  $";
    boolean enableMars;
    byte encryption;
    String instance;
    String hostProcess;
    public int serverEncryptMode = 2;
    private static final byte PL_OPTION_VERSION = 0;
    private static final byte PL_OPTION_ENCRYPTION = 1;
    private static final byte PL_OPTION_INSTOPT = 2;
    private static final byte PL_OPTION_THREADID = 3;
    private static final byte PL_OPTION_MARS = 4;
    private static final byte PL_OPTION_TDSVERSION = 5;
    private static final byte PL_OPTION_TERMINATOR = -1;
    private static final int PL_OPTION_VERSION_LENGTH = 6;
    private static final byte[] UL_VERSION = new byte[]{9, 0, 5, 119};
    private static final int PL_OPTION_ENCRYPTION_LENGTH = 1;
    private static final int PL_OPTION_THREADID_LENGTH = 4;
    private static final int PL_OPTION_MARS_LENGTH = 1;
    private static final int PL_OPTION_TDSVERSION_LENGTH = 4;

    public TDSPreLoginRequest(TDSConnection tDSConnection, SQLServerByteOrderedDataReader sQLServerByteOrderedDataReader, SQLServerByteOrderedDataWriter sQLServerByteOrderedDataWriter, byte by, String string) throws SQLException {
        super(tDSConnection, sQLServerByteOrderedDataReader, sQLServerByteOrderedDataWriter, 18);
        this.encryption = by;
        this.enableMars = false;
        this.instance = string;
        this.hostProcess = "0";
    }

    public void submitRequest(SQLServerImplStatement sQLServerImplStatement) throws SQLException {
        try {
            this.clearReplyChannel();
            this.setupPreLoginRecord();
            this.writer.send();
            this.reader.receive();
            this.processReply();
        }
        catch (UtilException utilException) {
            throw this.conn.exceptions.getException((Exception)((Object)utilException));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setupPreLoginRecord() throws SQLException {
        int n = this.instance != null ? this.instance.length() + 1 : 1;
        int n2 = 21;
        int n3 = n2 + 6;
        int n4 = n3 + 1;
        int n5 = n4 + n;
        try {
            TDSConnection tDSConnection = this.conn;
            synchronized (tDSConnection) {
                this.writer.messageType = 18;
                this.writer.writeInt8(0);
                this.writer.writeBigEndianInt16(n2);
                this.writer.writeBigEndianInt16(6);
                this.writer.writeInt8(1);
                this.writer.writeBigEndianInt16(n3);
                this.writer.writeBigEndianInt16(1);
                this.writer.writeInt8(2);
                this.writer.writeBigEndianInt16(n4);
                this.writer.writeBigEndianInt16(n);
                this.writer.writeInt8(3);
                this.writer.writeBigEndianInt16(n5);
                this.writer.writeBigEndianInt16(4);
                this.writer.writeInt8(-1);
                this.writer.writeBytes(UL_VERSION);
                this.writer.writeBigEndianInt16(0);
                this.writer.writeInt8(this.encryption);
                if (this.instance != null) {
                    this.writer.writeBytes(this.instance.getBytes());
                }
                this.writer.writeInt8(0);
                try {
                    this.writer.writeBigEndianInt32(Integer.decode(this.hostProcess));
                }
                catch (NumberFormatException numberFormatException) {
                    this.writer.writeBigEndianInt32(0);
                }
            }
        }
        catch (UtilException utilException) {
            throw this.conn.exceptions.getException((Exception)((Object)utilException));
        }
    }

    public void processReply() throws SQLException {
        short s = 0;
        short s2 = 0;
        short s3 = 0;
        short s4 = 0;
        short s5 = 0;
        short s6 = 0;
        try {
            byte by = this.reader.getByte();
            while (by != -1) {
                switch (by) {
                    case 0: {
                        this.reader.readBigEndianInt16();
                        s = this.reader.readBigEndianInt16();
                        break;
                    }
                    case 1: {
                        this.reader.readBigEndianInt16();
                        s2 = this.reader.readBigEndianInt16();
                        break;
                    }
                    case 2: {
                        this.reader.readBigEndianInt16();
                        s3 = this.reader.readBigEndianInt16();
                        break;
                    }
                    case 3: {
                        this.reader.readBigEndianInt16();
                        s4 = this.reader.readBigEndianInt16();
                        break;
                    }
                    case 4: {
                        this.reader.readBigEndianInt16();
                        s5 = this.reader.readBigEndianInt16();
                        break;
                    }
                    case 5: {
                        this.reader.readBigEndianInt16();
                        s6 = this.reader.readBigEndianInt16();
                    }
                }
                by = this.reader.getByte();
            }
            if (s != 0) {
                if (this.conn.connection.implConnection.protocolVersion == 72) {
                    if (this.reader.getByte() == 9) {
                        this.conn.setTDSVersion(1913192450);
                    }
                    this.reader.readAndDiscardBytes(s - 1);
                } else {
                    this.reader.readAndDiscardBytes(s);
                }
            }
            if (s2 != 0) {
                this.serverEncryptMode = this.reader.readInt8();
            }
            if (s3 != 0) {
                this.reader.readAndDiscardBytes(s3);
            }
            if (s4 != 0) {
                this.reader.readAndDiscardBytes(s4);
            }
            if (s5 != 0) {
                this.reader.readInt8();
            }
            if (s6 != 0) {
                this.reader.readAndDiscardBytes(s6);
            }
        }
        catch (UtilException utilException) {
            throw this.conn.exceptions.getException((Exception)((Object)utilException));
        }
    }
}

