/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sybase.tds;

import com.metamatrix.jdbc.base.BaseWarnings;
import com.metamatrix.jdbc.sybase.tds.SybaseTDSCancelInfo;
import com.metamatrix.jdbc.sybase.tds.SybaseTDSCommunication;
import com.metamatrix.jdbc.sybase.tds.SybaseTDSRequest;
import com.metamatrix.util.UtilByteOrderedDataReader;
import com.metamatrix.util.UtilByteOrderedDataWriter;
import com.metamatrix.util.UtilException;
import java.sql.SQLException;

public class SybaseTDSCursorRequest
extends SybaseTDSRequest {
    private static String footprint = "$Revision:   3.8.4.0  $";
    String sql;
    boolean isOpen;
    int cursorId;
    private int fetchSize;
    private static final int DEFAULT_FETCH_SIZE = 1024;
    static int cursorNumber = 1000;
    private boolean forceCursorWritable;

    public SybaseTDSCursorRequest(SybaseTDSCommunication sybaseTDSCommunication, UtilByteOrderedDataReader utilByteOrderedDataReader, UtilByteOrderedDataWriter utilByteOrderedDataWriter, String string, boolean bl) {
        super(sybaseTDSCommunication, utilByteOrderedDataReader, utilByteOrderedDataWriter, 15);
        this.sql = string;
        this.cursorId = -1;
        this.processMode = 2;
        this.fetchSize = 1024;
        this.isOpen = false;
        this.forceCursorWritable = bl;
    }

    public void setFetchSize(int n, int n2) {
        this.fetchSize = n2 > 0 ? n2 : 1024;
        if (n > 0 && n < this.fetchSize) {
            this.fetchSize = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openCursor(BaseWarnings baseWarnings) throws SQLException {
        String string = "S" + String.valueOf(cursorNumber++);
        try {
            int[] nArray = new int[1];
            this.writer.getTransliterator().encode(this.sql, nArray);
            int n = nArray[0];
            this.clearReplyChannel();
            SybaseTDSCancelInfo sybaseTDSCancelInfo = this.comm.cancelInfo;
            synchronized (sybaseTDSCancelInfo) {
                this.comm.setMessageType(this.messageType);
                int n2 = 1 + string.length() + 1 + 1 + 2 + n + 1;
                if (this.comm.supportsWideTables) {
                    this.writer.writeInt8(35);
                    this.writer.writeInt32(n2 += 3);
                } else {
                    this.writer.writeInt8(-122);
                    this.writer.writeInt16(n2);
                }
                this.writer.writeStringWithLength8(string);
                if (this.forceCursorWritable) {
                    this.writer.writeInt8(0);
                } else {
                    this.writer.writeInt8(1);
                }
                this.writer.writeInt8(this.hasParameters() ? 1 : 0);
                if (this.comm.supportsWideTables) {
                    this.writer.writeStringWithLength32(this.sql);
                    this.writer.writeInt16(0);
                } else {
                    this.writer.writeStringWithLength16(this.sql);
                    this.writer.writeInt8(0);
                }
                if (this.hasParameters()) {
                    this.writeParamFormats();
                }
                this.writer.writeInt8(-124);
                this.writer.writeInt16(5 + string.length() + 1);
                this.writer.writeInt32(0);
                this.writer.writeStringWithLength8(string);
                if (this.hasParameters()) {
                    this.writer.writeInt8(1);
                    this.writeParamFormats();
                    this.writeParamData();
                } else {
                    this.writer.writeInt8(0);
                }
                this.writer.send();
            }
            this.reader.receive();
            this.processReply(baseWarnings);
            this.clearReplyChannel();
            this.isOpen = true;
            sybaseTDSCancelInfo = this.comm.cancelInfo;
            synchronized (sybaseTDSCancelInfo) {
                this.comm.setMessageType(this.messageType);
                this.writer.writeInt8(-125);
                this.writer.writeInt16(11);
                this.writer.writeInt32(this.cursorId);
                this.writer.writeInt8(1);
                this.writer.writeInt16(32);
                this.writer.writeInt32(this.fetchSize);
                this.writer.send();
            }
            this.reader.receive();
            this.processReply(baseWarnings);
            this.sendCursorFetch();
            this.reader.pushByte(this.reader.readInt8());
            this.resultType = 0;
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCursorFetch() throws SQLException {
        try {
            this.clearReplyChannel();
            SybaseTDSCancelInfo sybaseTDSCancelInfo = this.comm.cancelInfo;
            synchronized (sybaseTDSCancelInfo) {
                this.comm.setMessageType(this.messageType);
                this.writer.writeInt8(-126);
                this.writer.writeInt16(5);
                this.writer.writeInt32(this.cursorId);
                this.writer.writeInt8(1);
                this.writer.send();
            }
            this.reader.receive();
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException));
        }
    }

    public boolean getRow(BaseWarnings baseWarnings) throws SQLException {
        boolean bl = false;
        if (this.isOpen) {
            try {
                bl = super.getRow(baseWarnings);
            }
            catch (SQLException sQLException) {
                this.closeCursor(baseWarnings);
                throw sQLException;
            }
            if (!bl) {
                this.sendCursorFetch();
                bl = super.getRow(baseWarnings);
            }
        }
        return bl;
    }

    public void completeRowProcessing(BaseWarnings baseWarnings) throws SQLException {
        this.closeCursor(baseWarnings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeCursor(BaseWarnings baseWarnings) throws SQLException {
        if (!this.isOpen) {
            return;
        }
        try {
            this.clearReplyChannel();
            SybaseTDSCancelInfo sybaseTDSCancelInfo = this.comm.cancelInfo;
            synchronized (sybaseTDSCancelInfo) {
                this.comm.setMessageType(this.messageType);
                this.writer.writeInt8(-128);
                this.writer.writeInt16(5);
                this.writer.writeInt32(this.cursorId);
                this.writer.writeInt8(1);
                this.writer.send();
            }
            this.exception = null;
            this.reader.receive();
            this.processReply(baseWarnings);
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException));
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() != -75) {
                throw this.comm.exceptions.getException((Exception)sQLException);
            }
        }
        finally {
            this.isOpen = false;
        }
    }

    public boolean processReplyToken(byte by, BaseWarnings baseWarnings) throws SQLException {
        try {
            switch (by) {
                case -125: {
                    short s = this.reader.readInt16();
                    this.cursorId = this.reader.readInt32();
                    if (this.cursorId == 0) {
                        this.reader.readString((int)this.reader.readInt8());
                    }
                    this.reader.readInt8();
                    short s2 = this.reader.readInt16();
                    if ((s2 & 0x20) != 0) {
                        this.reader.readInt32();
                    }
                    return true;
                }
            }
            return super.processReplyToken(by, baseWarnings);
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException));
        }
    }
}

