/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sequelink.parameters;

import com.metamatrix.jdbc.sequelink.parameters.SequeLinkParameter;
import com.metamatrix.jdbc.slbase.BaseExceptions;
import com.metamatrix.jdbc.slbase.BaseParameter;
import com.metamatrix.sequelink.ctxt.stmt.StatementContext;
import com.metamatrix.sequelink.ssp.DiagnosticList;
import com.metamatrix.sequelink.ssp.Message;
import com.metamatrix.sequelink.ssp.SspInputStream;
import com.metamatrix.sequelink.ssp.SspOutputStream;
import com.metamatrix.sequelink.variables.StreamVariable;
import com.metamatrix.slutil.UtilException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;

public abstract class SequeLinkStreamParameter
extends SequeLinkParameter
implements StreamVariable {
    protected int totalLength;

    public SequeLinkStreamParameter(StatementContext statementContext, int n, int n2, int n3, int n4, BaseExceptions baseExceptions) throws SQLException {
        super(statementContext, n, n2, n3, n4, baseExceptions);
    }

    public boolean isLong() {
        return true;
    }

    public void writeDefinitionOn(SspOutputStream sspOutputStream) throws IOException {
        throw new InternalError(this.getClass().getName() + " writeDefinitionOn");
    }

    public void readObjectAndIndicatorFrom(SspInputStream sspInputStream) throws IOException {
        throw new InternalError(this.getClass().getName() + " readObjectAndIndicatorFrom");
    }

    public StatementContext getContext() {
        return this.stmtCtxt;
    }

    public boolean isNull() {
        if (this.bdIn == null) {
            return true;
        }
        return this.bdIn.isNull();
    }

    public void writeObjectOn(SspOutputStream sspOutputStream, int n) throws IOException {
        throw new InternalError(this.getClass().getName() + " writeObjectOn");
    }

    public int readLongData(SspInputStream sspInputStream, byte[] byArray, int n, int n2) throws IOException {
        throw new InternalError(this.getClass().getName() + " readLongData");
    }

    public void writePartialObjectOn(SspOutputStream sspOutputStream, int n, int n2, byte[] byArray) throws IOException, UtilException {
        sspOutputStream.writeSSPInt32(this.position);
        sspOutputStream.writeSSPEnum(this.sqlnkType);
        sspOutputStream.writeSSPEnum(this.rsrvcType);
        sspOutputStream.writeSSPInt32(n);
        sspOutputStream.writeSSPString("");
    }

    public abstract void writeLongData(SspOutputStream var1, byte[] var2, int var3, int var4) throws IOException;

    public int getTotalLength() {
        if (this.bdIn == null) {
            return 0;
        }
        if (this.bdIn.isNull()) {
            return 0;
        }
        return this.totalLength;
    }

    public void setBatch() throws SQLException {
        throw Message.Gen.getSqlException(7426);
    }

    public void setDataOut(BaseParameter baseParameter) throws SQLException {
        throw Message.Gen.getSqlException(7473);
    }

    public void setDataIn(BaseParameter baseParameter) throws SQLException {
        throw new InternalError(this.getClass().getName() + " setDataIn");
    }

    public abstract void xfer(DiagnosticList var1) throws SQLException;

    protected void writeToStream(SspOutputStream sspOutputStream) throws IOException, UtilException {
        throw new InternalError(this.getClass().getName() + " writeToStream");
    }

    protected void convertDataIn() throws SQLException {
        throw new InternalError(this.getClass().getName() + " convertDataIn");
    }

    protected void readFromStream(SspInputStream sspInputStream) throws IOException, UtilException {
        throw new InternalError(this.getClass().getName() + " readFromStream");
    }

    protected void writeStream(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
        byte[] byArray = this.stmtCtxt.getXferBuffer();
        int n2 = Math.min(n, byArray.length);
        while (n2 > 0) {
            int n3 = inputStream.read(byArray);
            if (n3 == -1) {
                throw new EOFException();
            }
            outputStream.write(byArray, 0, n3);
            n2 = Math.min(n -= n3, byArray.length);
        }
    }
}

