/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.util;

import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilResource;
import com.metamatrix.util.UtilResourceLocator;
import com.metamatrix.util.UtilTransliterator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.security.PrivilegedActionException;
import java.util.HashMap;

public class UtilTransliteratorUsingICUTable
extends UtilTransliterator {
    private static String footprint = "$Revision:   3.2.1.1  $";
    private int[] unicodeToCharsetMapping;
    private int[] primaryCharsetToUnicodeMapping;
    private int[][] secondaryCharsetToUnicodeMapping;
    protected byte[] tempBytesCache;
    private int[] rl;
    private static final int CHUNK = 256;
    private static HashMap CachedConversionTables;
    private String tableName;
    private InputStream _in;

    public UtilTransliteratorUsingICUTable(String string) throws UtilException {
        ConversionTable conversionTable;
        this.tableName = string;
        if (CachedConversionTables == null) {
            CachedConversionTables = new HashMap();
        }
        if ((conversionTable = (ConversionTable)CachedConversionTables.get(string)) != null) {
            this.loadCachedConversionTable(conversionTable);
        } else {
            InputStream inputStream = null;
            UtilResource utilResource = new UtilResource(new UtilResourceLocator().getClass(), string);
            try {
                inputStream = utilResource.getAsStream();
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw new UtilException(1005, string);
            }
            if (inputStream == null) {
                throw new UtilException(1005, string);
            }
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            this.constructConversionTables(new BufferedReader(inputStreamReader));
            this.cacheConversionTables(string);
        }
        this.setCacheSize(256);
    }

    public static UtilTransliteratorUsingICUTable GetIfLoaded(String string) throws UtilException {
        if (CachedConversionTables == null) {
            return null;
        }
        if (CachedConversionTables.get(string) == null) {
            return null;
        }
        return new UtilTransliteratorUsingICUTable(string);
    }

    private void constructConversionTables(BufferedReader bufferedReader) throws UtilException {
        try {
            int n;
            this.unicodeToCharsetMapping = new int[65536];
            for (n = 0; n < 65536; ++n) {
                this.unicodeToCharsetMapping[n] = 63;
            }
            this.primaryCharsetToUnicodeMapping = new int[256];
            for (n = 0; n < 256; ++n) {
                this.primaryCharsetToUnicodeMapping[n] = 63;
            }
            this.secondaryCharsetToUnicodeMapping = new int[256][];
            String string = bufferedReader.readLine();
            while (string != null && string.length() == 0) {
                string = bufferedReader.readLine();
            }
            while (string != null) {
                if (string.charAt(0) != '<' || string.charAt(1) != 'U' || string.charAt(6) != '>') {
                    throw new UtilException(1034, this.tableName);
                }
                String string2 = string.substring(2, 6);
                n = Integer.parseInt(string2, 16);
                int n2 = string.indexOf(92, 6);
                if (n2 == -1 || string.charAt(n2 + 1) != 'x') {
                    throw new UtilException(1034, this.tableName);
                }
                int n3 = Integer.parseInt(string.substring(n2 + 2, n2 + 4), 16);
                int n4 = string.indexOf(92, n2 + 4);
                int n5 = string.indexOf(124, n4 == -1 ? n2 + 4 : n4 + 4);
                int n6 = Integer.parseInt(string.substring(n5 + 1, n5 + 2));
                if (n4 == -1) {
                    this.unicodeToCharsetMapping[n] = n3;
                    if (n6 == 0) {
                        this.primaryCharsetToUnicodeMapping[n3] = n;
                    }
                } else {
                    if (string.charAt(n4 + 1) != 'x') {
                        throw new UtilException(1034, this.tableName);
                    }
                    int n7 = Integer.parseInt(string.substring(n4 + 2, n4 + 4), 16);
                    this.unicodeToCharsetMapping[n] = n3 << 8 | n7;
                    this.primaryCharsetToUnicodeMapping[n3] = -1;
                    if (n6 == 0) {
                        if (this.secondaryCharsetToUnicodeMapping[n3] == null) {
                            this.secondaryCharsetToUnicodeMapping[n3] = new int[256];
                            for (int i = 0; i < 256; ++i) {
                                this.secondaryCharsetToUnicodeMapping[n3][i] = 63;
                            }
                        }
                        this.secondaryCharsetToUnicodeMapping[n3][n7] = n;
                    }
                }
                string = bufferedReader.readLine();
                while (string != null && string.length() == 0) {
                    string = bufferedReader.readLine();
                }
            }
        }
        catch (IOException iOException) {
            throw new UtilException(1008, this.tableName);
        }
    }

    private void cacheConversionTables(Object object) {
        ConversionTable conversionTable = new ConversionTable();
        conversionTable.unicodeToCharsetMapping = this.unicodeToCharsetMapping;
        conversionTable.primaryCharsetToUnicodeMapping = this.primaryCharsetToUnicodeMapping;
        conversionTable.secondaryCharsetToUnicodeMapping = this.secondaryCharsetToUnicodeMapping;
        CachedConversionTables.put(object, conversionTable);
    }

    private void loadCachedConversionTable(ConversionTable conversionTable) {
        this.unicodeToCharsetMapping = conversionTable.unicodeToCharsetMapping;
        this.primaryCharsetToUnicodeMapping = conversionTable.primaryCharsetToUnicodeMapping;
        this.secondaryCharsetToUnicodeMapping = conversionTable.secondaryCharsetToUnicodeMapping;
    }

    public boolean isFixedBytesPerChar() {
        return false;
    }

    public int getMaxBytesPerChar() {
        return 2;
    }

    public int getMaxCharsPerByte() {
        return 1;
    }

    private int _encode(char[] cArray, int n, int n2, byte[] byArray) throws UtilException {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            char c = cArray[n + i];
            int n4 = this.unicodeToCharsetMapping[c];
            if (n4 > 255) {
                byArray[n3++] = (byte)(n4 >> 8 & 0xFF);
                byArray[n3++] = (byte)(n4 & 0xFF);
                continue;
            }
            byArray[n3++] = (byte)n4;
        }
        return n3;
    }

    public byte[] encode(String string) throws UtilException {
        if (this.rl == null) {
            this.rl = new int[1];
        }
        byte[] byArray = this.encode(string, this.rl);
        int n = this.rl[0];
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    public byte[] encode(char[] cArray, int n, int n2) throws UtilException {
        int n3 = n2 * this.getMaxBytesPerChar();
        byte[] byArray = this.bytesCache.length >= n3 ? this.bytesCache : new byte[n3];
        int n4 = this._encode(cArray, n, n2, byArray);
        byte[] byArray2 = new byte[n4];
        System.arraycopy(byArray, 0, byArray2, 0, n4);
        return byArray2;
    }

    public byte[] encode(String string, int[] nArray) throws UtilException {
        int n = string.length();
        int n2 = n * this.getMaxBytesPerChar();
        byte[] byArray = this.bytesCache.length >= n2 ? this.bytesCache : new byte[n2];
        char[] cArray = this.charsCache.length >= n ? this.charsCache : new char[n];
        string.getChars(0, n, cArray, 0);
        nArray[0] = this._encode(cArray, 0, n, byArray);
        return byArray;
    }

    public void encode(InputStream inputStream, int n, OutputStream outputStream) throws UtilException {
        if (this.bytesCache.length < 256) {
            this.bytesCache = new byte[256];
        }
        if (this.tempBytesCache == null || this.tempBytesCache.length < 256) {
            this.tempBytesCache = new byte[256 * this.getMaxBytesPerChar()];
        }
        try {
            while (n > 0) {
                int n2 = Math.min(n, 256);
                int n3 = inputStream.read(this.bytesCache, 0, n2);
                if (n3 == -1) {
                    throw new UtilException(1002);
                }
                int n4 = 0;
                for (int i = 0; i < n3; ++i) {
                    int n5 = this.bytesCache[i] & 0xFF;
                    int n6 = this.unicodeToCharsetMapping[n5];
                    if (n6 > 255) {
                        this.tempBytesCache[n4++] = (byte)(n6 >> 8 & 0xFF);
                        this.tempBytesCache[n4++] = (byte)(n6 & 0xFF);
                        continue;
                    }
                    this.tempBytesCache[n4++] = (byte)n6;
                }
                outputStream.write(this.tempBytesCache, 0, n4);
                n -= n3;
            }
            outputStream.flush();
        }
        catch (IOException iOException) {
            throw UtilException.createTransliterationFailedException(iOException.getMessage());
        }
    }

    public void encode(Reader reader, int n, OutputStream outputStream) throws UtilException {
        if (this.bytesCache.length < 256) {
            this.bytesCache = new byte[256];
        }
        if (this.charsCache.length < 256) {
            this.charsCache = new char[256];
        }
        try {
            while (n > 0) {
                int n2 = Math.min(n, 256);
                int n3 = reader.read(this.charsCache, 0, n2);
                if (n3 == -1) {
                    throw new UtilException(1002);
                }
                int n4 = this._encode(this.charsCache, 0, n3, this.bytesCache);
                outputStream.write(this.bytesCache, 0, n4);
                n -= n3;
            }
        }
        catch (IOException iOException) {
            throw UtilException.createTransliterationFailedException(iOException.getMessage());
        }
    }

    private int _decode(byte[] byArray, int n, int n2, char[] cArray, int n3) throws UtilException {
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            int n6 = byArray[n5 + n] & 0xFF;
            ++n5;
            if (this.secondaryCharsetToUnicodeMapping[n6] != null) {
                if (n5 >= n2) {
                    throw UtilException.createTransliterationFailedException("invalid encoded data");
                }
                int n7 = byArray[n5 + n] & 0xFF;
                cArray[n3 + n4++] = (char)this.secondaryCharsetToUnicodeMapping[n6][n7];
                ++n5;
                continue;
            }
            cArray[n3 + n4++] = (char)this.primaryCharsetToUnicodeMapping[n6];
        }
        return n4;
    }

    public String decode(byte[] byArray, int n, int n2) throws UtilException {
        int n3 = n2 * 1;
        char[] cArray = this.charsCache.length >= n3 ? this.charsCache : new char[n3];
        int n4 = this._decode(byArray, n, n2, cArray, 0);
        return new String(cArray, 0, n4);
    }

    public int decode(byte[] byArray, int n, int n2, char[] cArray, int n3) throws UtilException {
        return this._decode(byArray, n, n2, cArray, n3);
    }

    public String decode(byte[] byArray, int n, int n2, int n3) throws UtilException {
        char[] cArray = n2 > this.charsCache.length ? new char[n2] : this.charsCache;
        n2 = this._decode(byArray, n, n2, cArray, 0);
        if (cArray.length < n3) {
            char[] cArray2 = new char[n3];
            System.arraycopy(cArray, 0, cArray2, 0, n2);
            cArray = cArray2;
        }
        for (int i = n2; i < n3; ++i) {
            cArray[i] = 32;
        }
        return new String(cArray, 0, n3);
    }

    public synchronized Reader decodeAsReader(InputStream inputStream) throws UtilException {
        this._in = inputStream;
        return new Reader(){
            private InputStream in;
            private int length;
            private byte[] cache;
            {
                this.in = UtilTransliteratorUsingICUTable.this._in;
            }

            public int read() throws IOException {
                int n = this.in.read();
                if (n == -1) {
                    return -1;
                }
                if (UtilTransliteratorUsingICUTable.this.secondaryCharsetToUnicodeMapping[n &= 0xFF] != null) {
                    int n2 = this.in.read() & 0xFF;
                    return UtilTransliteratorUsingICUTable.this.secondaryCharsetToUnicodeMapping[n][n2];
                }
                return UtilTransliteratorUsingICUTable.this.primaryCharsetToUnicodeMapping[n];
            }

            public int read(char[] cArray, int n, int n2) throws IOException {
                int n3;
                if (this.cache == null || this.cache.length < n2) {
                    this.cache = new byte[n2];
                }
                if ((n3 = this.in.read(this.cache, 0, n2)) <= 0) {
                    return n3;
                }
                int n4 = 0;
                try {
                    n4 = UtilTransliteratorUsingICUTable.this._decode(this.cache, n, n3, cArray, 0);
                }
                catch (UtilException utilException) {
                    return -1;
                }
                return n4;
            }

            public void close() throws IOException {
                this.in.close();
            }
        };
    }

    public synchronized InputStream decodeAsUCS2ByteStream(InputStream inputStream, int n) throws UtilException {
        this._in = inputStream;
        return new InputStream(){
            private InputStream in;
            {
                this.in = UtilTransliteratorUsingICUTable.this._in;
            }

            private int _decode(byte[] byArray, int n, int n2) throws IOException {
                int n3;
                for (n3 = 0; n3 < n2; n3 += 2) {
                    char c;
                    int n4 = UtilTransliteratorUsingICUTable.this._in.read();
                    if (n4 == -1) {
                        if (n3 == 0) {
                            return -1;
                        }
                        return n3;
                    }
                    if (UtilTransliteratorUsingICUTable.this.secondaryCharsetToUnicodeMapping[n4] != null) {
                        int n5 = UtilTransliteratorUsingICUTable.this._in.read();
                        if (n5 == -1) {
                            throw new IOException();
                        }
                        c = (char)UtilTransliteratorUsingICUTable.this.secondaryCharsetToUnicodeMapping[n4][n5];
                    } else {
                        c = (char)UtilTransliteratorUsingICUTable.this.primaryCharsetToUnicodeMapping[n4];
                    }
                    byArray[n++] = (byte)(c >> 8);
                    byArray[n++] = (byte)c;
                }
                return n3;
            }

            public int read() throws IOException {
                throw new IOException("Single byte reads are not supported by this InputStream derivative");
            }

            public int read(byte[] byArray, int n, int n2) throws IOException {
                if ((n2 &= 0xFFFFFFFE) == 0) {
                    return 0;
                }
                return this._decode(byArray, n, n2);
            }

            public void close() throws IOException {
                UtilTransliteratorUsingICUTable.this._in.close();
            }
        };
    }

    private class ConversionTable {
        int[] unicodeToCharsetMapping;
        int[] primaryCharsetToUnicodeMapping;
        int[][] secondaryCharsetToUnicodeMapping;

        private ConversionTable() {
        }
    }
}

