/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.util;

import com.metamatrix.util.UtilCipher;
import com.metamatrix.util.UtilException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;

public class UtilJavaxCryptoCipher
implements UtilCipher {
    static String footprint = "$Revision:   1.0.1.0  $";
    private Cipher encryptor;
    private Cipher decryptor;
    private byte[] cache;
    private byte[] chunkIn;
    private byte[] chunkOut;
    private static final int CACHE_SIZE = 1024;
    private static final int CHUNK_SIZE = 4096;

    public UtilJavaxCryptoCipher(String string, SecretKey secretKey, IvParameterSpec ivParameterSpec) throws UtilException {
        try {
            this.encryptor = Cipher.getInstance(string);
            this.encryptor.init(1, (Key)secretKey, ivParameterSpec);
            this.decryptor = Cipher.getInstance(string);
            this.decryptor.init(2, (Key)secretKey, ivParameterSpec);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new UtilException(1040, "NoSuchPaddingException");
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new UtilException(1040, "InvalidKeyException");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new UtilException(1040, "NoSuchAlgorithmException");
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new UtilException(1040, "InvalidAlgorithmParameterException");
        }
        this.cache = new byte[1024];
    }

    public byte[] encrypt(byte[] byArray) throws UtilException {
        try {
            return this.encryptor.doFinal(byArray);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new UtilException(1041, "IllegalBlockSizeException");
        }
        catch (BadPaddingException badPaddingException) {
            throw new UtilException(1041, "BadPaddingException");
        }
    }

    public byte[] encrypt(byte[] byArray, int n, int n2, int[] nArray) throws UtilException {
        int n3;
        int n4 = this.encryptor.getOutputSize(n2);
        byte[] byArray2 = new byte[n4];
        try {
            n3 = this.encryptor.doFinal(byArray, 0, byArray.length, byArray2);
        }
        catch (ShortBufferException shortBufferException) {
            throw new UtilException(1041, "ShortBufferException");
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new UtilException(1041, "IllegalBlockSizeException");
        }
        catch (BadPaddingException badPaddingException) {
            throw new UtilException(1041, "BadPaddingException");
        }
        nArray[0] = n3;
        return byArray2;
    }

    public byte[] encryptCached(byte[] byArray, int n, int n2, int[] nArray) throws UtilException {
        int n3;
        int n4 = this.encryptor.getOutputSize(n2);
        byte[] byArray2 = n4 <= this.cache.length ? this.cache : new byte[n4];
        try {
            n3 = this.encryptor.doFinal(byArray, 0, byArray.length, byArray2);
        }
        catch (ShortBufferException shortBufferException) {
            throw new UtilException(1041, "ShortBufferException");
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new UtilException(1041, "IllegalBlockSizeException");
        }
        catch (BadPaddingException badPaddingException) {
            throw new UtilException(1041, "BadPaddingException");
        }
        nArray[0] = n3;
        return byArray2;
    }

    public byte[] decrypt(byte[] byArray) throws UtilException {
        try {
            return this.decryptor.doFinal(byArray);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new UtilException(1042, "IllegalBlockSizeException");
        }
        catch (BadPaddingException badPaddingException) {
            throw new UtilException(1042, "BadPaddingException");
        }
    }

    public byte[] decrypt(byte[] byArray, int n, int n2, int[] nArray) throws UtilException {
        int n3;
        int n4 = this.decryptor.getOutputSize(n2);
        byte[] byArray2 = new byte[n4];
        try {
            n3 = this.decryptor.doFinal(byArray, 0, byArray.length, byArray2);
        }
        catch (ShortBufferException shortBufferException) {
            throw new UtilException(1042, "ShortBufferException");
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new UtilException(1042, "IllegalBlockSizeException");
        }
        catch (BadPaddingException badPaddingException) {
            throw new UtilException(1042, "BadPaddingException");
        }
        nArray[0] = n3;
        return byArray2;
    }

    public byte[] decryptCached(byte[] byArray, int n, int n2, int[] nArray) throws UtilException {
        int n3;
        int n4 = this.decryptor.getOutputSize(n2);
        byte[] byArray2 = n4 <= this.cache.length ? this.cache : new byte[n4];
        try {
            n3 = this.decryptor.doFinal(byArray, 0, byArray.length, byArray2);
        }
        catch (ShortBufferException shortBufferException) {
            throw new UtilException(1042, "ShortBufferException");
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new UtilException(1042, "IllegalBlockSizeException");
        }
        catch (BadPaddingException badPaddingException) {
            throw new UtilException(1042, "BadPaddingException");
        }
        nArray[0] = n3;
        return byArray2;
    }

    public int encrypt(InputStream inputStream, int n, OutputStream outputStream) throws UtilException {
        if (this.chunkIn == null) {
            this.chunkIn = new byte[4096];
        }
        if (this.chunkOut == null) {
            this.chunkOut = new byte[4096];
        }
        try {
            int n2;
            int n3 = 0;
            while (n > 0) {
                int n4 = inputStream.read(this.chunkIn);
                n2 = this.encryptor.update(this.chunkIn, 0, n4, this.chunkOut);
                if (n2 > 0) {
                    outputStream.write(this.chunkOut, 0, n2);
                    n3 += n2;
                }
                n -= n4;
            }
            n2 = this.encryptor.doFinal(this.chunkOut, 0);
            if (n2 > 0) {
                outputStream.write(this.chunkOut, 0, n2);
                n3 += n2;
            }
            return n3;
        }
        catch (ShortBufferException shortBufferException) {
            throw new UtilException(1041, "ShortBufferException");
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new UtilException(1041, "IllegalBlockSizeException");
        }
        catch (BadPaddingException badPaddingException) {
            throw new UtilException(1041, "BadPaddingException");
        }
        catch (IOException iOException) {
            throw new UtilException(1041, "IOException");
        }
    }

    public int decrypt(InputStream inputStream, int n, OutputStream outputStream) throws UtilException {
        if (this.chunkIn == null) {
            this.chunkIn = new byte[4096];
        }
        if (this.chunkOut == null) {
            this.chunkOut = new byte[4096];
        }
        try {
            int n2;
            int n3 = 0;
            while (n > 0) {
                int n4 = inputStream.read(this.chunkIn);
                n2 = this.decryptor.update(this.chunkIn, 0, n4, this.chunkOut);
                if (n2 > 0) {
                    outputStream.write(this.chunkOut, 0, n2);
                    n3 += n2;
                }
                n -= n4;
            }
            n2 = this.decryptor.doFinal(this.chunkOut, 0);
            if (n2 > 0) {
                outputStream.write(this.chunkOut, 0, n2);
                n3 += n2;
            }
            return n3;
        }
        catch (ShortBufferException shortBufferException) {
            throw new UtilException(1042, "ShortBufferException");
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new UtilException(1042, "IllegalBlockSizeException");
        }
        catch (BadPaddingException badPaddingException) {
            throw new UtilException(1042, "BadPaddingException");
        }
        catch (IOException iOException) {
            throw new UtilException(1042, "IOException");
        }
    }

    public void setCache(byte[] byArray) {
        this.cache = byArray;
    }
}

