/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.team.metabase.ui.action;

import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceItem;
import com.metamatrix.modeler.internal.core.workspace.ModelWorkspaceManager;
import com.metamatrix.modeler.internal.team.metabase.ui.InternalModelerTeamMetabaseUiConstants;
import com.metamatrix.modeler.team.metabase.MetabaseActionInitiator;
import com.metamatrix.modeler.team.metabase.MetabasePlugin;
import com.metamatrix.modeler.team.metabase.MetabaseResourceStatus;
import com.metamatrix.modeler.team.metabase.command.GetCheckoutStatusCommand;
import com.metamatrix.modeler.team.metabase.command.MetabaseCommand;
import com.metamatrix.modeler.team.metabase.command.RemoveCommand;
import com.metamatrix.modeler.team.metabase.repository.RepositoryObject;
import com.metamatrix.modeler.team.metabase.repository.impl.RepositoryFolderImpl;
import com.metamatrix.modeler.team.metabase.repository.impl.RepositoryItemImpl;
import com.metamatrix.modeler.team.metabase.ui.MetabaseDecorator;
import com.metamatrix.modeler.team.metabase.ui.action.DefaultActionInitiator;
import com.metamatrix.modeler.team.metabase.ui.action.MetabaseTeamAction;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class RemoveTeamAction
extends MetabaseTeamAction {
    private static final String CONFIRM_TITLE = InternalModelerTeamMetabaseUiConstants.Util.getString("RemoveTeamAction.Confirm_remove_title");
    private static final String CONFIRM_SEL_OBJ = InternalModelerTeamMetabaseUiConstants.Util.getString("RemoveTeamAction.unknown_selected_object");
    private static final String ERROR_WHILE_REMOVING = InternalModelerTeamMetabaseUiConstants.Util.getString("RemoveTeamAction.Error_while_removing");
    private static final String CANNOT_REMOVE_TITLE = InternalModelerTeamMetabaseUiConstants.Util.getString("RemoveTeamAction.Cannot_remove");
    private static final String CANNOT_REMOVE_MSG = InternalModelerTeamMetabaseUiConstants.Util.getString("RemoveTeamAction.Cannot_remove_when_elements_are_checked_out");

    public void runWithEvent(IAction action, Event event) {
        String confirmDelMsg;
        ArrayList projects = new ArrayList();
        if (!this.isValidProjectShare(false, true, true, projects)) {
            return;
        }
        if (this.someItemsAreCheckedOut(this.getSelectedObjects())) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)CANNOT_REMOVE_TITLE, (String)CANNOT_REMOVE_MSG);
            return;
        }
        Object[] selObjs = this.getSelectedObjects();
        int selObjCount = selObjs.length;
        if (selObjCount == 1) {
            String nameText = selObjs[0] instanceof IResource ? ((IResource)selObjs[0]).getName() : (selObjs[0] instanceof RepositoryObject ? ((RepositoryObject)selObjs[0]).getName() : CONFIRM_SEL_OBJ);
            confirmDelMsg = InternalModelerTeamMetabaseUiConstants.Util.getString("RemoveTeamAction.Confirm_remove_msg", (Object)nameText);
        } else {
            confirmDelMsg = InternalModelerTeamMetabaseUiConstants.Util.getString("RemoveTeamAction.Confirm_remove_multiple_msg", selObjCount);
        }
        if (!MessageDialog.openQuestion((Shell)this.getShell(), (String)CONFIRM_TITLE, (String)confirmDelMsg)) {
            return;
        }
        WorkspaceModifyOperation runnable = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
                try {
                    RemoveCommand command = null;
                    int optionsType = RemoveTeamAction.this.getOptionsType();
                    if (optionsType == 1) {
                        IResource[] resources = RemoveTeamAction.this.getSelectedResources();
                        command = MetabasePlugin.getCommandFactory().createRemove(resources, RemoveTeamAction.this.getResourceCallback());
                    } else if (optionsType == 2) {
                        RepositoryObject[] selectedObjects = RemoveTeamAction.this.getSelectedRepositoryObjects();
                        if (selectedObjects != null) {
                            for (int i = 0; i < selectedObjects.length; ++i) {
                                RepositoryObject object = selectedObjects[i];
                                if (object == null || object.eResource() != null) continue;
                                IPath path = object.getPathInWorkspace();
                                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                                IResource resource = root.findMember(path, true);
                                if (resource != null) continue;
                                throw new TeamException(InternalModelerTeamMetabaseUiConstants.Util.getString("RemoveTeamAction.project_must_in_workspace"));
                            }
                        }
                        command = MetabasePlugin.getRepositoryCommandFactory().createRemove(selectedObjects, RemoveTeamAction.this.getResourceCallback());
                    }
                    if (command != null) {
                        DefaultActionInitiator initiator = new DefaultActionInitiator(Display.getCurrent(), RemoveTeamAction.this.getShell());
                        MetabasePlugin.getMetabaseService().executeCommand((MetabaseCommand)command, monitor, (MetabaseActionInitiator)initiator);
                        RemoveTeamAction.this.postprocessResult(command.getResult());
                    }
                }
                catch (TeamException e) {
                    throw new InvocationTargetException(e);
                }
                finally {
                    monitor.done();
                }
            }
        };
        Exception[] exceptions = new Exception[]{null};
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable((IRunnableWithProgress)runnable, exceptions){
            private final /* synthetic */ IRunnableWithProgress val$runnable;
            private final /* synthetic */ Exception[] val$exceptions;
            {
                this.val$runnable = val$runnable;
                this.val$exceptions = val$exceptions;
            }

            public void run() {
                try {
                    this.val$runnable.run((IProgressMonitor)new NullProgressMonitor());
                }
                catch (InvocationTargetException e) {
                    this.val$exceptions[0] = e;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        if (exceptions[0] != null) {
            this.handle(exceptions[0], ERROR_WHILE_REMOVING, ERROR_WHILE_REMOVING);
        }
        if (!projects.isEmpty()) {
            Iterator iter = projects.iterator();
            while (iter.hasNext()) {
                IProject project = (IProject)iter.next();
                try {
                    RepositoryProvider.unmap((IProject)project);
                }
                catch (TeamException e) {}
            }
        }
    }

    private boolean someItemsAreCheckedOut(Object[] selectedObjects) {
        boolean bResult = false;
        int iCount = selectedObjects.length;
        this.refreshCheckoutStatus();
        block0: for (int i = 0; i < iCount; ++i) {
            RepositoryItemImpl riItem;
            String sLockHeldBy;
            if (selectedObjects[i] instanceof IResource) {
                IResource resource = (IResource)selectedObjects[i];
                boolean bIsCheckedOut = this.searchForCheckedOutResources(resource);
                if (!bIsCheckedOut) continue;
                bResult = true;
                break;
            }
            if (!(selectedObjects[0] instanceof RepositoryObject)) continue;
            if (selectedObjects[0] instanceof RepositoryFolderImpl) {
                RepositoryFolderImpl rfFolder = (RepositoryFolderImpl)selectedObjects[0];
                TreeIterator trIter = rfFolder.eAllContents();
                while (trIter.hasNext()) {
                    RepositoryItemImpl riItem2;
                    Object o = trIter.next();
                    if (o instanceof RepositoryFolderImpl || !(o instanceof RepositoryItemImpl) || (sLockHeldBy = (riItem2 = (RepositoryItemImpl)o).getLockedHeldBy()) == null || sLockHeldBy.trim() == "") continue;
                    bResult = true;
                    continue block0;
                }
                continue;
            }
            if (!(selectedObjects[0] instanceof RepositoryItemImpl) || (sLockHeldBy = (riItem = (RepositoryItemImpl)selectedObjects[0]).getLockedHeldBy()) == null || sLockHeldBy.trim() == "") continue;
            bResult = true;
            break;
        }
        return bResult;
    }

    private boolean searchForCheckedOutResources(IResource resource) {
        boolean bResult;
        block9: {
            bResult = false;
            if (resource.getType() == 1) {
                if (this.isCheckedOut(resource)) {
                    bResult = true;
                }
            } else if (resource.getType() == 2 || resource.getType() == 4) {
                ModelWorkspaceItem workspaceItem = ModelWorkspaceManager.create((IResource)resource, null);
                try {
                    if (workspaceItem.hasChildren()) {
                        ModelWorkspaceItem[] children = workspaceItem.getChildren();
                        for (int i = 0; i < children.length; ++i) {
                            boolean bCheckedOut = this.searchForCheckedOutResources(children[i].getResource());
                            if (!bCheckedOut) continue;
                            bResult = true;
                            break block9;
                        }
                        break block9;
                    }
                    if (this.isCheckedOut(workspaceItem.getResource())) {
                        bResult = true;
                    }
                }
                catch (ModelWorkspaceException mwe) {
                    InternalModelerTeamMetabaseUiConstants.Util.log(4, (Throwable)mwe, mwe.getMessage());
                }
            }
        }
        return bResult;
    }

    private boolean isCheckedOut(IResource resource) {
        boolean bResult = false;
        MetabaseResourceStatus status = MetabasePlugin.getMetabaseResourceStatuses().getMetabaseResourceStatus(resource);
        if (status != null && status.isCheckedOut()) {
            bResult = true;
        }
        return bResult;
    }

    public void refreshCheckoutStatus() {
        String msg = InternalModelerTeamMetabaseUiConstants.Util.getString("GetCheckoutStatusTeamAction.Error_while_getting_status");
        this.run((IRunnableWithProgress)new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
                try {
                    GetCheckoutStatusCommand command = null;
                    int optionsType = RemoveTeamAction.this.getOptionsType();
                    if (optionsType == 1) {
                        IResource[] resources = RemoveTeamAction.this.getSelectedResources();
                        command = MetabasePlugin.getCommandFactory().createGetCheckoutStatus(resources, RemoveTeamAction.this.getResourceCallback());
                    } else if (optionsType == 2) {
                        RepositoryObject[] selectedObjects = RemoveTeamAction.this.getSelectedRepositoryObjects();
                        command = MetabasePlugin.getRepositoryCommandFactory().createGetCheckoutStatus(selectedObjects, RemoveTeamAction.this.getResourceCallback());
                    }
                    if (command != null) {
                        command.setRecursive(true);
                        DefaultActionInitiator initiator = new DefaultActionInitiator(Display.getCurrent(), RemoveTeamAction.this.getShell());
                        MetabasePlugin.getMetabaseService().executeCommand((MetabaseCommand)command, monitor, (MetabaseActionInitiator)initiator);
                        RemoveTeamAction.this.updateDecorators();
                        MetabaseDecorator decorator = RemoveTeamAction.this.getMetabaseDecorator();
                        if (decorator != null) {
                            decorator.refreshFromStatusList(command.getResources());
                        }
                    }
                }
                catch (TeamException e) {
                    throw new InvocationTargetException(e);
                }
                finally {
                    monitor.done();
                }
            }
        }, msg, 2);
    }
}

