/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.comm.platform.socket;

import com.metamatrix.common.comm.platform.socket.SocketLog;
import java.io.PrintStream;

public class PrintStreamSocketLog
implements SocketLog {
    private PrintStream stream;
    private String staticContext;
    private int logLevel = 0;

    public PrintStreamSocketLog(PrintStream stream, String staticContext, int logLevel) {
        this.stream = stream;
        this.staticContext = staticContext;
        this.logLevel = logLevel;
    }

    public void logCritical(String context, String message) {
        if (this.isLogged(context, 1)) {
            this.log(1, context, message);
        }
    }

    public void logCritical(String context, Throwable throwable, String message) {
        if (this.isLogged(context, 1)) {
            this.log(1, context, throwable, message);
        }
    }

    public void logError(String context, String message) {
        if (this.isLogged(context, 2)) {
            this.log(2, context, message);
        }
    }

    public void logError(String context, Throwable throwable, String message) {
        if (this.isLogged(context, 2)) {
            this.log(2, context, throwable, message);
        }
    }

    public void logWarning(String context, String message) {
        if (this.isLogged(context, 3)) {
            this.log(3, context, message);
        }
    }

    public void logWarning(String context, Throwable throwable, String message) {
        if (this.isLogged(context, 3)) {
            this.log(3, context, throwable, message);
        }
    }

    public void logInfo(String context, String message) {
        if (this.isLogged(context, 4)) {
            this.log(4, context, message);
        }
    }

    public void logInfo(String context, Throwable throwable, String message) {
        if (this.isLogged(context, 4)) {
            this.log(4, context, throwable, message);
        }
    }

    public void logDetail(String context, String message) {
        if (this.isLogged(context, 5)) {
            this.log(5, context, message);
        }
    }

    public void logDetail(String context, Throwable throwable, String message) {
        if (this.isLogged(context, 5)) {
            this.log(5, context, throwable, message);
        }
    }

    public void logTrace(String context, String message) {
        if (this.isLogged(context, 6)) {
            this.log(6, context, message);
        }
    }

    public void logTrace(String context, Throwable throwable, String message) {
        if (this.isLogged(context, 6)) {
            this.log(6, context, throwable, message);
        }
    }

    private void log(int level, String context, String message) {
        this.stream.print(PrintStreamSocketLog.getLogLevelString(level));
        this.stream.print("\t[");
        this.stream.print(this.staticContext);
        this.stream.print("]\t");
        this.stream.print(context);
        this.stream.print("\t");
        this.stream.println(message);
    }

    private void log(int level, String context, Throwable t, String message) {
        this.log(level, context, message);
        t.printStackTrace(this.stream);
    }

    public boolean isLogged(String context, int level) {
        return this.logLevel >= level;
    }

    private static String getLogLevelString(int level) {
        switch (level) {
            case 1: {
                return "CRITICAL";
            }
            case 2: {
                return "ERROR";
            }
            case 3: {
                return "WARNING";
            }
            case 4: {
                return "INFO";
            }
            case 5: {
                return "DETAIL";
            }
            case 6: {
                return "TRACE";
            }
        }
        return "NONE";
    }

    public static int getLogLevelInt(String level) {
        if (level.equalsIgnoreCase("CRITICAL")) {
            return 1;
        }
        if (level.equalsIgnoreCase("ERROR")) {
            return 2;
        }
        if (level.equalsIgnoreCase("WARNING")) {
            return 3;
        }
        if (level.equalsIgnoreCase("INFO")) {
            return 4;
        }
        if (level.equalsIgnoreCase("DETAIL")) {
            return 5;
        }
        if (level.equalsIgnoreCase("TRACE")) {
            return 6;
        }
        return 0;
    }
}

