/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.testing.tools;

import com.metamatrix.cdk.api.TranslationUtility;
import com.metamatrix.data.language.IQuery;
import com.metamatrix.data.metadata.runtime.RuntimeMetadata;
import java.io.File;

public class VDBLoader {
    String vdbFolder;
    TranslationUtility transUtil;

    public VDBLoader(String CCProjectBuildRoot, String projectVDBPath, String VDBName) throws Exception {
        String localLocation = "./" + projectVDBPath;
        String ccLocation = CCProjectBuildRoot + "/" + projectVDBPath;
        File test = new File(localLocation);
        if (test.exists()) {
            this.vdbFolder = localLocation;
        } else {
            test = new File(ccLocation);
            if (test.exists()) {
                this.vdbFolder = ccLocation;
            } else {
                throw new Exception("The VDB path cannot be found at " + localLocation + "or at " + ccLocation);
            }
        }
        this.transUtil = new TranslationUtility(this.vdbFolder + "/" + VDBName);
    }

    public RuntimeMetadata getVDB() {
        return this.transUtil.createRuntimeMetadata();
    }

    public IQuery getDefaultIQuery(String query) {
        return (IQuery)this.transUtil.parseCommand(query);
    }
}

