/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xml.base;

import com.metamatrix.connector.xml.SAXFilterProvider;
import com.metamatrix.connector.xml.base.CountingInputStream;
import com.metamatrix.connector.xml.base.DocumentInfo;
import com.metamatrix.connector.xml.base.FileLifeManager;
import com.metamatrix.connector.xml.base.IDGeneratingXmlFilter;
import com.metamatrix.connector.xml.base.LargeTextExtractingXmlFilter;
import com.metamatrix.data.api.ConnectorLogger;
import com.metamatrix.data.exception.ConnectorException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

public class XMLExtractor {
    private int largeTextThreshold;
    private boolean generateIds;
    private ConnectorLogger connectorLogger;
    private File m_cacheFolder;
    private boolean m_logDocument;
    private static final int AVERAGE_ELEMENT_FILE_SIZE = 20;
    private static final int AVERAGE_ELEMENT_FILE_MEMORY_RATIO = 5;

    public XMLExtractor(int largeTextThreshold, boolean generateIds, boolean logDocument, File cacheFolder, ConnectorLogger connectorLogger) {
        this.largeTextThreshold = largeTextThreshold;
        this.generateIds = generateIds;
        this.connectorLogger = connectorLogger;
        this.m_cacheFolder = cacheFolder;
        this.m_logDocument = logDocument;
    }

    public DocumentInfo createDocumentFromStream(InputStream responseBody, String documentDistinguishingId, SAXFilterProvider provider) throws ConnectorException {
        CountingInputStream stream = new CountingInputStream(responseBody);
        XMLFilterImpl[] extendedFilters = provider.getExtendedFilters(this.connectorLogger);
        LargeTextExtractingXmlFilter largeTextFilter = null;
        ArrayList<XMLFilterImpl> filters = new ArrayList<XMLFilterImpl>();
        for (int i = 0; i < extendedFilters.length; ++i) {
            filters.add(extendedFilters[i]);
        }
        if (this.largeTextThreshold > 0) {
            largeTextFilter = new LargeTextExtractingXmlFilter(this.largeTextThreshold, this.m_cacheFolder, this.connectorLogger);
            filters.add(largeTextFilter);
        }
        if (this.generateIds) {
            IDGeneratingXmlFilter idGeneratingFilter = new IDGeneratingXmlFilter(documentDistinguishingId, this.connectorLogger);
            filters.add(idGeneratingFilter);
        }
        SAXBuilder builder = filters.size() > 0 ? new SAXBuilderFix() : new SAXBuilder();
        Iterator iter = filters.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            XMLFilter filter = (XMLFilter)o;
            builder.setXMLFilter(filter);
        }
        Document domDoc = null;
        try {
            domDoc = builder.build((InputStream)stream);
        }
        catch (Exception de) {
            throw new ConnectorException((Throwable)de);
        }
        FileLifeManager[] externalFiles = largeTextFilter != null ? largeTextFilter.getFiles() : new FileLifeManager[]{};
        long fileCacheSize = stream.getSize();
        return this.createDocument(domDoc, fileCacheSize, externalFiles);
    }

    public DocumentInfo createDocumentFromJDOM(Document domDoc, String documentDistinguishingId) throws ConnectorException {
        SelfAddingIDGeneratingXmlFilter idGeneratingXmlFilter = new SelfAddingIDGeneratingXmlFilter(documentDistinguishingId, this.connectorLogger);
        try {
            idGeneratingXmlFilter.startDocument();
            List children = domDoc.getContent();
            this.traverse(children, idGeneratingXmlFilter);
            idGeneratingXmlFilter.endDocument();
        }
        catch (SAXException e) {
            throw new ConnectorException((Throwable)e);
        }
        int fileCacheSize = idGeneratingXmlFilter.elemCount * 20;
        return this.createDocument(domDoc, fileCacheSize, new FileLifeManager[0]);
    }

    private void traverse(List content, IDGeneratingXmlFilter idGeneratingXmlFilter) throws SAXException {
        Iterator iter = content.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof Element)) continue;
            Element elem = (Element)o;
            String namespace = elem.getNamespaceURI();
            String name = elem.getName();
            String qname = elem.getQualifiedName();
            SAXAttributesWrapper attributes = new SAXAttributesWrapper(elem);
            idGeneratingXmlFilter.startElement(namespace, name, qname, attributes);
            List children = elem.getContent();
            this.traverse(children, idGeneratingXmlFilter);
            idGeneratingXmlFilter.endElement(namespace, name, qname);
        }
    }

    private DocumentInfo createDocument(Document domDoc, long fileCacheSize, FileLifeManager[] externalFiles) throws ConnectorException {
        long memoryCacheSize = fileCacheSize;
        try {
            for (int iFile = 0; iFile < externalFiles.length; ++iFile) {
                memoryCacheSize -= externalFiles[iFile].getLength();
            }
        }
        catch (IOException e) {
            throw new ConnectorException((Throwable)e);
        }
        if (memoryCacheSize < 100L) {
            memoryCacheSize = 100L;
        }
        return new DocumentInfo(domDoc, externalFiles, (int)(memoryCacheSize *= 5L), fileCacheSize);
    }

    private final class SAXBuilderFix
    extends SAXBuilder {
        private final List filters = new ArrayList();

        private SAXBuilderFix() {
        }

        protected XMLReader createParser() throws JDOMException {
            XMLReader reader = super.createParser();
            Iterator iter = this.filters.iterator();
            while (iter.hasNext()) {
                Object o = iter.next();
                XMLFilter filter = (XMLFilter)o;
                filter.setParent(reader);
                reader = filter;
            }
            return reader;
        }

        public void setXMLFilter(XMLFilter xmlFilter) {
            this.filters.add(xmlFilter);
        }
    }

    private class SelfAddingIDGeneratingXmlFilter
    extends IDGeneratingXmlFilter {
        int elemCount = 0;

        SelfAddingIDGeneratingXmlFilter(String documentDistinguishingId, ConnectorLogger connectorLogger) {
            super(documentDistinguishingId, connectorLogger);
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            super.startElement(namespaceURI, localName, qName, atts);
            ++this.elemCount;
        }

        protected Attributes addAttributes(Attributes atts, String indexValue, String pathValue) {
            SAXAttributesWrapper wrappedAttributes = (SAXAttributesWrapper)atts;
            wrappedAttributes.elem.setAttribute("com.metamatrix.xml.xpathpart", pathValue);
            wrappedAttributes.elem.setAttribute("com.metamatrix.xml.xpathpart.byindex", indexValue);
            return atts;
        }
    }

    private class SAXAttributesWrapper
    extends AttributesImpl {
        Element elem;

        SAXAttributesWrapper(Element elem) {
            this.elem = elem;
        }
    }
}

