/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.internal.process;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryParserException;
import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.api.exception.query.QueryResolverException;
import com.metamatrix.api.exception.query.QueryValidatorException;
import com.metamatrix.common.application.ApplicationEnvironment;
import com.metamatrix.common.buffer.BufferManager;
import com.metamatrix.common.buffer.TupleSourceID;
import com.metamatrix.common.buffer.TupleSourceNotFoundException;
import com.metamatrix.common.comm.api.ClientConnection;
import com.metamatrix.common.comm.api.Message;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.queue.QueueSuspendedException;
import com.metamatrix.common.queue.QueueWorkerFactory;
import com.metamatrix.common.queue.WorkerPool;
import com.metamatrix.common.queue.WorkerPoolStats;
import com.metamatrix.dqp.DQPPlugin;
import com.metamatrix.dqp.internal.cache.CacheID;
import com.metamatrix.dqp.internal.cache.ResultSetCache;
import com.metamatrix.dqp.internal.cache.ResultSetCacheUtil;
import com.metamatrix.dqp.internal.datamgr.ConnectorID;
import com.metamatrix.dqp.internal.process.ConnectorRequest;
import com.metamatrix.dqp.internal.process.DataTierManager;
import com.metamatrix.dqp.internal.process.MessageHandler;
import com.metamatrix.dqp.internal.process.PreparedPlanCache;
import com.metamatrix.dqp.internal.process.ProcessWorkerFactory;
import com.metamatrix.dqp.internal.process.QueueAdapter;
import com.metamatrix.dqp.internal.process.Request;
import com.metamatrix.dqp.internal.process.RequestManager;
import com.metamatrix.dqp.internal.process.TempTableStoresHolder;
import com.metamatrix.dqp.internal.process.WorkItem;
import com.metamatrix.dqp.internal.process.WorkQueue;
import com.metamatrix.dqp.message.AtomicRequestMessage;
import com.metamatrix.dqp.message.DQPInboundMessage;
import com.metamatrix.dqp.message.DQPMessage;
import com.metamatrix.dqp.message.RequestID;
import com.metamatrix.dqp.message.RequestMessage;
import com.metamatrix.dqp.message.ResultsMessage;
import com.metamatrix.dqp.service.BufferService;
import com.metamatrix.dqp.service.DataService;
import com.metamatrix.dqp.service.MetadataService;
import com.metamatrix.dqp.service.TrackingService;
import com.metamatrix.dqp.service.TransactionService;
import com.metamatrix.dqp.service.VDBService;
import com.metamatrix.license.LicenseChecker;
import com.metamatrix.query.processor.QueryProcessor;
import com.metamatrix.query.sql.lang.Command;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.transaction.InvalidTransactionException;
import javax.transaction.SystemException;

public class DQPCore {
    private int maxCodeTableRecords = 10000;
    private int maxCodeTables = 20;
    private static final int DEFAULT_MAX_CODE_TABLE_RECORDS = 10000;
    private static final int DEFAULT_MAX_CODE_TABLES = 20;
    private static final int DEFAULT_PROCESSOR_TIMESLICE = 2000;
    private ApplicationEnvironment env;
    private Map connectorCapabilitiesCache;
    private BufferManager bufferManager;
    private DataTierManager dataTierMgr;
    private RequestManager requestMgr = new RequestManager();
    private PreparedPlanCache prepPlanCache;
    private TrackingService tracker;
    private TransactionService transactionService;
    private MetadataService metadataService;
    private ResultSetCache rsCache;
    private WorkerPool processWorkerPool;
    private boolean processDebugAllowed;
    private boolean updatesAllowed;
    private boolean virtualLayerAllowed;
    private boolean xmlAllowed;
    private static final String PROCESS_PLAN_QUEUE_NAME = "QueryProcessorQueue";
    private MessageHandler messageHandler = null;
    private TempTableStoresHolder tempTableStoresHolder;
    private int chunkSize = 0;

    public DQPCore(ApplicationEnvironment env) {
        this.env = env;
        Properties props = env.getApplicationProperties();
        boolean DQPAllowed = LicenseChecker.hasValidProductLicense((String)"Query Engine", (String)"5.5", (boolean)false);
        LogManager.logInfo((String)"DQP", (String)DQPPlugin.Util.getString("DQPCore.License_allows_DQP_{0}", (Object)Boolean.valueOf(DQPAllowed).toString()));
        this.updatesAllowed = LicenseChecker.hasValidProductLicense((String)"Query/Updates", (String)"5.5", (boolean)false);
        LogManager.logInfo((String)"DQP", (String)DQPPlugin.Util.getString("DQPCore.License_allows_updates__{0}", (Object)Boolean.valueOf(this.updatesAllowed).toString()));
        this.virtualLayerAllowed = LicenseChecker.hasValidProductLicense((String)"Views/Relational", (String)"5.5", (boolean)false);
        LogManager.logInfo((String)"DQP", (String)DQPPlugin.Util.getString("DQPCore.virtual_allowed", (Object)this.virtualLayerAllowed));
        this.xmlAllowed = LicenseChecker.hasValidProductLicense((String)"Views/XML", (String)"5.5", (boolean)false);
        LogManager.logInfo((String)"DQP", (String)DQPPlugin.Util.getString("DQPCore.xml_allowed", (Object)this.xmlAllowed));
        this.chunkSize = this.getDefaultChunkSize();
        Properties rsCacheProps = null;
        if (Boolean.valueOf(props.getProperty("ResultSetCacheEnabled", "false")).booleanValue()) {
            rsCacheProps = new Properties();
            rsCacheProps.setProperty("maxSize", props.getProperty("ResultSetCacheMaxSize", "0"));
            rsCacheProps.setProperty("maxAge", props.getProperty("ResultSetCacheMaxAge", "0"));
            rsCacheProps.setProperty("scope", props.getProperty("ResultSetCacheScope", "vdb"));
            try {
                this.rsCache = new ResultSetCache(rsCacheProps);
            }
            catch (MetaMatrixComponentException e) {
                LogManager.logWarning((String)"DQP", (Throwable)e, (String)DQPPlugin.Util.getString("DQPCORE.6"));
            }
        }
        int maxSizeTotal = Integer.parseInt(props.getProperty("MaxPlanCacheSize", "" + PreparedPlanCache.DEFAULT_MAX_SIZE_TOTAL));
        this.prepPlanCache = new PreparedPlanCache(maxSizeTotal);
        String procDebugStr = props.getProperty("ProcessorDebugAllowed", "false");
        Boolean procDebugAllowed = Boolean.valueOf(procDebugStr);
        LogManager.logInfo((String)"DQP", (String)DQPPlugin.Util.getString("DQPCore.Processor_debug_allowed_{0}", this.processDebugAllowed));
        this.initialize(this.getInteger(props, "MinFetchSize", "DQPCore.Exception_trying_to_determine_min_fetch_size."), this.getInteger(props, "MaxFetchSize", "DQPCore.Exception_trying_to_determine_max_fetch_size."), this.getInteger(props, "MaxCodeTables", "DQPCore.Exception_trying_to_determine_maximum_number_of_code_tables."), this.getInteger(props, "MaxCodeTableRecords", "DQPCore.Exception_trying_to_determine_maximum_record_size_of_a_code_table."), this.getInteger(props, "ProcessorTimeslice", "DQPCore.Exception_trying_to_determine_processor_timeslice_from_{0}."), Integer.parseInt(props.getProperty("ProcessPoolMaxThreads", "15")), Integer.parseInt(props.getProperty("ProcessPoolThreadTTL", "120000")), procDebugAllowed);
    }

    private Integer getInteger(Properties props, String propertyName, String errorMessageKey) {
        String propertyText = props.getProperty(propertyName);
        if (propertyText != null) {
            try {
                return new Integer(propertyText);
            }
            catch (NumberFormatException e) {
                DQPPlugin.logWarning((Exception)e, (String)errorMessageKey, (Object[])new Object[]{propertyText});
            }
        }
        return null;
    }

    private void initialize(Integer minFetchSize, Integer maxFetchSize, Integer maxCodeTables, Integer maxCodeTableRecords, Integer processorTimeslice, int maxThreads, int threadTTL, boolean procDebugFlag) {
        this.initializeSettings(minFetchSize, maxFetchSize, maxCodeTables, maxCodeTableRecords, procDebugFlag);
        this.initializeServices();
        this.initializeProcessing(maxThreads, threadTTL, processorTimeslice);
        this.connectorCapabilitiesCache = new HashMap();
        this.messageHandler = new MessageHandler(this, this.tracker, this.transactionService, this.metadataService, this.requestMgr, this.prepPlanCache, this.env, this.tempTableStoresHolder);
    }

    private void initializeSettings(Integer minFetchSizeSetting, Integer maxFetchSizeSetting, Integer maxCodeTablesSetting, Integer maxCodeTableRecordsSetting, boolean procDebugFlag) {
        if (maxCodeTablesSetting != null) {
            this.maxCodeTables = maxCodeTablesSetting;
        }
        if (maxCodeTableRecordsSetting != null) {
            this.maxCodeTableRecords = maxCodeTableRecordsSetting;
        }
        this.processDebugAllowed = procDebugFlag;
    }

    private void initializeServices() {
        BufferService bufferService = (BufferService)this.env.findService("dqp.buffer");
        this.bufferManager = bufferService.getBufferManager();
        this.tracker = (TrackingService)this.env.findService("dqp.tracking");
        this.transactionService = (TransactionService)this.env.findService("dqp.transaction");
        this.metadataService = (MetadataService)this.env.findService("dqp.metadata");
    }

    private void initializeProcessing(int maxThreads, int threadTTL, Integer processorTimesliceSetting) {
        int processorTimeslice = 2000;
        if (processorTimesliceSetting != null) {
            processorTimeslice = processorTimesliceSetting;
        }
        ProcessWorkerFactory processWorkerFactory = new ProcessWorkerFactory(this.requestMgr, this.bufferManager, processorTimeslice, this.tracker, this.rsCache, this.transactionService);
        this.processWorkerPool = new WorkerPool(PROCESS_PLAN_QUEUE_NAME, (QueueWorkerFactory)processWorkerFactory, maxThreads, (long)threadTTL);
        this.requestMgr.setWorkQueue((WorkQueue)new QueueAdapter(this.processWorkerPool));
        processWorkerFactory.setProcessPool(this.processWorkerPool);
        this.tempTableStoresHolder = new TempTableStoresHolder(this.bufferManager);
        this.dataTierMgr = new DataTierManager(this.requestMgr, (DataService)this.env.findService("dqp.data"), (MetadataService)this.env.findService("dqp.metadata"), (VDBService)this.env.findService("dqp.vdb"), (TransactionService)this.env.findService("dqp.transaction"), (BufferService)this.env.findService("dqp.buffer"), this.processWorkerPool, this.maxCodeTables, this.maxCodeTableRecords);
        processWorkerFactory.setDataTierManager(this.dataTierMgr);
    }

    public void stop() {
        this.processWorkerPool.shutdown();
    }

    public Message process(DQPInboundMessage message) throws Exception {
        return this.messageHandler.processMessage(message);
    }

    Collection getRequestsByClient(ClientConnection clientConnection) {
        return this.requestMgr.getRequestsByClient(clientConnection);
    }

    Map getRequestMapByClient(ClientConnection clientConnection) {
        return this.requestMgr.getRequestMapByClient(clientConnection);
    }

    Map getRequests() {
        return this.requestMgr.getRequests();
    }

    DQPMessage processRequestMessage(RequestMessage requestMsg) throws MetaMatrixComponentException, QueryParserException, QueryResolverException, QueryValidatorException, QueryPlannerException {
        RequestID requestID = requestMsg.getRequestID();
        Request request = Request.createRequest(requestMsg, this.env, this.prepPlanCache, this.bufferManager, this.dataTierMgr, this.connectorCapabilitiesCache, this.transactionService, this.updatesAllowed, this.processDebugAllowed, this.virtualLayerAllowed, this.xmlAllowed, this.tempTableStoresHolder.getTempTableStore(requestMsg.getConnectionID()));
        try {
            this.requestMgr.addRequest(requestMsg);
            if (this.areResultsInCache(requestMsg)) {
                request.validateEntitlement(requestMsg.getCommand());
                requestMsg.markProcessingStart();
                CacheID cID = ResultSetCacheUtil.createCacheID((RequestMessage)requestMsg, (ResultSetCache)this.rsCache);
                Command command = this.rsCache.getResults(cID, new int[]{1, 1}).getCommand();
                this.requestMgr.addRequestState(requestID, command, null, null, null, null);
                this.executeRequest(new WorkItem(requestID, this.rsCache));
            } else {
                request.processRequest();
                this.requestMgr.addRequestState(requestID, requestMsg.getCommand(), request.processor, request.context.getTupleSourceID(), request.analysisRecord, request.schemas);
                this.executeRequest(new WorkItem(requestID));
            }
            if (requestMsg.isSynchronousRequest()) {
                return new ResultsMessage(requestMsg, new List[0], Collections.EMPTY_LIST);
            }
            return null;
        }
        catch (QueryValidatorException e) {
            this.requestMgr.removeRequest(requestID);
            throw e;
        }
        catch (QueryParserException e) {
            this.requestMgr.removeRequest(requestID);
            throw e;
        }
        catch (QueryResolverException e) {
            this.requestMgr.removeRequest(requestID);
            throw e;
        }
        catch (QueryPlannerException e) {
            this.requestMgr.removeRequest(requestID);
            throw e;
        }
        catch (MetaMatrixComponentException e) {
            this.requestMgr.removeRequest(requestID);
            throw e;
        }
        catch (Throwable e) {
            this.requestMgr.removeRequest(requestID);
            throw new MetaMatrixComponentException(e);
        }
    }

    void executeRequest(WorkItem work) throws MetaMatrixComponentException {
        try {
            this.processWorkerPool.addWork((Object)work);
        }
        catch (QueueSuspendedException e) {
            throw new MetaMatrixComponentException((Throwable)e);
        }
    }

    boolean areResultsInCache(RequestMessage requestMsg) {
        if (this.rsCache == null) {
            return false;
        }
        if (!requestMsg.useResultSetCache()) {
            return false;
        }
        CacheID cID = ResultSetCacheUtil.createCacheID((RequestMessage)requestMsg, (ResultSetCache)this.rsCache);
        return this.rsCache.hasResults(cID);
    }

    void requestNextLobChunk(RequestID reqId, String streamId, int streamRequestId) throws MetaMatrixComponentException {
        if (LogManager.isMessageToBeRecorded((String)"DQP", (int)5)) {
            LogManager.logDetail((String)"DQP", (String)("Request for next Lob chunk with Stream id=" + streamId + " instance id=" + streamRequestId));
        }
        try {
            this.processWorkerPool.addWork((Object)new WorkItem(reqId, streamId, streamRequestId, this.chunkSize));
        }
        catch (QueueSuspendedException e) {
            throw new MetaMatrixComponentException((Throwable)e);
        }
    }

    void closeLobChunkStream(RequestID requestId, String streamId, int streamRequestId) throws MetaMatrixComponentException {
        if (LogManager.isMessageToBeRecorded((String)"DQP", (int)5)) {
            LogManager.logDetail((String)"DQP", (String)("Request to close the Lob stream with Stream id=" + streamId + " instance id=" + streamRequestId));
        }
        this.requestMgr.removeLobStream(requestId, streamId, streamRequestId);
    }

    void processCursorRequest(RequestID reqID, int batchFirst, int batchLast) throws MetaMatrixComponentException {
        if (LogManager.isMessageToBeRecorded((String)"DQP", (int)5)) {
            LogManager.logDetail((String)"DQP", (String)("DQP process cursor request from " + batchFirst + " to " + batchLast));
        }
        if (this.isValidRequestID(reqID)) {
            try {
                WorkItem workItem = this.hasResultsInCache(reqID) ? new WorkItem(reqID, this.rsCache) : new WorkItem(reqID);
                this.requestMgr.markNeedsResults(reqID, workItem, batchFirst, batchLast);
            }
            catch (QueueSuspendedException e) {
                throw new MetaMatrixComponentException((Throwable)e);
            }
        } else {
            throw new MetaMatrixComponentException(DQPPlugin.Util.getString("DQPCore.The_request_has_been_cancelled.", (Object)reqID));
        }
    }

    private boolean hasResultsInCache(RequestID reqID) {
        if (this.rsCache == null) {
            return false;
        }
        RequestMessage requestMsg = this.requestMgr.getRequest(reqID);
        if (requestMsg == null) {
            return false;
        }
        if (!requestMsg.useResultSetCache()) {
            return false;
        }
        CacheID cID = ResultSetCacheUtil.createCacheID((RequestMessage)requestMsg, (ResultSetCache)this.rsCache);
        return this.rsCache.hasResults(cID);
    }

    Collection getQueueStatistics() {
        if (this.processWorkerPool == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<WorkerPoolStats> statList = new ArrayList<WorkerPoolStats>(1);
        statList.add(this.processWorkerPool.getStats());
        return statList;
    }

    Collection getQueueStatistics(String name) {
        if (!name.equalsIgnoreCase(PROCESS_PLAN_QUEUE_NAME) || this.processWorkerPool == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<WorkerPoolStats> stats = new ArrayList<WorkerPoolStats>(2);
        stats.add(this.processWorkerPool.getStats());
        return stats;
    }

    void cancelAtomicRequest(RequestID requestID, int nodeID, ClientConnection clientConnection) throws MetaMatrixComponentException {
        if (clientConnection == null) {
            return;
        }
        RequestMessage request = this.requestMgr.getRequest(requestID);
        if (!request.supportsPartialResults()) {
            this.cancelRequest(requestID);
        } else {
            boolean canceled = false;
            List conInfoList = this.requestMgr.getAllConnectorInfo(requestID);
            if (conInfoList != null && !conInfoList.isEmpty()) {
                Iterator i = conInfoList.iterator();
                while (i.hasNext()) {
                    ConnectorRequest conInfo = (ConnectorRequest)i.next();
                    AtomicRequestMessage aqr = conInfo.getAtomicRequest();
                    if (aqr.getAtomicRequestID().getNodeID() != nodeID) continue;
                    this.cancelAtomicRequest(conInfo);
                    canceled = true;
                }
            }
            if (!canceled) {
                LogManager.logInfo((String)"DQP", (String)("Connector request not queued yet. RequestID=" + requestID + " Node id=" + nodeID));
            }
        }
    }

    void terminateConnection(ClientConnection clientConnection) throws MetaMatrixComponentException {
        if (clientConnection == null) {
            return;
        }
        String connectionID = (String)clientConnection.getConnectionProperty("connectionID");
        Iterator iter = this.requestMgr.getRequestsByClient(clientConnection).iterator();
        while (iter.hasNext()) {
            RequestMessage rMsg = (RequestMessage)((Object)iter.next());
            this.requestMgr.markRequestCancelled(rMsg.getRequestID());
            try {
                this.cancelRequest(rMsg.getRequestID());
            }
            catch (MetaMatrixComponentException err) {
                LogManager.logWarning((String)"DQP", (Throwable)err, (String)("Failed to cancel " + rMsg.getRequestID()));
            }
        }
        List requestIDs = this.requestMgr.getRequestIdByclient(clientConnection);
        Iterator i = requestIDs.iterator();
        while (i.hasNext()) {
            RequestID reqId = (RequestID)i.next();
            try {
                this.cancelRequest(reqId);
            }
            catch (MetaMatrixComponentException err) {
                LogManager.logWarning((String)"DQP", (Throwable)err, (String)("Failed to cancel " + reqId));
            }
        }
        if (connectionID != null) {
            try {
                this.bufferManager.removeTupleSources(connectionID);
            }
            catch (Exception e) {
                LogManager.logWarning((String)"DQP", (Throwable)e, (String)("Failed to remove buffered tuples for connection " + connectionID));
            }
        }
        this.clearPlanCache(clientConnection);
        if (this.transactionService != null) {
            try {
                this.transactionService.getTransactionServer().cancelTransactions(connectionID, false);
            }
            catch (InvalidTransactionException err) {
                LogManager.logWarning((String)"DQP", (String)("rollback failed for requestID=" + connectionID));
            }
            catch (SystemException err) {
                throw new MetaMatrixComponentException((Throwable)err);
            }
        }
    }

    private boolean isValidRequestID(RequestID requestID) {
        RequestMessage request = this.requestMgr.getRequest(requestID);
        return request != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void cancelRequest(RequestID requestID) throws MetaMatrixComponentException {
        if (LogManager.isMessageToBeRecorded((String)"DQP", (int)5)) {
            LogManager.logDetail((String)"DQP", (String)("cancelQuery for requestID=" + requestID));
        }
        markCancelled = false;
        if (this.isValidRequestID(requestID) && (markCancelled = this.requestMgr.markRequestCancelled(requestID))) {
            try {
                this.cancelAtomicRequests(requestID);
                var4_3 = null;
                this.notifyProcessorOfCancelling(requestID);
                ** if (this.transactionService == null) goto lbl-1000
            }
            catch (Throwable var3_9) {
                var4_4 = null;
                this.notifyProcessorOfCancelling(requestID);
                if (this.transactionService != null) {
                    try {
                        this.transactionService.getTransactionServer().cancelTransactions(requestID.getConnectionID(), true);
                    }
                    catch (InvalidTransactionException err) {
                        LogManager.logWarning((String)"DQP", (String)("rollback failed for requestID=" + requestID.getConnectionID()));
                    }
                    catch (SystemException err) {
                        throw new MetaMatrixComponentException((Throwable)err);
                    }
                }
                throw var3_9;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    this.transactionService.getTransactionServer().cancelTransactions(requestID.getConnectionID(), true);
                }
                catch (InvalidTransactionException err) {
                    LogManager.logWarning((String)"DQP", (String)("rollback failed for requestID=" + requestID.getConnectionID()));
                }
                catch (SystemException err) {
                    throw new MetaMatrixComponentException((Throwable)err);
                }
            }
lbl-1000:
            // 1 sources

            {
            }
        }
        if (!markCancelled) {
            throw new MetaMatrixComponentException(DQPPlugin.Util.getString("DQPCore.failed_to_cancel"));
        }
    }

    void closeRequest(RequestID requestID) throws MetaMatrixComponentException {
        if (LogManager.isMessageToBeRecorded((String)"DQP", (int)5)) {
            LogManager.logDetail((String)"DQP", (String)("closeQuery for requestID=" + requestID));
        }
        if (this.isValidRequestID(requestID)) {
            RequestMessage request = this.requestMgr.getRequest(requestID);
            MetaMatrixComponentException exception = null;
            this.clearCache(request);
            try {
                this.closeAtomicRequests(requestID);
            }
            catch (MetaMatrixComponentException e) {
                exception = e;
            }
            this.notifyProcessorOfClosing(requestID);
            try {
                this.removeTupleSource(requestID);
            }
            catch (MetaMatrixComponentException e) {
                exception = e;
            }
            this.requestMgr.removeRequest(requestID);
            if (exception != null) {
                throw exception;
            }
        }
    }

    private void cancelAtomicRequests(RequestID requestID) throws MetaMatrixComponentException {
        List conInfoList = this.requestMgr.getAllConnectorInfo(requestID);
        if (conInfoList != null && !conInfoList.isEmpty()) {
            Iterator i = conInfoList.iterator();
            while (i.hasNext()) {
                ConnectorRequest conInfo = (ConnectorRequest)i.next();
                this.cancelAtomicRequest(conInfo);
            }
        }
    }

    private void cancelAtomicRequest(ConnectorRequest conInfo) throws MetaMatrixComponentException {
        if (conInfo == null) {
            return;
        }
        ConnectorID connectorID = conInfo.getConnectorID();
        if (connectorID != null) {
            AtomicRequestMessage cancelRequest = conInfo.getAtomicRequest();
            cancelRequest.setType(3);
            cancelRequest.setConnectorID(connectorID);
            this.dataTierMgr.registerRequest(cancelRequest);
        }
    }

    private void closeAtomicRequests(RequestID requestID) throws MetaMatrixComponentException {
        List conInfoList = this.requestMgr.getAllConnectorInfo(requestID);
        if (conInfoList != null && !conInfoList.isEmpty()) {
            Iterator i = conInfoList.iterator();
            while (i.hasNext()) {
                ConnectorRequest conInfo = (ConnectorRequest)i.next();
                this.closeAtomicRequest(conInfo);
            }
        }
    }

    private void closeAtomicRequest(ConnectorRequest conInfo) throws MetaMatrixComponentException {
        if (conInfo == null) {
            return;
        }
        ConnectorID connectorID = conInfo.getConnectorID();
        if (connectorID != null) {
            AtomicRequestMessage closeRequest = conInfo.getAtomicRequest();
            closeRequest.setType(4);
            closeRequest.setConnectorID(connectorID);
            this.dataTierMgr.registerRequest(closeRequest);
        }
    }

    private void removeTupleSource(RequestID requestID) throws MetaMatrixComponentException {
        if (LogManager.isMessageToBeRecorded((String)"DQP", (int)5)) {
            LogManager.logDetail((String)"DQP", (String)("Removing tuplesource for the request " + requestID));
        }
        try {
            TupleSourceID tupleSourceID = this.requestMgr.getResultsID(requestID);
            if (tupleSourceID == null) {
                return;
            }
            this.bufferManager.removeTupleSource(tupleSourceID);
        }
        catch (TupleSourceNotFoundException tupleSourceNotFoundException) {
            // empty catch block
        }
    }

    private void notifyProcessorOfCancelling(RequestID requestID) {
        QueryProcessor processor = this.requestMgr.getProcessor(requestID);
        if (processor != null) {
            processor.requestCancelled();
        }
        try {
            this.requestMgr.markHasData(requestID, new WorkItem(requestID));
        }
        catch (QueueSuspendedException queueSuspendedException) {
            // empty catch block
        }
    }

    private void notifyProcessorOfClosing(RequestID requestID) {
        QueryProcessor processor = this.requestMgr.getProcessor(requestID);
        if (processor != null) {
            processor.requestClosed();
        }
    }

    private void clearCache(RequestMessage request) {
        if (this.rsCache != null && request != null) {
            CacheID cID = ResultSetCacheUtil.createCacheID((RequestMessage)request, (ResultSetCache)this.rsCache);
            this.rsCache.removeTempResults(cID);
        }
    }

    private void clearPlanCache(ClientConnection clientConn) {
        if (clientConn == null) {
            return;
        }
        this.prepPlanCache.clear(clientConn);
    }

    void clearPlanCache() {
        LogManager.logInfo((String)"DQP", (String)DQPPlugin.Util.getString("DQPCore.Clearing_prepared_plan_cache"));
        this.prepPlanCache.clearAll();
    }

    void clearCodeTableCache() {
        LogManager.logInfo((String)"DQP", (String)DQPPlugin.Util.getString("DQPCore.Clearing_code_table_cache"));
        this.dataTierMgr.clearCodeTables();
    }

    void clearResultSetCache() {
        if (this.rsCache != null) {
            this.rsCache.clear();
        }
    }

    int getFinalRowCount(RequestID requestID) {
        TupleSourceID tupleSourceID = this.requestMgr.getResultsID(requestID);
        try {
            return this.bufferManager.getFinalRowCount(tupleSourceID);
        }
        catch (Throwable t) {
            return -1;
        }
    }

    int getDefaultChunkSize() {
        int size;
        String streamingBatchSize;
        Properties envProps = this.env.getApplicationProperties();
        if (envProps != null && (streamingBatchSize = envProps.getProperty("metamatrix.server.streamingBatchSize")) != null && (size = Integer.parseInt(streamingBatchSize) * 1024) > 0) {
            return size;
        }
        return 10240;
    }
}

