/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.internal.datamgr.impl;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.application.basic.BasicApplication;
import com.metamatrix.common.application.exception.ApplicationLifecycleException;
import com.metamatrix.common.comm.api.ClientConnection;
import com.metamatrix.common.comm.api.Message;
import com.metamatrix.common.comm.api.ServerListener;
import com.metamatrix.common.comm.exception.ApplicationException;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.queue.QueueSuspendedException;
import com.metamatrix.common.queue.QueueWorkerFactory;
import com.metamatrix.common.queue.WorkerPool;
import com.metamatrix.common.queue.WorkerPoolStats;
import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.common.xa.TransactionID;
import com.metamatrix.data.api.Connection;
import com.metamatrix.data.api.Connector;
import com.metamatrix.data.api.ConnectorCapabilities;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.api.ConnectorLogger;
import com.metamatrix.data.api.ExecutionContext;
import com.metamatrix.data.api.GlobalConnectorCapabilitiesProvider;
import com.metamatrix.data.api.SecurityContext;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.monitor.AliveStatus;
import com.metamatrix.data.monitor.ConnectionStatus;
import com.metamatrix.data.monitor.MonitoredConnector;
import com.metamatrix.data.xa.api.XAConnector;
import com.metamatrix.dqp.DQPPlugin;
import com.metamatrix.dqp.internal.cache.ResultSetCache;
import com.metamatrix.dqp.internal.cache.connector.CacheConnector;
import com.metamatrix.dqp.internal.datamgr.CapabilitiesConverter;
import com.metamatrix.dqp.internal.datamgr.ConnectorID;
import com.metamatrix.dqp.internal.datamgr.exception.ConnectorInitializationException;
import com.metamatrix.dqp.internal.datamgr.impl.ConnectorEnvironmentImpl;
import com.metamatrix.dqp.internal.datamgr.impl.ConnectorRequestStateManager;
import com.metamatrix.dqp.internal.datamgr.impl.ConnectorWorkerFactory;
import com.metamatrix.dqp.internal.datamgr.impl.DefaultConnectorLogger;
import com.metamatrix.dqp.internal.datamgr.impl.ExecutionContextImpl;
import com.metamatrix.dqp.internal.datamgr.impl.NullMonitoredConnector;
import com.metamatrix.dqp.message.AdminRequestMessage;
import com.metamatrix.dqp.message.AdminResultsMessage;
import com.metamatrix.dqp.message.AtomicRequestID;
import com.metamatrix.dqp.message.AtomicRequestMessage;
import com.metamatrix.dqp.message.CapabilitiesMessage;
import com.metamatrix.dqp.message.DQPInboundMessage;
import com.metamatrix.dqp.message.DQPMessage;
import com.metamatrix.dqp.message.MessageProcessor;
import com.metamatrix.dqp.message.ResultsMessage;
import com.metamatrix.dqp.service.MetadataService;
import com.metamatrix.dqp.service.TrackingService;
import com.metamatrix.dqp.service.TransactionService;
import com.metamatrix.dqp.transaction.TransactionServer;
import com.metamatrix.query.sql.lang.Command;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;

public class ConnectorManager
extends BasicApplication {
    public static final String DEFAULT_MAX_PROCESSOR_THREADS = "15";
    public static final String DEFAULT_PROCESSOR_TREAD_TTL = "120000";
    private ConnectorEnvironment connectorEnv;
    private Connector connector;
    private MonitoredConnector monitoredConnector;
    private Collection clientConnections = new HashSet();
    private ConnectorRequestStateManager connectorStateManager;
    private ConnectorID connectorID;
    private WorkerPool connectorWorkerPool;
    private ConnectorWorkerFactory connectorWorkerFactory;
    private MetadataService metadataService;
    private TrackingService tracker;
    private TransactionService transactionService;
    private boolean poolIsOpen;
    private ServerListener listenerFilter = new InternalServerListener();

    protected void addWork(AtomicRequestMessage message) throws QueueSuspendedException {
        this.connectorWorkerPool.addWork((Object)message);
    }

    public String getName() {
        String name = null;
        if (this.connectorID != null) {
            name = this.connectorID.toString();
        }
        return name;
    }

    public ConnectionStatus getStatus() {
        if (this.monitoredConnector != null) {
            return this.monitoredConnector.getStatus();
        }
        return new ConnectionStatus(AliveStatus.UNKNOWN);
    }

    public void setConnectorID(ConnectorID connectorID) {
        this.connectorID = connectorID;
    }

    public ConnectorID getConnectorID() {
        return this.connectorID;
    }

    public void clearPool(boolean force) {
        this.poolIsOpen = false;
        if (force && this.connectorWorkerPool != null) {
            this.connectorWorkerPool.shutdown();
            this.connectorWorkerPool = null;
        }
    }

    public void start() throws ApplicationLifecycleException {
        Properties appProps = this.getEnvironment().getApplicationProperties();
        String connectorName = appProps.getProperty("ConnectorBindingName");
        if (this.connectorID == null) {
            String connIDStr = appProps.getProperty("ConnectorID");
            this.connectorID = new ConnectorID(connIDStr);
        }
        DQPPlugin.logInfo((String)"ConnectorManagerImpl.Initializing_connector", (Object[])new Object[]{connectorName});
        this.transactionService = (TransactionService)this.getEnvironment().findService("dqp.transaction");
        String connectorClassString = appProps.getProperty("ConnectorClass");
        if (connectorClassString == null || connectorClassString.trim().length() == 0) {
            String msg = DQPPlugin.logError((String)"Missing_required_property", (Object[])new Object[]{"ConnectorClass", connectorName});
            throw new ApplicationLifecycleException(msg);
        }
        connectorClassString = connectorClassString.trim();
        Properties clonedProps = PropertiesUtils.clone((Properties)appProps);
        this.connectorEnv = new ConnectorEnvironmentImpl(clonedProps, (ConnectorLogger)new DefaultConnectorLogger(this.connectorID), this.getEnvironment());
        this.initStartConnector(connectorName, this.connectorEnv);
        this.metadataService = (MetadataService)this.getEnvironment().findService("dqp.metadata");
        if (this.metadataService == null) {
            String msg = DQPPlugin.logError((String)"Failed_to_find_service", (Object[])new Object[]{"dqp.metadata", connectorName});
            throw new ApplicationLifecycleException(msg);
        }
        this.tracker = (TrackingService)this.getEnvironment().findService("dqp.tracking");
        try {
            this.createConnectorPool(appProps);
        }
        catch (ConnectorInitializationException e) {
            throw new ApplicationLifecycleException((CoreException)e);
        }
        this.poolIsOpen = true;
    }

    public boolean started() {
        return this.poolIsOpen;
    }

    public void stop() throws ApplicationLifecycleException {
        super.stop();
        this.stopMyself();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopMyself() {
        Properties appProps = this.getEnvironment().getApplicationProperties();
        String connectorName = appProps.getProperty("ConnectorBindingName");
        this.poolIsOpen = false;
        this.notifyClosing();
        if (this.connectorWorkerPool != null) {
            this.connectorWorkerPool.shutdown();
        }
        if (this.connector != null) {
            if (this.connector instanceof XAConnector && this.transactionService != null) {
                TransactionServer ts = this.transactionService.getTransactionServer();
                ts.removeRecoverySource(connectorName);
            }
            Thread currentThread = Thread.currentThread();
            ClassLoader threadContextLoader = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(this.connector.getClass().getClassLoader());
                this.connector.stop();
            }
            finally {
                currentThread.setContextClassLoader(threadContextLoader);
            }
            if (this.connector instanceof CacheConnector) {
                ((CacheConnector)this.connector).getCache().shutDown();
            }
        }
        if (this.connectorStateManager != null) {
            this.connectorStateManager.shutdown();
        }
    }

    public void restart() throws ApplicationLifecycleException {
        this.stopMyself();
        this.start();
    }

    public Connector getConnector() {
        return this.connector;
    }

    private Collection getQueueStatistics() {
        if (this.connectorWorkerPool == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<WorkerPoolStats> statList = new ArrayList<WorkerPoolStats>(1);
        statList.add(this.connectorWorkerPool.getStats());
        return statList;
    }

    private Collection getQueueStatistics(String name) {
        if (this.connectorID == null || !name.equalsIgnoreCase(this.connectorID.getID()) || this.connectorWorkerPool == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<WorkerPoolStats> stats = new ArrayList<WorkerPoolStats>(2);
        stats.add(this.connectorWorkerPool.getStats());
        return stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyClosing() {
        Collection collection = this.clientConnections;
        synchronized (collection) {
            Iterator clientConnectionItr = this.clientConnections.iterator();
            while (clientConnectionItr.hasNext()) {
                ClientConnection clientConnection = (ClientConnection)clientConnectionItr.next();
                try {
                    clientConnection.shutdown();
                }
                catch (CommunicationException e) {
                    DQPPlugin.logError((String)"Error_closing_client_connection", null);
                }
            }
        }
    }

    private void sendResult(ClientConnection connection, ResultsMessage msg, String key) {
        try {
            if (msg.getException() != null) {
                Object[] params = new Object[]{msg.getRequestID(), msg.getException()};
                DQPPlugin.logError((String)"RequestMessage_failed_Cause", (Object[])params);
            }
            connection.send((Message)msg, key);
        }
        catch (CommunicationException e) {
            DQPPlugin.logError((Exception)((Object)e), (String)"Unable_to_notify_client_of_failure", (Object[])new Object[]{connection.getConnectionProperty("connectionID"), msg.getException().getMessage()});
        }
    }

    private void createConnectorPool(Properties appProps) throws ConnectorInitializationException {
        String threadTTLString;
        this.connectorStateManager = new ConnectorRequestStateManager(this.connector, this);
        this.connectorWorkerFactory = new ConnectorWorkerFactory(this.connectorStateManager, this.getEnvironment(), this.metadataService, this.transactionService, this.connector.getClass().getClassLoader());
        String maxThreadsString = appProps.getProperty("ConnectorMaxThreads");
        if (maxThreadsString == null || maxThreadsString.trim().length() == 0) {
            maxThreadsString = DEFAULT_MAX_PROCESSOR_THREADS;
            DQPPlugin.logWarning((String)"using_default_value", (Object[])new Object[]{"ConnectorMaxThreads", DEFAULT_MAX_PROCESSOR_THREADS});
        }
        if ((threadTTLString = appProps.getProperty("ConnectorThreadTTL")) == null || threadTTLString.trim().length() == 0) {
            threadTTLString = DEFAULT_PROCESSOR_TREAD_TTL;
            DQPPlugin.logWarning((String)"using_default_value", (Object[])new Object[]{"ConnectorThreadTTL", DEFAULT_PROCESSOR_TREAD_TTL});
        }
        int maxThreads = 0;
        int threadTTL = 0;
        try {
            maxThreads = Integer.parseInt(maxThreadsString);
        }
        catch (NumberFormatException e) {
            throw new ConnectorInitializationException((Throwable)e, DQPPlugin.Util.getString("Unable_to_parse_required_property", new Object[]{maxThreadsString, "ConnectorMaxThreads", this.connectorID}));
        }
        try {
            threadTTL = Integer.parseInt(threadTTLString);
        }
        catch (NumberFormatException e) {
            throw new ConnectorInitializationException((Throwable)e, DQPPlugin.Util.getString("Unable_to_parse_required_property", new Object[]{threadTTLString, "ConnectorThreadTTL", this.connectorID}));
        }
        String connectorName = appProps.getProperty("ConnectorBindingName");
        if (connectorName == null) {
            connectorName = "Unknown_Binding_Name";
        }
        String threadName = connectorName + "_" + this.connectorID.getID();
        this.connectorWorkerPool = new WorkerPool(threadName, (QueueWorkerFactory)this.connectorWorkerFactory, maxThreads, (long)threadTTL);
        this.connectorWorkerFactory.setWorkerPool(this.connectorWorkerPool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initStartConnector(String connectorName, ConnectorEnvironment env) throws ApplicationLifecycleException {
        String connectorClassName = env.getProperties().getProperty("ConnectorClass");
        ClassLoader loader = (ClassLoader)this.getEnvironment().getApplicationProperties().get("ConnectorClassLoader");
        if (loader == null) {
            loader = ((Object)((Object)this)).getClass().getClassLoader();
        }
        Class<?> clazz = null;
        try {
            clazz = loader.loadClass(connectorClassName);
        }
        catch (ClassNotFoundException e) {
            String msg = DQPPlugin.logError((Exception)e, (String)"failed_find_Connector_class", (Object[])new Object[]{connectorClassName});
            throw new ApplicationLifecycleException((Throwable)e, msg);
        }
        try {
            this.connector = (Connector)clazz.newInstance();
            if (this.connector instanceof XAConnector) {
                if (this.transactionService == null) {
                    String bindingName = (String)this.getEnvironment().getApplicationProperties().get("ConnectorBindingName");
                    String msg = DQPPlugin.Util.getString("no_txn_manager", new Object[]{bindingName});
                    throw new ApplicationLifecycleException(msg);
                }
                TransactionServer ts = this.transactionService.getTransactionServer();
                ts.registerRecoverySource(connectorName, (XAConnector)this.connector);
            }
            this.monitoredConnector = this.connector instanceof MonitoredConnector ? (MonitoredConnector)this.connector : new NullMonitoredConnector();
            this.connector = this.wrapCacheConnector();
        }
        catch (InstantiationException e) {
            String msg = DQPPlugin.logError((Exception)e, (String)"failed_instantiate_Connector_class", (Object[])new Object[]{connectorClassName});
            throw new ApplicationLifecycleException((Throwable)e, msg);
        }
        catch (IllegalAccessException e) {
            String msg = DQPPlugin.logError((Exception)e, (String)"failed_access_Connector_class", (Object[])new Object[]{connectorClassName});
            throw new ApplicationLifecycleException((Throwable)e, msg);
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader threadContextLoader = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(loader);
            try {
                this.connector.initialize(env);
            }
            catch (ConnectorException e) {
                String msg = DQPPlugin.logError((Exception)((Object)e), (String)"failed_to_initialize", (Object[])new Object[]{connectorClassName});
                throw new ApplicationLifecycleException((Throwable)((Object)e), msg);
            }
            try {
                this.connector.start();
            }
            catch (ConnectorException e) {
                String msg = DQPPlugin.logError((Exception)((Object)e), (String)"failed_start_Connector", (Object[])new Object[]{this.getConnectorID(), e.getMessage()});
                throw new ApplicationLifecycleException((Throwable)((Object)e), msg);
            }
        }
        finally {
            currentThread.setContextClassLoader(threadContextLoader);
        }
    }

    private Connector wrapCacheConnector() {
        Properties props = this.connectorEnv.getProperties();
        Properties rsCacheProps = null;
        if (Boolean.valueOf(props.getProperty("ResultSetCacheEnabled", "false")).booleanValue()) {
            rsCacheProps = new Properties();
            rsCacheProps.setProperty("maxSize", props.getProperty("ResultSetCacheMaxSize", "0"));
            rsCacheProps.setProperty("maxAge", props.getProperty("ResultSetCacheMaxAge", "0"));
            rsCacheProps.setProperty("scope", props.getProperty("ResultSetCacheScope", "vdb"));
            try {
                ResultSetCache rsCache = new ResultSetCache(rsCacheProps);
                return new CacheConnector(this.connector, rsCache);
            }
            catch (MetaMatrixComponentException e) {
                LogManager.logWarning((String)"CONNECTOR", (Throwable)e, (String)DQPPlugin.Util.getString("DQPCORE.6"));
            }
        }
        return this.connector;
    }

    public void connectionAdded(ClientConnection connection) {
        this.listenerFilter.connectionAdded(connection);
    }

    public void connectionRemoved(ClientConnection connection) {
        this.listenerFilter.connectionRemoved(connection);
    }

    public void receive(ClientConnection connection, Message message, String messageKey) {
        this.listenerFilter.receive(connection, message, messageKey);
    }

    public Message receive(ClientConnection connection, Message message) throws ApplicationException {
        return this.listenerFilter.receive(connection, message);
    }

    public ConnectorEnvironment getConnectorEnvironment() {
        return this.connectorEnv;
    }

    void logSRCCommand(AtomicRequestMessage qr, short cmdStatus, int finalRowCnt, ExecutionContext context) {
        if (this.tracker == null || !this.tracker.willRecordSrcCmd()) {
            return;
        }
        Command sqlCmd = null;
        if (cmdStatus == 1) {
            sqlCmd = qr.getCommand();
        }
        String userName = qr.getUserName();
        TransactionID transactionID = null;
        if (qr.isTransactional()) {
            transactionID = qr.getTransactionContext().getTxnID();
        }
        String modelName = qr.getModelName();
        AtomicRequestID id = qr.getAtomicRequestID();
        this.tracker.log(qr.getRequestID().toString(), (long)id.getNodeID(), transactionID == null ? null : transactionID.getID(), cmdStatus, modelName == null ? "null" : modelName, qr.getConnectorBindingID(), cmdStatus == 1 ? (short)1 : 2, qr.getConnectionID(), userName == null ? "unknown" : userName, sqlCmd, finalRowCnt, context);
    }

    class InternalServerListener
    extends MessageProcessor
    implements ServerListener {
        InternalServerListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connectionAdded(ClientConnection connection) {
            Collection collection = ConnectorManager.this.clientConnections;
            synchronized (collection) {
                ConnectorManager.this.clientConnections.add(connection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connectionRemoved(ClientConnection connection) {
            Collection collection = ConnectorManager.this.clientConnections;
            synchronized (collection) {
                ConnectorManager.this.clientConnections.remove(connection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DQPMessage process(CapabilitiesMessage message) throws Exception {
            Connection conn = null;
            try {
                ExecutionContextImpl context = new ExecutionContextImpl(message.getVdbName(), message.getVdbVersion(), message.getUserName(), message.getTrustedPayload(), message.getExecutionPayload(), "capabilities-request", ConnectorManager.this.connectorID.getID(), message.getRequestID().toString(), "capabilities-request", "0", false, false);
                Thread currentThread = Thread.currentThread();
                ClassLoader threadContextLoader = currentThread.getContextClassLoader();
                try {
                    ConnectorCapabilities caps;
                    block12: {
                        currentThread.setContextClassLoader(ConnectorManager.this.connector.getClass().getClassLoader());
                        caps = null;
                        try {
                            conn = ConnectorManager.this.connector.getConnection((SecurityContext)context);
                            caps = conn.getCapabilities();
                        }
                        catch (ConnectorException e) {
                            if (ConnectorManager.this.connector instanceof GlobalConnectorCapabilitiesProvider) {
                                caps = ((GlobalConnectorCapabilitiesProvider)ConnectorManager.this.connector).getCapabilities();
                            }
                            if (caps != null) break block12;
                            throw new ApplicationException((Throwable)((Object)e), DQPPlugin.Util.getString("ConnectorStateManager.Unable_to_create_connection_for_request", new Object[]{message}));
                        }
                    }
                    ResultsMessage result = new ResultsMessage();
                    result.setSourceCapabilities((Object)CapabilitiesConverter.convertCapabilities(caps, ConnectorManager.this.getName()));
                    ResultsMessage resultsMessage = result;
                    currentThread.setContextClassLoader(threadContextLoader);
                    return resultsMessage;
                }
                catch (Throwable throwable) {
                    try {
                        currentThread.setContextClassLoader(threadContextLoader);
                        throw throwable;
                    }
                    catch (ConnectorException e) {
                        throw new ApplicationException((Throwable)((Object)e), DQPPlugin.Util.getString("ConnectorStateManager.Unable_to_create_connection_for_request", new Object[]{message}));
                    }
                }
            }
            finally {
                if (conn != null) {
                    conn.release();
                }
            }
        }

        public DQPMessage process(AdminRequestMessage message) throws Exception {
            switch (message.getRequestType()) {
                case 2: {
                    return new AdminResultsMessage(ConnectorManager.this.getQueueStatistics());
                }
                case 3: {
                    return new AdminResultsMessage(ConnectorManager.this.getQueueStatistics(message.getMsgParam()));
                }
                case 6: {
                    if (ConnectorManager.this.connector instanceof CacheConnector) {
                        ((CacheConnector)ConnectorManager.this.connector).getCache().clear();
                    }
                    return null;
                }
            }
            return null;
        }

        protected DQPMessage wrongMessage(DQPInboundMessage message) throws Exception {
            throw new ConnectorException(DQPPlugin.Util.getString("wrong_message_type", new Object[]{ConnectorManager.this.connectorID, message.getRequestID(), message.getClass()}));
        }

        public Message receive(ClientConnection connection, Message message) throws ApplicationException {
            try {
                DQPInboundMessage incomingMessage = (DQPInboundMessage)message;
                return incomingMessage.process((MessageProcessor)this);
            }
            catch (Exception e) {
                ResultsMessage resultsMsg = new ResultsMessage();
                resultsMsg.setException((Throwable)e);
                return resultsMsg;
            }
        }

        public void receive(ClientConnection connection, Message message, String messageKey) {
            ResultsMessage result = null;
            Object error = null;
            if (message == null) {
                error = new ConnectorException(DQPPlugin.Util.getString("received_null_message", new Object[]{ConnectorManager.this.connectorID}));
            } else {
                DQPInboundMessage inMessage = (DQPInboundMessage)message;
                inMessage.setClientConnection(connection);
                inMessage.setMessageKey(messageKey);
                try {
                    result = (ResultsMessage)inMessage.process((MessageProcessor)this);
                }
                catch (Exception e) {
                    error = e;
                }
            }
            if (error != null) {
                result = new ResultsMessage();
                result.setException((Throwable)error);
            }
            if (result != null) {
                ConnectorManager.this.sendResult(connection, result, messageKey);
            }
        }

        public DQPMessage process(AtomicRequestMessage message) throws Exception {
            if (!ConnectorManager.this.poolIsOpen) {
                throw new ApplicationLifecycleException(DQPPlugin.Util.getString("Connector_Shutting_down", new Object[]{message.getAtomicRequestID(), ConnectorManager.this.connectorID}));
            }
            message.setConnectorID(ConnectorManager.this.connectorID);
            if (message.getType() == 1) {
                ConnectorManager.this.connectorStateManager.createState(message);
                message.markProcessingStart();
            } else {
                boolean isCancel = message.getType() == 3;
                boolean isCancelled = ConnectorManager.this.connectorStateManager.isCancelled(message);
                if (isCancel && !isCancelled) {
                    try {
                        LogManager.logDetail((String)"CONNECTOR", (Object[])new Object[]{message.getAtomicRequestID(), "Processing CANCEL request"});
                        ConnectorManager.this.connectorStateManager.asynchCancel(message);
                        ConnectorManager.this.connectorStateManager.logSRCCommand(message, (short)3, -1);
                    }
                    catch (ConnectorException e) {
                        LogManager.logError((String)"CONNECTOR", (Throwable)((Object)e), (String)DQPPlugin.Util.getString("Cancel_request_failed", new Object[]{message.getAtomicRequestID()}));
                    }
                    return null;
                }
            }
            ConnectorManager.this.addWork(message);
            return null;
        }
    }
}

