/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.salesforce.connection;

import com.metamatrix.connector.salesforce.Connector;
import com.metamatrix.connector.salesforce.connection.SalesforceConnection;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.api.ConnectorLogger;
import org.apache.commons.pool.BaseKeyedPoolableObjectFactory;

public class SalesforceConnectionPoolFactory
extends BaseKeyedPoolableObjectFactory {
    public static final int LOGIN_RETRY_COUNT = 4;
    private ConnectorLogger logger;
    private ConnectorEnvironment connectorEnv;
    private Connector connector;

    public SalesforceConnectionPoolFactory(Connector connector) {
        this.connector = connector;
        this.logger = connector.getConnectorEnv().getLogger();
    }

    public void activateObject(Object key, Object obj) throws Exception {
        SalesforceConnection connection = (SalesforceConnection)obj;
        this.logger.logTrace("activateObject: " + key.toString());
        int retryCount = 4;
        while (retryCount > 0) {
            try {
                connection.login();
                this.logger.logInfo("Connected to " + connection.getServerUrl() + " as " + connection.getUserId() + " with session id " + connection.getSessionId());
                break;
            }
            catch (Exception e) {
                if (--retryCount <= 0) {
                    this.logger.logError("activateObject: unable to login " + e.getMessage());
                    throw e;
                }
                this.logger.logInfo("Retry: binding.login() : due to Error " + e.getMessage());
            }
        }
    }

    public void destroyObject(Object key, Object obj) throws Exception {
        SalesforceConnection connection = (SalesforceConnection)obj;
        this.logger.logTrace("destroyObject: " + key.toString() + " with session id" + connection.getSessionId());
        connection.close();
    }

    public Object makeObject(Object arg0) throws Exception {
        this.logger.logTrace("makeObject: " + arg0.toString());
        SalesforceConnection connection = new SalesforceConnection(this.connector, this.connector.getTarget());
        return connection;
    }

    public void passivateObject(Object arg0, Object arg1) throws Exception {
        this.logger.logTrace("passivateObject: " + arg0.toString());
    }

    public boolean validateObject(Object key, Object obj) {
        SalesforceConnection connection = (SalesforceConnection)obj;
        boolean alive = connection.isAlive();
        this.logger.logTrace("validateObject: " + key.toString() + " alive=" + Boolean.toString(alive) + "session id=" + connection.getSessionId());
        return alive;
    }
}

