/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.salesforce;

import com.metamatrix.connector.salesforce.Messages;
import com.metamatrix.data.exception.ConnectorException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;

public class Util {
    public static boolean convertStringToBoolean(String value) {
        Boolean retval = value == null ? Boolean.FALSE : new Boolean(value.equalsIgnoreCase(Boolean.TRUE.toString()));
        return retval;
    }

    public static String stripQutes(String id) {
        if (id.startsWith("'") && id.endsWith("'")) {
            id = id.substring(1, id.length() - 1);
        } else if (id.startsWith("\"") && id.endsWith("\"")) {
            id = id.substring(1, id.length() - 1);
        }
        return id;
    }

    public static String addSingleQuotes(String text) {
        StringBuffer result = new StringBuffer();
        if (!text.startsWith("'")) {
            result.append('\'');
        }
        result.append(text);
        if (!text.endsWith("'")) {
            result.append('\'');
        }
        return result.toString();
    }

    public static void validateQueryLength(StringBuffer query) throws ConnectorException {
        if (query.length() >= 10000) {
            throw new ConnectorException(Messages.getString((String)"Util.query.exceeds.max.length"));
        }
    }

    public static SimpleDateFormat getSalesforceDateTimeFormat() {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    }

    public static SimpleDateFormat getTimeZoneOffsetFormat() {
        return new SimpleDateFormat("Z");
    }

    public static DateFormat getSalesforceDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd");
    }
}

