/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xml.base;

import com.metamatrix.common.types.ClobType;
import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.common.types.Transform;
import com.metamatrix.common.types.TransformationException;
import com.metamatrix.connector.xml.base.CriteriaDesc;
import com.metamatrix.connector.xml.base.LargeOrSmallString;
import com.metamatrix.connector.xml.base.Messages;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.api.ExecutionContext;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.metadata.runtime.Element;
import java.text.MessageFormat;
import java.util.ArrayList;

public class ValueConvertor {
    public static Object convertString(String value, Class type, ConnectorEnvironment env, ExecutionContext ctx) throws ConnectorException {
        String newValue = value;
        if (newValue == null) {
            return null;
        }
        if (type == String.class) {
            return newValue;
        }
        if (type == ClobType.class) {
            LargeOrSmallString los = LargeOrSmallString.createSmallString(value);
            ClobType retval = los.getAsClobValue();
            return retval;
        }
        if (type != Character.class) {
            newValue = newValue.replaceAll(",", "");
        }
        return ValueConvertor.attemptTransformation(newValue, type);
    }

    public static Object attemptTransformation(String value, Class type) throws ConnectorException {
        String newValue = value;
        if (DataTypeManager.isTransformable((Class)String.class, (Class)type)) {
            try {
                Transform transform = DataTypeManager.getTransform((Class)String.class, (Class)type);
                return transform.transform((Object)newValue);
            }
            catch (TransformationException tex) {
                String msgRaw = Messages.getString("XMLExecutionImpl.type.conversion.failure");
                String msg = MessageFormat.format(msgRaw, newValue, type);
                throw new ConnectorException(msg);
            }
        }
        String msgRaw = Messages.getString("XMLExecutionImpl.type.conversion.failure");
        String msg = MessageFormat.format(msgRaw, newValue, type);
        throw new ConnectorException(msg);
    }

    public static boolean compareData(LargeOrSmallString dataStr, String compareStr, Element elementMetadata, ConnectorEnvironment env, ExecutionContext ctx) throws ConnectorException {
        if (dataStr == null) {
            return false;
        }
        String dataValueStr = dataStr.getAsString();
        String compareValueStr = new String(compareStr);
        if (!elementMetadata.isCaseSensitive()) {
            dataValueStr = dataValueStr.toUpperCase();
            compareValueStr = compareValueStr.toUpperCase();
        }
        Class dataValueType = elementMetadata.getJavaType();
        Object value = ValueConvertor.convertString(dataValueStr, dataValueType, env, ctx);
        Object compareValue = ValueConvertor.convertString(compareValueStr, dataValueType, env, ctx);
        int comparison = 0;
        Comparable comparable = (Comparable)value;
        comparison = comparable.compareTo(compareValue);
        return comparison == 0;
    }

    public static boolean evaluate(LargeOrSmallString currentValue, CriteriaDesc criteria, ConnectorEnvironment env, ExecutionContext ctx) throws ConnectorException {
        ArrayList values = criteria.getValues();
        Element element = criteria.getElement();
        for (int y = 0; y < values.size(); ++y) {
            if (!ValueConvertor.compareData(currentValue, (String)values.get(y), element, env, ctx)) continue;
            return true;
        }
        return false;
    }

    public static Object convertLargeOrSmallString(LargeOrSmallString value, Class type, ConnectorEnvironment env, ExecutionContext ctx) throws ConnectorException {
        if (value == null) {
            return null;
        }
        return ValueConvertor.convertString(value.getAsString(), type, env, ctx);
    }
}

