/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xml.cache;

import com.metamatrix.connector.xml.cache.ExecutionRecord;
import com.metamatrix.connector.xml.cache.IDocumentCache;
import com.metamatrix.connector.xml.cache.Record;
import com.metamatrix.data.api.ConnectorLogger;
import java.util.HashMap;
import java.util.Map;

public class RequestPartRecord
implements Record {
    Record parent;
    String partID;
    Map executionRecords = new HashMap();

    public RequestPartRecord(Record parent, String partID, String executionID, String sourceRequestID, String cacheKey) {
        this.partID = partID;
        this.parent = parent;
        this.addExecutionRecord(executionID, sourceRequestID, cacheKey);
    }

    public void addExecutionRecord(String executionID, String sourceRequestID, String cacheKey) {
        ExecutionRecord execution = (ExecutionRecord)this.executionRecords.get(executionID);
        if (null == execution) {
            execution = new ExecutionRecord(this, executionID, sourceRequestID, cacheKey);
        } else {
            execution.addCacheRecord(sourceRequestID, cacheKey);
        }
    }

    public IDocumentCache getCache() {
        return this.parent.getCache();
    }

    public String getID() {
        return this.parent.getID() + this.partID;
    }

    public void deleteExecutionRecords(String executionID, ConnectorLogger logger) {
        ExecutionRecord execution = (ExecutionRecord)this.executionRecords.get(executionID);
        if (null != execution) {
            execution.deleteCacheItems(logger);
        }
    }
}

