/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xml.base;

import com.metamatrix.connector.xml.base.Messages;
import com.metamatrix.data.api.ConnectorLogger;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LoggingInputStreamFilter
extends FilterInputStream {
    ConnectorLogger logger;
    StringBuffer buff = new StringBuffer();
    boolean alreadyLogged = false;

    public LoggingInputStreamFilter(InputStream in, ConnectorLogger logger) {
        super(in);
        this.logger = logger;
    }

    public int read() throws IOException {
        int retval = this.in.read();
        if (retval != -1) {
            String aChar = new Character((char)retval).toString();
            this.buff.append(aChar);
        } else {
            this.log();
        }
        return retval;
    }

    public int read(byte[] b) throws IOException {
        int retval = this.in.read(b);
        if (retval != -1) {
            this.buff.append(new String(b, 0, retval));
        }
        if (-1 == retval || retval < b.length) {
            this.log();
        }
        return retval;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int retval = this.in.read(b, off, len);
        if (retval != -1) {
            this.buff.append(new String(b));
        } else {
            this.log();
        }
        return retval;
    }

    public void close() throws IOException {
        super.close();
        if (!this.alreadyLogged) {
            this.log();
        }
    }

    public synchronized void mark(int readlimit) {
    }

    public boolean markSupported() {
        return false;
    }

    public synchronized void reset() throws IOException {
        throw new IOException(Messages.getString("InputStream_reset_not_supported"));
    }

    public long skip(long n) throws IOException {
        int i = 0;
        while ((long)i < n) {
            if (-1 == this.read()) {
                return i;
            }
            ++i;
        }
        return n;
    }

    private void log() {
        this.logger.logInfo("XML Connector Framework: response body is: " + this.buff.toString().trim());
        this.alreadyLogged = true;
    }
}

