/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.transformation.util;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.metamodels.transformation.SqlTransformationMappingRoot;
import com.metamatrix.metamodels.transformation.XQueryTransformationMappingRoot;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.metamodel.aspect.AspectManager;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlTableAspect;
import com.metamatrix.modeler.core.util.INewModelObjectHelper;
import com.metamatrix.modeler.core.util.ModelResourceContainerFactory;
import com.metamatrix.modeler.internal.transformation.util.TransformationHelper;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;

public class TransformationNewModelObjectHelper
implements INewModelObjectHelper {
    public static final String VIRTUAL_TABLE_CLEAR_SUPPORTS_UPDATE = "clearSupportsUpdate";

    public boolean canHelpCreate(Object newObject) {
        ArgCheck.isNotNull((Object)newObject);
        if (newObject instanceof EObject) {
            EObject newEObject = (EObject)newObject;
            if (TransformationHelper.isVirtual(newEObject)) {
                if (TransformationHelper.isSqlTable(newEObject) && !TransformationHelper.isXmlDocument(newEObject)) {
                    return true;
                }
                if (TransformationHelper.isSqlProcedure(newEObject)) {
                    return true;
                }
            }
            if (TransformationHelper.isPhysical(newEObject) && TransformationHelper.isXQueryProcedure(newEObject)) {
                return true;
            }
        }
        return false;
    }

    public Object getTransactionSetting() {
        return null;
    }

    public boolean helpCreate(Object newObject, Map properties) throws ModelerCoreException {
        ArgCheck.isNotNull((Object)newObject);
        if (newObject instanceof EObject) {
            EObject newTarget = (EObject)newObject;
            if (TransformationHelper.isVirtual(newTarget)) {
                SqlAspect aspect = AspectManager.getSqlAspect((EObject)newTarget);
                if (aspect != null && aspect instanceof SqlTableAspect) {
                    if (!TransformationHelper.hasSqlTransformationMappingRoot(newTarget)) {
                        SqlTransformationMappingRoot newRoot = ModelResourceContainerFactory.createNewSqlTransformationMappingRoot((EObject)newTarget, (boolean)false, (Object)this);
                        ModelResourceContainerFactory.addMappingHelper((Object)newRoot);
                        if (TransformationNewModelObjectHelper.isMapValueTrue(VIRTUAL_TABLE_CLEAR_SUPPORTS_UPDATE, properties, true)) {
                            SqlTableAspect tableAspect = (SqlTableAspect)aspect;
                            tableAspect.setSupportsUpdate(newTarget, false);
                        }
                        return true;
                    }
                } else if (TransformationHelper.isXQueryProcedure(newTarget)) {
                    if (!TransformationHelper.hasXQueryTransformationMappingRoot(newTarget)) {
                        XQueryTransformationMappingRoot newRoot = ModelResourceContainerFactory.createNewXQueryTransformationMappingRoot((EObject)newTarget, (boolean)false, (Object)this);
                        ModelResourceContainerFactory.addMappingHelper((Object)newRoot);
                        EObject procResultSet = TransformationHelper.createProcResultSet(newTarget);
                        if (procResultSet != null) {
                            TransformationHelper.createProcResultSetColumn(procResultSet);
                        }
                        return true;
                    }
                } else if (TransformationHelper.isSqlProcedure(newTarget) && !TransformationHelper.hasSqlTransformationMappingRoot(newTarget)) {
                    SqlTransformationMappingRoot newRoot = ModelResourceContainerFactory.createNewSqlTransformationMappingRoot((EObject)newTarget, (boolean)false, (Object)this);
                    ModelResourceContainerFactory.addMappingHelper((Object)newRoot);
                    TransformationHelper.createProcResultSet(newTarget);
                    return true;
                }
            }
            if (TransformationHelper.isPhysical(newTarget) && TransformationHelper.isXQueryProcedure(newTarget)) {
                EObject procResultSet = TransformationHelper.createProcResultSet(newTarget);
                if (procResultSet != null) {
                    TransformationHelper.createProcResultSetColumn(procResultSet);
                }
                return true;
            }
        }
        return false;
    }

    private static boolean isMapValueTrue(String propertyName, Map properties, boolean defaultValue) {
        if (properties == null) {
            return defaultValue;
        }
        Boolean bool = (Boolean)properties.get(propertyName);
        if (bool == null) {
            return defaultValue;
        }
        return bool;
    }
}

