/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbcx.base;

import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbcx.base.BaseImplXAResource;
import com.metamatrix.jdbcx.base.BasePooledConnection;
import com.metamatrix.jdbcx.base.BaseXADataSource;
import com.metamatrix.jdbcx.base.BaseXAResource;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.List;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;

public class BaseXAConnection
extends BasePooledConnection
implements XAConnection {
    private static String footprint = "$Revision:   3.7.1.0  $";
    private BaseXADataSource xaDataSource;
    private BaseXAResource xaResource;
    protected BaseImplXAResource implXAResource;
    private boolean inGlobalTransaction = false;
    private boolean autoCommitModePriorToXaTxnStart;

    public BaseXAConnection(BaseXADataSource baseXADataSource, BaseConnection baseConnection) throws SQLException {
        super(baseConnection);
        this.xaDataSource = baseXADataSource;
        this.xaResource = null;
        this.implXAResource = null;
        try {
            this.implXAResource = baseXADataSource.createImplXAResource(baseConnection);
            this.implXAResource.exceptions = this.exceptions;
            this.implXAResource.xaConnection = this;
            String string = baseConnection.getConnectProperties().get("loginTimeout");
            if (string != null) {
                this.implXAResource.open(Integer.parseInt(string));
            } else {
                this.implXAResource.open(0);
            }
        }
        catch (SQLException sQLException) {
            baseConnection.close();
            throw sQLException;
        }
    }

    public synchronized XAResource getXAResource() throws SQLException {
        if (this.isClosed()) {
            throw this.exceptions.getException(6009);
        }
        if (this.xaResource == null) {
            this.xaResource = new BaseXAResource(this, this.implXAResource);
        }
        return this.xaResource;
    }

    public synchronized void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        try {
            this.implXAResource.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.realConnection.closeXA(this.inGlobalTransaction);
    }

    void forceAutoCommitMode() throws SQLException {
        if (this.realConnection.getManualTxnWorkStarted()) {
            throw this.exceptions.getException(6095);
        }
        this.autoCommitModePriorToXaTxnStart = this.realConnection.getAutoCommit();
        if (!this.autoCommitModePriorToXaTxnStart) {
            this.realConnection.setAutoCommit(true);
        }
        if (!this.realConnection.getActualAutoCommit()) {
            this.realConnection.setActualAutoCommit(true);
        }
    }

    void unforceAutoCommitMode() throws SQLException {
        this.realConnection.setAutoCommit(this.autoCommitModePriorToXaTxnStart);
    }

    public synchronized void setGlobalTransaction(boolean bl) throws SQLException {
        this.inGlobalTransaction = bl;
    }

    public synchronized boolean getAutoCommit() throws SQLException {
        if (this.inGlobalTransaction) {
            return false;
        }
        return super.getAutoCommit();
    }

    public synchronized void setAutoCommit(boolean bl) throws SQLException {
        if (this.inGlobalTransaction) {
            if (bl) {
                throw this.exceptions.getException(6072);
            }
        } else {
            super.setAutoCommit(bl);
        }
    }

    public synchronized void commit() throws SQLException {
        if (this.inGlobalTransaction) {
            throw this.exceptions.getException(6073);
        }
        super.commit();
    }

    public synchronized void rollback() throws SQLException {
        if (this.inGlobalTransaction) {
            throw this.exceptions.getException(6074);
        }
        super.rollback();
    }

    public Savepoint setSavepoint() throws SQLException {
        if (this.inGlobalTransaction) {
            throw this.exceptions.getException(6086);
        }
        return super.setSavepoint();
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        if (this.inGlobalTransaction) {
            throw this.exceptions.getException(6086);
        }
        return super.setSavepoint(string);
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        if (this.inGlobalTransaction) {
            throw this.exceptions.getException(6074);
        }
        super.rollback(savepoint);
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        if (this.inGlobalTransaction) {
            throw this.exceptions.getException(6087);
        }
        super.releaseSavepoint(savepoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(List list, List list2) {
        try {
            BaseConnection baseConnection = this.realConnection;
            synchronized (baseConnection) {
                this.commonReset(list, list2);
                this.realConnection.resetXA(this.inGlobalTransaction);
                this.implXAResource.reset();
            }
            this.connectionClosed();
        }
        catch (SQLException sQLException) {
            this.connectionErrorOccurred(sQLException);
        }
    }
}

