/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.messaging.jgroups;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.jgroups.JGroupsManager;
import com.metamatrix.common.log.I18nLogManager;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.messaging.MessageBus;
import com.metamatrix.common.messaging.MessagingException;
import com.metamatrix.common.messaging.jgroups.MessageListener;
import com.metamatrix.core.event.EventBroker;
import com.metamatrix.core.event.EventObjectListener;
import java.io.Serializable;
import java.util.EventObject;
import java.util.Properties;
import org.jgroups.Channel;
import org.jgroups.ChannelException;
import org.jgroups.Message;

public class JGroupsMessageBus
implements MessageBus {
    static Channel channel;
    static MessageListener listener;

    public JGroupsMessageBus(Properties env, EventBroker eventBroker) {
        LogManager.logTrace((String)"MESSAGE_BUS", (String)"JGroupsMessageBus instance being created");
        try {
            channel = JGroupsManager.createJChannel("MessageBus");
            this.initListener(channel, eventBroker);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LogManager.logTrace((String)"MESSAGE_BUS", (String)"JGroupsMessageBus instance being returned");
    }

    private void initListener(Channel channel, EventBroker eventBroker) {
        listener = new MessageListener(this, channel, eventBroker);
        Thread thread = new Thread((Runnable)listener, "MessageListener");
        thread.start();
    }

    public void reinitListener() throws ChannelException {
        channel = JGroupsManager.createJChannel("MessageBus");
        listener.setChannel(channel);
    }

    public void addListener(Class eventClass, EventObjectListener listener) throws MessagingException {
    }

    public void processEvent(EventObject obj) throws MessagingException {
        if (obj != null) {
            try {
                if (!channel.isOpen()) {
                    this.reinitListener();
                }
                channel.send(new Message(null, null, (Serializable)obj));
            }
            catch (Exception e) {
                I18nLogManager.logCritical((String)"MESSAGE_BUS", (String)"ERR.003.017.0004", (Throwable)e);
                throw new MessagingException((Throwable)e, "ERR.003.017.0004", CommonPlugin.Util.getString("ERR.003.017.0004"));
            }
        }
    }

    public void removeListener(Class eventClass, EventObjectListener listener) throws MessagingException {
    }

    public void removeListener(EventObjectListener listener) throws MessagingException {
    }

    public void shutdown() throws MessagingException {
        listener.close();
        this.getChannel().close();
    }

    Channel getChannel() {
        return channel;
    }
}

