/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.informix;

import com.metamatrix.jdbc.base.BaseColumn;
import com.metamatrix.jdbc.base.BaseColumns;
import com.metamatrix.jdbc.base.BaseData;
import com.metamatrix.jdbc.base.BaseImplResultSet;
import com.metamatrix.jdbc.base.BaseImplStatement;
import com.metamatrix.jdbc.base.BaseParameter;
import com.metamatrix.jdbc.base.BaseParameterInfo;
import com.metamatrix.jdbc.base.BaseParameters;
import com.metamatrix.jdbc.base.BaseSQL;
import com.metamatrix.jdbc.base.BaseTimestamp;
import com.metamatrix.jdbc.informix.InformixColumn;
import com.metamatrix.jdbc.informix.InformixImplConnection;
import com.metamatrix.jdbc.informix.InformixImplResultSet;
import com.metamatrix.jdbc.informix.InformixLocalMessages;
import com.metamatrix.jdbc.informix.InformixParameter;
import com.metamatrix.jdbc.informix.sqli.InformixSQLICommunication;
import com.metamatrix.jdbc.informix.sqli.InformixSQLICursorRequest;
import com.metamatrix.jdbc.informix.sqli.InformixSQLIExecuteRequest;
import com.metamatrix.jdbc.informix.sqli.InformixSQLIProcedureRequest;
import com.metamatrix.jdbc.informix.sqli.InformixSQLIRequest;
import com.metamatrix.util.UtilException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.Calendar;

public class InformixImplStatement
extends BaseImplStatement {
    private static String footprint = "$Revision:   3.15.1.0  $";
    private int stmtId = -1;
    private int stmtType = 0;
    private boolean isPrepared = false;
    private String preparedSql = "";
    private String nativeSql = "";
    private int resultType = 0;
    private int numRows = 0;
    private int numInputs = 0;
    InformixImplConnection implConnection = null;
    InformixSQLICommunication comm = null;
    InformixSQLIRequest request = null;
    private int resultSetType;
    private int resultSetConcurrency;
    private Integer generatedValueForSerialColumn;
    private Long generatedValueForSerial8Column;
    private BaseColumns autoGenKeysColDescriptions = null;
    public boolean routineHasOutParams;
    private int routineHandle = -1;

    InformixImplStatement(InformixImplConnection informixImplConnection, InformixSQLICommunication informixSQLICommunication, int n, int n2) {
        this.implConnection = informixImplConnection;
        this.comm = informixSQLICommunication;
        this.resultSetType = n;
        this.resultSetConcurrency = n2;
    }

    public void prepare() throws SQLException {
        this.isPrepared = true;
        this.nativeSql = this.sql.getFormatted();
        if (this.nativeSql.equals(this.preparedSql)) {
            return;
        }
        if (this.request != null) {
            this.request.closeStatement();
            this.request = null;
        }
        this.numInputs = this.sql.getParameterCount();
        this.preparedSql = this.nativeSql;
        this.resultType = 3;
        if (this.sql.getType() == 1) {
            this.request = new InformixSQLICursorRequest(this.comm, this, this.preparedSql, this.resultSetType, this.resultSetConcurrency);
            ((InformixSQLICursorRequest)this.request).setInputParameterCount(this.numInputs);
            this.request.setFetchSize(this.fetchSize);
            ((InformixSQLICursorRequest)this.request).prepare();
            if (this.request.getNumberOfColumns() > 0) {
                this.resultType = 2;
            }
        } else if (this.sql.getType() == 3 || this.sql.getVerb().toLowerCase().equals("execute")) {
            this.request = new InformixSQLIProcedureRequest(this.comm, this, this.preparedSql, this.resultSetType, this.resultSetConcurrency);
            ((InformixSQLIProcedureRequest)this.request).setInputParameterCount(this.numInputs);
            this.request.setFetchSize(this.fetchSize);
            try {
                ((InformixSQLIProcedureRequest)this.request).prepare();
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() == -9752) {
                    this.routineHasOutParams = true;
                    String[] stringArray = new String[]{"User-Defined Routine contains an output parameter."};
                    this.warnings.add(6001, stringArray, sQLException.getSQLState(), sQLException.getErrorCode());
                    return;
                }
                throw sQLException;
            }
            if (this.request.getNumberOfColumns() > 0) {
                this.resultType = 2;
            }
        } else {
            this.request = new InformixSQLIExecuteRequest(this.comm, this, this.preparedSql);
            ((InformixSQLIExecuteRequest)this.request).setInputParameterCount(this.numInputs);
            this.request.setFetchSize(this.fetchSize);
            ((InformixSQLIExecuteRequest)this.request).prepare();
        }
    }

    public void execute() throws SQLException {
        InformixImplConnection informixImplConnection = this.implConnection;
        if (this.routineHasOutParams) {
            try {
                if (this.routineHandle == -1) {
                    try {
                        this.getFastPathRoutine("function ");
                    }
                    catch (SQLException sQLException) {
                        if (sQLException.getErrorCode() == -674) {
                            this.getFastPathRoutine("procedure ");
                        }
                        throw sQLException;
                    }
                }
                if (this.numInputs > 0) {
                    BaseParameters baseParameters = (BaseParameters)this.parameterSets.elementAt(0);
                    InformixParameter[] informixParameterArray = InformixParameter.prepareParamData(baseParameters, this.request.paramDescs, this.stmtType, this.comm.getImplConnection().versionNumber, true, this.comm.exceptions, this.comm.warnings);
                    this.request.setInputParameters(informixParameterArray);
                }
                this.request.fastpathReturnValuesProcessed = false;
                this.request.writeExecuteFastPath(this.routineHandle, this.numInputs, true);
                this.request.writePacket(5);
                this.request.writePacket(104);
                this.request.writePacket(12);
                this.request.submitRequest();
                this.request.processReply();
                this.processOutputParameterData();
                if (this.request.fastpathNumOfReturnValues == 0) {
                    this.request.processReply();
                    this.resultType = 3;
                } else {
                    this.resultType = 2;
                }
                return;
            }
            catch (UtilException utilException) {
                throw this.implConnection.exceptions.getException(utilException);
            }
        }
        if (this.isPrepared) {
            if (this.numInputs > 0) {
                BaseParameters baseParameters = (BaseParameters)this.parameterSets.elementAt(0);
                InformixParameter[] informixParameterArray = InformixParameter.prepareParamData(baseParameters, this.request.columns, this.stmtType, this.comm.getImplConnection().versionNumber, false, this.comm.exceptions, this.comm.warnings);
                this.request.setInputParameters(informixParameterArray);
            }
            this.resultType = 3;
            if (this.sql.getType() == 1) {
                this.request.setFetchSize(this.fetchSize);
                this.request.setupTupleBuffer();
                if (this.request.getNumberOfColumns() > 0) {
                    ((InformixSQLICursorRequest)this.request).openPreparedCursor();
                    this.resultType = 2;
                } else {
                    this.request.executePrepared();
                }
            } else if (this.sql.getType() == 3 || this.sql.getVerb().toLowerCase().equals("execute")) {
                this.request.setFetchSize(this.fetchSize);
                this.request.setupTupleBuffer();
                this.request.executePrepared();
                if (this.request.getNumberOfColumns() > 0) {
                    this.resultType = 2;
                }
            } else {
                this.request.executePrepared();
            }
        } else {
            if (this.request != null) {
                this.request.closeStatement();
                this.request = null;
            }
            this.nativeSql = this.processSQL();
            this.resultType = 3;
            if (this.sql.getType() == 1) {
                this.request = new InformixSQLICursorRequest(this.comm, this, this.nativeSql, this.resultSetType, this.resultSetConcurrency);
                this.request.setFetchSize(this.fetchSize);
                ((InformixSQLICursorRequest)this.request).openCursor();
                if (this.request.getNumberOfColumns() > 0) {
                    this.resultType = 2;
                }
            } else if (this.sql.getType() == 3 || this.sql.getVerb().toLowerCase().equals("execute")) {
                this.request = new InformixSQLICursorRequest(this.comm, this, this.nativeSql, this.resultSetType, this.resultSetConcurrency);
                this.request.setFetchSize(this.fetchSize);
                this.request.prepare();
                if (this.request.getNumberOfColumns() > 0) {
                    this.resultType = 2;
                    ((InformixSQLICursorRequest)this.request).openCursor();
                } else {
                    this.request.executePrepared();
                }
            } else {
                this.request = new InformixSQLIExecuteRequest(this.comm, this, this.nativeSql);
                this.request.setFetchSize(this.fetchSize);
                this.request.execute();
            }
        }
    }

    private String processSQL() throws SQLException {
        String string = this.sql.getFormatted();
        return string;
    }

    public BaseColumns describeColumns(BaseColumns baseColumns) throws SQLException {
        if (this.databaseMetaDataResultSet != 0) {
            return baseColumns;
        }
        if (this.stmtType == 6 || this.stmtType == 33 || this.stmtType == 4) {
            return null;
        }
        if (this.request == null) {
            return null;
        }
        return this.request.columns;
    }

    public void describeParameters(BaseParameters baseParameters) throws SQLException {
        BaseColumns baseColumns;
        int n;
        if ((this.stmtType == 6 || this.stmtType == 33 || this.stmtType == 4) && (n = (baseColumns = this.request.columns).count(0)) == this.sql.getParameterCount()) {
            for (int i = 1; i <= n; ++i) {
                BaseColumn baseColumn = baseColumns.get(i);
                BaseParameterInfo baseParameterInfo = new BaseParameterInfo();
                baseParameterInfo.setType(baseColumn.type);
                baseParameterInfo.signed = baseColumn.isSigned;
                baseParameterInfo.nullable = baseColumn.isNullable;
                baseParameterInfo.precision = baseColumn.precision;
                baseParameterInfo.scale = baseColumn.scale;
                baseParameterInfo.nativeTypeName = baseColumn.typeName;
                baseParameterInfo.mode = 1;
                baseParameters.setParameterInfo(i - 1, baseParameterInfo);
            }
        }
    }

    public BaseImplResultSet getNextResultSet() throws SQLException {
        InformixImplResultSet informixImplResultSet = new InformixImplResultSet(this.request, this.resultSetType, this.resultSetConcurrency);
        return informixImplResultSet;
    }

    public int getNextResultType() throws SQLException {
        int n = this.resultType;
        this.resultType = 1;
        if (this.autoGeneratedKeysRequested) {
            try {
                InformixSQLICursorRequest informixSQLICursorRequest = new InformixSQLICursorRequest(this.comm, null, "select count(*), dbinfo('sqlca.sqlerrd1'), dbinfo('serial8') from informix.systables", 1003, 1007);
                informixSQLICursorRequest.openCursor();
                if (informixSQLICursorRequest.fetch()) {
                    informixSQLICursorRequest.buildRow();
                    InformixColumn informixColumn = (InformixColumn)informixSQLICursorRequest.columns.get(2);
                    this.generatedValueForSerialColumn = (Integer)informixColumn.data;
                    informixColumn = (InformixColumn)informixSQLICursorRequest.columns.get(3);
                    this.generatedValueForSerial8Column = (Long)informixColumn.data;
                    this.autoGenKeysColDescriptions = informixSQLICursorRequest.columns;
                    informixSQLICursorRequest.closeCursor();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    public int getNextRowsAffectedCount() throws SQLException {
        if (this.request != null && this.stmtType != 2) {
            return this.request.getRowsAffected();
        }
        return -1;
    }

    public BaseColumns describeAutoGeneratedKeyColumns() throws SQLException {
        BaseColumns baseColumns = null;
        BaseColumn baseColumn = null;
        if (this.generatedValueForSerialColumn.longValue() != 0L) {
            baseColumns = new BaseColumns();
            baseColumn = this.autoGenKeysColDescriptions.get(2);
            baseColumn.label = "SERIAL_COL";
            baseColumn.name = "SERIAL_COL";
            baseColumns.add(baseColumn);
        }
        if (this.generatedValueForSerial8Column != 0L) {
            baseColumn = this.autoGenKeysColDescriptions.get(3);
            baseColumn.label = "SERIAL8_COL";
            baseColumn.name = "SERIAL8_COL";
            if (baseColumns == null) {
                baseColumns = new BaseColumns();
            }
            baseColumns.add(baseColumn);
        }
        return baseColumns;
    }

    public BaseImplResultSet getAutoGeneratedKeyResultSet() throws SQLException {
        return new InformixAutoGeneratedKeyResultSet();
    }

    public void close() throws SQLException {
        if (this.request != null) {
            this.request.closeStatement();
        }
        this.preparedSql = "";
    }

    private boolean isAutoCommit() {
        return this.implConnection.isAutoCommit;
    }

    private boolean isQuery() {
        return this.sql.getType() == 1;
    }

    public int getStatementId() {
        return this.stmtId;
    }

    public void setStatementId(int n) {
        this.stmtId = n;
    }

    public int getStatementType() {
        return this.stmtType;
    }

    public void setStatementType(int n) {
        this.stmtType = n;
    }

    public String getRowIdColumnName() {
        return "rowid";
    }

    public boolean supportsDefaultKeyword() {
        return false;
    }

    public void setSQL(BaseSQL baseSQL) throws SQLException {
        super.setSQL(baseSQL);
        this.isPrepared = false;
        this.routineHasOutParams = false;
        this.routineHandle = -1;
    }

    private void getFastPathRoutine(String string) throws SQLException, UtilException {
        String string2 = this.getRoutineSignature(string);
        this.request.writeGetRoutine(string2, true);
        this.request.writePacket(12);
        this.request.submitRequest();
        this.request.processReply();
        this.routineHandle = this.request.fastpathRoutineHandle;
    }

    private String getRoutineSignature(String string) throws SQLException {
        int n;
        String string2 = string;
        String string3 = this.nativeSql.toLowerCase();
        int n2 = string3.indexOf(" procedure ");
        if (n2 == -1) {
            n2 = string3.indexOf(" function ");
            n = n2 + " function ".length();
        } else {
            n = n2 + " procedure ".length();
        }
        int n3 = string3.indexOf("(");
        String string4 = this.nativeSql.substring(n, n3);
        string2 = string2 + string4 + "(";
        BaseParameters baseParameters = (BaseParameters)this.parameterSets.elementAt(0);
        for (int i = 1; i <= this.numInputs; ++i) {
            BaseParameter baseParameter = baseParameters.get(i, 1);
            if (baseParameter == null) {
                baseParameter = baseParameters.get(i, 2);
            }
            string2 = string2 + this.mapSQLTypeToSQLTypeName(baseParameter.sqlType);
            string2 = i < this.numInputs ? string2 + "," : string2 + ")";
        }
        return string2;
    }

    private String mapSQLTypeToSQLTypeName(int n) {
        String string;
        switch (n) {
            case 1: {
                string = "char";
                break;
            }
            case 12: {
                string = "varchar";
                break;
            }
            case 2: {
                string = "numeric";
                break;
            }
            case 3: {
                string = "decimal";
                break;
            }
            case -6: {
                string = "tynyint";
                break;
            }
            case 5: {
                string = "smallint";
                break;
            }
            case 4: {
                string = "int";
                break;
            }
            case -5: {
                string = "bigint";
                break;
            }
            case 7: {
                string = "real";
                break;
            }
            case 6: {
                string = "float";
                break;
            }
            case 8: {
                string = "double precision";
                break;
            }
            case 91: {
                string = "date";
                break;
            }
            case 92: {
                string = "time";
                break;
            }
            case 93: {
                string = "datetime year to fraction(5)";
                break;
            }
            case -2: {
                string = "binary";
                break;
            }
            case -3: {
                string = "varbinary";
                break;
            }
            case -1: {
                string = "longvarchar";
                break;
            }
            case -4: {
                string = "longvarbinary";
                break;
            }
            case 2004: {
                string = "blob";
                break;
            }
            case 2005: {
                string = "clob";
                break;
            }
            case -7: 
            case 16: {
                string = "boolean";
                break;
            }
            default: {
                string = "char";
            }
        }
        return string;
    }

    private void processOutputParameterData() throws SQLException, UtilException {
        int n = this.request.fastpathReturnParameter - this.request.fastpathNumOfReturnValues;
        BaseParameters baseParameters = (BaseParameters)this.parameterSets.elementAt(0);
        for (int i = 0; i < this.numInputs; ++i) {
            BaseParameter baseParameter = baseParameters.parametersOut[i];
            if (baseParameter == null) continue;
            int n2 = this.request.reader.readInt16() & 0xFF;
            short s = this.request.reader.readInt16();
            if (s == -1) {
                baseParameter.setData(baseParameter.sqlType, null);
                short s2 = this.request.reader.readInt16();
                continue;
            }
            this.getDataFromValueSubpacket(baseParameter, n2);
        }
    }

    public void getDataFromValueSubpacket(BaseData baseData, int n) throws SQLException, UtilException {
        short s = this.request.reader.readInt16();
        switch (n) {
            case 0: 
            case 13: 
            case 15: 
            case 16: {
                short s2 = this.request.reader.readInt16();
                String string = this.request.reader.readString(s2);
                baseData.setString(string);
                break;
            }
            case 40: {
                long l = this.request.reader.readInt64();
                String string = this.request.reader.readString((int)l);
                baseData.setString(string);
                break;
            }
            case 1: {
                short s3 = this.request.reader.readInt16();
                baseData.setShort(s3);
                break;
            }
            case 2: 
            case 6: {
                int n2 = this.request.reader.readInt32();
                baseData.setInteger(n2);
                break;
            }
            case 17: 
            case 18: {
                short s4 = this.request.reader.readInt16();
                long l = this.request.reader.readUnsignedInt32();
                baseData.setLong((l += this.request.reader.readUnsignedInt32() << 32) * (long)s4);
                break;
            }
            case 4: {
                int n3 = this.request.reader.readInt32();
                baseData.setFloat(Float.intBitsToFloat(n3));
                break;
            }
            case 3: {
                long l = this.request.reader.readInt64();
                baseData.setDouble(Double.longBitsToDouble(l));
                break;
            }
            case 5: 
            case 8: {
                int n4;
                int n5 = s >> 8;
                int n6 = s & 0xFF;
                int n7 = this.request.reader.readUnsignedInt16();
                int n8 = n7--;
                int n9 = this.request.reader.readUnsignedInt8();
                int n10 = (n9 & 0x80) == 0 ? -1 : 1;
                n9 &= 0x7F;
                if (n10 < 0) {
                    n9 ^= 0x7F;
                }
                n9 -= 64;
                StringBuffer stringBuffer = new StringBuffer(n7 * 2 + 1);
                int n11 = 0;
                int n12 = 0;
                boolean bl = false;
                for (int i = 0; i < n7; ++i) {
                    n11 = this.request.reader.readUnsignedInt8();
                    if (n10 < 0) {
                        n11 = 100 - n11 - 1;
                    }
                    int n13 = n11 / 10;
                    int n14 = n11 % 10;
                    if (n14 != 0) {
                        n12 = i * 2 + 1;
                        bl = true;
                    } else if (n13 != 0) {
                        n12 = i * 2;
                        bl = true;
                    }
                    stringBuffer.append(n13);
                    stringBuffer.append(n14);
                }
                BigDecimal bigDecimal = new BigDecimal(stringBuffer.toString());
                if (n10 < 0) {
                    bigDecimal = bigDecimal.add(BigDecimal.valueOf(1L)).negate();
                }
                bigDecimal = bigDecimal.movePointLeft((n7 - n9) * 2);
                if (n6 == 255) {
                    n4 = n12 + 1 - n9 * 2;
                    if (n4 > 0 && bl) {
                        baseData.setBigDecimal(bigDecimal.setScale(n4, 3));
                    } else {
                        baseData.setBigDecimal(bigDecimal.setScale(0, 3));
                    }
                } else {
                    baseData.setBigDecimal(bigDecimal.setScale(n6, 3));
                }
                if (n8 % 2 != 1) break;
                n4 = this.request.reader.readInt8();
                break;
            }
            case 7: {
                int n15 = this.request.reader.readInt32();
                long l = (long)(n15 -= 25568) * 24L * 60L * 60L * 1000L;
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(new Date(l));
                l -= (long)calendar.get(15);
                baseData.setDate(new Date(l -= (long)calendar.get(16)));
                break;
            }
            case 10: {
                int n16;
                int n17 = this.request.reader.readInt16();
                int n18 = this.request.reader.readUnsignedInt8();
                int n19 = 0;
                int n20 = 0;
                short s5 = 1;
                short s6 = 0;
                short s7 = 0;
                short s8 = 0;
                int n21 = 0;
                int n22 = n18;
                for (n16 = 1; n16 < n17; ++n16) {
                    switch (n22) {
                        case 199: {
                            n19 = this.request.reader.readUnsignedInt8() * 100;
                            break;
                        }
                        case 198: {
                            n19 += this.request.reader.readUnsignedInt8();
                            break;
                        }
                        case 197: {
                            n20 = this.request.reader.readUnsignedInt8() - 1;
                            break;
                        }
                        case 196: {
                            s5 = this.request.reader.readUnsignedInt8();
                            break;
                        }
                        case 195: {
                            s6 = this.request.reader.readUnsignedInt8();
                            break;
                        }
                        case 194: {
                            s7 = this.request.reader.readUnsignedInt8();
                            break;
                        }
                        case 193: {
                            s8 = this.request.reader.readUnsignedInt8();
                            break;
                        }
                        case 192: {
                            n21 = this.request.reader.readUnsignedInt8() * 10000000;
                            break;
                        }
                        case 191: {
                            n21 += this.request.reader.readUnsignedInt8() * 100000;
                            break;
                        }
                        case 190: {
                            n21 += this.request.reader.readUnsignedInt8() * 1000;
                            break;
                        }
                        default: {
                            this.request.reader.readUnsignedInt8();
                        }
                    }
                    --n22;
                }
                if (n17 % 2 == 1) {
                    n16 = this.request.reader.readUnsignedInt8();
                }
                baseData.setTimestamp(new BaseTimestamp(n19, n20, s5, s6, s7, s8, n21, null));
                break;
            }
            case 45: {
                long l = this.request.reader.readInt64();
                byte by = this.request.reader.readInt8();
                byte by2 = this.request.reader.readInt8();
                if (by == 1) {
                    baseData.setBoolean(true);
                    break;
                }
                baseData.setBoolean(false);
                break;
            }
            default: {
                throw this.comm.exceptions.getException(InformixLocalMessages.UNSUPPORTED_TYPE, null, "HY000");
            }
        }
    }

    class InformixAutoGeneratedKeyResultSet
    extends BaseImplResultSet {
        boolean returnedTheRow = false;

        InformixAutoGeneratedKeyResultSet() {
        }

        public boolean fetchAtPosition(int n) throws SQLException {
            if (this.returnedTheRow) {
                return false;
            }
            this.returnedTheRow = true;
            return true;
        }

        public BaseData getData(int n, int n2) throws SQLException {
            if (n == 1 && InformixImplStatement.this.generatedValueForSerialColumn.longValue() != 0L) {
                return new BaseData(4, InformixImplStatement.this.generatedValueForSerialColumn, InformixImplStatement.this.implConnection.connection);
            }
            return new BaseData(5, InformixImplStatement.this.generatedValueForSerial8Column, InformixImplStatement.this.implConnection.connection);
        }

        public void close() throws SQLException {
        }
    }
}

