/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xml.soap;

import com.metamatrix.connector.xml.CachingConnector;
import com.metamatrix.connector.xml.DocumentProducer;
import com.metamatrix.connector.xml.SOAPConnectorState;
import com.metamatrix.connector.xml.TrustedPayloadHandler;
import com.metamatrix.connector.xml.XMLConnectorState;
import com.metamatrix.connector.xml.XMLExecution;
import com.metamatrix.connector.xml.base.CriteriaDesc;
import com.metamatrix.connector.xml.base.DocumentInfo;
import com.metamatrix.connector.xml.base.RequestGenerator;
import com.metamatrix.connector.xml.base.RequestResponseDocumentProducer;
import com.metamatrix.connector.xml.base.Response;
import com.metamatrix.connector.xml.base.XMLDocument;
import com.metamatrix.connector.xml.cache.IDocumentCache;
import com.metamatrix.connector.xml.http.Messages;
import com.metamatrix.connector.xml.soap.FilteringHTTPSender;
import com.metamatrix.connector.xml.soap.SOAPDocBuilder;
import com.metamatrix.connector.xmlsource.soap.SecurityToken;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.api.ExecutionContext;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.internal.core.text.MessageFormat;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import org.apache.axis.AxisFault;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Handler;
import org.apache.axis.Message;
import org.apache.axis.SimpleChain;
import org.apache.axis.SimpleTargetedChain;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.client.Transport;
import org.apache.axis.configuration.SimpleProvider;
import org.apache.axis.handlers.SimpleSessionHandler;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.transport.http.HTTPTransport;
import org.apache.ws.axis.security.WSDoAllSender;
import org.jdom.Document;
import org.jdom.input.DOMBuilder;
import org.jdom.output.DOMOutputter;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SOAPExecutor
extends RequestResponseDocumentProducer {
    SOAPEnvelope envelope = new SOAPEnvelope((SOAPConstants)SOAPConstants.SOAP11_CONSTANTS);
    SecurityToken secToken;

    public SOAPExecutor(SOAPConnectorState state, XMLExecution execution) throws ConnectorException {
        super((XMLConnectorState)state, execution);
    }

    public Response getXMLResponse(int invocationNumber) throws ConnectorException {
        Response result;
        CachingConnector connector = this.getExecution().getConnection().getConnector();
        IDocumentCache cache = this.getExecution().getCache();
        ExecutionContext exeContext = this.getExecution().getExeContext();
        String requestID = exeContext.getRequestIdentifier();
        String partID = exeContext.getPartIdentifier();
        String executionID = exeContext.getExecutionCountIdentifier();
        String cacheReference = requestID + partID + executionID + Integer.toString(invocationNumber);
        CriteriaDesc criterion = this.getExecutionInfo().getResponseIDCriterion();
        if (null != criterion) {
            String responseid = (String)criterion.getValues().get(0);
            this.getExecution().getConnection().getConnector().createCacheObjectRecord(requestID, partID, executionID, Integer.toString(invocationNumber), responseid);
            result = new Response(responseid, (DocumentProducer)this, cache, true, cacheReference);
        } else {
            this.createRequest(this.getExecutionInfo().getParameters());
            Document response = this.executeCall();
            DocumentInfo info = this.xmlExtractor.createDocumentFromJDOM(response, "");
            XMLDocument doc = new XMLDocument((Object)info.m_domDoc, info.m_externalFiles);
            SOAPDocBuilder.removeEnvelope((SOAPConnectorState)this.getState(), doc);
            XMLDocument[] docs = new XMLDocument[]{doc};
            String cacheKey = this.getCacheKey(1);
            String[] cacheKeys = new String[]{cacheKey};
            cache.addToCache(cacheKey, doc, info.m_memoryCacheSize, cacheReference);
            connector.createCacheObjectRecord(requestID, partID, executionID, Integer.toString(invocationNumber), cacheKey);
            result = new Response(docs, cacheKeys, (DocumentProducer)this, cache, this.getState().isErrorOnRecreateDoc(), cacheReference);
        }
        return result;
    }

    private Document executeCall() throws ConnectorException {
        try {
            TrustedPayloadHandler handler = this.getExecution().getConnection().getTrustedPayloadHandler();
            ConnectorEnvironment env = this.getExecution().getConnection().getConnectorEnv();
            this.secToken = SecurityToken.getSecurityToken((ConnectorEnvironment)env, (TrustedPayloadHandler)handler);
            Service service = new Service(this.getMyConfig());
            Call call = new Call(service);
            call.setSOAPActionURI(this.getExecutionInfo().getOtherProperties().getProperty("SOAPAction"));
            call.setTransport((Transport)new HTTPTransport());
            call.setTargetEndpointAddress(this.removeAngleBrackets(this.buildUriString()));
            this.secToken.handleSecurity(call);
            Message message = new Message((Object)this.envelope);
            this.attemptConditionalLog("XML Connector Framework: request set to: " + this.envelope.toString());
            this.getLogger().logDetail("XML Connector Framework: request created");
            SOAPEnvelope response = call.invoke(message);
            SOAPBody responseBody = response.getBody();
            if (responseBody.hasFault() && ((SOAPConnectorState)this.getState()).isExceptionOnFault()) {
                SOAPFault fault = responseBody.getFault();
                String msgRaw = Messages.getString((String)"SOAPExecutor.soap.fault.message");
                String msg = MessageFormat.format((String)msgRaw, (Object[])new Object[]{fault.getFaultString(), fault.getFaultCode(), fault.getDetail()});
                throw new ConnectorException(msg);
            }
            org.w3c.dom.Document doc = responseBody.getOwnerDocument();
            return new DOMBuilder().build(doc);
        }
        catch (AxisFault e) {
            String faultReason = e.getFaultReason();
            String msg = "(Axis Fault) Reason: " + faultReason;
            throw new ConnectorException(msg);
        }
        catch (Exception e) {
            throw new ConnectorException((Throwable)e);
        }
    }

    private EngineConfiguration getMyConfig() {
        SimpleProvider clientConfig = new SimpleProvider();
        SimpleSessionHandler sessionHandler = new SimpleSessionHandler();
        SimpleChain reqHandler = new SimpleChain();
        if (this.secToken instanceof CallbackHandler) {
            reqHandler.addHandler((Handler)new WSDoAllSender());
        }
        SimpleChain respHandler = new SimpleChain();
        reqHandler.addHandler((Handler)sessionHandler);
        respHandler.addHandler((Handler)sessionHandler);
        FilteringHTTPSender fhttpSender = new FilteringHTTPSender(this.getState(), this.getLogger());
        SOAPConnectorState state = (SOAPConnectorState)this.getState();
        fhttpSender.httpChunkStream = state.isUseHttpChunking();
        SimpleTargetedChain transport = new SimpleTargetedChain((Handler)reqHandler, (Handler)fhttpSender, (Handler)respHandler);
        clientConfig.deployTransport("http", (Handler)transport);
        return clientConfig;
    }

    protected void createRequest(List params) throws ConnectorException {
        SOAPConnectorState state = (SOAPConnectorState)this.getState();
        ArrayList requestPerms = RequestGenerator.getRequestPerms((List)params);
        CriteriaDesc[] queryParameters = (CriteriaDesc[])requestPerms.get(0);
        List<CriteriaDesc> newList = Arrays.asList(queryParameters);
        ArrayList<CriteriaDesc> queryList = new ArrayList<CriteriaDesc>(newList);
        ArrayList headerParams = new ArrayList();
        ArrayList bodyParams = new ArrayList();
        this.sortParams(queryList, headerParams, bodyParams);
        String namespacePrefixes = this.getExecutionInfo().getOtherProperties().getProperty("NamespacePrefixes");
        String inputParmsXPath = this.getExecutionInfo().getOtherProperties().getProperty("XPathRootForInput");
        SOAPDocBuilder builder = new SOAPDocBuilder();
        Document doc = builder.createXMLRequestDoc(bodyParams, (SOAPConnectorState)this.getState(), namespacePrefixes, inputParmsXPath);
        org.jdom.Element docRoot = doc.getRootElement();
        DOMOutputter domOutputter = new DOMOutputter();
        try {
            if (docRoot.getNamespaceURI().equals("http://www.metamatrix.com/dummy")) {
                org.w3c.dom.Document dummyNode = domOutputter.output(doc);
                NodeList children = dummyNode.getChildNodes().item(0).getChildNodes();
                for (int j = 0; j < children.getLength(); ++j) {
                    Element child = (Element)children.item(j);
                    this.envelope.getBody().addChildElement((SOAPElement)new SOAPBodyElement(child));
                }
            } else {
                org.w3c.dom.Document document = domOutputter.output(doc);
                Element child = (Element)document.getFirstChild();
                this.envelope.getBody().addChildElement((SOAPElement)new SOAPBodyElement(child));
            }
            List headers = builder.createSOAPHeaders((SOAPConnectorState)this.getState(), headerParams, namespacePrefixes, inputParmsXPath);
            for (SOAPHeaderElement headerElement : headers) {
                this.envelope.addHeader(headerElement);
            }
        }
        catch (Exception e) {
            throw new ConnectorException((Throwable)e);
        }
    }

    public String getCacheKey(int i) throws ConnectorException {
        StringBuffer cacheKey = new StringBuffer();
        cacheKey.append("|");
        cacheKey.append(this.getExecution().getConnection().getUser());
        cacheKey.append("|");
        cacheKey.append(this.getExecution().getConnection().getQueryId());
        cacheKey.append("|");
        cacheKey.append(this.buildUriString());
        cacheKey.append("|");
        try {
            cacheKey.append(this.envelope.getBody().toString());
        }
        catch (SOAPException e) {
            throw new ConnectorException(e.getMessage());
        }
        return cacheKey.toString();
    }

    public int getDocumentCount() throws ConnectorException {
        return 1;
    }

    private void sortParams(List allParams, List headerParams, List bodyParams) throws ConnectorException {
        for (CriteriaDesc desc : allParams) {
            if (desc.getInputXpath().startsWith("SOAP-ENV:Header")) {
                headerParams.add(desc);
                continue;
            }
            bodyParams.add(desc);
        }
    }

    public Serializable getRequestObject(int i) throws ConnectorException {
        try {
            return this.envelope.getBody().getValue();
        }
        catch (SOAPException e) {
            throw new ConnectorException((Throwable)e);
        }
    }
}

