/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.webservice.util;

import com.metamatrix.core.PluginUtil;
import com.metamatrix.core.util.I18nUtil;
import com.metamatrix.metamodels.core.ModelAnnotation;
import com.metamatrix.metamodels.core.ModelType;
import com.metamatrix.metamodels.webservice.Input;
import com.metamatrix.metamodels.webservice.Interface;
import com.metamatrix.metamodels.webservice.Operation;
import com.metamatrix.metamodels.webservice.Output;
import com.metamatrix.metamodels.webservice.aspects.sql.InputAspect;
import com.metamatrix.metamodels.webservice.aspects.sql.InterfaceAspect;
import com.metamatrix.metamodels.webservice.aspects.sql.OperationAspect;
import com.metamatrix.metamodels.webservice.aspects.sql.OutputAspect;
import com.metamatrix.metamodels.xml.XmlDocument;
import com.metamatrix.metamodels.xml.XmlElement;
import com.metamatrix.metamodels.xml.XmlSequence;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlAspectHelper;
import com.metamatrix.modeler.core.util.ModelContents;
import com.metamatrix.modeler.core.util.NewModelObjectHelperManager;
import com.metamatrix.modeler.core.validation.ValidationResult;
import com.metamatrix.modeler.core.validation.rules.CoreValidationRulesUtil;
import com.metamatrix.modeler.core.workspace.ModelProject;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceItem;
import com.metamatrix.modeler.internal.core.builder.ModelBuildUtil;
import com.metamatrix.modeler.internal.core.resource.xmi.MtkXmiResourceImpl;
import com.metamatrix.modeler.internal.core.validation.ValidationResultImpl;
import com.metamatrix.modeler.internal.transformation.util.TransformationHelper;
import com.metamatrix.modeler.internal.transformation.util.TransformationMappingHelper;
import com.metamatrix.modeler.internal.transformation.util.TransformationSqlHelper;
import com.metamatrix.modeler.webservice.WebServicePlugin;
import com.metamatrix.modeler.webservice.procedure.XsdInstanceNode;
import com.metamatrix.modeler.webservice.util.WebServiceBuildOptions;
import com.metamatrix.modeler.webservice.util.WebServiceUtil;
import com.metamatrix.query.sql.lang.Query;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDElementDeclaration;

public class WebServiceBuilderHelper {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(WebServiceBuilderHelper.class);
    private static final String FILE_EXT = ".xmi";
    public static boolean HEADLESS = false;
    private final PluginUtil Util = WebServicePlugin.Util;
    private MultiStatus result = new MultiStatus("com.metamatrix.modeler.webservice", 0, this.Util.getString("WebServiceBuilderHelper.result"), null);
    private String parentPath;
    private ModelResource wsModel;
    private Collection transformationsToFinish;
    private boolean createMultipleWebServices = false;
    private boolean useLocationContainer;
    private IContainer locationContainer;

    private static Command getInterfaceDescriptor(Resource resource) {
        EObject eObj;
        SqlAspect aspect;
        Command interfaceDescriptor = null;
        Collection descriptors = null;
        try {
            descriptors = ModelerCore.getModelEditor().getNewRootObjectCommands(resource);
        }
        catch (ModelerCoreException e) {
            String message = WebServiceBuilderHelper.getString("getInterfaceDescriptor.errMsg");
            WebServicePlugin.Util.log(4, (Throwable)e, message);
            return null;
        }
        Iterator iter = descriptors.iterator();
        while (iter.hasNext() && !((aspect = SqlAspectHelper.getSqlAspect((EObject)(eObj = (EObject)(interfaceDescriptor = (Command)iter.next()).getResult().iterator().next()))) instanceof InterfaceAspect)) {
        }
        return interfaceDescriptor;
    }

    private static Command getOperationDescriptor(EObject targetEObject) {
        EObject eObj;
        SqlAspect aspect;
        Command operationDescriptor = null;
        Collection descriptors = null;
        try {
            descriptors = ModelerCore.getModelEditor().getNewChildCommands(targetEObject);
        }
        catch (ModelerCoreException e) {
            String message = WebServiceBuilderHelper.getString("getOperationDescriptor.errMsg");
            WebServicePlugin.Util.log(4, (Throwable)e, message);
            return null;
        }
        Iterator iter = descriptors.iterator();
        while (iter.hasNext() && !((aspect = SqlAspectHelper.getSqlAspect((EObject)(eObj = (EObject)(operationDescriptor = (Command)iter.next()).getResult().iterator().next()))) instanceof OperationAspect)) {
        }
        return operationDescriptor;
    }

    private static Command getOperationInputDescriptor(EObject targetEObject) {
        EObject eObj;
        SqlAspect aspect;
        Command operationInputDescriptor = null;
        Collection descriptors = null;
        try {
            descriptors = ModelerCore.getModelEditor().getNewChildCommands(targetEObject);
        }
        catch (ModelerCoreException e) {
            String message = WebServiceBuilderHelper.getString("getOperationInputDescriptor.errMsg");
            WebServicePlugin.Util.log(4, (Throwable)e, message);
            return null;
        }
        Iterator iter = descriptors.iterator();
        while (iter.hasNext() && !((aspect = SqlAspectHelper.getSqlAspect((EObject)(eObj = (EObject)(operationInputDescriptor = (Command)iter.next()).getResult().iterator().next()))) instanceof InputAspect)) {
        }
        return operationInputDescriptor;
    }

    private static Command getOperationOutputDescriptor(EObject targetEObject) {
        EObject eObj;
        SqlAspect aspect;
        Command operationOutputDescriptor = null;
        Collection descriptors = null;
        try {
            descriptors = ModelerCore.getModelEditor().getNewChildCommands(targetEObject);
        }
        catch (ModelerCoreException e) {
            String message = WebServiceBuilderHelper.getString("getOperationOutputDescriptor.errMsg");
            WebServicePlugin.Util.log(4, (Throwable)e, message);
            return null;
        }
        Iterator iter = descriptors.iterator();
        while (iter.hasNext() && !((aspect = SqlAspectHelper.getSqlAspect((EObject)(eObj = (EObject)(operationOutputDescriptor = (Command)iter.next()).getResult().iterator().next()))) instanceof OutputAspect)) {
        }
        return operationOutputDescriptor;
    }

    private static String getString(String theKey) {
        return WebServicePlugin.Util.getString(new StringBuffer().append(PREFIX).append(theKey).toString());
    }

    public static String validateModelName(String proposedName, String fileExtension) {
        boolean removedValidExtension = false;
        if (proposedName.endsWith(fileExtension)) {
            proposedName = proposedName.substring(0, proposedName.lastIndexOf(fileExtension));
            removedValidExtension = true;
        }
        if (proposedName.indexOf(46) != -1 && !removedValidExtension) {
            return WebServicePlugin.Util.getString("ModelUtilities.illegalExtensionMessage", (Object)fileExtension);
        }
        ValidationResultImpl result = new ValidationResultImpl((Object)proposedName);
        CoreValidationRulesUtil.validateStringNameChars((ValidationResult)result, (String)proposedName, null);
        if (result.hasProblems()) {
            return result.getProblems()[0].getMessage();
        }
        return null;
    }

    private void addStatus(String msg, int severity, Throwable err) {
        if (this.result == null) {
            this.result = new MultiStatus("com.metamatrix.modeler.webservice", 0, this.Util.getString("WebServiceBuilderHelper.result"), null);
        }
        Status status = new Status(severity, "com.metamatrix.modeler.webservice", 0, msg, err);
        this.result.add((IStatus)status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object createInterface(Resource resource, String interfaceName, IProgressMonitor monitor) {
        EObject newInterface = null;
        monitor = monitor == null ? new NullProgressMonitor() : monitor;
        for (Object element : resource.getContents()) {
            EObject obj = (EObject)element;
            if (!(obj instanceof Interface) || !interfaceName.equals(((Interface)obj).getName())) continue;
            return obj;
        }
        String txnDescr = WebServiceBuilderHelper.getString("createInterface.txnDescr");
        boolean startedTxn = ModelerCore.startTxn((boolean)false, (boolean)false, (String)txnDescr, (Object)this);
        try {
            Command interfaceToCreate = WebServiceBuilderHelper.getInterfaceDescriptor(resource);
            if (interfaceToCreate != null) {
                try {
                    newInterface = ModelerCore.getModelEditor().createNewRootObjectFromCommand(resource, interfaceToCreate);
                    ModelerCore.getModelEditor().rename(newInterface, interfaceName);
                }
                catch (ModelerCoreException theException) {
                    String message = WebServiceBuilderHelper.getString("createInterface.errMsg");
                    WebServicePlugin.Util.log(4, (Throwable)theException, message);
                }
            }
        }
        catch (Exception e) {
            String message = WebServiceBuilderHelper.getString("createInterface.errMsg");
            this.addStatus(message, 4, e);
        }
        finally {
            if (startedTxn) {
                ModelerCore.commitTxn();
            }
        }
        return newInterface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object createModel(ModelProject project, String modelName, IProgressMonitor monitor) {
        Object newModel = null;
        monitor = monitor == null ? new NullProgressMonitor() : monitor;
        String txnDescr = WebServiceBuilderHelper.getString("createModel.txnDescr");
        boolean startedTxn = ModelerCore.startTxn((boolean)false, (boolean)false, (String)txnDescr, (Object)this);
        try {
            boolean foundExisting = false;
            List wsModels = this.getWebServiceModelsForProject(project);
            for (Object mr : wsModels) {
                String mName = null;
                if (mr instanceof ModelResource) {
                    mName = ModelerCore.getModelEditor().getModelName((ModelResource)mr);
                } else if (mr instanceof Resource) {
                    mName = ModelerCore.getModelEditor().getModelName((Resource)mr);
                }
                if (mName == null || !mName.equalsIgnoreCase(modelName)) continue;
                newModel = mr;
                foundExisting = true;
                break;
            }
            if (!foundExisting) {
                if (HEADLESS) {
                    newModel = this.createWebServiceModel(null, modelName);
                } else {
                    IResource targetResource = project.getResource();
                    if (this.isValidWebServiceModelName(targetResource, modelName)) {
                        newModel = this.createWebServiceModel(targetResource, modelName);
                    }
                }
            }
        }
        catch (Exception e) {
            String err = WebServiceBuilderHelper.getString("createModel.errMsg");
            this.addStatus(err, 4, e);
        }
        finally {
            if (startedTxn) {
                ModelerCore.commitTxn();
            }
        }
        return newModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object createOperation(EObject theInterface, String operationName, String inputName, String outputName, IProgressMonitor monitor) {
        EObject newOperation;
        block15: {
            newOperation = null;
            monitor = monitor == null ? new NullProgressMonitor() : monitor;
            Interface i = (Interface)theInterface;
            ArrayList<String> opNames = new ArrayList<String>(i.getOperations().size());
            Iterator iter = i.getOperations().iterator();
            while (iter.hasNext()) {
                opNames.add(((Operation)iter.next()).getName());
            }
            String newName = operationName;
            EList siblings = i.getOperations();
            if (siblings != null) {
                HashSet<String> siblingNames = new HashSet<String>();
                Iterator it = siblings.iterator();
                while (it.hasNext()) {
                    siblingNames.add(((Operation)it.next()).getName());
                }
                boolean foundUniqueName = false;
                int index = 1;
                while (!foundUniqueName) {
                    if (siblingNames.contains(newName)) {
                        newName = operationName + String.valueOf(index++);
                        continue;
                    }
                    foundUniqueName = true;
                }
            }
            operationName = newName;
            String txnDescr = WebServiceBuilderHelper.getString("createOperation.txnDescr");
            boolean startedTxn = ModelerCore.startTxn((boolean)false, (boolean)false, (String)txnDescr, (Object)this);
            try {
                Command operationToCreate = WebServiceBuilderHelper.getOperationDescriptor(theInterface);
                if (operationToCreate == null) break block15;
                try {
                    newOperation = ModelerCore.getModelEditor().createNewChildFromCommand(theInterface, operationToCreate);
                    ModelerCore.getModelEditor().rename(newOperation, operationName);
                    if (inputName != null) {
                        Command operationInputToCreate = WebServiceBuilderHelper.getOperationInputDescriptor(newOperation);
                        EObject newInputMessage = ModelerCore.getModelEditor().createNewChildFromCommand(newOperation, operationInputToCreate);
                        ModelerCore.getModelEditor().rename(newInputMessage, inputName);
                    }
                    Command operationOutputToCreate = WebServiceBuilderHelper.getOperationOutputDescriptor(newOperation);
                    EObject newOutputMessage = ModelerCore.getModelEditor().createNewChildFromCommand(newOperation, operationOutputToCreate);
                    ModelerCore.getModelEditor().rename(newOutputMessage, outputName);
                    if (newOperation != null) {
                        NewModelObjectHelperManager.helpCreate((Object)newOperation, null);
                    }
                }
                catch (ModelerCoreException theException) {
                    String message = WebServiceBuilderHelper.getString("createOperation.errMsg");
                    WebServicePlugin.Util.log(4, (Throwable)theException, message);
                }
            }
            catch (Exception e) {
                String message = WebServiceBuilderHelper.getString("createOperation.errMsg");
                this.addStatus(message, 4, e);
            }
            finally {
                if (startedTxn) {
                    ModelerCore.commitTxn();
                }
            }
        }
        return newOperation;
    }

    private String createSqlAssignment(Operation operation, XSDElementDeclaration elem) {
        StringBuffer sbuffer = new StringBuffer();
        if (operation != null && elem != null) {
            String operationInputName = this.getSqlFullName((EObject)operation.getInput());
            String name = elem.getName();
            sbuffer.append("VARIABLES.IN_");
            sbuffer.append(name.toUpperCase());
            sbuffer.append(" = xPathValue(");
            sbuffer.append(operationInputName);
            sbuffer.append(", '");
            XsdInstanceNode node = this.findNode(new XsdInstanceNode(operation.getInput().getContentElement()), elem);
            sbuffer.append(WebServiceUtil.createXPath((XsdInstanceNode)node));
            sbuffer.append("');");
        }
        return sbuffer.toString();
    }

    private String createSqlCriteria(XmlElement docElem, XSDElementDeclaration elem) {
        XmlElement docInstanceElem = docElem;
        EList elementChildren = docElem.eContents();
        for (Object obj : elementChildren) {
            XmlSequence seq;
            EList seqElems;
            Object seqElemObj;
            if (!(obj instanceof XmlSequence) || !((seqElemObj = (seqElems = (seq = (XmlSequence)obj).getEntities()).get(0)) instanceof XmlElement)) continue;
            docInstanceElem = (XmlElement)seqElemObj;
            break;
        }
        StringBuffer sbuffer = new StringBuffer();
        if (docInstanceElem != null && elem != null) {
            String docStr = this.getSqlFullName((EObject)docInstanceElem);
            String inpName = elem.getName();
            if (docStr != null) {
                Container cntr = ModelerCore.getContainer((EObject)docElem);
                String runtimeType = cntr.getDatatypeManager().getRuntimeTypeName((EObject)elem.getType());
                sbuffer.append(docStr);
                sbuffer.append(".");
                sbuffer.append(inpName);
                if (runtimeType != null && !runtimeType.equals("string")) {
                    sbuffer.append(" = convert(");
                    sbuffer.append("VARIABLES.IN_");
                    sbuffer.append(inpName.toUpperCase());
                    sbuffer.append(", ");
                    sbuffer.append(runtimeType);
                    sbuffer.append(")");
                } else {
                    sbuffer.append(" = ");
                    sbuffer.append("VARIABLES.IN_");
                    sbuffer.append(inpName.toUpperCase());
                }
            } else {
                sbuffer.append("DocElement = ");
                sbuffer.append("VARIABLES.IN_");
                sbuffer.append(inpName.toUpperCase());
            }
        }
        return sbuffer.toString();
    }

    private String createSqlDeclaration(XSDElementDeclaration elem) {
        StringBuffer sbuffer = new StringBuffer();
        if (elem != null) {
            sbuffer.append("DECLARE string VARIABLES.IN_");
            sbuffer.append(elem.getName().toUpperCase());
            sbuffer.append(";");
        }
        return sbuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiStatus createWebService(WebServiceBuildOptions buildOptions, boolean autoGenSQL, boolean saveModel, IProgressMonitor monitor) {
        this.useLocationContainer = buildOptions.shouldUseLocationContainer();
        this.locationContainer = buildOptions.getLocationContainer();
        String txnDescr = WebServiceBuilderHelper.getString("createWebService.txnDescr");
        boolean startedTxn = ModelerCore.startTxn((boolean)false, (boolean)false, (String)txnDescr, (Object)this);
        try {
            String operationOutputMessageName;
            String operationInputMessageName;
            String operationName;
            Object returnedObj;
            ModelProject project = buildOptions.getCurrentProject();
            ModelResource model = null;
            Resource resource = null;
            Object modelObj = buildOptions.getModel();
            if (modelObj != null && modelObj instanceof ModelResource) {
                model = (ModelResource)modelObj;
                resource = model.getEmfResource();
            } else if (modelObj instanceof String) {
                String modelName = (String)modelObj;
                Object returnedObj2 = this.createModel(project, modelName, monitor);
                if (returnedObj2 instanceof ModelResource) {
                    this.wsModel = model = (ModelResource)returnedObj2;
                    resource = model.getEmfResource();
                } else if (HEADLESS && returnedObj2 instanceof Resource) {
                    resource = (Resource)returnedObj2;
                }
            }
            Interface theInterface = null;
            if (resource != null && this.result.getSeverity() < 4) {
                String interfaceName;
                Object returnedObj3;
                Object interfaceObj = buildOptions.getInterface();
                if (interfaceObj != null && interfaceObj instanceof Interface) {
                    theInterface = (Interface)interfaceObj;
                } else if (interfaceObj instanceof String && (returnedObj3 = this.createInterface(resource, interfaceName = (String)interfaceObj, monitor)) instanceof Interface) {
                    theInterface = (Interface)returnedObj3;
                }
            }
            Operation theOperation = null;
            if (theInterface != null && this.result.getSeverity() < 4 && (returnedObj = this.createOperation((EObject)theInterface, operationName = buildOptions.getOperationName(), operationInputMessageName = buildOptions.getOperationInputMessageName(), operationOutputMessageName = buildOptions.getOperationOutputMessageName(), monitor)) instanceof Operation) {
                theOperation = (Operation)returnedObj;
            }
            XmlDocument outputDoc = null;
            if (theOperation != null && this.result.getSeverity() < 4) {
                Output opOutput;
                XSDElementDeclaration inputElem = buildOptions.getOperationInputMessageElem();
                XSDElementDeclaration outputElem = buildOptions.getOperationOutputMessageElem();
                outputDoc = buildOptions.getOperationOutputXmlDoc();
                Input opInput = theOperation.getInput();
                if (opInput != null) {
                    opInput.setContentElement(inputElem);
                }
                if ((opOutput = theOperation.getOutput()) != null) {
                    opOutput.setContentElement(outputElem);
                    opOutput.setXmlDocument(outputDoc);
                }
            }
            if (!HEADLESS) {
                TransformationFinisher finisher = new TransformationFinisher(model, outputDoc, theOperation, autoGenSQL);
                if (!this.createMultipleWebServices) {
                    finisher.finish();
                } else {
                    this.transformationsToFinish.add(finisher);
                }
            }
            try {
                ModelBuildUtil.rebuildImports((Resource)model.getEmfResource(), (Object)this, (boolean)false);
            }
            catch (ModelWorkspaceException e) {
                this.Util.log((Throwable)e);
            }
            if (saveModel && model != null) {
                try {
                    model.save(monitor, true);
                }
                catch (Exception e) {
                    String saveError = WebServiceBuilderHelper.getString("createWebService.errSave");
                    this.addStatus(saveError, 4, e);
                }
            }
        }
        catch (Exception e) {
            String err = WebServiceBuilderHelper.getString("createWebService.errMsg");
            this.addStatus(err, 4, e);
        }
        finally {
            if (startedTxn) {
                ModelerCore.commitTxn();
            }
        }
        return this.result;
    }

    private Object createWebServiceModel(IResource targetRes, String modelName) {
        String fileName = this.getFileName(modelName);
        if (HEADLESS) {
            if (this.parentPath != null) {
                fileName = this.parentPath + File.separator + modelName;
            }
            URI uri = URI.createURI((String)fileName);
            try {
                Resource rsrc = ModelerCore.getModelContainer().createResource(uri);
                ModelContents mc = ModelerCore.getModelEditor().getModelContents(rsrc);
                mc.getModelAnnotation().setPrimaryMetamodelUri("http://www.metamatrix.com/metamodels/WebService");
                mc.getModelAnnotation().setModelType(ModelType.VIRTUAL_LITERAL);
                return rsrc;
            }
            catch (CoreException err) {
                return null;
            }
        }
        IFile modelFile = null;
        ModelResource resrc = null;
        boolean exists = false;
        if (this.parentPath == null) {
            IPath relativeModelPath = null;
            if (this.useLocationContainer) {
                IWorkspaceRoot wsroot = ResourcesPlugin.getWorkspace().getRoot();
                relativeModelPath = this.locationContainer.getFullPath();
                modelFile = wsroot.getFileForLocation(wsroot.getRawLocation().append(relativeModelPath).append(fileName));
            } else {
                relativeModelPath = targetRes.getProjectRelativePath().append(fileName);
                modelFile = targetRes.getProject().getFile(relativeModelPath);
            }
        } else {
            Path path = new Path(this.parentPath + File.separator + fileName);
            IWorkspaceRoot wsroot = ResourcesPlugin.getWorkspace().getRoot();
            modelFile = wsroot.getFileForLocation((IPath)path);
            exists = new File(path.toString()).exists();
        }
        if (modelFile != null) {
            resrc = ModelerCore.create((IFile)modelFile);
            if (!exists) {
                try {
                    resrc.getModelAnnotation().setPrimaryMetamodelUri("http://www.metamatrix.com/metamodels/WebService");
                    resrc.getModelAnnotation().setModelType(ModelType.VIRTUAL_LITERAL);
                    try {
                        String msg = this.Util.getString("WebServiceBuilderHelper.newModel", (Object)modelFile.getName());
                        this.addStatus(msg, 1, null);
                        resrc.save(null, false);
                    }
                    catch (ModelWorkspaceException e) {
                        WebServicePlugin.Util.log((Throwable)e);
                    }
                }
                catch (ModelWorkspaceException e) {
                    e.printStackTrace();
                }
            }
        }
        return resrc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiStatus createWebServices(Collection buildOptions, boolean autoGenSQL, MultiStatus result, IProgressMonitor monitor) {
        if (result != null) {
            this.result = result;
        }
        this.createMultipleWebServices = true;
        String txnDescr = WebServiceBuilderHelper.getString("createWebServices.txnDescr");
        boolean startedTxn = ModelerCore.startTxn((boolean)false, (boolean)false, (String)txnDescr, (Object)this);
        try {
            if (buildOptions != null && buildOptions.size() > 0) {
                this.transformationsToFinish = new ArrayList(buildOptions.size());
                for (WebServiceBuildOptions option : buildOptions) {
                    this.createWebService(option, autoGenSQL, false, monitor);
                }
                HashSet<ModelResource> modelsToIndex = new HashSet<ModelResource>();
                for (TransformationFinisher finisher : this.transformationsToFinish) {
                    modelsToIndex.add(finisher.model);
                }
                if (!modelsToIndex.isEmpty()) {
                    HashSet<IResource> iResources = new HashSet<IResource>(modelsToIndex.size());
                    for (ModelResource mr : modelsToIndex) {
                        IResource resrc = mr.getCorrespondingResource();
                        if (resrc == null) continue;
                        iResources.add(resrc);
                    }
                    ModelBuildUtil.indexResources(null, iResources);
                }
                for (TransformationFinisher finisher : this.transformationsToFinish) {
                    finisher.finish();
                }
                this.saveModels(buildOptions, monitor);
            }
        }
        catch (Exception e) {
            String err = WebServiceBuilderHelper.getString("createWebServices.errMsg");
            this.addStatus(err, 4, e);
        }
        finally {
            if (startedTxn) {
                ModelerCore.commitTxn();
            }
        }
        this.createMultipleWebServices = false;
        return result;
    }

    private String createWhereClause(List sqlCriteria) {
        StringBuffer sbuffer = new StringBuffer();
        if (sqlCriteria != null && !sqlCriteria.isEmpty()) {
            sbuffer.append(" WHERE ");
            Iterator criteriaIter = sqlCriteria.iterator();
            while (criteriaIter.hasNext()) {
                sbuffer.append(" (");
                sbuffer.append((String)criteriaIter.next());
                sbuffer.append(") ");
                if (!criteriaIter.hasNext()) continue;
                sbuffer.append(" AND ");
            }
        }
        return sbuffer.toString();
    }

    private XsdInstanceNode findNode(XsdInstanceNode node, XSDElementDeclaration element) {
        if (node.getResolvedXsdComponent() == element) {
            return node;
        }
        XsdInstanceNode[] nodes = node.getChildren();
        int ndx = nodes.length;
        while (--ndx >= 0) {
            node = this.findNode(nodes[ndx], element);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    String generateDefaultSQL(XmlDocument outputDoc, Operation operation) {
        StringBuffer sbuffer = new StringBuffer();
        sbuffer.append("CREATE VIRTUAL PROCEDURE ");
        sbuffer.append("BEGIN ");
        Query qry = TransformationSqlHelper.createDefaultQuery((EObject)outputDoc);
        if (qry != null) {
            sbuffer.append(qry.toString());
            sbuffer.append(";");
        }
        sbuffer.append(" END");
        return sbuffer.toString();
    }

    String generateSQLUsingMessageElements(XmlDocument outputDoc, Operation operation) {
        Iterator inpIter;
        if (HEADLESS) {
            return this.generateDefaultSQL(outputDoc, operation);
        }
        StringBuffer sbuffer = new StringBuffer();
        sbuffer.append("CREATE VIRTUAL PROCEDURE ");
        sbuffer.append("BEGIN ");
        List inputElems = WebServiceUtil.getInputElements((Operation)operation, (boolean)true);
        if (!inputElems.isEmpty()) {
            inpIter = inputElems.iterator();
            while (inpIter.hasNext()) {
                String sqlDeclare = this.createSqlDeclaration((XSDElementDeclaration)inpIter.next());
                sbuffer.append(sqlDeclare);
            }
        } else {
            sbuffer.append("DECLARE string ");
            sbuffer.append("VARIABLES.IN_");
            sbuffer.append("exampleVar ;");
        }
        if (!inputElems.isEmpty()) {
            inpIter = inputElems.iterator();
            while (inpIter.hasNext()) {
                String sqlAssign = this.createSqlAssignment(operation, (XSDElementDeclaration)inpIter.next());
                sbuffer.append(sqlAssign);
            }
        } else {
            String operationInputName = "inputMessage";
            if (operation != null) {
                operationInputName = this.getSqlFullName((EObject)operation.getInput());
            }
            sbuffer.append("VARIABLES.IN_");
            sbuffer.append("exampleVar = xPathValue(");
            sbuffer.append(operationInputName);
            sbuffer.append(", '//*[local-name()=\"exampleName\"]');");
        }
        Query qry = TransformationSqlHelper.createDefaultQuery((EObject)outputDoc);
        if (qry != null) {
            sbuffer.append(qry.toString());
            ArrayList<String> criteriaList = new ArrayList<String>();
            if (!inputElems.isEmpty()) {
                XmlElement docElement = this.getDocElemMatchingOperationOutputElem(outputDoc, operation);
                Iterator inpIter2 = inputElems.iterator();
                while (inpIter2.hasNext()) {
                    String criteria = this.createSqlCriteria(docElement, (XSDElementDeclaration)inpIter2.next());
                    criteriaList.add(criteria);
                }
            }
            if (!criteriaList.isEmpty()) {
                String whereClause = this.createWhereClause(criteriaList);
                sbuffer.append(whereClause);
            }
            sbuffer.append(";");
        }
        sbuffer.append(" END");
        return sbuffer.toString();
    }

    private XmlElement getDocElemMatchingOperationOutputElem(XmlDocument xmlDoc, Operation operation) {
        XmlElement docElement = null;
        if (xmlDoc != null && operation != null) {
            Output outp = operation.getOutput();
            XSDElementDeclaration outputElem = outp.getContentElement();
            TreeIterator docIter = xmlDoc.eAllContents();
            while (docIter.hasNext()) {
                XmlElement xmlElem;
                XSDComponent xsdComp;
                Object elem = docIter.next();
                if (!(elem instanceof XmlElement) || (xsdComp = (xmlElem = (XmlElement)elem).getXsdComponent()) == null || !xsdComp.equals(outputElem)) continue;
                docElement = xmlElem;
                break;
            }
        }
        return docElement;
    }

    private String getFileName(String modelName) {
        String result = modelName.trim();
        if (!result.endsWith(FILE_EXT)) {
            result = result + FILE_EXT;
        }
        return result;
    }

    public String getParentPath() {
        return this.parentPath;
    }

    private String getSqlFullName(EObject eObj) {
        SqlAspect aspect;
        String fullName = null;
        if (eObj != null && (aspect = SqlAspectHelper.getSqlAspect((EObject)eObj)) != null) {
            fullName = aspect.getFullName(eObj);
        }
        return fullName;
    }

    public ModelResource getWebServiceModel() {
        return this.wsModel;
    }

    private List getWebServiceModelsForProject(ModelProject project) {
        if (HEADLESS) {
            ArrayList<Resource> result = new ArrayList<Resource>();
            try {
                for (Resource next : ModelerCore.getModelContainer().getResources()) {
                    ModelContents contents;
                    ModelAnnotation ma;
                    if (!(next instanceof MtkXmiResourceImpl) || !"http://www.metamatrix.com/metamodels/WebService".equals((ma = (contents = ModelerCore.getModelEditor().getModelContents(next)).getModelAnnotation()).getPrimaryMetamodelUri())) continue;
                    result.add(next);
                }
            }
            catch (Exception err) {
                // empty catch block
            }
            return result;
        }
        ArrayList<ModelResource> allWebServiceModels = new ArrayList<ModelResource>();
        ModelWorkspaceItem[] workspaceItems = null;
        try {
            workspaceItems = project.getChildren();
        }
        catch (ModelWorkspaceException err) {
            // empty catch block
        }
        if (workspaceItems != null) {
            for (ModelWorkspaceItem workspaceItem : workspaceItems) {
                IResource resource = null;
                try {
                    resource = workspaceItem.getCorrespondingResource();
                }
                catch (ModelWorkspaceException err) {
                    // empty catch block
                }
                ModelResource mr = null;
                if (!(resource instanceof IFile)) continue;
                try {
                    mr = ModelerCore.getModelEditor().findModelResource((IFile)resource);
                }
                catch (ModelWorkspaceException e) {
                    e.printStackTrace();
                }
                if (mr == null || !WebServiceUtil.isWebServiceModelResource((ModelResource)mr)) continue;
                allWebServiceModels.add(mr);
            }
        }
        return allWebServiceModels;
    }

    private boolean isValidWebServiceModelName(IResource targetResource, String modelName) {
        if (modelName == null || modelName.length() == 0) {
            return false;
        }
        String fileNameMessage = WebServiceBuilderHelper.validateModelName(modelName, FILE_EXT);
        if (fileNameMessage != null) {
            return false;
        }
        String fileName = this.getFileName(modelName);
        IPath modelRelativePath = null;
        if (targetResource != null) {
            modelRelativePath = targetResource.getProjectRelativePath().append(fileName);
        }
        return targetResource == null || !targetResource.getProject().exists(modelRelativePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveModels(Collection webServiceBuildOptions, IProgressMonitor monitor) {
        monitor = monitor == null ? new NullProgressMonitor() : monitor;
        String txnDescr = WebServiceBuilderHelper.getString("saveModels.txnDescr");
        boolean startedTxn = ModelerCore.startTxn((boolean)false, (boolean)false, (String)txnDescr, (Object)this);
        ArrayList<ModelResource> savedModels = new ArrayList<ModelResource>();
        try {
            block5: for (WebServiceBuildOptions wsOption : webServiceBuildOptions) {
                Object model = wsOption.getModel();
                if (model instanceof ModelResource) {
                    ModelResource modelRes = (ModelResource)model;
                    if (savedModels.contains(modelRes)) continue;
                    modelRes.save(monitor, true);
                    savedModels.add(modelRes);
                    continue;
                }
                if (!(model instanceof String)) continue;
                String modelName = (String)model;
                ModelProject project = wsOption.getCurrentProject();
                List wsModels = this.getWebServiceModelsForProject(project);
                for (Object tmp : wsModels) {
                    String mName = null;
                    ModelResource mr = null;
                    if (tmp instanceof ModelResource) {
                        mr = (ModelResource)tmp;
                        mName = ModelerCore.getModelEditor().getModelName(mr);
                    } else if (tmp instanceof Resource) {
                        mName = ModelerCore.getModelEditor().getModelName((Resource)tmp);
                    }
                    if (mName == null || !mName.equalsIgnoreCase(modelName) || mr == null) continue;
                    if (savedModels.contains(mr)) continue block5;
                    mr.save(monitor, true);
                    savedModels.add(mr);
                    continue block5;
                }
            }
        }
        catch (Exception e) {
            String err = WebServiceBuilderHelper.getString("saveModels.errMsg");
            this.addStatus(err, 4, e);
        }
        finally {
            if (startedTxn) {
                ModelerCore.commitTxn();
            }
        }
    }

    public void setParentPath(String parentPath) {
        this.parentPath = parentPath;
    }

    private class TransformationFinisher {
        ModelResource model;
        boolean autoGenSql;
        XmlDocument xmlOutputDoc;
        Operation operation;

        public TransformationFinisher(ModelResource theModel, XmlDocument theXmlDoc, Operation theOperation, boolean theAutoGenSql) {
            this.model = theModel;
            this.xmlOutputDoc = theXmlDoc;
            this.operation = theOperation;
            this.autoGenSql = theAutoGenSql;
        }

        protected void finish() {
            String sqlString = null;
            sqlString = this.autoGenSql ? WebServiceBuilderHelper.this.generateSQLUsingMessageElements(this.xmlOutputDoc, this.operation) : WebServiceBuilderHelper.this.generateDefaultSQL(this.xmlOutputDoc, this.operation);
            EObject mappingRoot = TransformationHelper.getMappingRoot((EObject)this.operation);
            TransformationHelper.setSelectSqlString((Object)mappingRoot, (String)sqlString, (boolean)false, null);
            TransformationMappingHelper.reconcileMappingsOnSqlChange((EObject)mappingRoot, null);
        }
    }
}

