/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.buffer;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.buffer.BufferManagerLookup;
import com.metamatrix.common.buffer.IndexedTupleSource;
import com.metamatrix.common.buffer.MemoryNotAvailableException;
import com.metamatrix.common.buffer.StorageManager;
import com.metamatrix.common.buffer.TupleBatch;
import com.metamatrix.common.buffer.TupleSourceID;
import com.metamatrix.common.buffer.TupleSourceNotFoundException;
import com.metamatrix.common.lob.LobChunk;
import java.util.List;
import java.util.Properties;

public interface BufferManager {
    public static final int STATUS_ACTIVE = 1;
    public static final int STATUS_FULL = 2;
    public static final int TYPE_CONNECTOR = 0;
    public static final int TYPE_PROCESSOR = 1;
    public static final int TYPE_FINAL = 2;

    public void initialize(BufferManagerLookup var1, Properties var2) throws MetaMatrixComponentException;

    public int getProcessorBatchSize();

    public int getConnectorBatchSize();

    public void addStorageManager(StorageManager var1);

    public TupleSourceID createTupleSource(List var1, String[] var2, String var3, int var4) throws MetaMatrixComponentException;

    public void removeTupleSource(TupleSourceID var1) throws TupleSourceNotFoundException, MetaMatrixComponentException;

    public void removeTupleSources(String var1) throws MetaMatrixComponentException;

    public IndexedTupleSource getTupleSource(TupleSourceID var1) throws TupleSourceNotFoundException, MetaMatrixComponentException;

    public TupleBatch pinTupleBatch(TupleSourceID var1, int var2, int var3) throws TupleSourceNotFoundException, MemoryNotAvailableException, MetaMatrixComponentException;

    public void unpinTupleBatch(TupleSourceID var1, int var2, int var3) throws TupleSourceNotFoundException, MetaMatrixComponentException;

    public void unpinTupleBatch(TupleSourceID var1, int var2, int var3, boolean var4) throws TupleSourceNotFoundException, MetaMatrixComponentException;

    public List getTupleSchema(TupleSourceID var1) throws TupleSourceNotFoundException, MetaMatrixComponentException;

    public void addTupleBatch(TupleSourceID var1, TupleBatch var2) throws TupleSourceNotFoundException, MetaMatrixComponentException;

    public int getRowCount(TupleSourceID var1) throws TupleSourceNotFoundException, MetaMatrixComponentException;

    public void setStatus(TupleSourceID var1, int var2) throws TupleSourceNotFoundException, MetaMatrixComponentException;

    public int getStatus(TupleSourceID var1) throws TupleSourceNotFoundException, MetaMatrixComponentException;

    public int getFinalRowCount(TupleSourceID var1) throws TupleSourceNotFoundException, MetaMatrixComponentException;

    public void addStreamablePart(TupleSourceID var1, LobChunk var2, int var3) throws TupleSourceNotFoundException, MetaMatrixComponentException;

    public LobChunk getStreamablePart(TupleSourceID var1, int var2) throws TupleSourceNotFoundException, MetaMatrixComponentException;

    public void stop();

    public void releasePinnedBatches() throws MetaMatrixComponentException;
}

