/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.common.aop.AOP;
import com.metamatrix.common.aop.ProxyFactory;
import com.metamatrix.core.log.Logger;
import com.metamatrix.jdbc.JDBCPlugin;
import com.metamatrix.jdbc.api.ResultSetMetaData;
import java.sql.SQLException;

public class FilteredResultsMetadata
implements ResultSetMetaData {
    private ResultSetMetaData delegate;
    private int actualColumnCount;
    Logger logger;
    static /* synthetic */ Class class$com$metamatrix$jdbc$FilteredResultsMetadata;
    static /* synthetic */ Class class$com$metamatrix$core$log$Logger;
    static /* synthetic */ Class class$com$metamatrix$jdbc$api$ResultSetMetaData;

    static FilteredResultsMetadata newInstance(ResultSetMetaData rsmd, int actualColumnCount, Logger logger) {
        if (AOP.useproxy()) {
            Class<?> clazz = class$com$metamatrix$jdbc$FilteredResultsMetadata;
            if (clazz == null) {
                clazz = class$com$metamatrix$jdbc$FilteredResultsMetadata = new FilteredResultsMetadata[0].getClass().getComponentType();
            }
            Class[] classArray = new Class[3];
            Class<?> clazz2 = class$com$metamatrix$jdbc$api$ResultSetMetaData;
            if (clazz2 == null) {
                clazz2 = class$com$metamatrix$jdbc$api$ResultSetMetaData = new ResultSetMetaData[0].getClass().getComponentType();
            }
            classArray[0] = clazz2;
            classArray[1] = Integer.TYPE;
            Class<?> clazz3 = class$com$metamatrix$core$log$Logger;
            if (clazz3 == null) {
                clazz3 = class$com$metamatrix$core$log$Logger = new Logger[0].getClass().getComponentType();
            }
            classArray[2] = clazz3;
            return (FilteredResultsMetadata)ProxyFactory.extend(clazz, classArray, new Object[]{rsmd, new Integer(actualColumnCount), logger});
        }
        return new FilteredResultsMetadata(rsmd, actualColumnCount, logger);
    }

    FilteredResultsMetadata(ResultSetMetaData rsmd, int actualColumnCount, Logger logger) {
        this.delegate = rsmd;
        this.actualColumnCount = actualColumnCount;
        this.logger = logger;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public int getColumnCount() throws SQLException {
        return this.actualColumnCount;
    }

    private void verifyColumnIndex(int index) throws SQLException {
        if (index > this.actualColumnCount) {
            throw new SQLException(JDBCPlugin.Util.getString("FilteredResultsMetadata.Invalid_index", index));
        }
    }

    public String getVirtualDatabaseName(int index) throws SQLException {
        this.verifyColumnIndex(index);
        return this.delegate.getVirtualDatabaseName(index);
    }

    public String getVirtualDatabaseVersion(int index) throws SQLException {
        this.verifyColumnIndex(index);
        return this.delegate.getVirtualDatabaseVersion(index);
    }

    public boolean isAutoIncrement(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return this.delegate.isAutoIncrement(column);
    }

    public boolean isCaseSensitive(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return this.delegate.isCaseSensitive(column);
    }

    public boolean isSearchable(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return this.delegate.isSearchable(column);
    }

    public boolean isCurrency(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return this.delegate.isCurrency(column);
    }

    public int isNullable(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return this.delegate.isNullable(column);
    }

    public boolean isSigned(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return this.delegate.isSigned(column);
    }

    public int getColumnDisplaySize(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return this.delegate.getColumnDisplaySize(column);
    }

    public String getColumnLabel(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return this.delegate.getColumnLabel(column);
    }

    public String getColumnName(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return this.delegate.getColumnName(column);
    }

    public String getSchemaName(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return this.delegate.getSchemaName(column);
    }

    public int getPrecision(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return this.delegate.getPrecision(column);
    }

    public int getScale(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return this.delegate.getScale(column);
    }

    public String getTableName(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return this.delegate.getTableName(column);
    }

    public String getCatalogName(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return this.delegate.getCatalogName(column);
    }

    public int getColumnType(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return this.delegate.getColumnType(column);
    }

    public String getColumnTypeName(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return this.delegate.getColumnTypeName(column);
    }

    public boolean isReadOnly(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return this.delegate.isReadOnly(column);
    }

    public boolean isWritable(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return this.delegate.isWritable(column);
    }

    public boolean isDefinitelyWritable(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return this.delegate.isDefinitelyWritable(column);
    }

    public String getColumnClassName(int column) throws SQLException {
        this.verifyColumnIndex(column);
        return this.delegate.getColumnClassName(column);
    }

    public int getParameterCount() throws SQLException {
        return this.delegate.getParameterCount();
    }
}

