/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.lang;

import com.metamatrix.core.util.EquivalenceUtil;
import com.metamatrix.core.util.HashCodeUtil;
import com.metamatrix.query.QueryPlugin;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.visitor.SQLStringVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class GroupBy
implements LanguageObject {
    private List symbols;

    public GroupBy() {
        this.symbols = new ArrayList();
    }

    public GroupBy(List symbols) {
        this.symbols = new ArrayList(symbols);
    }

    public int getCount() {
        return this.symbols.size();
    }

    public List getSymbols() {
        return this.symbols;
    }

    public Expression getSymbol(int index) {
        return (Expression)this.symbols.get(index);
    }

    public void addSymbol(Expression symbol) {
        if (symbol != null) {
            this.symbols.add(symbol);
        }
    }

    public void addSymbols(Collection symbols) {
        if (symbols != null) {
            this.symbols.addAll(symbols);
        }
    }

    public void replaceSymbols(Collection symbols) {
        if (symbols == null) {
            throw new IllegalArgumentException(QueryPlugin.Util.getString("ERR.015.010.0003"));
        }
        this.symbols = new ArrayList(symbols);
    }

    public boolean containsSymbol(Expression symbol) {
        return this.symbols.contains(symbol);
    }

    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public Object clone() {
        List thisSymbols = this.getSymbols();
        ArrayList<Object> copySymbols = new ArrayList<Object>(thisSymbols.size());
        Iterator iter = thisSymbols.iterator();
        while (iter.hasNext()) {
            Expression es = (Expression)iter.next();
            copySymbols.add(es.clone());
        }
        return new GroupBy(copySymbols);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        return EquivalenceUtil.areEqual(this.getSymbols(), ((GroupBy)obj).getSymbols());
    }

    public int hashCode() {
        return HashCodeUtil.hashCode(0, this.getSymbols());
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }
}

