/*
 * Decompiled with CFR 0.152.
 */
package jdbc.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import jdbc.sql.cli.oacli;
import jdbc.sql.oabaseconnection;
import jdbc.sql.oabasedatasource;
import jdbc.sql.oaclosedconnection;
import jdbc.sql.oawrappedconnection;

public class oapooledconnection
extends oabaseconnection
implements PooledConnection {
    private List _listOfListeners = null;
    private oawrappedconnection _internalConnection = null;
    private static oaclosedconnection _closedConnection = new oaclosedconnection();

    protected oapooledconnection(String string, String string2, oabasedatasource oabasedatasource2) throws SQLException {
        super(string, string2, oabasedatasource2);
        this.getoacli().setPooledConnection(this);
        this._listOfListeners = Collections.synchronizedList(new LinkedList());
    }

    public Connection getConnection() throws SQLException {
        int n;
        if (oapooledconnection.traceOn()) {
            oapooledconnection.trace("getConnection() called for " + this);
        }
        if (this._internalConnection != null) {
            if (oapooledconnection.traceOn()) {
                oapooledconnection.trace("Forced close of connection " + this._internalConnection);
            }
            this._internalConnection.internalClose();
            this._internalConnection = null;
        }
        int n2 = n = this.getoacli().inTransaction() ? 1 : 0;
        while (n < 2) {
            try {
                this.throwErrorWhenClosed();
                n = 2;
            }
            catch (SQLException sQLException) {
                if (++n > 1) {
                    throw sQLException;
                }
                this.getoacli().Reconnect();
            }
        }
        this._internalConnection = new oawrappedconnection(this, _closedConnection);
        this._currentConnection = this._internalConnection;
        this.reset(false);
        if (oapooledconnection.traceOn()) {
            oapooledconnection.trace("getConnection() returning " + this._internalConnection);
        }
        return this._internalConnection;
    }

    public void close() throws SQLException {
        if (oapooledconnection.traceOn()) {
            oapooledconnection.trace("close: called to close real connection");
        }
        this.internalClose();
    }

    protected void throwErrorWhenClosed() throws SQLException {
        try {
            super.throwErrorWhenClosed();
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
    }

    void closeFromWrapper() throws SQLException {
        this._currentConnection = null;
        oacli oacli2 = this.getoacli();
        if (oacli2 != null && oacli2.inLocalTransaction()) {
            this.rollback();
        }
        this.notifyClosed();
        try {
            this.reset(true);
        }
        catch (SQLException sQLException) {
            this.notifyError(sQLException);
            throw sQLException;
        }
        this.throwErrorWhenClosed();
    }

    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (oapooledconnection.traceOn()) {
            oapooledconnection.trace("addConnectionEventListener: invoked with argument " + connectionEventListener);
        }
        if (connectionEventListener == null) {
            throw new NullPointerException("Argument 'listener' is null");
        }
        if (this._listOfListeners.contains(connectionEventListener)) {
            throw new IllegalStateException("The listener " + connectionEventListener.toString() + " is alredy present in the list of listeners of " + this.toString());
        }
        this._listOfListeners.add(connectionEventListener);
        if (oapooledconnection.traceOn()) {
            oapooledconnection.trace("addConnectionEventListener: added " + connectionEventListener + " to listener chain");
        }
    }

    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (oapooledconnection.traceOn()) {
            oapooledconnection.trace("removeConnectionEventListener: invoked with argument " + connectionEventListener);
        }
        if (!this._listOfListeners.remove(connectionEventListener)) {
            throw new IllegalStateException("The given listener " + connectionEventListener.toString() + " is not registered with this PooledConnection " + this.toString());
        }
        if (oapooledconnection.traceOn()) {
            oapooledconnection.trace("removeConnectionEventListener: removed " + connectionEventListener + " from listener chain");
        }
    }

    void notifyClosed() {
        if (oapooledconnection.traceOn()) {
            oapooledconnection.trace("Logical close for " + this);
        }
        this._internalConnection = null;
        Object[] objectArray = this._listOfListeners.toArray();
        ConnectionEvent connectionEvent = new ConnectionEvent(this);
        for (int i = 0; i < objectArray.length; ++i) {
            if (oapooledconnection.traceOn()) {
                oapooledconnection.trace("notifyClosed: notifying " + objectArray[i]);
            }
            ((ConnectionEventListener)objectArray[i]).connectionClosed(connectionEvent);
        }
    }

    public void notifyError(SQLException sQLException) {
        if (oapooledconnection.traceOn()) {
            oapooledconnection.trace("Serious error '" + sQLException.getMessage() + "' occured for object " + this);
        }
        this._internalConnection = null;
        Object[] objectArray = this._listOfListeners.toArray();
        ConnectionEvent connectionEvent = new ConnectionEvent(this, sQLException);
        for (int i = 0; i < objectArray.length; ++i) {
            if (oapooledconnection.traceOn()) {
                oapooledconnection.trace("notifyError: notifying " + objectArray[i] + ". Error = " + sQLException.getMessage());
            }
            ((ConnectionEventListener)objectArray[i]).connectionErrorOccurred(connectionEvent);
        }
    }
}

