/*
 * Decompiled with CFR 0.152.
 */
package jdbc.sql;

import java.sql.SQLException;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import jdbc.sql.cli.oacli;
import jdbc.sql.cli.oacliexception;
import jdbc.sql.cli.oaclistmt;
import jdbc.sql.oabasedatasource;
import jdbc.sql.oapooledconnection;
import jdbc.sql.oaxid;

public class oaxaconnection
extends oapooledconnection
implements XAConnection,
XAResource {
    int _iRetryCount;
    Xid _xid = null;

    protected oaxaconnection(String string, String string2, oabasedatasource oabasedatasource2) throws SQLException {
        super(string, string2, oabasedatasource2);
        this.getoacli().setXAConnection(this);
    }

    public XAResource getXAResource() throws SQLException {
        int n;
        try {
            this.throwXAExceptionWhenRealConnectionClosed();
        }
        catch (XAException xAException) {
            throw new SQLException("Connection error", "80003");
        }
        int n2 = n = this.getoacli().inTransaction() ? 1 : 0;
        if (oaxaconnection.traceOn()) {
            oaxaconnection.trace("getXAResource called for " + this);
        }
        while (n < 2) {
            try {
                this.throwErrorWhenClosed();
                n = 2;
            }
            catch (SQLException sQLException) {
                if (++n > 1) {
                    throw sQLException;
                }
                this.getoacli().Reconnect();
            }
        }
        if (oaxaconnection.traceOn()) {
            oaxaconnection.trace("getXAResource returning " + this);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void throwXAExceptionWhenRealConnectionClosed() throws XAException {
        boolean bl = false;
        oacli oacli2 = this.getoacli();
        if (oacli2 == null && oaxaconnection.traceOn()) {
            oaxaconnection.trace("throwXAExceptionWhenRealConnectionClosed: invoked with a null oacli " + this);
        }
        if (oacli2 != null && (oacli2.isClosed() || !oacli2.isConnected())) {
            bl = true;
        }
        try {
            if (bl) {
                oacli2.Reconnect();
            }
            if (oacli2 == null) {
                throw new SQLException("Connection closed", "08003");
            }
            if (oacli2.isClosed()) {
                throw new SQLException("Connection closed", "08003");
            }
            if (!oacli2.isConnected()) {
                throw new SQLException("Connection lost", "08S01");
            }
        }
        catch (SQLException sQLException) {
            try {
                this.notifyError(sQLException);
            }
            finally {
                if (oaxaconnection.traceOn()) {
                    oaxaconnection.trace("throwXAExceptionWhenRealConnectionClosed: Connection bad, throwing XAException.XAER_RMFAIL");
                }
                throw new XAException(-7);
            }
        }
    }

    private void processXaException(XAException xAException) throws XAException {
        if (xAException.errorCode == -7) {
            block9: {
                try {
                    this.getoacli().markConnectionAsBad();
                }
                catch (Exception exception) {
                    if (!oaxaconnection.traceOn()) break block9;
                    oaxaconnection.trace("processXaException: Ignoring exception " + exception + " when trying to recover from XAER_RMFAIL");
                }
            }
            ++this._iRetryCount;
            if (this._iRetryCount > 1) {
                if (oaxaconnection.traceOn()) {
                    oaxaconnection.trace("processXaException: Connection bad, throwing XAException " + Integer.toString(xAException.errorCode));
                }
                throw xAException;
            }
            try {
                this.getoacli().Reconnect();
            }
            catch (oacliexception oacliexception2) {
                if (oaxaconnection.traceOn()) {
                    oaxaconnection.trace("processXaException: Failed to reconnect, exception gotten was " + oacliexception2 + " rethrowing original exception " + xAException);
                }
                throw xAException;
            }
        }
        if (oaxaconnection.traceOn()) {
            oaxaconnection.trace("processXaException: throwing XAException " + Integer.toString(xAException.errorCode));
        }
        throw xAException;
    }

    public int getTransactionTimeout() throws XAException {
        return 999;
    }

    public boolean setTransactionTimeout(int n) throws XAException {
        return false;
    }

    public boolean isSameRM(XAResource xAResource) throws XAException {
        String string;
        if (oaxaconnection.traceOn()) {
            oaxaconnection.trace("isSameRM(" + xAResource + ") invoked for " + this);
        }
        boolean bl = xAResource instanceof oaxaconnection ? ((string = ((oaxaconnection)xAResource).getConnectionId()) != null ? string.equals(this.getConnectionId()) : false) : false;
        if (oaxaconnection.traceOn()) {
            oaxaconnection.trace("isSameRM(" + xAResource + ") returns " + bl + " for " + this);
        }
        return bl;
    }

    public void start(Xid xid, int n) throws XAException {
        if (oaxaconnection.traceOn()) {
            oaxaconnection.trace("start(" + xid + ", " + n + ") invoked for " + this);
        }
        this.throwXAExceptionWhenRealConnectionClosed();
        this._iRetryCount = 0;
        while (this._iRetryCount < 2) {
            try {
                this.do_start(xid, n);
                this._iRetryCount = 2;
            }
            catch (XAException xAException) {
                this.processXaException(xAException);
            }
        }
        if (oaxaconnection.traceOn()) {
            oaxaconnection.trace("start(" + xid + ", " + n + ") done for " + this);
        }
    }

    public void end(Xid xid, int n) throws XAException {
        if (oaxaconnection.traceOn()) {
            oaxaconnection.trace("end(" + xid + ", " + n + ") invoked for " + this);
        }
        this.throwXAExceptionWhenRealConnectionClosed();
        this._iRetryCount = this.getoacli().inTransaction() ? 1 : 0;
        try {
            this.do_end(xid, n);
        }
        catch (XAException xAException) {
            this.processXaException(xAException);
        }
        if (oaxaconnection.traceOn()) {
            oaxaconnection.trace("end(" + xid + ", " + n + ") done for " + this);
        }
    }

    public void commit(Xid xid, boolean bl) throws XAException {
        if (oaxaconnection.traceOn()) {
            oaxaconnection.trace("commit(" + xid + ", " + bl + ") invoked for " + this);
        }
        this.throwXAExceptionWhenRealConnectionClosed();
        int n = this._iRetryCount = this.getoacli().inTransaction() ? 1 : 0;
        while (this._iRetryCount < 2) {
            try {
                this.do_runXARequest2(this.getoacli(), "CO", xid, bl ? 0x40000000 : 0);
                this._iRetryCount = 2;
            }
            catch (XAException xAException) {
                this.processXaException(xAException);
            }
        }
        if (oaxaconnection.traceOn()) {
            oaxaconnection.trace("commit(" + xid + ", " + bl + ") done for " + this);
        }
    }

    public void forget(Xid xid) throws XAException {
        if (oaxaconnection.traceOn()) {
            oaxaconnection.trace("forget(" + xid + ") invoked for " + this);
        }
        this.throwXAExceptionWhenRealConnectionClosed();
        int n = this._iRetryCount = this.getoacli().inTransaction() ? 1 : 0;
        while (this._iRetryCount < 2) {
            try {
                this.do_runXARequest2(this.getoacli(), "FO", xid, 0);
                this._iRetryCount = 2;
            }
            catch (XAException xAException) {
                this.processXaException(xAException);
            }
        }
        if (oaxaconnection.traceOn()) {
            oaxaconnection.trace("forget(" + xid + ") done for " + this);
        }
    }

    public int prepare(Xid xid) throws XAException {
        int n = 0;
        if (oaxaconnection.traceOn()) {
            oaxaconnection.trace("prepare(" + xid + ") invoked for " + this);
        }
        this.throwXAExceptionWhenRealConnectionClosed();
        int n2 = this._iRetryCount = this.getoacli().inTransaction() ? 1 : 0;
        while (this._iRetryCount < 2) {
            try {
                n = this.do_runXARequest2(this.getoacli(), "PR", xid, 0);
                this._iRetryCount = 2;
            }
            catch (XAException xAException) {
                n = xAException.errorCode;
                this.processXaException(xAException);
            }
        }
        if (oaxaconnection.traceOn()) {
            oaxaconnection.trace("prepare(" + xid + ") returns " + n + " for " + this);
        }
        return n;
    }

    public Xid[] recover(int n) throws XAException {
        Xid[] xidArray = null;
        int n2 = 0;
        if (oaxaconnection.traceOn()) {
            oaxaconnection.trace("recover(" + n + ") invoked for " + this);
        }
        this.throwXAExceptionWhenRealConnectionClosed();
        int n3 = this._iRetryCount = this.getoacli().inTransaction() ? 1 : 0;
        while (this._iRetryCount < 2) {
            try {
                xidArray = this.do_recover(n);
                n2 = xidArray != null ? xidArray.length : 0;
                this._iRetryCount = 2;
            }
            catch (XAException xAException) {
                xidArray = null;
                n2 = 0;
                this.processXaException(xAException);
            }
        }
        if (oaxaconnection.traceOn()) {
            oaxaconnection.trace("recover(" + n + ") returns " + n2 + " xids for " + this);
        }
        return xidArray;
    }

    public void rollback(Xid xid) throws XAException {
        if (oaxaconnection.traceOn()) {
            oaxaconnection.trace("rollback(" + xid + ") invoked for " + this);
        }
        this.throwXAExceptionWhenRealConnectionClosed();
        int n = this._iRetryCount = this.getoacli().inTransaction() ? 1 : 0;
        while (this._iRetryCount < 2) {
            try {
                this.do_runXARequest2(this.getoacli(), "RB", xid, 0);
                this._iRetryCount = 2;
            }
            catch (XAException xAException) {
                this.processXaException(xAException);
            }
        }
        if (oaxaconnection.traceOn()) {
            oaxaconnection.trace("rollback(" + xid + ") done for " + this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void do_start(Xid xid, int n) throws XAException {
        oacli oacli2 = this.getoacli();
        if (oacli2.inLocalTransaction()) {
            throw new XAException(-9);
        }
        try {
            oacli2.handleXAautocommit(true);
        }
        catch (oacliexception oacliexception2) {
            throw new XAException(-7);
        }
        if (oacli2.inXATransaction() && oaxaconnection.traceOn()) {
            oaxaconnection.trace("xa_start called when already in transaction (" + this._xid.toString() + ") for oacli: " + this.toString());
        }
        this.enterLocked2(oacli2);
        try {
            this.do_runXARequest(oacli2, "ST", xid, n);
        }
        finally {
            this.exitLocked2(oacli2);
        }
        oacli2.setXaTransaction(true);
        this._xid = new oaxid(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void do_end(Xid xid, int n) throws XAException {
        oacli oacli2 = this.getoacli();
        this.enterLocked2(oacli2);
        try {
            this.do_runXARequest(this.getoacli(), "EN", xid, n);
        }
        finally {
            this.exitLocked2(oacli2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Xid[] do_recover(int n) throws XAException {
        Xid[] xidArray = null;
        boolean bl = false;
        oacli oacli2 = this.getoacli();
        if (oaxaconnection.traceOn()) {
            oaxaconnection.trace("recover: XA recover request, flags:" + Integer.toHexString(n));
        }
        if ((n & 0x1000000) == 0) {
            if (oaxaconnection.traceOn()) {
                oaxaconnection.trace("recover: called with other option than TMSTARTRSCAN, returning null");
            }
            return null;
        }
        oaxaconnection oaxaconnection2 = this;
        synchronized (oaxaconnection2) {
            if (this.enterLockedXA(oacli2) == -1) {
                try {
                    if (oaxaconnection.traceOn()) {
                        oaxaconnection.trace("recover: Using normal cli to perform operation " + this);
                    }
                    xidArray = oaxaconnection.do_recover2(oacli2, n);
                    bl = true;
                }
                finally {
                    this.exitLockedXA(oacli2);
                }
            } else if (oaxaconnection.traceOn()) {
                oaxaconnection.trace("recover: Unable to use normal cli to perform operation " + this);
            }
        }
        if (!bl) {
            boolean bl2 = true;
            while (bl2) {
                oacli oacli3;
                bl2 = false;
                oacli oacli4 = oacli3 = this.do_getXaCli();
                synchronized (oacli4) {
                    if (!oacli3.isConnected() || oacli3.isClosed()) {
                        if (oaxaconnection.traceOn()) {
                            oaxaconnection.trace("recover: oacli broken before we got it, retrying operation");
                        }
                        bl2 = true;
                    }
                    if (!bl2) {
                        try {
                            xidArray = oaxaconnection.do_recover2(oacli3, n);
                        }
                        finally {
                            oacli3.setSpecialOwner(null);
                        }
                    }
                }
                if (!bl2) continue;
                oacli3.removeXaCli();
            }
        }
        if (oaxaconnection.traceOn()) {
            if (xidArray == null) {
                oaxaconnection.trace("recover: XA Recovery request successfully processed, no xids to recover");
            } else {
                oaxaconnection.trace("recover: XA Recovery request successfully processed, " + xidArray.length + " xids returned");
            }
        }
        return xidArray;
    }

    private static Xid[] do_recover2(oacli oacli2, int n) throws XAException {
        Xid[] xidArray = null;
        int n2 = 0;
        int n3 = 0;
        try {
            oaclistmt oaclistmt2 = oacli2.getSystemStatement();
            String string = "select XID_FORMAT, XID_GTRID_LENGTH, XID_BQUAL_LENGTH, XID_DATA from OA_XA_LOG";
            if (oaxaconnection.traceOn()) {
                oaxaconnection.trace("recover2: Sending XA recovery request: " + string);
            }
            oaclistmt2.ExecuteLocked(string);
            n2 = oaclistmt2.getRowCount();
            if (n2 > 0) {
                xidArray = new Xid[n2];
                boolean bl = oaclistmt2.nextLocked();
                while (bl) {
                    xidArray[n3] = new oaxid(oaclistmt2.getInt(1), oaclistmt2.getInt(2), oaclistmt2.getInt(3), oaclistmt2.getBytes(4));
                    if (oaxaconnection.traceOn()) {
                        oaxaconnection.trace("recover2: XA Recover returned Xid: " + xidArray[n3].toString());
                    }
                    ++n3;
                    bl = oaclistmt2.nextLocked();
                }
            }
            oaclistmt2.closeResultSet();
        }
        catch (oacliexception oacliexception2) {
            oacli2.resetSystemStatement();
            if (oaxaconnection.traceOn()) {
                oaxaconnection.trace("recover2: XA recover request failed with error: " + oacliexception2.getMessage());
            }
            throw new XAException(-7);
        }
        return xidArray;
    }

    private int do_runXARequest(oacli oacli2, String string, Xid xid, int n) throws XAException {
        int n2 = -7;
        try {
            oaclistmt oaclistmt2 = oacli2.getSystemStatement();
            String string2 = "_OA_SET_INFO XA " + string + " " + oaxid.xidToString(xid) + "F=" + Integer.toString(n, 16) + "/" + Integer.toString(this._xaOptions, 16) + "/";
            if (oaxaconnection.traceOn()) {
                oaxaconnection.trace("Sending XA Request: '" + string2 + "' for oacli: " + this.toString());
            }
            oaclistmt2.ExecuteLocked(string2);
        }
        catch (oacliexception oacliexception2) {
            if (oacliexception2.getSQLState().equals("63000")) {
                if (string.equals("PR") && oacliexception2.getErrorCode() == 3) {
                    if (oaxaconnection.traceOn()) {
                        oaxaconnection.trace("XA Request successfully processed (prepare with read-only optimization returned) for oacli: " + this.toString());
                    }
                    return 3;
                }
                n2 = oacliexception2.getErrorCode();
            } else {
                n2 = -7;
            }
            this.do_MaybeEndDistributedTransaction(oacli2, string, xid, n2);
            throw new XAException(n2);
        }
        this.do_MaybeEndDistributedTransaction(oacli2, string, xid, 0);
        if (oaxaconnection.traceOn()) {
            oaxaconnection.trace("XA Request successfully processed for oacli: " + this.toString());
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int do_runXARequest2(oacli oacli2, String string, Xid xid, int n) throws XAException {
        boolean bl = false;
        int n2 = -7;
        oaxaconnection oaxaconnection2 = this;
        synchronized (oaxaconnection2) {
            if (this.enterLockedXA(oacli2) == -1) {
                try {
                    if (oaxaconnection.traceOn()) {
                        oaxaconnection.trace("runXARequest2: " + string + " Using normal cli to perform operation " + this);
                    }
                    n2 = this.do_runXARequest(oacli2, string, xid, n);
                    bl = true;
                }
                finally {
                    this.exitLockedXA(oacli2);
                }
            } else if (oaxaconnection.traceOn()) {
                oaxaconnection.trace("runXARequest2: " + string + " Unable to use normal cli to perform operation " + this);
            }
        }
        if (!bl) {
            boolean bl2 = true;
            while (bl2) {
                oacli oacli3;
                bl2 = false;
                oacli oacli4 = oacli3 = this.do_getXaCli();
                synchronized (oacli4) {
                    if (!oacli3.isConnected() || oacli3.isClosed()) {
                        if (oaxaconnection.traceOn()) {
                            oaxaconnection.trace("runXARequest2: oacli broken before we got it, retrying operation");
                        }
                        bl2 = true;
                    }
                    if (!bl2) {
                        try {
                            n2 = this.do_runXARequest(oacli3, string, xid, n);
                        }
                        finally {
                            oacli3.setSpecialOwner(null);
                        }
                    }
                }
                if (!bl2) continue;
                oacli3.removeXaCli();
            }
        }
        return n2;
    }

    private void do_MaybeEndDistributedTransaction(oacli oacli2, String string, Xid xid, int n) throws XAException {
        if (!oacli2.inXATransaction()) {
            return;
        }
        boolean bl = false;
        if (n == -7) {
            if (oaxaconnection.traceOn()) {
                oaxaconnection.trace("Ending transaction due to XAER_RMFAIL for oacli:  " + this.toString());
            }
            bl = true;
        }
        if (string.equals("EN")) {
            if (n == 0) {
                if (oaxaconnection.traceOn()) {
                    oaxaconnection.trace("Ending transaction due to normal return from xa_end for oacli: " + this.toString());
                }
                bl = true;
            } else if (n >= 100 && n <= 107) {
                if (oaxaconnection.traceOn()) {
                    oaxaconnection.trace("Ending transaction due to rc " + Integer.toString(n) + " from xa_end for oacli:  " + this.toString());
                }
                bl = true;
            }
        }
        if (string.equals("RB") && this._xid.equals(xid) && (this._xaOptions & 4) == 0 && n != -6 && n != -2 && n != -5) {
            if (oaxaconnection.traceOn()) {
                oaxaconnection.trace("Ending transaction due to rc " + Integer.toString(n) + " from xa_rollback and strict semantics is off. oacli: " + this.toString());
            }
            bl = true;
        }
        if (!bl) {
            return;
        }
        oacli2.setXaTransaction(false);
        this._xid = null;
        try {
            oacli2.handleXAautocommit(false);
        }
        catch (oacliexception oacliexception2) {
            if (oaxaconnection.traceOn()) {
                oaxaconnection.trace("Failed to reset autocommit after failure, error: '" + oacliexception2.getMessage() + "' for oacli:  " + this.toString());
            }
            throw new XAException(-7);
        }
    }

    private void enterLocked2(oacli oacli2) throws XAException {
        if (oacli2 == null) {
            if (oaxaconnection.traceOn()) {
                oaxaconnection.trace("enterLocked2: oacli is null, generating exception XAException.XAER_RMFAIL");
            }
            throw new XAException(-7);
        }
        try {
            oacli2.enterLocked();
        }
        catch (oacliexception oacliexception2) {
            if (oaxaconnection.traceOn()) {
                oaxaconnection.trace("enterLocked2: Converting oacliexception " + oacliexception2.toString() + " to XAException.XAER_RMFAIL");
            }
            throw new XAException(-7);
        }
    }

    private void exitLocked2(oacli oacli2) throws XAException {
        try {
            oacli2.exitLocked();
        }
        catch (oacliexception oacliexception2) {
            if (oaxaconnection.traceOn()) {
                oaxaconnection.trace("exitLocked2: Converting oacliexception " + oacliexception2.toString() + " to XAException.XAER_RMFAIL");
            }
            throw new XAException(-7);
        }
    }

    private int enterLockedXA(oacli oacli2) throws XAException {
        int n = 0;
        boolean bl = false;
        if (oacli2 == null) {
            if (oaxaconnection.traceOn()) {
                oaxaconnection.trace("enterLockedXA: oacli is null generating exception XAException.XAER_RMFAIL");
            }
            throw new XAException(-7);
        }
        if ((this._xaOptions & 8) != 8) {
            try {
                long l = System.currentTimeMillis() + 2000L;
                while ((n = oacli2.lock(true)) != -1 && System.currentTimeMillis() < l) {
                    try {
                        if (!bl && oaxaconnection.traceOn()) {
                            oaxaconnection.trace("enterLockedXA: oacli " + this + " is locked, waiting for it to be released");
                            bl = true;
                        }
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (oacliexception oacliexception2) {
                if (oaxaconnection.traceOn()) {
                    oaxaconnection.trace("enterLockedXA: Converting oacliexception " + oacliexception2.toString() + " to XAException.XAER_RMFAIL");
                }
                throw new XAException(-7);
            }
        }
        if (oaxaconnection.traceOn() && n != -1) {
            oaxaconnection.trace("enterLockedXA: Failed to take XA lock. oacli = " + this);
        }
        return n;
    }

    private void exitLockedXA(oacli oacli2) throws XAException {
        try {
            oacli2.unlock(true);
        }
        catch (oacliexception oacliexception2) {
            if (oaxaconnection.traceOn()) {
                oaxaconnection.trace("exitLockedXA: Converting oacliexception " + oacliexception2.toString() + " to XAException.XAER_RMFAIL");
            }
            throw new XAException(-7);
        }
    }

    private oacli do_getXaCli() throws XAException {
        oacli oacli2 = this.getoacli();
        try {
            return oacli2.getXaCli();
        }
        catch (oacliexception oacliexception2) {
            if (oaxaconnection.traceOn()) {
                oaxaconnection.trace("do_getXaCli: Converting oacliexception " + oacliexception2.toString() + " to XAException.XAER_RMFAIL");
            }
            throw new XAException(-7);
        }
    }
}

